/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor;

import homestrifeeditor.HSObject;
import homestrifeeditor.HSTexture;
import homestrifeeditor.TGAReader;
import homestrifeeditor.windows.EditorWindow;
import homestrifeeditor.windows.panes.TextureObjectLayeredPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class HSTextureLabel
extends JLabel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    public TextureObjectLayeredPane parent;
    public HSTexture texture;
    public HSObject parentObject;
    public ImageIcon icon = null;
    public ImageIcon originalIcon = null;
    private int mouseStartX;
    private int mouseStartY;
    private int mouseMoveThreshold;
    private boolean moveBox;

    public HSTextureLabel(HSObject theParentObject, TextureObjectLayeredPane theParent, HSTexture theTexture) {
        this.setName("texture");
        this.parent = theParent;
        this.parentObject = theParentObject;
        this.texture = theTexture;
        this.mouseStartX = 0;
        this.mouseStartY = 0;
        this.mouseMoveThreshold = 0;
        this.moveBox = false;
        this.loadIcon();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public HSTextureLabel(HSTextureLabel l) {
        this(l.parentObject, l.parent, l.texture);
        this.setBounds(l.getBounds());
        this.texture = new HSTexture(this.texture);
    }

    public void loadIcon() {
        if (this.originalIcon == null) {
            this.originalIcon = TGAReader.loadTGA(this.texture.filePath, "");
        }
        if (this.originalIcon == null) {
            return;
        }
        this.icon = EditorWindow.resize(this.originalIcon);
        if (this.icon == null) {
            return;
        }
        this.setIcon(this.icon);
        this.setText("");
        this.setName("texture");
        Point pos = this.parent.parent.getSwingOffset(this.texture.offset.x * EditorWindow.scale, this.texture.offset.y * EditorWindow.scale);
        this.setMinimumSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.setMaximumSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.setBounds(pos.x, pos.y, this.icon.getIconWidth(), this.icon.getIconHeight());
    }

    public void updatePos() {
        this.updatePos((int)this.parentObject.pos.x, (int)this.parentObject.pos.y);
    }

    public void updatePos(int nx, int ny) {
        this.parentObject.pos.x = nx;
        this.parentObject.pos.y = ny;
        Point pos = this.parent.parent.getSwingOffset(this.parentObject.pos.x * EditorWindow.scale, this.parentObject.pos.y * EditorWindow.scale);
        this.setBounds(pos.x, pos.y, this.icon.getIconWidth(), this.icon.getIconHeight());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.parent.selectedItems.contains(this)) {
            return;
        }
        Component c = e.getComponent();
        if (c == null) {
            return;
        }
        float xDiff = e.getX() - this.mouseStartX;
        float yDiff = e.getY() - this.mouseStartY;
        if (Math.abs(xDiff) >= (float)this.mouseMoveThreshold || Math.abs(yDiff) >= (float)this.mouseMoveThreshold) {
            this.moveBox = true;
        }
        if (!this.moveBox) {
            return;
        }
        this.parentObject.pos.x += xDiff;
        this.parentObject.pos.y += yDiff;
        Point pos = this.parent.parent.getSwingOffset(this.parentObject.pos.x * EditorWindow.scale, this.parentObject.pos.y * EditorWindow.scale);
        this.setBounds(pos.x, pos.y, this.icon.getIconWidth(), this.icon.getIconHeight());
        this.parent.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.parent.parent.parent.objectListPane.objectList.clearSelection();
        if (e.getClickCount() == 1) {
            boolean multiSelect = false;
            boolean shouldSelect = true;
            if (e.isControlDown()) {
                if (this.parent.selectedItems.contains(this)) {
                    this.parent.unselect(this);
                    shouldSelect = false;
                } else {
                    multiSelect = true;
                }
            }
            if (shouldSelect) {
                this.parent.setSelected(this, multiSelect);
                this.mouseStartX = e.getX();
                this.mouseStartY = e.getY();
            }
        }
        this.parent.parent.parent.objectListPane.setSelectedFromTexturePane();
        if (e.getClickCount() == 2) {
            this.parent.parent.parent.objectListPane.editObjectButtonPressed();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.moveBox = false;
    }
}

