/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows.panes;

import homestrifeeditor.HSObject;
import homestrifeeditor.HSStage;
import homestrifeeditor.HSTextureLabel;
import homestrifeeditor.ObjectListCellRenderer;
import homestrifeeditor.windows.EditorWindow;
import homestrifeeditor.windows.MassShiftWindow;
import homestrifeeditor.windows.ObjectAttributesWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ObjectListPane
extends JPanel
implements ActionListener,
ListSelectionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    public EditorWindow parent;
    public DefaultListModel<HSObject> objectListModel;
    public JList<HSObject> objectList;
    private JToolBar objectListToolbar;

    public ObjectListPane(EditorWindow theParent) {
        this.parent = theParent;
        this.createPaneContents();
    }

    private void createPaneContents() {
        JLabel objectListLabel = new JLabel("Object List");
        this.objectListModel = new DefaultListModel();
        this.objectList = new JList<HSObject>(this.objectListModel);
        this.objectList.setSelectionMode(2);
        this.objectList.setName("objectList");
        this.objectList.setCellRenderer(new ObjectListCellRenderer());
        this.objectList.addListSelectionListener(this);
        this.objectList.addMouseListener(this);
        JScrollPane objectListScrollPane = new JScrollPane(this.objectList);
        JButton addObjectButton = new JButton("+");
        addObjectButton.setActionCommand("addObject");
        addObjectButton.setToolTipText("Create New Object");
        addObjectButton.addActionListener(this);
        JButton removeObjectsButton = new JButton("-");
        removeObjectsButton.setActionCommand("removeObjects");
        removeObjectsButton.setToolTipText("Delete Selected Object(s)");
        removeObjectsButton.addActionListener(this);
        JButton moveObjectUpButton = new JButton("/\\");
        moveObjectUpButton.setActionCommand("moveObjectUp");
        moveObjectUpButton.setToolTipText("Move Selected Object Up");
        moveObjectUpButton.addActionListener(this);
        JButton moveObjectDownButton = new JButton("\\/");
        moveObjectDownButton.setActionCommand("moveObjectDown");
        moveObjectDownButton.setToolTipText("Move Selected Object Down");
        moveObjectDownButton.addActionListener(this);
        JButton editObjectButton = new JButton("Edit");
        editObjectButton.setActionCommand("editObject");
        editObjectButton.setToolTipText("Edit Object Attributes");
        editObjectButton.addActionListener(this);
        JButton massShiftObjectButton = new JButton("Mass Shift");
        massShiftObjectButton.setActionCommand("massShift");
        massShiftObjectButton.setToolTipText("Mass Shift Attributes");
        massShiftObjectButton.addActionListener(this);
        this.objectListToolbar = new JToolBar();
        this.objectListToolbar.setFloatable(false);
        this.objectListToolbar.add(addObjectButton);
        this.objectListToolbar.add(removeObjectsButton);
        this.objectListToolbar.add(moveObjectUpButton);
        this.objectListToolbar.add(moveObjectDownButton);
        this.objectListToolbar.add(editObjectButton);
        this.objectListToolbar.add(massShiftObjectButton);
        this.setToolBarEnabled(true);
        this.setLayout(new BorderLayout());
        this.add((Component)objectListLabel, "First");
        this.add((Component)objectListScrollPane, "Center");
        this.add((Component)this.objectListToolbar, "Last");
    }

    public void setToolBarEnabled(boolean enable) {
        Component[] componentArray = this.objectListToolbar.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setEnabled(enable);
            ++n2;
        }
    }

    public void addObjectToList(HSObject obj, int index) {
        if (obj == null) {
            return;
        }
        if (index >= 0) {
            this.objectListModel.add(index + 1, obj);
        } else {
            this.objectListModel.addElement(obj);
        }
        this.moveIndexDown();
    }

    public void addObjectToList(HSObject obj) {
        this.addObjectToList(obj, this.objectList.getSelectedIndex());
    }

    public void addObjectsToList(ArrayList<HSObject> objs) {
        for (HSObject obj : objs) {
            this.addObjectToList(obj);
        }
    }

    public int getIndexOfObject(HSObject obj) {
        HSObject[] objs = this.getAllObjects();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] == obj) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void removeObjectFromList(HSObject obj) {
        int i = this.getIndexOfObject(obj);
        if (i >= 0 && i < this.parent.currentlyLoadedStage.objects.size()) {
            this.removeObjectFromList(i);
        }
        System.out.println(i);
    }

    public HSObject removeObjectFromList(int index) {
        return this.objectListModel.remove(index);
    }

    public ArrayList<HSObject> removeObjectsFromList(int[] indices) {
        ArrayList<HSObject> removedObjects = new ArrayList<HSObject>();
        Arrays.sort(indices, 0, indices.length - 1);
        int i = indices.length - 1;
        while (i >= 0) {
            removedObjects.add(0, this.removeObjectFromList(indices[i]));
            --i;
        }
        return removedObjects;
    }

    public ArrayList<HSObject> removeSelectedObjects() {
        int n = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the selected object(s)?", "Delete Object(s)", 0);
        if (n != 0) {
            return null;
        }
        ArrayList<HSObject> removeObjs = this.removeObjectsFromList(this.objectList.getSelectedIndices());
        this.parent.currentlyLoadedStage.objects.remove(removeObjs);
        Component[] componentArray = this.parent.textureObjectPane.textureObjectLayeredPane.getComponents();
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Component c = componentArray[n3];
            HSTextureLabel texLabel = (HSTextureLabel)c;
            if (removeObjs.contains(texLabel.parentObject)) {
                this.parent.textureObjectPane.textureObjectLayeredPane.remove(c);
            }
            ++n3;
        }
        this.parent.textureObjectPane.textureObjectLayeredPane.repaint();
        return n == 0 ? removeObjs : null;
    }

    public void removeAllObjectsFromList() {
        this.setToolBarEnabled(false);
        this.objectListModel.removeAllElements();
    }

    public int getCurrentlySelectedIndex() {
        return this.objectList.getSelectedIndex();
    }

    public HSObject getCurrentlySelectedObject() {
        if (this.objectList.getSelectedIndex() < 0) {
            return null;
        }
        return this.objectListModel.get(this.objectList.getSelectedIndex());
    }

    public HSObject[] getAllObjects() {
        HSObject[] objs = new HSObject[this.objectListModel.getSize()];
        int i = 0;
        while (i < this.objectListModel.getSize()) {
            HSObject obj;
            objs[i] = obj = this.objectListModel.get(i);
            ++i;
        }
        return objs;
    }

    public void moveSelectedObjectUp() {
        int index = this.objectList.getSelectedIndex();
        if (index <= 0) {
            return;
        }
        HSObject objectToMove = this.removeObjectFromList(index);
        this.objectListModel.add(index - 1, objectToMove);
        this.objectList.setSelectedIndex(index - 1);
    }

    public void moveSelectedObjectDown() {
        int index = this.objectList.getSelectedIndex();
        if (index < 0 || index >= this.objectListModel.getSize() - 1) {
            return;
        }
        HSObject objectToMove = this.removeObjectFromList(index);
        this.objectListModel.add(index + 1, objectToMove);
        this.objectList.setSelectedIndex(index + 1);
    }

    public void loadStageObjects(HSStage currentlyLoadedStage) {
        this.removeAllObjectsFromList();
        if (currentlyLoadedStage == null) {
            return;
        }
        this.setToolBarEnabled(true);
        this.addObjectsToList(currentlyLoadedStage.objects);
    }

    public void applyObjectChanges(HSObject obj, int index) {
        this.objectListModel.setElementAt(obj, index);
    }

    public void editObjectButtonPressed() {
        if (this.getCurrentlySelectedObject() != null) {
            this.createObjectAttributesWindow(this.getCurrentlySelectedObject());
        }
    }

    private void createObjectAttributesWindow(HSObject hsobj) {
        ObjectAttributesWindow window = new ObjectAttributesWindow(this, hsobj);
        window.setVisible(true);
    }

    public void massShift(int shiftX, int shiftY) {
        int[] indices;
        int[] nArray = indices = this.objectList.getSelectedIndices();
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            HSObject obj = this.objectListModel.get(i);
            obj.pos.x += (float)shiftX;
            obj.pos.y += (float)shiftY;
            Component[] componentArray = this.parent.textureObjectPane.textureObjectLayeredPane.getComponents();
            int n3 = componentArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Component c = componentArray[n4];
                if (c instanceof HSTextureLabel) {
                    ((HSTextureLabel)c).updatePos();
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void massShiftButtonPressed() {
        MassShiftWindow window = new MassShiftWindow(this);
        window.setVisible(true);
    }

    public void moveIndexUp() {
        int index = this.objectList.getSelectedIndex();
        this.objectList.setSelectedIndex(index - 1);
        this.objectList.ensureIndexIsVisible(index - 1);
    }

    public void moveIndexDown() {
        int index = this.objectList.getSelectedIndex();
        this.objectList.setSelectedIndex(index + 1);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        HSObject sel;
        if (e.getClickCount() == 1) {
            if (e.getButton() == 3) {
                int[] selected = this.objectList.getSelectedIndices();
                this.objectList.setSelectedIndex(this.objectList.locationToIndex(e.getPoint()));
                this.editObjectButtonPressed();
                this.objectList.setSelectedIndices(selected);
            }
        } else if (e.getClickCount() == 2 && (sel = this.objectList.getSelectedValue()) != null) {
            JScrollPane scrollPane = this.parent.textureObjectPane.textureObjectScrollPane;
            scrollPane.revalidate();
            scrollPane.getHorizontalScrollBar().setValue((int)(sel.pos.x * EditorWindow.scale) + (scrollPane.getHorizontalScrollBar().getMinimum() + scrollPane.getHorizontalScrollBar().getMaximum()) / 2 - scrollPane.getWidth() / 2);
            scrollPane.getVerticalScrollBar().setValue((int)(sel.pos.y * EditorWindow.scale) + (scrollPane.getVerticalScrollBar().getMinimum() + scrollPane.getVerticalScrollBar().getMaximum()) / 2 - scrollPane.getHeight() / 2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public void setSelectedFromTexturePane() {
        ArrayList<Integer> toSelectList = new ArrayList<Integer>();
        for (JLabel sel : this.parent.textureObjectPane.textureObjectLayeredPane.selectedItems) {
            if (!(sel instanceof HSTextureLabel)) continue;
            int i = 0;
            while (i < this.objectListModel.getSize()) {
                if (((HSTextureLabel)sel).parentObject.equals(this.objectListModel.get(i))) {
                    toSelectList.add(i);
                }
                ++i;
            }
        }
        int[] toSelectArray = new int[toSelectList.size()];
        int i = 0;
        while (i < toSelectList.size()) {
            toSelectArray[i] = (Integer)toSelectList.get(i);
            ++i;
        }
        this.objectList.setSelectedIndices(toSelectArray);
    }

    private void addObject() {
        if (this.parent.currentlyLoadedStage == null) {
            return;
        }
        int returnVal = EditorWindow.fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File file = EditorWindow.fileChooser.getSelectedFile();
        HSObject obj = HSObject.ObjectFromDefinition(file, this.parent);
        this.parent.textureObjectPane.textureObjectLayeredPane.addObject(obj);
        this.addObjectToList(obj);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "addObject": {
                this.addObject();
                break;
            }
            case "removeObjects": {
                this.removeSelectedObjects();
                break;
            }
            case "moveObjectUp": {
                this.moveSelectedObjectUp();
                break;
            }
            case "moveObjectDown": {
                this.moveSelectedObjectDown();
                break;
            }
            case "editObject": {
                this.editObjectButtonPressed();
                break;
            }
            case "massShift": {
                this.massShiftButtonPressed();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.parent.textureObjectPane.textureObjectLayeredPane.setSelectedFromListPane();
    }
}

