/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.objects.holds.properties;

import homestrifeeditor.objects.holds.properties.HSBox;
import homestrifeeditor.windows.HitboxAttributesWindow;
import homestrifeeditor.windows.panes.TextureHitboxLayeredPane;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class HSBoxLabel
extends JLabel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private static int resizeBoxSize = 10;
    public TextureHitboxLayeredPane parent;
    public HSBox box;
    private int mouseStartX;
    private int mouseStartY;
    private Rectangle topLeft;
    private Rectangle top;
    private Rectangle topRight;
    private Rectangle left;
    private Rectangle right;
    private Rectangle bottomLeft;
    private Rectangle bottom;
    private Rectangle bottomRight;
    private Rectangle resizeBoxPressed;
    private int mouseMoveThreshold;
    private boolean moveBox;
    public boolean locked;

    public HSBoxLabel(TextureHitboxLayeredPane theParent, HSBox theBox) {
        this.setOpaque(true);
        this.parent = theParent;
        this.box = theBox;
        this.mouseStartX = 0;
        this.mouseStartY = 0;
        this.topLeft = new Rectangle();
        this.top = new Rectangle();
        this.topRight = new Rectangle();
        this.left = new Rectangle();
        this.right = new Rectangle();
        this.bottomLeft = new Rectangle();
        this.bottom = new Rectangle();
        this.bottomRight = new Rectangle();
        this.resizeBoxPressed = null;
        this.mouseMoveThreshold = 5;
        this.moveBox = false;
        this.locked = false;
        this.setText("");
        Point pos = this.parent.parent.getSwingOffset(this.box.offset.x, this.box.offset.y);
        this.setMinimumSize(new Dimension((int)this.box.width, (int)this.box.height));
        this.setMaximumSize(new Dimension((int)this.box.width, (int)this.box.height));
        this.setBounds(pos.x, pos.y, (int)this.box.width, (int)this.box.height);
        this.setResizeBoxes();
        this.setAsHurtBox();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public HSBoxLabel(HSBoxLabel l) {
        this(l.parent, l.box);
        this.setBounds(l.getBounds());
        this.box = new HSBox(this.box);
        this.setName(l.getName());
    }

    private void setResizeBoxes() {
        this.topLeft.setBounds(0, 0, resizeBoxSize, resizeBoxSize);
        this.top.setBounds((int)this.box.width / 2 - resizeBoxSize / 2 - 1, 0, resizeBoxSize, resizeBoxSize);
        this.topRight.setBounds((int)this.box.width - resizeBoxSize - 1, 0, resizeBoxSize, resizeBoxSize);
        this.left.setBounds(0, (int)this.box.height / 2 - resizeBoxSize / 2 - 1, resizeBoxSize, resizeBoxSize);
        this.right.setBounds((int)this.box.width - resizeBoxSize - 1, (int)this.box.height / 2 - resizeBoxSize / 2 - 1, resizeBoxSize, resizeBoxSize);
        this.bottomLeft.setBounds(0, (int)this.box.height - resizeBoxSize - 1, resizeBoxSize, resizeBoxSize);
        this.bottom.setBounds((int)this.box.width / 2 - resizeBoxSize / 2 - 1, (int)this.box.height - resizeBoxSize - 1, resizeBoxSize, resizeBoxSize);
        this.bottomRight.setBounds((int)this.box.width - resizeBoxSize, (int)this.box.height - resizeBoxSize - 1, resizeBoxSize, resizeBoxSize);
    }

    public void setAsTerrainBox() {
        this.setName("terrain");
        this.updateColor();
    }

    public void setAsAttackBox() {
        this.setName("attack");
        this.updateColor();
    }

    public void setAsHurtBox() {
        this.setName("hurt");
        this.updateColor();
    }

    public void updateColor() {
        if (this.getName().compareTo("terrain") == 0) {
            this.setBackground(Color.green);
            this.setBorder(BorderFactory.createLineBorder(Color.green, 1, false));
        } else if (this.getName().compareTo("attack") == 0) {
            this.setBackground(Color.red);
            this.setBorder(BorderFactory.createLineBorder(Color.red, 1, false));
        } else if (this.getName().compareTo("hurt") == 0) {
            this.setBackground(Color.blue);
            this.setBorder(BorderFactory.createLineBorder(Color.blue, 1, false));
        }
        if (this.locked) {
            this.setBackground(this.getBackground().darker());
        }
    }

    public void createHitboxAttributesWindow() {
        HitboxAttributesWindow newWindow = new HitboxAttributesWindow(this);
        newWindow.setVisible(true);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        if (this.parent.selectedItems.size() == 1 && this.parent.selectedItems.contains(this)) {
            this.setResizeBoxes();
            g2.draw(this.topLeft);
            g2.draw(this.top);
            g2.draw(this.topRight);
            g2.draw(this.left);
            g2.draw(this.right);
            g2.draw(this.bottomLeft);
            g2.draw(this.bottom);
            g2.draw(this.bottomRight);
        }
        super.paint(g2);
        g2.dispose();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.moveBox = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.createHitboxAttributesWindow();
        } else if (e.getClickCount() == 1) {
            boolean multiSelect = false;
            if (e.isControlDown()) {
                if (this.parent.selectedItems.contains(this)) {
                    this.parent.unselect(this);
                    return;
                }
                multiSelect = true;
            }
            this.parent.setSelected(this, multiSelect);
            this.mouseStartX = e.getX();
            this.mouseStartY = e.getY();
            this.resizeBoxPressed = null;
            if (this.topLeft.contains(this.mouseStartX, this.mouseStartY)) {
                this.resizeBoxPressed = this.topLeft;
            } else if (this.top.contains(this.mouseStartX, this.mouseStartY)) {
                this.resizeBoxPressed = this.top;
            } else if (this.topRight.contains(this.mouseStartX, this.mouseStartY)) {
                this.resizeBoxPressed = this.topRight;
            } else if (this.left.contains(this.mouseStartX, this.mouseStartY)) {
                this.resizeBoxPressed = this.left;
            } else if (this.right.contains(this.mouseStartX, this.mouseStartY)) {
                this.resizeBoxPressed = this.right;
            } else if (this.bottomLeft.contains(this.mouseStartX, this.mouseStartY)) {
                this.resizeBoxPressed = this.bottomLeft;
            } else if (this.bottom.contains(this.mouseStartX, this.mouseStartY)) {
                this.resizeBoxPressed = this.bottom;
            } else if (this.bottomRight.contains(this.mouseStartX, this.mouseStartY)) {
                this.resizeBoxPressed = this.bottomRight;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.moveBox = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.parent.selectedItems.contains(this)) {
            return;
        }
        if (this.locked) {
            return;
        }
        int MINSIZE = 10;
        Component c = e.getComponent();
        if (c == null) {
            return;
        }
        int xDiff = e.getX() - this.mouseStartX;
        int yDiff = e.getY() - this.mouseStartY;
        if (Math.abs(xDiff) >= this.mouseMoveThreshold || Math.abs(yDiff) >= this.mouseMoveThreshold) {
            this.moveBox = true;
        }
        if (!this.moveBox) {
            return;
        }
        if (this.resizeBoxPressed == null) {
            this.box.offset.x += (float)xDiff;
            this.box.offset.y += (float)yDiff;
        } else if (this.resizeBoxPressed == this.topLeft) {
            this.box.offset.x += (float)xDiff;
            this.box.offset.y += (float)yDiff;
            this.box.width -= (float)xDiff;
            this.box.height -= (float)yDiff;
            if (this.box.width < 10.0f) {
                this.box.offset.x -= -this.box.width + 10.0f;
                this.box.width = 10.0f;
            }
            if (this.box.height < 10.0f) {
                this.box.offset.y -= -this.box.height + 10.0f;
                this.box.height = 10.0f;
            }
        } else if (this.resizeBoxPressed == this.top) {
            this.box.offset.y += (float)yDiff;
            this.box.height -= (float)yDiff;
            if (this.box.height < 10.0f) {
                this.box.offset.y -= -this.box.height + 10.0f;
                this.box.height = 10.0f;
            }
        } else if (this.resizeBoxPressed == this.topRight) {
            this.box.offset.y += (float)yDiff;
            this.box.width += (float)xDiff;
            this.mouseStartX = e.getX();
            this.box.height -= (float)yDiff;
            if (this.box.width < 10.0f) {
                this.box.width = 10.0f;
            }
            if (this.box.height < 10.0f) {
                this.box.offset.y -= -this.box.height + 10.0f;
                this.box.height = 10.0f;
            }
        } else if (this.resizeBoxPressed == this.left) {
            this.box.offset.x += (float)xDiff;
            this.box.width -= (float)xDiff;
            if (this.box.width < 10.0f) {
                this.box.offset.x -= -this.box.width + 10.0f;
                this.box.width = 10.0f;
            }
        } else if (this.resizeBoxPressed == this.right) {
            this.box.width += (float)xDiff;
            this.mouseStartX = e.getX();
            if (this.box.width < 10.0f) {
                this.box.width = 10.0f;
            }
        } else if (this.resizeBoxPressed == this.bottomLeft) {
            this.box.offset.x += (float)xDiff;
            this.box.width -= (float)xDiff;
            this.box.height += (float)yDiff;
            this.mouseStartY = e.getY();
            if (this.box.width < 10.0f) {
                this.box.offset.x -= -this.box.width + 10.0f;
                this.box.width = 10.0f;
            }
            if (this.box.height < 10.0f) {
                this.box.height = 10.0f;
            }
        } else if (this.resizeBoxPressed == this.bottom) {
            this.box.height += (float)yDiff;
            this.mouseStartY = e.getY();
            if (this.box.height < 10.0f) {
                this.box.height = 10.0f;
            }
        } else if (this.resizeBoxPressed == this.bottomRight) {
            this.box.width += (float)xDiff;
            this.mouseStartX = e.getX();
            this.box.height += (float)yDiff;
            this.mouseStartY = e.getY();
            if (this.box.width < 10.0f) {
                this.box.width = 10.0f;
            }
            if (this.box.height < 10.0f) {
                this.box.height = 10.0f;
            }
        }
        Point pos = this.parent.parent.getSwingOffset(this.box.offset.x, this.box.offset.y);
        this.setBounds(pos.x, pos.y, (int)this.box.width, (int)this.box.height);
        this.parent.repaint();
    }
}

