/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.objects.holds.properties;

import homestrifeeditor.TGAReader;
import homestrifeeditor.objects.holds.properties.HSTexture;
import homestrifeeditor.windows.TextureAttributesWindow;
import homestrifeeditor.windows.panes.TextureHitboxLayeredPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class HSTextureLabel
extends JLabel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    public TextureHitboxLayeredPane parent;
    public HSTexture texture;
    public ImageIcon icon;
    private int mouseStartX;
    private int mouseStartY;
    private int mouseMoveThreshold;
    private boolean moveBox;
    public boolean locked;

    public HSTextureLabel(TextureHitboxLayeredPane theParent, HSTexture theTexture) {
        this.setName("texture");
        this.parent = theParent;
        this.texture = theTexture;
        this.mouseStartX = 0;
        this.mouseStartY = 0;
        this.mouseMoveThreshold = 5;
        this.moveBox = false;
        this.locked = false;
        this.loadIcon();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public HSTextureLabel(HSTextureLabel l) {
        this(l.parent, l.texture);
        this.setBounds(l.getBounds());
        this.texture = new HSTexture(this.texture);
    }

    public void loadIcon() {
        this.icon = this.parent.parent.parent.currentlyLoadedObject.palettes.size() > 0 ? TGAReader.loadTGA(this.texture.filePath, this.parent.parent.parent.currentlyLoadedObject.palettes.get((int)this.parent.parent.parent.currentlyLoadedObject.curPalette).path) : TGAReader.loadTGA(this.texture.filePath, "");
        this.setIcon(this.icon);
        this.setText("");
        this.setName("texture");
        this.setMinimumSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.setMaximumSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        Point pos = this.parent.parent.getSwingOffset(this.texture.offset.x, this.texture.offset.y);
        this.setBounds(pos.x, pos.y, this.icon.getIconWidth(), this.icon.getIconHeight());
    }

    public void createTextureAttributesWindow() {
        TextureAttributesWindow newWindow = new TextureAttributesWindow(this);
        newWindow.setVisible(true);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.moveBox = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.createTextureAttributesWindow();
        } else if (e.getClickCount() == 1) {
            boolean multiSelect = false;
            if (e.isControlDown()) {
                if (this.parent.selectedItems.contains(this)) {
                    this.parent.unselect(this);
                    return;
                }
                multiSelect = true;
            }
            this.parent.setSelected(this, multiSelect);
            this.mouseStartX = e.getX();
            this.mouseStartY = e.getY();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.moveBox = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.parent.selectedItems.contains(this)) {
            return;
        }
        if (this.locked) {
            return;
        }
        Component c = e.getComponent();
        if (c == null) {
            return;
        }
        int xDiff = e.getX() - this.mouseStartX;
        int yDiff = e.getY() - this.mouseStartY;
        if (Math.abs(xDiff) >= this.mouseMoveThreshold || Math.abs(yDiff) >= this.mouseMoveThreshold) {
            this.moveBox = true;
        }
        if (!this.moveBox) {
            return;
        }
        this.texture.offset.x += (float)xDiff;
        this.texture.offset.y += (float)yDiff;
        Point pos = this.parent.parent.getSwingOffset(this.texture.offset.x, this.texture.offset.y);
        this.setBounds(pos.x, pos.y, this.icon.getIconWidth(), this.icon.getIconHeight());
        this.parent.repaint();
    }
}

