/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows;

import homestrifeeditor.TGAReader;
import homestrifeeditor.objects.FighterObject;
import homestrifeeditor.objects.HSObject;
import homestrifeeditor.objects.PhysicsObject;
import homestrifeeditor.objects.TerrainObject;
import homestrifeeditor.objects.holds.FighterHold;
import homestrifeeditor.objects.holds.HSObjectHold;
import homestrifeeditor.objects.holds.PhysicsObjectHold;
import homestrifeeditor.objects.holds.TerrainObjectHold;
import homestrifeeditor.objects.holds.properties.Blockability;
import homestrifeeditor.objects.holds.properties.Cancel;
import homestrifeeditor.objects.holds.properties.HSAudio;
import homestrifeeditor.objects.holds.properties.HSBox;
import homestrifeeditor.objects.holds.properties.HSPalette;
import homestrifeeditor.objects.holds.properties.HSSpawnObject;
import homestrifeeditor.objects.holds.properties.HSTexture;
import homestrifeeditor.objects.holds.properties.HitLevel;
import homestrifeeditor.objects.holds.properties.Invulnerability;
import homestrifeeditor.windows.EventHoldsWindow;
import homestrifeeditor.windows.ObjectAttributesWindow;
import homestrifeeditor.windows.PalettesWindow;
import homestrifeeditor.windows.panes.HoldListPane;
import homestrifeeditor.windows.panes.TextureHitboxPane;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EditorWindow
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int XML_FORMAT_VERSION = 2;
    public static String BaseWindowTitle = "Homestrife Editor - ";
    public static int windowWidth = 1000;
    public static int windowHeight = 600;
    public static int newObjectTerrainBoxSize = 200;
    public HoldListPane holdListPane;
    public TextureHitboxPane textureHitboxPane;
    public HSObject currentlyLoadedObject = null;
    public String workingDirectory = "";
    public String exeDirectory;
    public String fileChooserDirectory;
    private JMenu palettesMenu;
    public static JFileChooser fileChooser;
    private String changeLogText = "<html><h2>Noteworthy Changes:</h2>17 July, 2014:<ul><li>Faster scrolling</li></ul>16 July, 2014:<ul><li>Can now scroll and resize Hold Attributes window</li></ul>15 July, 2014:<ul><li>Add a bunch of new TerrainObject hold data</li></ul>7 May, 2014:<ul><li>Saves using only forward slashes</li></ul>30 April, 2014:<ul><li>Added spawn object indicator in hold window/list</li><li>Added change log! :D</li></ul></html>";
    int curPal;

    public EditorWindow() {
        this.loadSettings();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EditorWindow.this.saveSettings();
                super.windowClosing(e);
            }
        });
        this.setTitle(String.valueOf(BaseWindowTitle) + "No Object Loaded");
        this.setSize(windowWidth, windowHeight);
        this.setMinimumSize(new Dimension(windowWidth, windowHeight));
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.createMenuBar();
        this.createWindowContents();
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyDispatcher());
    }

    private void createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenu newObjectMenu = new JMenu("New");
        JMenuItem newGraphicItem = new JMenuItem("Graphic");
        newGraphicItem.setActionCommand("newGraphic");
        newGraphicItem.addActionListener(this);
        JMenuItem newTerrainItem = new JMenuItem("Terrain");
        newTerrainItem.setActionCommand("newTerrain");
        newTerrainItem.addActionListener(this);
        JMenuItem newPhysicsObjectItem = new JMenuItem("Physics Object");
        newPhysicsObjectItem.setActionCommand("newPhysicsObject");
        newPhysicsObjectItem.addActionListener(this);
        JMenuItem newFighterItem = new JMenuItem("Fighter");
        newFighterItem.setActionCommand("newFighter");
        newFighterItem.addActionListener(this);
        JMenuItem generateItem = new JMenuItem("Generate...");
        generateItem.setActionCommand("generate");
        generateItem.addActionListener(this);
        JMenuItem openItem = new JMenuItem("Open...");
        openItem.setActionCommand("open");
        openItem.addActionListener(this);
        JMenuItem saveItem = new JMenuItem("Save");
        saveItem.setActionCommand("save");
        saveItem.addActionListener(this);
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        JMenuItem saveAsItem = new JMenuItem("Save As...");
        saveAsItem.setActionCommand("saveAs");
        saveAsItem.addActionListener(this);
        JMenuItem importAnimationItem = new JMenuItem("Import Animation");
        importAnimationItem.setActionCommand("importAnimation");
        importAnimationItem.addActionListener(this);
        JMenuItem setExeLocationItem = new JMenuItem("Set Game Location");
        setExeLocationItem.setActionCommand("exeLocation");
        setExeLocationItem.addActionListener(this);
        newObjectMenu.add(newGraphicItem);
        newObjectMenu.add(newTerrainItem);
        newObjectMenu.add(newPhysicsObjectItem);
        newObjectMenu.add(newFighterItem);
        fileMenu.add(newObjectMenu);
        fileMenu.add(generateItem);
        fileMenu.add(openItem);
        fileMenu.add(saveItem);
        fileMenu.add(saveAsItem);
        fileMenu.add(new JSeparator());
        fileMenu.add(importAnimationItem);
        fileMenu.add(new JSeparator());
        fileMenu.add(setExeLocationItem);
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        JMenuItem undoItem = new JMenuItem("Undo");
        undoItem.setActionCommand("undo");
        undoItem.addActionListener(this);
        undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        JMenuItem redoItem = new JMenuItem("Redo");
        redoItem.setActionCommand("redo");
        redoItem.addActionListener(this);
        JMenuItem cutItem = new JMenuItem("Cut");
        cutItem.setActionCommand("cut");
        cutItem.addActionListener(this);
        cutItem.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        JMenuItem copyItem = new JMenuItem("Copy");
        copyItem.setActionCommand("copy");
        copyItem.addActionListener(this);
        copyItem.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        JMenuItem pasteItem = new JMenuItem("Paste");
        pasteItem.setActionCommand("paste");
        pasteItem.addActionListener(this);
        pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        JMenuItem deleteItem = new JMenuItem("Delete");
        deleteItem.setActionCommand("delete");
        deleteItem.addActionListener(this);
        deleteItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        JMenuItem selectAllItem = new JMenuItem("Select All");
        selectAllItem.setActionCommand("selectAll");
        selectAllItem.addActionListener(this);
        selectAllItem.setAccelerator(KeyStroke.getKeyStroke(65, 512));
        editMenu.add(undoItem);
        editMenu.add(redoItem);
        editMenu.add(new JSeparator());
        editMenu.add(cutItem);
        editMenu.add(copyItem);
        editMenu.add(pasteItem);
        editMenu.add(deleteItem);
        editMenu.add(selectAllItem);
        menuBar.add(editMenu);
        JMenu objectMenu = new JMenu("Object");
        JMenuItem objectAttributesItem = new JMenuItem("Attributes");
        objectAttributesItem.setActionCommand("objectAttributes");
        objectAttributesItem.addActionListener(this);
        JMenuItem eventHoldsItem = new JMenuItem("Event Holds");
        eventHoldsItem.setActionCommand("eventHolds");
        eventHoldsItem.addActionListener(this);
        objectMenu.add(objectAttributesItem);
        objectMenu.add(eventHoldsItem);
        menuBar.add(objectMenu);
        this.palettesMenu = new JMenu("Palettes");
        menuBar.add(this.palettesMenu);
        this.updatePalettesMenu();
        JMenu helpMenu = new JMenu("Help");
        JMenuItem helpContentItem = new JMenuItem("Help Content");
        helpContentItem.setActionCommand("helpContent");
        helpContentItem.addActionListener(this);
        JMenuItem aboutItem = new JMenuItem("About");
        aboutItem.setActionCommand("about");
        aboutItem.addActionListener(this);
        JMenuItem changeLogItem = new JMenuItem("Change Log");
        changeLogItem.setActionCommand("changeLog");
        changeLogItem.addActionListener(this);
        helpMenu.add(helpContentItem);
        helpMenu.add(aboutItem);
        helpMenu.add(changeLogItem);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
    }

    private JComponent createHoldListPane() {
        this.holdListPane = new HoldListPane(this);
        return this.holdListPane;
    }

    private JComponent createHoldDataPane() {
        this.textureHitboxPane = new TextureHitboxPane(this);
        return this.textureHitboxPane;
    }

    private void createWindowContents() {
        JSplitPane sp = new JSplitPane(1, this.createHoldListPane(), this.createHoldDataPane());
        sp.setResizeWeight(0.34);
        this.setContentPane(sp);
    }

    private void loadSettings() {
        File file = new File("settings.xml");
        fileChooser = new JFileChooser(".");
        this.exeDirectory = "";
        this.fileChooserDirectory = ".";
        System.out.println("Loading Settings...");
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            doc.getDocumentElement().normalize();
            Element root = doc.getDocumentElement();
            if (root.getNodeName().compareTo("Settings") != 0) {
                JOptionPane.showMessageDialog(this, "Settings file has invalid root, expected <Settings>", "Error loading settings", 0);
                return;
            }
            NodeList nodes = root.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                System.out.println(String.valueOf(node.getNodeName()) + ": " + node.getTextContent());
                switch (node.getNodeName()) {
                    case "FileChooserDir": {
                        if (node.getTextContent() != null) {
                            this.fileChooserDirectory = node.getTextContent();
                        }
                        fileChooser = new JFileChooser(this.fileChooserDirectory);
                        break;
                    }
                    case "ExeDir": {
                        if (node.getTextContent() == null) break;
                        this.exeDirectory = node.getTextContent();
                    }
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            JOptionPane.showMessageDialog(this, String.valueOf(e.getMessage()) + " | Using default settings", "Parser Configuration Exception", 0);
            return;
        }
        catch (SAXException e) {
            JOptionPane.showMessageDialog(this, String.valueOf(e.getMessage()) + " | Using default settings", "SAX Exception", 0);
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("Finished Loading Settings\n");
        if (this.exeDirectory.isEmpty() && JOptionPane.showConfirmDialog(this, "Set game .exe directory now?", ".exe Directory Not Set", 0) == 0) {
            this.setExeLocation();
        }
    }

    private void saveSettings() {
        System.out.println("\nSaving Settings...");
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.newDocument();
            Element root = doc.createElement("Settings");
            Element chooserDir = doc.createElement("FileChooserDir");
            chooserDir.setTextContent(fileChooser.getCurrentDirectory().getPath());
            System.out.println("FileChooserDir: " + fileChooser.getCurrentDirectory().getPath());
            Element exeDir = doc.createElement("ExeDir");
            exeDir.setTextContent(this.exeDirectory);
            System.out.println("ExeDir: " + this.exeDirectory);
            root.appendChild(chooserDir);
            root.appendChild(exeDir);
            doc.appendChild(root);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File("settings.xml"));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Parser Configuration Exception", 0);
        }
        catch (TransformerConfigurationException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Transformer Configuration Exception", 0);
        }
        catch (TransformerException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Transformer Exception", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Exception", 0);
        }
    }

    private void setExeLocation() {
        File lastFile = fileChooser.getCurrentDirectory();
        fileChooser = new JFileChooser(this.exeDirectory);
        fileChooser.setFileSelectionMode(1);
        int returnVal = fileChooser.showDialog(this, "Choose .exe Location");
        if (returnVal == 0) {
            this.exeDirectory = fileChooser.getSelectedFile().getAbsolutePath();
            System.out.println(this.exeDirectory);
        }
        fileChooser = new JFileChooser(lastFile);
    }

    public void setCurrentlyLoadedObject(HSObject newObject) {
        this.currentlyLoadedObject = newObject;
        this.setTitle(String.valueOf(BaseWindowTitle) + newObject.name);
    }

    public ArrayList<HSObjectHold> getAllHolds() {
        return this.holdListPane.getAllHolds();
    }

    public void applyHoldChanges(HSObjectHold hold, TreePath path) {
        this.holdListPane.applyHoldChanges(hold, path);
    }

    public void newObject() {
        if (this.currentlyLoadedObject.IsTerrainObject() && ((TerrainObject)this.currentlyLoadedObject).terrainBoxes.size() == 0) {
            HSBox terrainBox = new HSBox();
            terrainBox.width = newObjectTerrainBoxSize;
            terrainBox.height = newObjectTerrainBoxSize;
            terrainBox.offset.x = -terrainBox.width / 2.0f;
            terrainBox.offset.y = -terrainBox.height / 2.0f;
            terrainBox.depth = 1;
            ((TerrainObject)this.currentlyLoadedObject).terrainBoxes.add(terrainBox);
        }
        if (this.currentlyLoadedObject.IsFighter() && ((FighterObject)this.currentlyLoadedObject).uprightTerrainBoxes.size() == 0) {
            HSBox uprightBox = new HSBox();
            uprightBox.width = newObjectTerrainBoxSize;
            uprightBox.height = newObjectTerrainBoxSize * 2;
            uprightBox.offset.x = -uprightBox.width / 2.0f;
            uprightBox.offset.y = -uprightBox.height;
            uprightBox.depth = 1;
            ((FighterObject)this.currentlyLoadedObject).uprightTerrainBoxes.add(uprightBox);
        }
        if (this.currentlyLoadedObject.IsFighter() && ((FighterObject)this.currentlyLoadedObject).crouchingTerrainBoxes.size() == 0) {
            HSBox crouchingBox = new HSBox();
            crouchingBox.width = newObjectTerrainBoxSize;
            crouchingBox.height = newObjectTerrainBoxSize;
            crouchingBox.offset.x = -crouchingBox.width / 2.0f;
            crouchingBox.offset.y = -crouchingBox.height;
            crouchingBox.depth = 1;
            ((FighterObject)this.currentlyLoadedObject).crouchingTerrainBoxes.add(crouchingBox);
        }
        if (this.currentlyLoadedObject.IsFighter() && ((FighterObject)this.currentlyLoadedObject).proneTerrainBoxes.size() == 0) {
            HSBox proneBox = new HSBox();
            proneBox.width = newObjectTerrainBoxSize * 2;
            proneBox.height = newObjectTerrainBoxSize;
            proneBox.offset.x = -proneBox.width / 2.0f;
            proneBox.offset.y = -proneBox.height;
            proneBox.depth = 1;
            ((FighterObject)this.currentlyLoadedObject).proneTerrainBoxes.add(proneBox);
        }
        if (this.currentlyLoadedObject.IsFighter() && ((FighterObject)this.currentlyLoadedObject).compactTerrainBoxes.size() == 0) {
            HSBox compactBox = new HSBox();
            compactBox.width = newObjectTerrainBoxSize;
            compactBox.height = newObjectTerrainBoxSize;
            compactBox.offset.x = -compactBox.width / 2.0f;
            compactBox.offset.y = -compactBox.height * 1.5f;
            compactBox.depth = 1;
            ((FighterObject)this.currentlyLoadedObject).compactTerrainBoxes.add(compactBox);
        }
        this.holdListPane.loadObjectHolds(this.currentlyLoadedObject);
        this.textureHitboxPane.resetScrollBars();
        this.textureHitboxPane.setCorrectTerrainBox();
        this.updatePalettesMenu();
    }

    public void newGraphic() {
        this.workingDirectory = "";
        this.setCurrentlyLoadedObject(new HSObject());
        HSObjectHold newHold = new HSObjectHold();
        this.currentlyLoadedObject.holds.add(newHold);
        this.newObject();
        this.updatePalettesMenu();
    }

    public void newTerrain() {
        this.workingDirectory = "";
        this.setCurrentlyLoadedObject(new TerrainObject());
        TerrainObjectHold newHold = new TerrainObjectHold();
        this.currentlyLoadedObject.holds.add(newHold);
        this.newObject();
        this.updatePalettesMenu();
    }

    public void newPhysicsObject() {
        this.workingDirectory = "";
        this.setCurrentlyLoadedObject(new PhysicsObject());
        PhysicsObjectHold newHold = new PhysicsObjectHold();
        this.currentlyLoadedObject.holds.add(newHold);
        this.newObject();
        this.updatePalettesMenu();
    }

    public void newFighter() {
        this.workingDirectory = "";
        this.setCurrentlyLoadedObject(new FighterObject());
        FighterHold newHold = new FighterHold();
        this.currentlyLoadedObject.holds.add(newHold);
        this.newObject();
        this.updatePalettesMenu();
    }

    private void generate() {
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        try {
            String type;
            int n;
            int n2;
            File[] fileArray;
            File f;
            File[] animDirectories;
            HSObject newObject;
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            doc.getDocumentElement().normalize();
            if (doc.getDocumentElement().getNodeName().compareTo("HSAutoGenerateDefinition") != 0) {
                return;
            }
            String objectType = doc.getElementsByTagName("ObjectType").item(0).getTextContent();
            if (objectType.compareTo("Graphic") == 0) {
                newObject = new HSObject();
            } else if (objectType.compareTo("Terrain") == 0) {
                newObject = new TerrainObject();
            } else if (objectType.compareTo("PhysicsObject") == 0) {
                newObject = new PhysicsObject();
            } else if (objectType.compareTo("Fighter") == 0) {
                newObject = new FighterObject();
            } else {
                return;
            }
            File[] fileArray2 = animDirectories = file.getParentFile().listFiles();
            int n3 = animDirectories.length;
            int n4 = 0;
            while (n4 < n3) {
                f = fileArray2[n4];
                if (f.isDirectory() && f.getName().compareTo("palettes") == 0) {
                    File[] palettes = f.listFiles();
                    int paletteIndex = 0;
                    fileArray = palettes;
                    n2 = palettes.length;
                    n = 0;
                    while (n < n2) {
                        File p = fileArray[n];
                        type = Files.probeContentType(p.toPath());
                        if (type == null && p.getName().endsWith(".hsp")) {
                            HSPalette pal = new HSPalette();
                            pal.path = p.getAbsolutePath();
                            newObject.palettes.add(pal);
                            if (++paletteIndex >= palettes.length) break;
                        }
                        ++n;
                    }
                    if (paletteIndex >= palettes.length) break;
                }
                ++n4;
            }
            fileArray2 = animDirectories;
            n3 = animDirectories.length;
            n4 = 0;
            while (n4 < n3) {
                f = fileArray2[n4];
                if (f.isDirectory() && f.getName().compareTo("palettes") != 0) {
                    File[] holds = f.listFiles();
                    HSObjectHold prevHold = null;
                    fileArray = holds;
                    n2 = holds.length;
                    n = 0;
                    while (n < n2) {
                        File h = fileArray[n];
                        if (h.isFile() && (type = Files.probeContentType(h.toPath())) == null && h.getName().endsWith(".tga")) {
                            HSObjectHold newHold = newObject.IsFighter() ? new FighterHold() : (newObject.IsPhysicsObject() ? new PhysicsObjectHold() : (newObject.IsTerrainObject() ? new TerrainObjectHold() : new HSObjectHold()));
                            ImageIcon icon = TGAReader.loadTGA(h.getAbsolutePath(), newObject.palettes.size() > 0 ? newObject.palettes.get((int)0).path : "");
                            if (icon != null) {
                                HSTexture newTex = new HSTexture(h.getAbsolutePath());
                                newTex.depth = 0;
                                newTex.offset.x = -icon.getIconWidth() / 2;
                                newTex.offset.y = newObject.IsFighter() ? (float)(-icon.getIconHeight()) : (float)(-icon.getIconHeight() / 2);
                                newHold.duration = 4;
                                newHold.name = h.getName().replace(".tga", "");
                                newHold.textures.add(newTex);
                                newObject.holds.add(newHold);
                                if (prevHold == null) {
                                    String directoryName = f.getName();
                                    if (directoryName.compareTo("lifetime_death") == 0) {
                                        newObject.hsObjectEventHolds.lifetimeDeath = newHold;
                                    }
                                    if (newObject.IsTerrainObject() && directoryName.compareTo("health_death") == 0) {
                                        ((TerrainObject)newObject).terrainEventHolds.healthDeath = newHold;
                                    }
                                    newObject.IsPhysicsObject();
                                    if (newObject.IsFighter()) {
                                        if (directoryName.compareTo("idle") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.standing = newHold;
                                        }
                                        if (directoryName.compareTo("idleturn") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.turn = newHold;
                                        }
                                        if (directoryName.compareTo("walkstart") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.walk = newHold;
                                        }
                                        if (directoryName.compareTo("walk") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.walking = newHold;
                                        }
                                        if (directoryName.compareTo("walkturn") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.walkingTurn = newHold;
                                        }
                                        if (directoryName.compareTo("crouchstart") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.crouch = newHold;
                                        }
                                        if (directoryName.compareTo("crouch") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.crouching = newHold;
                                        }
                                        if (directoryName.compareTo("crouchturn") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.crouchingTurn = newHold;
                                        }
                                        if (directoryName.compareTo("crouchend") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.stand = newHold;
                                        }
                                        if (directoryName.compareTo("dashstart") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.run = newHold;
                                        }
                                        if (directoryName.compareTo("dash") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.running = newHold;
                                        }
                                        if (directoryName.compareTo("dashstop") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.runningStop = newHold;
                                        }
                                        if (directoryName.compareTo("dashturn") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.runningTurn = newHold;
                                        }
                                        if (directoryName.compareTo("jumpstart") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.jumpNeutralStart = newHold;
                                        }
                                        if (directoryName.compareTo("jumpstart_air") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.jumpNeutralStartAir = newHold;
                                        }
                                        if (directoryName.compareTo("jumprise_back") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.jumpBackwardRising = newHold;
                                        }
                                        if (directoryName.compareTo("jumprise_fwdneu") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.jumpNeutralRising = newHold;
                                        }
                                        if (directoryName.compareTo("jumppeak_back") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.jumpBackwardFall = newHold;
                                        }
                                        if (directoryName.compareTo("jumppeak_fwdneu") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.jumpNeutralFall = newHold;
                                        }
                                        if (directoryName.compareTo("jumpfall") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.jumpNeutralFalling = newHold;
                                        }
                                        if (directoryName.compareTo("landsoft") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.jumpNeutralLand = newHold;
                                        }
                                        if (directoryName.compareTo("airdash_back") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.airDashBackward = newHold;
                                        }
                                        if (directoryName.compareTo("airdash_fwd") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.airDashForward = newHold;
                                        }
                                        if (directoryName.compareTo("block_stand") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.blockHigh = newHold;
                                        }
                                        if (directoryName.compareTo("block_crouch") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.blockLow = newHold;
                                        }
                                        if (directoryName.compareTo("block_aerial") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.blockAir = newHold;
                                        }
                                        if (directoryName.compareTo("hitstand_highlt") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.hitstunLightHighStanding = newHold;
                                        }
                                        if (directoryName.compareTo("hitstand_midlt") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.hitstunLightMidStanding = newHold;
                                        }
                                        if (directoryName.compareTo("hitstand_lowlt") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.hitstunLightLowStanding = newHold;
                                        }
                                        if (directoryName.compareTo("hitcrouch_midlt") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.hitstunLightMidCrouching = newHold;
                                        }
                                        if (directoryName.compareTo("hitcrouch_lowlt") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.hitstunLightLowCrouching = newHold;
                                        }
                                        if (directoryName.compareTo("hitaerial_lt") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.hitstunLightAir = newHold;
                                        }
                                        if (directoryName.compareTo("atklt") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackLightNeutralGround = newHold;
                                        }
                                        if (directoryName.compareTo("atklt_dwn") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackLightDownGround = newHold;
                                        }
                                        if (directoryName.compareTo("atklt_fwd") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackLightForwardGround = newHold;
                                        }
                                        if (directoryName.compareTo("atklt_up") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackLightUpGround = newHold;
                                        }
                                        if (directoryName.compareTo("atklt_air") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackLightNeutralAir = newHold;
                                        }
                                        if (directoryName.compareTo("special_fwdlt") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackLightQCFGround = newHold;
                                        }
                                        if (directoryName.compareTo("atklt_airdwn") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackLightDownAir = newHold;
                                        }
                                        if (directoryName.compareTo("atklt_airfwd") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackLightForwardAir = newHold;
                                        }
                                        if (directoryName.compareTo("atklt_airup") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackLightUpAir = newHold;
                                        }
                                        if (directoryName.compareTo("atklt_airback") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackLightBackwardAir = newHold;
                                        }
                                        if (directoryName.compareTo("special_airfwdlt") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackLightQCFAir = newHold;
                                        }
                                        if (directoryName.compareTo("atkhvy") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackHeavyNeutralGround = newHold;
                                        }
                                        if (directoryName.compareTo("atkhvy_dwn") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackHeavyDownGround = newHold;
                                        }
                                        if (directoryName.compareTo("atkhvy_fwd") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackHeavyForwardGround = newHold;
                                        }
                                        if (directoryName.compareTo("atkhvy_up") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackHeavyUpGround = newHold;
                                        }
                                        if (directoryName.compareTo("atkhvy_air") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackHeavyNeutralAir = newHold;
                                        }
                                        if (directoryName.compareTo("special_fwdhvy") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackHeavyQCFGround = newHold;
                                        }
                                        if (directoryName.compareTo("atkhvy_airdwn") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackHeavyDownAir = newHold;
                                        }
                                        if (directoryName.compareTo("atkhvy_airfwd") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackHeavyForwardAir = newHold;
                                        }
                                        if (directoryName.compareTo("atkhvy_airup") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackHeavyUpAir = newHold;
                                        }
                                        if (directoryName.compareTo("atkhvy_airback") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackHeavyBackwardAir = newHold;
                                        }
                                        if (directoryName.compareTo("special_airfwdhvy") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.attackHeavyQCFAir = newHold;
                                        }
                                        if (directoryName.compareTo("ko") == 0) {
                                            ((FighterObject)newObject).fighterEventHolds.knockout = newHold;
                                        }
                                    }
                                } else {
                                    prevHold.nextHold = newHold;
                                }
                                prevHold = newHold;
                            }
                        }
                        ++n;
                    }
                }
                ++n4;
            }
            this.setCurrentlyLoadedObject(newObject);
            this.newObject();
            this.workingDirectory = file.getParent();
            this.updatePalettesMenu();
        }
        catch (ParserConfigurationException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Parser Configuration Exception", 0);
        }
        catch (SAXException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "SAX Exception", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "IO Exception", 0);
        }
    }

    private HSObjectHold getHoldFromId(HSObject object, int id) {
        for (HSObjectHold hold : object.holds) {
            if (hold.id != id) continue;
            return hold;
        }
        return null;
    }

    public String createAbsolutePath(String relPath) {
        return this.createAbsolutePathFrom(relPath, this.workingDirectory);
    }

    public String createAbsolutePathFrom(String relPath, String fromPath) {
        relPath = relPath.replace('\\', '/');
        if (!fromPath.endsWith("/")) {
            fromPath = String.valueOf(fromPath) + "/";
        }
        File a = new File(fromPath);
        File b = new File(a, relPath);
        String absolute = "";
        try {
            absolute = b.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return absolute.replace('\\', '/');
    }

    public String createRelativePath(String absPath) {
        return this.createPathRelativeTo(absPath, this.workingDirectory);
    }

    public String createPathRelativeTo(String absPath, String relativeTo) {
        int end;
        String[] absPathPieces;
        absPath = absPath.replace('\\', '/');
        String[] relativeToPieces = (relativeTo = relativeTo.replace('\\', '/')).split("/");
        if (!relativeToPieces[0].equals((absPathPieces = absPath.split("/"))[0])) {
            return "";
        }
        int divergeancePoint = end = relativeToPieces.length > absPathPieces.length ? absPathPieces.length : relativeToPieces.length;
        int i = 0;
        while (i < end) {
            if (!relativeToPieces[i].equals(absPathPieces[i])) {
                divergeancePoint = i;
                break;
            }
            ++i;
        }
        String relativePath = "";
        int i2 = 0;
        while (i2 < end - divergeancePoint) {
            relativePath = String.valueOf(relativePath) + "../";
            ++i2;
        }
        i2 = divergeancePoint;
        while (i2 < absPathPieces.length) {
            if (i2 > divergeancePoint) {
                relativePath = String.valueOf(relativePath) + "/";
            }
            relativePath = String.valueOf(relativePath) + absPathPieces[i2];
            ++i2;
        }
        return relativePath.replace('\\', '/');
    }

    private void open() {
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        try {
            HSObject loadObject;
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            doc.getDocumentElement().normalize();
            EditorWindow.removeWhitespaceNodes(doc);
            int version = 0;
            if (doc.getDocumentElement().getNodeName().compareTo("HSObjects") != 0) {
                System.out.println(String.valueOf(doc.getDocumentElement().getNodeName()) + " - Not Recognized As Definition - " + file.getName());
                return;
            }
            if (!doc.getDocumentElement().getAttribute("version").isEmpty()) {
                version = Integer.parseInt(doc.getDocumentElement().getAttribute("version"));
            }
            System.out.println("Loading object with xml format version: " + version);
            Node object = doc.getDocumentElement().getFirstChild();
            if (object.getNodeName().compareTo("Fighter") == 0) {
                loadObject = new FighterObject();
            } else if (object.getNodeName().compareTo("PhysicsObject") == 0) {
                loadObject = new PhysicsObject();
            } else if (object.getNodeName().compareTo("TerrainObject") == 0) {
                loadObject = new TerrainObject();
            } else if (object.getNodeName().compareTo("HSObject") == 0) {
                loadObject = new HSObject();
            } else {
                System.out.println(String.valueOf(object.getNodeName()) + " - Not Recognized As Object - " + file.getName());
                return;
            }
            this.workingDirectory = file.getParent();
            String relativeDir = this.exeDirectory;
            if (version == 0) {
                relativeDir = this.workingDirectory;
            }
            NodeList defSecs = object.getChildNodes();
            LinkedList<NamedNodeMap> terrainBoxAttributes = new LinkedList<NamedNodeMap>();
            Node terrainBoxes = null;
            NamedNodeMap uprightTerrainBoxAttributes = null;
            NamedNodeMap crouchingTerrainBoxAttributes = null;
            NamedNodeMap proneTerrainBoxAttributes = null;
            NamedNodeMap compactTerrainBoxAttributes = null;
            NamedNodeMap eventHoldsAttributes = null;
            Node holds = null;
            Node palettes = null;
            int i = 0;
            while (i < defSecs.getLength()) {
                Node defSec = defSecs.item(i);
                if (defSec.getNodeName().compareTo("TerrainBox") == 0) {
                    terrainBoxAttributes.add(defSec.getAttributes());
                }
                if (defSec.getNodeName().compareTo("TerrainBoxes") == 0) {
                    terrainBoxes = defSec;
                }
                if (defSec.getNodeName().compareTo("UprightTerrainBox") == 0) {
                    uprightTerrainBoxAttributes = defSec.getAttributes();
                }
                if (defSec.getNodeName().compareTo("CrouchingTerrainBox") == 0) {
                    crouchingTerrainBoxAttributes = defSec.getAttributes();
                }
                if (defSec.getNodeName().compareTo("ProneTerrainBox") == 0) {
                    proneTerrainBoxAttributes = defSec.getAttributes();
                }
                if (defSec.getNodeName().compareTo("CompactTerrainBox") == 0) {
                    compactTerrainBoxAttributes = defSec.getAttributes();
                }
                if (defSec.getNodeName().compareTo("EventHolds") == 0) {
                    eventHoldsAttributes = defSec.getAttributes();
                }
                if (defSec.getNodeName().compareTo("Holds") == 0) {
                    holds = defSec;
                }
                if (defSec.getNodeName().compareTo("Palettes") == 0) {
                    palettes = defSec;
                }
                ++i;
            }
            NodeList holdList = holds.getChildNodes();
            int i2 = 0;
            while (i2 < holdList.getLength()) {
                Node hold = holdList.item(i2);
                if (hold.getNodeName().compareTo("Hold") == 0) {
                    String filePath;
                    int j;
                    HSObjectHold loadHold = object.getNodeName().compareTo("Fighter") == 0 ? new FighterHold() : (object.getNodeName().compareTo("PhysicsObject") == 0 ? new PhysicsObjectHold() : (object.getNodeName().compareTo("TerrainObject") == 0 ? new TerrainObjectHold() : new HSObjectHold()));
                    NodeList holdSecs = hold.getChildNodes();
                    Node textures = null;
                    Node audioList = null;
                    Node spawnObjects = null;
                    Node attackBoxes = null;
                    Node hurtBoxes = null;
                    Node hitAudioList = null;
                    Node blockedAudioList = null;
                    int j2 = 0;
                    while (j2 < holdSecs.getLength()) {
                        Node holdSec = holdSecs.item(j2);
                        if (holdSec.getNodeName().compareTo("Textures") == 0) {
                            textures = holdSec;
                        }
                        if (holdSec.getNodeName().compareTo("AudioList") == 0) {
                            audioList = holdSec;
                        }
                        if (holdSec.getNodeName().compareTo("SpawnObjects") == 0) {
                            spawnObjects = holdSec;
                        }
                        if (holdSec.getNodeName().compareTo("AttackBoxes") == 0) {
                            attackBoxes = holdSec;
                        }
                        if (holdSec.getNodeName().compareTo("HurtBoxes") == 0) {
                            hurtBoxes = holdSec;
                        }
                        if (holdSec.getNodeName().compareTo("HitAudioList") == 0) {
                            hitAudioList = holdSec;
                        }
                        if (holdSec.getNodeName().compareTo("BlockedAudioList") == 0) {
                            blockedAudioList = holdSec;
                        }
                        ++j2;
                    }
                    NamedNodeMap holdAttributes = hold.getAttributes();
                    if (holdAttributes.getNamedItem("name") != null) {
                        loadHold.name = holdAttributes.getNamedItem("name").getNodeValue();
                    }
                    if (holdAttributes.getNamedItem("id") != null) {
                        loadHold.id = Integer.parseInt(holdAttributes.getNamedItem("id").getNodeValue());
                    }
                    if (holdAttributes.getNamedItem("nextHoldId") != null) {
                        loadHold.nextHoldId = Integer.parseInt(holdAttributes.getNamedItem("nextHoldId").getNodeValue());
                    }
                    if (holdAttributes.getNamedItem("duration") != null) {
                        loadHold.duration = Integer.parseInt(holdAttributes.getNamedItem("duration").getNodeValue());
                    }
                    if (holdAttributes.getNamedItem("repositionX") != null) {
                        loadHold.reposition.x = Float.parseFloat(holdAttributes.getNamedItem("repositionX").getNodeValue());
                    }
                    if (holdAttributes.getNamedItem("repositionY") != null) {
                        loadHold.reposition.y = Float.parseFloat(holdAttributes.getNamedItem("repositionY").getNodeValue());
                    }
                    if (holdAttributes.getNamedItem("velocityX") != null) {
                        loadHold.velocity.x = Float.parseFloat(holdAttributes.getNamedItem("velocityX").getNodeValue());
                    }
                    if (holdAttributes.getNamedItem("velocityY") != null) {
                        loadHold.velocity.y = Float.parseFloat(holdAttributes.getNamedItem("velocityY").getNodeValue());
                    }
                    if (holdAttributes.getNamedItem("overwriteVelocity") != null) {
                        loadHold.overwriteVelocity = Boolean.parseBoolean(holdAttributes.getNamedItem("overwriteVelocity").getNodeValue());
                    }
                    if (textures != null) {
                        NodeList textureList = textures.getChildNodes();
                        j = 0;
                        while (j < textureList.getLength()) {
                            if (textureList.item(j).getNodeName().compareTo("Texture") == 0) {
                                NamedNodeMap textureAttributes = textureList.item(j).getAttributes();
                                filePath = "";
                                if (textureAttributes.getNamedItem("textureFilePath") != null) {
                                    filePath = this.createAbsolutePathFrom(textureAttributes.getNamedItem("textureFilePath").getNodeValue(), relativeDir);
                                }
                                filePath = filePath.replace('\\', '/');
                                HSTexture tex = new HSTexture(filePath);
                                if (textureAttributes.getNamedItem("depth") != null) {
                                    tex.depth = Integer.parseInt(textureAttributes.getNamedItem("depth").getNodeValue());
                                }
                                if (textureAttributes.getNamedItem("offsetX") != null) {
                                    tex.offset.x = Float.parseFloat(textureAttributes.getNamedItem("offsetX").getNodeValue());
                                }
                                if (textureAttributes.getNamedItem("offsetY") != null) {
                                    tex.offset.y = Float.parseFloat(textureAttributes.getNamedItem("offsetY").getNodeValue());
                                }
                                loadHold.textures.add(tex);
                            }
                            ++j;
                        }
                    }
                    if (audioList != null) {
                        NodeList audioListList = audioList.getChildNodes();
                        j = 0;
                        while (j < audioListList.getLength()) {
                            if (audioListList.item(j).getNodeName().compareTo("Audio") == 0) {
                                NamedNodeMap audioAttributes = audioListList.item(j).getAttributes();
                                filePath = "";
                                if (audioAttributes.getNamedItem("audioFilePath") != null) {
                                    filePath = this.createAbsolutePathFrom(audioAttributes.getNamedItem("audioFilePath").getNodeValue(), relativeDir);
                                }
                                filePath = filePath.replace('\\', '/');
                                HSAudio aud = new HSAudio(filePath);
                                if (audioAttributes.getNamedItem("delay") != null) {
                                    aud.delay = Integer.parseInt(audioAttributes.getNamedItem("delay").getNodeValue());
                                }
                                if (audioAttributes.getNamedItem("exclusive") != null) {
                                    aud.exclusive = Boolean.parseBoolean(audioAttributes.getNamedItem("exclusive").getNodeValue());
                                }
                                if (audioAttributes.getNamedItem("usePercentage") != null) {
                                    aud.usePercentage = Boolean.parseBoolean(audioAttributes.getNamedItem("usePercentage").getNodeValue());
                                }
                                if (audioAttributes.getNamedItem("percentage") != null) {
                                    aud.percentage = Integer.parseInt(audioAttributes.getNamedItem("percentage").getNodeValue());
                                }
                                loadHold.audioList.add(aud);
                            }
                            ++j;
                        }
                    }
                    if (spawnObjects != null) {
                        NodeList spawnObjectsList = spawnObjects.getChildNodes();
                        j = 0;
                        while (j < spawnObjectsList.getLength()) {
                            if (spawnObjectsList.item(j).getNodeName().compareTo("SpawnObject") == 0) {
                                NamedNodeMap spawnObjectAttributes = spawnObjectsList.item(j).getAttributes();
                                filePath = "";
                                if (spawnObjectAttributes.getNamedItem("definitionFilePath") != null) {
                                    filePath = this.createAbsolutePathFrom(spawnObjectAttributes.getNamedItem("definitionFilePath").getNodeValue(), relativeDir);
                                }
                                filePath = filePath.replace('\\', '/');
                                HSSpawnObject sob = new HSSpawnObject(filePath);
                                if (spawnObjectAttributes.getNamedItem("delay") != null) {
                                    sob.delay = Integer.parseInt(spawnObjectAttributes.getNamedItem("delay").getNodeValue());
                                }
                                if (spawnObjectAttributes.getNamedItem("number") != null) {
                                    sob.number = Integer.parseInt(spawnObjectAttributes.getNamedItem("number").getNodeValue());
                                }
                                if (spawnObjectAttributes.getNamedItem("parentOffsetX") != null) {
                                    sob.parentOffset.x = Float.parseFloat(spawnObjectAttributes.getNamedItem("parentOffsetX").getNodeValue());
                                }
                                if (spawnObjectAttributes.getNamedItem("parentOffsetY") != null) {
                                    sob.parentOffset.y = Float.parseFloat(spawnObjectAttributes.getNamedItem("parentOffsetY").getNodeValue());
                                }
                                if (spawnObjectAttributes.getNamedItem("velocityX") != null) {
                                    sob.vel.x = Float.parseFloat(spawnObjectAttributes.getNamedItem("velocityX").getNodeValue());
                                }
                                if (spawnObjectAttributes.getNamedItem("velocityY") != null) {
                                    sob.vel.y = Float.parseFloat(spawnObjectAttributes.getNamedItem("velocityY").getNodeValue());
                                }
                                if (spawnObjectAttributes.getNamedItem("followParent") != null) {
                                    sob.followParent = Boolean.parseBoolean(spawnObjectAttributes.getNamedItem("followParent").getNodeValue());
                                }
                                if (spawnObjectAttributes.getNamedItem("collideParent") != null) {
                                    sob.collideParent = Boolean.parseBoolean(spawnObjectAttributes.getNamedItem("collideParent").getNodeValue());
                                }
                                if (spawnObjectAttributes.getNamedItem("useParentPalette") != null) {
                                    sob.useParentPalette = Boolean.parseBoolean(spawnObjectAttributes.getNamedItem("useParentPalette").getNodeValue());
                                }
                                loadHold.spawnObjects.add(sob);
                            }
                            ++j;
                        }
                    }
                    if (loadHold.IsTerrainObjectHold()) {
                        HSAudio aud;
                        String filePath2;
                        HSBox box;
                        TerrainObjectHold toHold = (TerrainObjectHold)loadHold;
                        try {
                            if (holdAttributes.getNamedItem("blockability") != null) {
                                toHold.blockability = Blockability.valueOf(holdAttributes.getNamedItem("blockability").getNodeValue());
                            }
                        }
                        catch (IllegalArgumentException e) {
                            toHold.blockability = Blockability.BLOCKABLE;
                        }
                        if (holdAttributes.getNamedItem("ownHitstop") != null) {
                            toHold.ownHitstop = Integer.parseInt(holdAttributes.getNamedItem("ownHitstop").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("ownHitstopOverride") != null) {
                            toHold.ownHitstopOverride = Boolean.parseBoolean(holdAttributes.getNamedItem("ownHitstopOverride").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("victimHitstop") != null) {
                            toHold.victimHitstop = Integer.parseInt(holdAttributes.getNamedItem("victimHitstop").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("victimHitstopOverride") != null) {
                            toHold.victimHitstopOverride = Boolean.parseBoolean(holdAttributes.getNamedItem("victimHitstopOverride").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("blockstun") != null) {
                            toHold.blockstun = Integer.parseInt(holdAttributes.getNamedItem("blockstun").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("changeAttackBoxAttributes") != null) {
                            toHold.changeAttackBoxAttributes = Boolean.parseBoolean(holdAttributes.getNamedItem("changeAttackBoxAttributes").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("damage") != null) {
                            toHold.damage = Integer.parseInt(holdAttributes.getNamedItem("damage").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("forceX") != null) {
                            toHold.force.x = Float.parseFloat(holdAttributes.getNamedItem("forceX").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("forceY") != null) {
                            toHold.force.y = Float.parseFloat(holdAttributes.getNamedItem("forceY").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("hitstun") != null) {
                            toHold.hitstun = Integer.parseInt(holdAttributes.getNamedItem("hitstun").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("horizontalDirectionBasedBlock") != null) {
                            toHold.horizontalDirectionBasedBlock = Boolean.parseBoolean(holdAttributes.getNamedItem("horizontalDirectionBasedBlock").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("reversedHorizontalBlock") != null) {
                            toHold.reversedHorizontalBlock = Boolean.parseBoolean(holdAttributes.getNamedItem("reversedHorizontalBlock").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("trips") != null) {
                            toHold.trips = Boolean.parseBoolean(holdAttributes.getNamedItem("trips").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("resetHits") != null) {
                            toHold.resetHits = Boolean.parseBoolean(holdAttributes.getNamedItem("resetHits").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("changeHurtBoxAttributes") != null) {
                            toHold.changeHurtBoxAttributes = Boolean.parseBoolean(holdAttributes.getNamedItem("changeHurtBoxAttributes").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("invulnerability") != null) {
                            toHold.invulnerability = Invulnerability.valueOf(holdAttributes.getNamedItem("invulnerability").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("hitLevel") != null) {
                            toHold.hitLevel = HitLevel.valueOf(holdAttributes.getNamedItem("hitLevel").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("superArmorHits") != null) {
                            toHold.superArmorHits = Integer.parseInt(holdAttributes.getNamedItem("superArmorHits").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("superArmorDamage") != null) {
                            toHold.superArmorDamage = Integer.parseInt(holdAttributes.getNamedItem("superArmorDamage").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("superArmorDamageScaling") != null) {
                            toHold.superArmorDamageScaling = Float.parseFloat(holdAttributes.getNamedItem("superArmorDamageScaling").getNodeValue());
                        }
                        if (attackBoxes != null) {
                            NodeList attackBoxList = attackBoxes.getChildNodes();
                            int j3 = 0;
                            while (j3 < attackBoxList.getLength()) {
                                if (attackBoxList.item(j3).getNodeName().compareTo("Box") == 0) {
                                    NamedNodeMap attackBoxAttributes = attackBoxList.item(j3).getAttributes();
                                    box = new HSBox();
                                    if (attackBoxAttributes.getNamedItem("width") != null) {
                                        box.width = Float.parseFloat(attackBoxAttributes.getNamedItem("width").getNodeValue());
                                    }
                                    if (attackBoxAttributes.getNamedItem("height") != null) {
                                        box.height = Float.parseFloat(attackBoxAttributes.getNamedItem("height").getNodeValue());
                                    }
                                    if (attackBoxAttributes.getNamedItem("offsetX") != null) {
                                        box.offset.x = Float.parseFloat(attackBoxAttributes.getNamedItem("offsetX").getNodeValue());
                                    }
                                    if (attackBoxAttributes.getNamedItem("offsetY") != null) {
                                        box.offset.y = Float.parseFloat(attackBoxAttributes.getNamedItem("offsetY").getNodeValue());
                                    }
                                    if (attackBoxAttributes.getNamedItem("depth") != null) {
                                        box.depth = Integer.parseInt(attackBoxAttributes.getNamedItem("depth").getNodeValue());
                                    }
                                    toHold.attackBoxes.add(box);
                                }
                                ++j3;
                            }
                        }
                        if (hurtBoxes != null) {
                            NodeList hurtBoxList = hurtBoxes.getChildNodes();
                            int j4 = 0;
                            while (j4 < hurtBoxList.getLength()) {
                                if (hurtBoxList.item(j4).getNodeName().compareTo("Box") == 0) {
                                    NamedNodeMap hurtBoxAttributes = hurtBoxList.item(j4).getAttributes();
                                    box = new HSBox();
                                    if (hurtBoxAttributes.getNamedItem("width") != null) {
                                        box.width = Float.parseFloat(hurtBoxAttributes.getNamedItem("width").getNodeValue());
                                    }
                                    if (hurtBoxAttributes.getNamedItem("height") != null) {
                                        box.height = Float.parseFloat(hurtBoxAttributes.getNamedItem("height").getNodeValue());
                                    }
                                    if (hurtBoxAttributes.getNamedItem("offsetX") != null) {
                                        box.offset.x = Float.parseFloat(hurtBoxAttributes.getNamedItem("offsetX").getNodeValue());
                                    }
                                    if (hurtBoxAttributes.getNamedItem("offsetY") != null) {
                                        box.offset.y = Float.parseFloat(hurtBoxAttributes.getNamedItem("offsetY").getNodeValue());
                                    }
                                    if (hurtBoxAttributes.getNamedItem("depth") != null) {
                                        box.depth = Integer.parseInt(hurtBoxAttributes.getNamedItem("depth").getNodeValue());
                                    }
                                    toHold.hurtBoxes.add(box);
                                }
                                ++j4;
                            }
                        }
                        if (hitAudioList != null) {
                            NodeList hitAudioListList = hitAudioList.getChildNodes();
                            int j5 = 0;
                            while (j5 < hitAudioListList.getLength()) {
                                if (hitAudioListList.item(j5).getNodeName().compareTo("HitAudio") == 0) {
                                    NamedNodeMap hitAudioAttributes = hitAudioListList.item(j5).getAttributes();
                                    filePath2 = "";
                                    if (hitAudioAttributes.getNamedItem("hitAudioFilePath") != null) {
                                        filePath2 = this.createAbsolutePathFrom(hitAudioAttributes.getNamedItem("hitAudioFilePath").getNodeValue(), relativeDir);
                                    }
                                    filePath2 = filePath2.replace('\\', '/');
                                    aud = new HSAudio(filePath2);
                                    if (hitAudioAttributes.getNamedItem("delay") != null) {
                                        aud.delay = Integer.parseInt(hitAudioAttributes.getNamedItem("delay").getNodeValue());
                                    }
                                    if (hitAudioAttributes.getNamedItem("exclusive") != null) {
                                        aud.exclusive = Boolean.parseBoolean(hitAudioAttributes.getNamedItem("exclusive").getNodeValue());
                                    }
                                    if (hitAudioAttributes.getNamedItem("usePercentage") != null) {
                                        aud.usePercentage = Boolean.parseBoolean(hitAudioAttributes.getNamedItem("usePercentage").getNodeValue());
                                    }
                                    if (hitAudioAttributes.getNamedItem("percentage") != null) {
                                        aud.percentage = Integer.parseInt(hitAudioAttributes.getNamedItem("percentage").getNodeValue());
                                    }
                                    toHold.hitAudioList.add(aud);
                                }
                                ++j5;
                            }
                        }
                        if (blockedAudioList != null) {
                            NodeList blockedAudioListList = blockedAudioList.getChildNodes();
                            int j6 = 0;
                            while (j6 < blockedAudioListList.getLength()) {
                                if (blockedAudioListList.item(j6).getNodeName().compareTo("BlockedAudio") == 0) {
                                    NamedNodeMap blockedAudioAttributes = blockedAudioListList.item(j6).getAttributes();
                                    filePath2 = "";
                                    if (blockedAudioAttributes.getNamedItem("blockedAudioFilePath") != null) {
                                        filePath2 = this.createAbsolutePathFrom(blockedAudioAttributes.getNamedItem("blockedAudioFilePath").getNodeValue(), relativeDir);
                                    }
                                    filePath2 = filePath2.replace('\\', '/');
                                    aud = new HSAudio(filePath2);
                                    if (blockedAudioAttributes.getNamedItem("delay") != null) {
                                        aud.delay = Integer.parseInt(blockedAudioAttributes.getNamedItem("delay").getNodeValue());
                                    }
                                    if (blockedAudioAttributes.getNamedItem("exclusive") != null) {
                                        aud.exclusive = Boolean.parseBoolean(blockedAudioAttributes.getNamedItem("exclusive").getNodeValue());
                                    }
                                    if (blockedAudioAttributes.getNamedItem("usePercentage") != null) {
                                        aud.usePercentage = Boolean.parseBoolean(blockedAudioAttributes.getNamedItem("usePercentage").getNodeValue());
                                    }
                                    if (blockedAudioAttributes.getNamedItem("percentage") != null) {
                                        aud.percentage = Integer.parseInt(blockedAudioAttributes.getNamedItem("percentage").getNodeValue());
                                    }
                                    toHold.blockedAudioList.add(aud);
                                }
                                ++j6;
                            }
                        }
                    }
                    if (loadHold.IsPhysicsObjectHold()) {
                        PhysicsObjectHold poHold = (PhysicsObjectHold)loadHold;
                        if (holdAttributes.getNamedItem("changePhysicsAttributes") != null) {
                            poHold.changePhysics = Boolean.parseBoolean(holdAttributes.getNamedItem("changePhysicsAttributes").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("ignoreGravity") != null) {
                            poHold.ignoreGravity = Boolean.parseBoolean(holdAttributes.getNamedItem("ignoreGravity").getNodeValue());
                        }
                    }
                    if (loadHold.IsFighterHold()) {
                        FighterHold fHold = (FighterHold)loadHold;
                        if (holdAttributes.getNamedItem("changeFighterAttributes") != null) {
                            fHold.changeFighterAttributes = Boolean.parseBoolean(holdAttributes.getNamedItem("changeFighterAttributes").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("disableAirControl") != null) {
                            fHold.disableAirControl = Boolean.parseBoolean(holdAttributes.getNamedItem("disableAirControl").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("endAirDash") != null) {
                            fHold.endAirDash = Boolean.parseBoolean(holdAttributes.getNamedItem("endAirDash").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("changeCancels") != null) {
                            fHold.changeCancels = Boolean.parseBoolean(holdAttributes.getNamedItem("changeCancels").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("dashCancel") != null) {
                            fHold.cancels.dash = Cancel.valueOf(holdAttributes.getNamedItem("dashCancel").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("jumpCancel") != null) {
                            fHold.cancels.jump = Cancel.valueOf(holdAttributes.getNamedItem("jumpCancel").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("lightNeutralCancel") != null) {
                            fHold.cancels.lightNeutral = Cancel.valueOf(holdAttributes.getNamedItem("lightNeutralCancel").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("lightForwardCancel") != null) {
                            fHold.cancels.lightForward = Cancel.valueOf(holdAttributes.getNamedItem("lightForwardCancel").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("lightUpCancel") != null) {
                            fHold.cancels.lightUp = Cancel.valueOf(holdAttributes.getNamedItem("lightUpCancel").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("lightDownCancel") != null) {
                            fHold.cancels.lightDown = Cancel.valueOf(holdAttributes.getNamedItem("lightDownCancel").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("lightBackwardCancel") != null) {
                            fHold.cancels.lightBackward = Cancel.valueOf(holdAttributes.getNamedItem("lightBackwardCancel").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("lightQCFCancel") != null) {
                            fHold.cancels.lightQCF = Cancel.valueOf(holdAttributes.getNamedItem("lightQCFCancel").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("heavyNeutralCancel") != null) {
                            fHold.cancels.heavyNeutral = Cancel.valueOf(holdAttributes.getNamedItem("heavyNeutralCancel").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("heavyForwardCancel") != null) {
                            fHold.cancels.heavyForward = Cancel.valueOf(holdAttributes.getNamedItem("heavyForwardCancel").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("heavyUpCancel") != null) {
                            fHold.cancels.heavyUp = Cancel.valueOf(holdAttributes.getNamedItem("heavyUpCancel").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("heavyDownCancel") != null) {
                            fHold.cancels.heavyDown = Cancel.valueOf(holdAttributes.getNamedItem("heavyDownCancel").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("heavyBackwardCancel") != null) {
                            fHold.cancels.heavyBackward = Cancel.valueOf(holdAttributes.getNamedItem("heavyBackwardCancel").getNodeValue());
                        }
                        if (holdAttributes.getNamedItem("heavyQCFCancel") != null) {
                            fHold.cancels.heavyQCF = Cancel.valueOf(holdAttributes.getNamedItem("heavyQCFCancel").getNodeValue());
                        }
                    }
                    loadObject.holds.add(loadHold);
                }
                ++i2;
            }
            NamedNodeMap objectAttributes = object.getAttributes();
            if (objectAttributes.getNamedItem("name") != null) {
                loadObject.name = objectAttributes.getNamedItem("name").getNodeValue();
            }
            if (objectAttributes.getNamedItem("lifetime") != null) {
                loadObject.lifetime = Integer.parseInt(objectAttributes.getNamedItem("lifetime").getNodeValue());
            }
            int i3 = 1;
            while (objectAttributes.getNamedItem("palette" + i3 + "FilePath") != null) {
                HSPalette pal = new HSPalette();
                pal.path = this.createAbsolutePathFrom(objectAttributes.getNamedItem("palette" + i3 + "FilePath").getNodeValue(), relativeDir);
                pal.path = pal.path.replace('\\', '/');
                pal.name = "Palette " + i3;
                pal.id = i3++;
                loadObject.palettes.add(pal);
            }
            if (palettes != null) {
                NodeList palettesList = palettes.getChildNodes();
                int i4 = 0;
                while (i4 < palettesList.getLength()) {
                    Node palette = palettesList.item(i4);
                    HSPalette pal = new HSPalette();
                    pal.path = this.createAbsolutePathFrom(palette.getAttributes().getNamedItem("path").getNodeValue(), relativeDir);
                    pal.path = pal.path.replace('\\', '/');
                    pal.name = palette.getAttributes().getNamedItem("name") != null ? palette.getAttributes().getNamedItem("name").getNodeValue() : "";
                    pal.id = palette.getAttributes().getNamedItem("id") != null ? Integer.parseInt(palette.getAttributes().getNamedItem("id").getNodeValue()) : i4;
                    loadObject.palettes.add(pal);
                    ++i4;
                }
            } else {
                JOptionPane.showMessageDialog(this, "Using legacy palette loading, advise saving again to convert to new palette format", "Legacy Palette Loading", 2);
            }
            if (eventHoldsAttributes != null && eventHoldsAttributes.getNamedItem("lifetimeDeath") != null) {
                loadObject.hsObjectEventHolds.lifetimeDeath = this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("lifetimeDeath").getNodeValue()));
            }
            if (loadObject.IsTerrainObject()) {
                TerrainObject tObject = (TerrainObject)loadObject;
                if (objectAttributes.getNamedItem("bounce") != null) {
                    tObject.bounce = Float.parseFloat(objectAttributes.getNamedItem("bounce").getNodeValue());
                }
                if (objectAttributes.getNamedItem("canBeJumpedThrough") != null) {
                    tObject.canBeJumpedThrough = Boolean.parseBoolean(objectAttributes.getNamedItem("canBeJumpedThrough").getNodeValue());
                }
                if (objectAttributes.getNamedItem("friction") != null) {
                    tObject.friction = Float.parseFloat(objectAttributes.getNamedItem("friction").getNodeValue());
                }
                if (objectAttributes.getNamedItem("health") != null) {
                    tObject.health = Integer.parseInt(objectAttributes.getNamedItem("health").getNodeValue());
                }
                if (objectAttributes.getNamedItem("takesTerrainDamage") != null) {
                    tObject.takesTerrainDamage = Boolean.parseBoolean(objectAttributes.getNamedItem("takesTerrainDamage").getNodeValue());
                }
                if (objectAttributes.getNamedItem("fragile") != null) {
                    tObject.fragile = Boolean.parseBoolean(objectAttributes.getNamedItem("fragile").getNodeValue());
                }
                if (version < 2) {
                    for (NamedNodeMap attr : terrainBoxAttributes) {
                        HSBox terrainBox = new HSBox();
                        if (attr.getNamedItem("width") != null) {
                            terrainBox.width = Float.parseFloat(attr.getNamedItem("width").getNodeValue());
                        }
                        if (attr.getNamedItem("height") != null) {
                            terrainBox.height = Float.parseFloat(attr.getNamedItem("height").getNodeValue());
                        }
                        if (attr.getNamedItem("offsetX") != null) {
                            terrainBox.offset.x = Float.parseFloat(attr.getNamedItem("offsetX").getNodeValue());
                        }
                        if (attr.getNamedItem("offsetY") != null) {
                            terrainBox.offset.y = Float.parseFloat(attr.getNamedItem("offsetY").getNodeValue());
                        }
                        if (attr.getNamedItem("depth") != null) {
                            terrainBox.depth = Integer.parseInt(attr.getNamedItem("depth").getNodeValue());
                        }
                        tObject.terrainBoxes.add(terrainBox);
                        if (!loadObject.IsPhysicsObject() && !loadObject.IsFighter()) {
                            continue;
                        }
                        break;
                    }
                } else {
                    NodeList terrainBoxNodeList = terrainBoxes.getChildNodes();
                    int i5 = 0;
                    while (i5 < terrainBoxNodeList.getLength()) {
                        Node tBox = terrainBoxNodeList.item(i5);
                        NamedNodeMap attr = tBox.getAttributes();
                        HSBox terrainBox = new HSBox();
                        if (attr.getNamedItem("width") != null) {
                            terrainBox.width = Float.parseFloat(attr.getNamedItem("width").getNodeValue());
                        }
                        if (attr.getNamedItem("height") != null) {
                            terrainBox.height = Float.parseFloat(attr.getNamedItem("height").getNodeValue());
                        }
                        if (attr.getNamedItem("offsetX") != null) {
                            terrainBox.offset.x = Float.parseFloat(attr.getNamedItem("offsetX").getNodeValue());
                        }
                        if (attr.getNamedItem("offsetY") != null) {
                            terrainBox.offset.y = Float.parseFloat(attr.getNamedItem("offsetY").getNodeValue());
                        }
                        if (attr.getNamedItem("depth") != null) {
                            terrainBox.depth = Integer.parseInt(attr.getNamedItem("depth").getNodeValue());
                        }
                        tObject.terrainBoxes.add(terrainBox);
                        if (!loadObject.IsPhysicsObject() && !loadObject.IsFighter()) {
                            ++i5;
                            continue;
                        }
                        break;
                    }
                }
                if (eventHoldsAttributes.getNamedItem("healthDeath") != null) {
                    tObject.terrainEventHolds.healthDeath = (TerrainObjectHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("healthDeath").getNodeValue()));
                }
            }
            if (loadObject.IsPhysicsObject()) {
                PhysicsObject pObject = (PhysicsObject)loadObject;
                if (objectAttributes.getNamedItem("falls") != null) {
                    pObject.falls = Boolean.parseBoolean(objectAttributes.getNamedItem("falls").getNodeValue());
                }
                if (objectAttributes.getNamedItem("mass") != null) {
                    pObject.mass = Float.parseFloat(objectAttributes.getNamedItem("mass").getNodeValue());
                }
                if (objectAttributes.getNamedItem("maxFallSpeed") != null) {
                    pObject.maxFallSpeed = Float.parseFloat(objectAttributes.getNamedItem("maxFallSpeed").getNodeValue());
                }
            }
            if (loadObject.IsFighter()) {
                FighterObject fighter = (FighterObject)loadObject;
                if (objectAttributes.getNamedItem("airActions") != null) {
                    fighter.airActions = Integer.parseInt(objectAttributes.getNamedItem("airActions").getNodeValue());
                }
                if (objectAttributes.getNamedItem("airControlAccel") != null) {
                    fighter.airControlAccel = Float.parseFloat(objectAttributes.getNamedItem("airControlAccel").getNodeValue());
                }
                if (objectAttributes.getNamedItem("backwardAirDashDuration") != null) {
                    fighter.backwardAirDashDuration = Integer.parseInt(objectAttributes.getNamedItem("backwardAirDashDuration").getNodeValue());
                }
                if (objectAttributes.getNamedItem("backwardAirDashSpeed") != null) {
                    fighter.backwardAirDashSpeed = Float.parseFloat(objectAttributes.getNamedItem("backwardAirDashSpeed").getNodeValue());
                }
                if (objectAttributes.getNamedItem("forwardAirDashDuration") != null) {
                    fighter.forwardAirDashDuration = Integer.parseInt(objectAttributes.getNamedItem("forwardAirDashDuration").getNodeValue());
                }
                if (objectAttributes.getNamedItem("forwardAirDashSpeed") != null) {
                    fighter.forwardAirDashSpeed = Float.parseFloat(objectAttributes.getNamedItem("forwardAirDashSpeed").getNodeValue());
                }
                if (objectAttributes.getNamedItem("jumpSpeed") != null) {
                    fighter.jumpSpeed = Float.parseFloat(objectAttributes.getNamedItem("jumpSpeed").getNodeValue());
                }
                if (objectAttributes.getNamedItem("maxAirControlSpeed") != null) {
                    fighter.maxAirControlSpeed = Float.parseFloat(objectAttributes.getNamedItem("maxAirControlSpeed").getNodeValue());
                }
                if (objectAttributes.getNamedItem("runSpeed") != null) {
                    fighter.runSpeed = Float.parseFloat(objectAttributes.getNamedItem("runSpeed").getNodeValue());
                }
                if (objectAttributes.getNamedItem("stepHeight") != null) {
                    fighter.stepHeight = Float.parseFloat(objectAttributes.getNamedItem("stepHeight").getNodeValue());
                }
                if (objectAttributes.getNamedItem("walkSpeed") != null) {
                    fighter.walkSpeed = Float.parseFloat(objectAttributes.getNamedItem("walkSpeed").getNodeValue());
                }
                HSBox uprightTerrainBox = new HSBox();
                if (uprightTerrainBoxAttributes.getNamedItem("width") != null) {
                    uprightTerrainBox.width = Float.parseFloat(uprightTerrainBoxAttributes.getNamedItem("width").getNodeValue());
                }
                if (uprightTerrainBoxAttributes.getNamedItem("height") != null) {
                    uprightTerrainBox.height = Float.parseFloat(uprightTerrainBoxAttributes.getNamedItem("height").getNodeValue());
                }
                if (uprightTerrainBoxAttributes.getNamedItem("offsetX") != null) {
                    uprightTerrainBox.offset.x = Float.parseFloat(uprightTerrainBoxAttributes.getNamedItem("offsetX").getNodeValue());
                }
                if (uprightTerrainBoxAttributes.getNamedItem("offsetY") != null) {
                    uprightTerrainBox.offset.y = Float.parseFloat(uprightTerrainBoxAttributes.getNamedItem("offsetY").getNodeValue());
                }
                if (uprightTerrainBoxAttributes.getNamedItem("depth") != null) {
                    uprightTerrainBox.depth = Integer.parseInt(uprightTerrainBoxAttributes.getNamedItem("depth").getNodeValue());
                }
                fighter.uprightTerrainBoxes.add(uprightTerrainBox);
                HSBox crouchingTerrainBox = new HSBox();
                if (crouchingTerrainBoxAttributes.getNamedItem("width") != null) {
                    crouchingTerrainBox.width = Float.parseFloat(crouchingTerrainBoxAttributes.getNamedItem("width").getNodeValue());
                }
                if (crouchingTerrainBoxAttributes.getNamedItem("height") != null) {
                    crouchingTerrainBox.height = Float.parseFloat(crouchingTerrainBoxAttributes.getNamedItem("height").getNodeValue());
                }
                if (crouchingTerrainBoxAttributes.getNamedItem("offsetX") != null) {
                    crouchingTerrainBox.offset.x = Float.parseFloat(crouchingTerrainBoxAttributes.getNamedItem("offsetX").getNodeValue());
                }
                if (crouchingTerrainBoxAttributes.getNamedItem("offsetY") != null) {
                    crouchingTerrainBox.offset.y = Float.parseFloat(crouchingTerrainBoxAttributes.getNamedItem("offsetY").getNodeValue());
                }
                if (crouchingTerrainBoxAttributes.getNamedItem("depth") != null) {
                    crouchingTerrainBox.depth = Integer.parseInt(crouchingTerrainBoxAttributes.getNamedItem("depth").getNodeValue());
                }
                fighter.crouchingTerrainBoxes.add(crouchingTerrainBox);
                HSBox proneTerrainBox = new HSBox();
                if (proneTerrainBoxAttributes.getNamedItem("width") != null) {
                    proneTerrainBox.width = Float.parseFloat(proneTerrainBoxAttributes.getNamedItem("width").getNodeValue());
                }
                if (proneTerrainBoxAttributes.getNamedItem("height") != null) {
                    proneTerrainBox.height = Float.parseFloat(proneTerrainBoxAttributes.getNamedItem("height").getNodeValue());
                }
                if (proneTerrainBoxAttributes.getNamedItem("offsetX") != null) {
                    proneTerrainBox.offset.x = Float.parseFloat(proneTerrainBoxAttributes.getNamedItem("offsetX").getNodeValue());
                }
                if (proneTerrainBoxAttributes.getNamedItem("offsetY") != null) {
                    proneTerrainBox.offset.y = Float.parseFloat(proneTerrainBoxAttributes.getNamedItem("offsetY").getNodeValue());
                }
                if (proneTerrainBoxAttributes.getNamedItem("depth") != null) {
                    proneTerrainBox.depth = Integer.parseInt(proneTerrainBoxAttributes.getNamedItem("depth").getNodeValue());
                }
                fighter.proneTerrainBoxes.add(proneTerrainBox);
                HSBox compactTerrainBox = new HSBox();
                if (compactTerrainBoxAttributes.getNamedItem("width") != null) {
                    compactTerrainBox.width = Float.parseFloat(compactTerrainBoxAttributes.getNamedItem("width").getNodeValue());
                }
                if (compactTerrainBoxAttributes.getNamedItem("height") != null) {
                    compactTerrainBox.height = Float.parseFloat(compactTerrainBoxAttributes.getNamedItem("height").getNodeValue());
                }
                if (compactTerrainBoxAttributes.getNamedItem("offsetX") != null) {
                    compactTerrainBox.offset.x = Float.parseFloat(compactTerrainBoxAttributes.getNamedItem("offsetX").getNodeValue());
                }
                if (compactTerrainBoxAttributes.getNamedItem("offsetY") != null) {
                    compactTerrainBox.offset.y = Float.parseFloat(compactTerrainBoxAttributes.getNamedItem("offsetY").getNodeValue());
                }
                if (compactTerrainBoxAttributes.getNamedItem("depth") != null) {
                    compactTerrainBox.depth = Integer.parseInt(compactTerrainBoxAttributes.getNamedItem("depth").getNodeValue());
                }
                fighter.compactTerrainBoxes.add(compactTerrainBox);
                if (eventHoldsAttributes.getNamedItem("standing") != null) {
                    fighter.fighterEventHolds.standing = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("standing").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("turn") != null) {
                    fighter.fighterEventHolds.turn = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("turn").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("walk") != null) {
                    fighter.fighterEventHolds.walk = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("walk").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("walking") != null) {
                    fighter.fighterEventHolds.walking = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("walking").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("walkingTurn") != null) {
                    fighter.fighterEventHolds.walkingTurn = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("walkingTurn").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("run") != null) {
                    fighter.fighterEventHolds.run = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("run").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("running") != null) {
                    fighter.fighterEventHolds.running = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("running").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("runningTurn") != null) {
                    fighter.fighterEventHolds.runningTurn = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("runningTurn").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("runningStop") != null) {
                    fighter.fighterEventHolds.runningStop = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("runningStop").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("crouch") != null) {
                    fighter.fighterEventHolds.crouch = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("crouch").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("crouching") != null) {
                    fighter.fighterEventHolds.crouching = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("crouching").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("crouchingTurn") != null) {
                    fighter.fighterEventHolds.crouchingTurn = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("crouchingTurn").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("stand") != null) {
                    fighter.fighterEventHolds.stand = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("stand").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("jumpNeutralStart") != null) {
                    fighter.fighterEventHolds.jumpNeutralStart = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("jumpNeutralStart").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("jumpNeutralStartAir") != null) {
                    fighter.fighterEventHolds.jumpNeutralStartAir = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("jumpNeutralStartAir").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("jumpNeutralRising") != null) {
                    fighter.fighterEventHolds.jumpNeutralRising = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("jumpNeutralRising").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("jumpNeutralFall") != null) {
                    fighter.fighterEventHolds.jumpNeutralFall = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("jumpNeutralFall").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("jumpNeutralFalling") != null) {
                    fighter.fighterEventHolds.jumpNeutralFalling = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("jumpNeutralFalling").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("jumpNeutralLand") != null) {
                    fighter.fighterEventHolds.jumpNeutralLand = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("jumpNeutralLand").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("jumpBackwardRising") != null) {
                    fighter.fighterEventHolds.jumpBackwardRising = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("jumpBackwardRising").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("jumpBackwardFall") != null) {
                    fighter.fighterEventHolds.jumpBackwardFall = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("jumpBackwardFall").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("airDashForward") != null) {
                    fighter.fighterEventHolds.airDashForward = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("airDashForward").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("airDashBackward") != null) {
                    fighter.fighterEventHolds.airDashBackward = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("airDashBackward").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("blockHigh") != null) {
                    fighter.fighterEventHolds.blockHigh = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("blockHigh").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("blockLow") != null) {
                    fighter.fighterEventHolds.blockLow = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("blockLow").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("blockAir") != null) {
                    fighter.fighterEventHolds.blockAir = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("blockAir").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("hitstunLightHighStanding") != null) {
                    fighter.fighterEventHolds.hitstunLightHighStanding = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("hitstunLightHighStanding").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("hitstunLightMidStanding") != null) {
                    fighter.fighterEventHolds.hitstunLightMidStanding = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("hitstunLightMidStanding").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("hitstunLightLowStanding") != null) {
                    fighter.fighterEventHolds.hitstunLightLowStanding = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("hitstunLightLowStanding").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("hitstunLightMidCrouching") != null) {
                    fighter.fighterEventHolds.hitstunLightMidCrouching = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("hitstunLightMidCrouching").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("hitstunLightLowCrouching") != null) {
                    fighter.fighterEventHolds.hitstunLightLowCrouching = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("hitstunLightLowCrouching").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("hitstunLightAir") != null) {
                    fighter.fighterEventHolds.hitstunLightAir = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("hitstunLightAir").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackLightNeutralGround") != null) {
                    fighter.fighterEventHolds.attackLightNeutralGround = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackLightNeutralGround").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackLightDownGround") != null) {
                    fighter.fighterEventHolds.attackLightDownGround = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackLightDownGround").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackLightUpGround") != null) {
                    fighter.fighterEventHolds.attackLightUpGround = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackLightUpGround").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackLightForwardGround") != null) {
                    fighter.fighterEventHolds.attackLightForwardGround = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackLightForwardGround").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackLightQCFGround") != null) {
                    fighter.fighterEventHolds.attackLightQCFGround = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackLightQCFGround").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackLightNeutralAir") != null) {
                    fighter.fighterEventHolds.attackLightNeutralAir = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackLightNeutralAir").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackLightDownAir") != null) {
                    fighter.fighterEventHolds.attackLightDownAir = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackLightDownAir").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackLightUpAir") != null) {
                    fighter.fighterEventHolds.attackLightUpAir = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackLightUpAir").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackLightForwardAir") != null) {
                    fighter.fighterEventHolds.attackLightForwardAir = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackLightForwardAir").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackLightBackwardAir") != null) {
                    fighter.fighterEventHolds.attackLightBackwardAir = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackLightBackwardAir").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackLightQCFAir") != null) {
                    fighter.fighterEventHolds.attackLightQCFAir = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackLightQCFAir").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackHeavyNeutralGround") != null) {
                    fighter.fighterEventHolds.attackHeavyNeutralGround = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackHeavyNeutralGround").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackHeavyDownGround") != null) {
                    fighter.fighterEventHolds.attackHeavyDownGround = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackHeavyDownGround").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackHeavyUpGround") != null) {
                    fighter.fighterEventHolds.attackHeavyUpGround = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackHeavyUpGround").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackHeavyForwardGround") != null) {
                    fighter.fighterEventHolds.attackHeavyForwardGround = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackHeavyForwardGround").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackHeavyQCFGround") != null) {
                    fighter.fighterEventHolds.attackHeavyQCFGround = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackHeavyQCFGround").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackHeavyNeutralAir") != null) {
                    fighter.fighterEventHolds.attackHeavyNeutralAir = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackHeavyNeutralAir").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackHeavyDownAir") != null) {
                    fighter.fighterEventHolds.attackHeavyDownAir = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackHeavyDownAir").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackHeavyUpAir") != null) {
                    fighter.fighterEventHolds.attackHeavyUpAir = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackHeavyUpAir").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackHeavyForwardAir") != null) {
                    fighter.fighterEventHolds.attackHeavyForwardAir = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackHeavyForwardAir").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackHeavyBackwardAir") != null) {
                    fighter.fighterEventHolds.attackHeavyBackwardAir = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackHeavyBackwardAir").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("attackHeavyQCFAir") != null) {
                    fighter.fighterEventHolds.attackHeavyQCFAir = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("attackHeavyQCFAir").getNodeValue()));
                }
                if (eventHoldsAttributes.getNamedItem("knockout") != null) {
                    fighter.fighterEventHolds.knockout = (FighterHold)this.getHoldFromId(loadObject, Integer.parseInt(eventHoldsAttributes.getNamedItem("knockout").getNodeValue()));
                }
            }
            for (HSObjectHold hold : loadObject.holds) {
                if (hold.nextHoldId == 0) continue;
                hold.nextHold = this.getHoldFromId(loadObject, hold.nextHoldId);
            }
            this.setCurrentlyLoadedObject(loadObject);
            this.newObject();
            this.updatePalettesMenu(true);
        }
        catch (ParserConfigurationException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Parser Configuration Exception", 0);
        }
        catch (SAXException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "SAX Exception", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "IO Exception", 0);
        }
    }

    private void createDefinitionFile() {
        if (this.currentlyLoadedObject == null) {
            return;
        }
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.newDocument();
            Element root = doc.createElement("HSObjects");
            root.setAttribute("version", "2");
            Element object = this.currentlyLoadedObject.IsFighter() ? doc.createElement("Fighter") : (this.currentlyLoadedObject.IsPhysicsObject() ? doc.createElement("PhysicsObject") : (this.currentlyLoadedObject.IsTerrainObject() ? doc.createElement("TerrainObject") : doc.createElement("HSObject")));
            ArrayList<HSObjectHold> holdList = this.holdListPane.getAllHolds();
            Element eventHolds = doc.createElement("EventHolds");
            object.setAttribute("name", this.currentlyLoadedObject.name);
            object.setAttribute("lifetime", "" + this.currentlyLoadedObject.lifetime);
            Element palElement = doc.createElement("Palettes");
            for (HSPalette p : this.currentlyLoadedObject.palettes) {
                if (p.path.isEmpty()) continue;
                Element singlePalElement = doc.createElement("Palette");
                singlePalElement.setAttribute("name", p.name);
                singlePalElement.setAttribute("path", this.createPathRelativeTo(p.path, this.exeDirectory));
                singlePalElement.setAttribute("id", "" + p.id);
                palElement.appendChild(singlePalElement);
            }
            object.appendChild(palElement);
            if (this.currentlyLoadedObject.hsObjectEventHolds.lifetimeDeath != null) {
                eventHolds.setAttribute("lifetimeDeath", "" + this.currentlyLoadedObject.hsObjectEventHolds.lifetimeDeath.id);
            }
            if (this.currentlyLoadedObject.IsTerrainObject()) {
                TerrainObject tObject = (TerrainObject)this.currentlyLoadedObject;
                object.setAttribute("bounce", "" + tObject.bounce);
                object.setAttribute("friction", "" + tObject.friction);
                object.setAttribute("health", "" + tObject.health);
                object.setAttribute("takesTerrainDamage", "" + tObject.takesTerrainDamage);
                object.setAttribute("fragile", "" + tObject.fragile);
                object.setAttribute("canBeJumpedThrough", "" + tObject.canBeJumpedThrough);
                Element terrainBoxesElement = doc.createElement("TerrainBoxes");
                for (HSBox tBox : tObject.terrainBoxes) {
                    Element terrainBox = doc.createElement("TerrainBox");
                    terrainBox.setAttribute("offsetX", "" + tBox.offset.x);
                    terrainBox.setAttribute("offsetY", "" + tBox.offset.y);
                    terrainBox.setAttribute("width", "" + tBox.width);
                    terrainBox.setAttribute("height", "" + tBox.height);
                    terrainBox.setAttribute("depth", "" + tBox.depth);
                    terrainBoxesElement.appendChild(terrainBox);
                }
                object.appendChild(terrainBoxesElement);
                if (!tObject.onHitSounds.isEmpty()) {
                    Element hitAudioList = doc.createElement("OnHitAudioList");
                    for (HSAudio a : tObject.onHitSounds) {
                        Element hitAudio = doc.createElement("OnHitAudio");
                        hitAudio.setAttribute("delay", "" + a.delay);
                        hitAudio.setAttribute("hitAudioFilePath", this.createPathRelativeTo(a.filePath, this.exeDirectory));
                        hitAudio.setAttribute("exclusive", "" + a.exclusive);
                        hitAudio.setAttribute("percentage", "" + a.percentage);
                        hitAudio.setAttribute("usePercentage", "" + a.usePercentage);
                        hitAudioList.appendChild(hitAudio);
                    }
                    object.appendChild(hitAudioList);
                }
                if (tObject.terrainEventHolds.healthDeath != null) {
                    eventHolds.setAttribute("healthDeath", "" + tObject.terrainEventHolds.healthDeath.id);
                }
            }
            if (this.currentlyLoadedObject.IsPhysicsObject()) {
                PhysicsObject pObject = (PhysicsObject)this.currentlyLoadedObject;
                object.setAttribute("falls", "" + pObject.falls);
                object.setAttribute("mass", "" + pObject.mass);
                object.setAttribute("maxFallSpeed", "" + pObject.maxFallSpeed);
            }
            if (this.currentlyLoadedObject.IsFighter()) {
                FighterObject fighter = (FighterObject)this.currentlyLoadedObject;
                object.setAttribute("airActions", "" + fighter.airActions);
                object.setAttribute("airControlAccel", "" + fighter.airControlAccel);
                object.setAttribute("backwardAirDashDuration", "" + fighter.backwardAirDashDuration);
                object.setAttribute("backwardAirDashSpeed", "" + fighter.backwardAirDashSpeed);
                object.setAttribute("forwardAirDashDuration", "" + fighter.forwardAirDashDuration);
                object.setAttribute("forwardAirDashSpeed", "" + fighter.forwardAirDashSpeed);
                object.setAttribute("jumpSpeed", "" + fighter.jumpSpeed);
                object.setAttribute("maxAirControlSpeed", "" + fighter.maxAirControlSpeed);
                object.setAttribute("runSpeed", "" + fighter.runSpeed);
                object.setAttribute("stepHeight", "" + fighter.stepHeight);
                object.setAttribute("walkSpeed", "" + fighter.walkSpeed);
                Element uprightTerrainBox = doc.createElement("UprightTerrainBox");
                uprightTerrainBox.setAttribute("offsetX", "" + fighter.uprightTerrainBoxes.get((int)0).offset.x);
                uprightTerrainBox.setAttribute("offsetY", "" + fighter.uprightTerrainBoxes.get((int)0).offset.y);
                uprightTerrainBox.setAttribute("width", "" + fighter.uprightTerrainBoxes.get((int)0).width);
                uprightTerrainBox.setAttribute("height", "" + fighter.uprightTerrainBoxes.get((int)0).height);
                uprightTerrainBox.setAttribute("depth", "" + ((HSBox)fighter.terrainBoxes.get((int)0)).depth);
                object.appendChild(uprightTerrainBox);
                Element crouchingTerrainBox = doc.createElement("CrouchingTerrainBox");
                crouchingTerrainBox.setAttribute("offsetX", "" + fighter.crouchingTerrainBoxes.get((int)0).offset.x);
                crouchingTerrainBox.setAttribute("offsetY", "" + fighter.crouchingTerrainBoxes.get((int)0).offset.y);
                crouchingTerrainBox.setAttribute("width", "" + fighter.crouchingTerrainBoxes.get((int)0).width);
                crouchingTerrainBox.setAttribute("height", "" + fighter.crouchingTerrainBoxes.get((int)0).height);
                crouchingTerrainBox.setAttribute("depth", "" + ((HSBox)fighter.terrainBoxes.get((int)0)).depth);
                object.appendChild(crouchingTerrainBox);
                Element proneTerrainBox = doc.createElement("ProneTerrainBox");
                proneTerrainBox.setAttribute("offsetX", "" + fighter.proneTerrainBoxes.get((int)0).offset.x);
                proneTerrainBox.setAttribute("offsetY", "" + fighter.proneTerrainBoxes.get((int)0).offset.y);
                proneTerrainBox.setAttribute("width", "" + fighter.proneTerrainBoxes.get((int)0).width);
                proneTerrainBox.setAttribute("height", "" + fighter.proneTerrainBoxes.get((int)0).height);
                proneTerrainBox.setAttribute("depth", "" + ((HSBox)fighter.terrainBoxes.get((int)0)).depth);
                object.appendChild(proneTerrainBox);
                Element compactTerrainBox = doc.createElement("CompactTerrainBox");
                compactTerrainBox.setAttribute("offsetX", "" + fighter.compactTerrainBoxes.get((int)0).offset.x);
                compactTerrainBox.setAttribute("offsetY", "" + fighter.compactTerrainBoxes.get((int)0).offset.y);
                compactTerrainBox.setAttribute("width", "" + fighter.compactTerrainBoxes.get((int)0).width);
                compactTerrainBox.setAttribute("height", "" + fighter.compactTerrainBoxes.get((int)0).height);
                compactTerrainBox.setAttribute("depth", "" + ((HSBox)fighter.terrainBoxes.get((int)0)).depth);
                object.appendChild(compactTerrainBox);
                if (fighter.fighterEventHolds.standing != null) {
                    eventHolds.setAttribute("standing", "" + fighter.fighterEventHolds.standing.id);
                }
                if (fighter.fighterEventHolds.turn != null) {
                    eventHolds.setAttribute("turn", "" + fighter.fighterEventHolds.turn.id);
                }
                if (fighter.fighterEventHolds.crouch != null) {
                    eventHolds.setAttribute("crouch", "" + fighter.fighterEventHolds.crouch.id);
                }
                if (fighter.fighterEventHolds.crouching != null) {
                    eventHolds.setAttribute("crouching", "" + fighter.fighterEventHolds.crouching.id);
                }
                if (fighter.fighterEventHolds.crouchingTurn != null) {
                    eventHolds.setAttribute("crouchingTurn", "" + fighter.fighterEventHolds.crouchingTurn.id);
                }
                if (fighter.fighterEventHolds.stand != null) {
                    eventHolds.setAttribute("stand", "" + fighter.fighterEventHolds.stand.id);
                }
                if (fighter.fighterEventHolds.walk != null) {
                    eventHolds.setAttribute("walk", "" + fighter.fighterEventHolds.walk.id);
                }
                if (fighter.fighterEventHolds.walking != null) {
                    eventHolds.setAttribute("walking", "" + fighter.fighterEventHolds.walking.id);
                }
                if (fighter.fighterEventHolds.walkingTurn != null) {
                    eventHolds.setAttribute("walkingTurn", "" + fighter.fighterEventHolds.walkingTurn.id);
                }
                if (fighter.fighterEventHolds.run != null) {
                    eventHolds.setAttribute("run", "" + fighter.fighterEventHolds.run.id);
                }
                if (fighter.fighterEventHolds.running != null) {
                    eventHolds.setAttribute("running", "" + fighter.fighterEventHolds.running.id);
                }
                if (fighter.fighterEventHolds.runningTurn != null) {
                    eventHolds.setAttribute("runningTurn", "" + fighter.fighterEventHolds.runningTurn.id);
                }
                if (fighter.fighterEventHolds.runningStop != null) {
                    eventHolds.setAttribute("runningStop", "" + fighter.fighterEventHolds.runningStop.id);
                }
                if (fighter.fighterEventHolds.jumpNeutralStart != null) {
                    eventHolds.setAttribute("jumpNeutralStart", "" + fighter.fighterEventHolds.jumpNeutralStart.id);
                }
                if (fighter.fighterEventHolds.jumpNeutralStartAir != null) {
                    eventHolds.setAttribute("jumpNeutralStartAir", "" + fighter.fighterEventHolds.jumpNeutralStartAir.id);
                }
                if (fighter.fighterEventHolds.jumpNeutralRising != null) {
                    eventHolds.setAttribute("jumpNeutralRising", "" + fighter.fighterEventHolds.jumpNeutralRising.id);
                }
                if (fighter.fighterEventHolds.jumpNeutralFall != null) {
                    eventHolds.setAttribute("jumpNeutralFall", "" + fighter.fighterEventHolds.jumpNeutralFall.id);
                }
                if (fighter.fighterEventHolds.jumpNeutralFalling != null) {
                    eventHolds.setAttribute("jumpNeutralFalling", "" + fighter.fighterEventHolds.jumpNeutralFalling.id);
                }
                if (fighter.fighterEventHolds.jumpNeutralLand != null) {
                    eventHolds.setAttribute("jumpNeutralLand", "" + fighter.fighterEventHolds.jumpNeutralLand.id);
                }
                if (fighter.fighterEventHolds.jumpBackwardRising != null) {
                    eventHolds.setAttribute("jumpBackwardRising", "" + fighter.fighterEventHolds.jumpBackwardRising.id);
                }
                if (fighter.fighterEventHolds.jumpBackwardFall != null) {
                    eventHolds.setAttribute("jumpBackwardFall", "" + fighter.fighterEventHolds.jumpBackwardFall.id);
                }
                if (fighter.fighterEventHolds.airDashForward != null) {
                    eventHolds.setAttribute("airDashForward", "" + fighter.fighterEventHolds.airDashForward.id);
                }
                if (fighter.fighterEventHolds.airDashBackward != null) {
                    eventHolds.setAttribute("airDashBackward", "" + fighter.fighterEventHolds.airDashBackward.id);
                }
                if (fighter.fighterEventHolds.blockHigh != null) {
                    eventHolds.setAttribute("blockHigh", "" + fighter.fighterEventHolds.blockHigh.id);
                }
                if (fighter.fighterEventHolds.blockLow != null) {
                    eventHolds.setAttribute("blockLow", "" + fighter.fighterEventHolds.blockLow.id);
                }
                if (fighter.fighterEventHolds.blockAir != null) {
                    eventHolds.setAttribute("blockAir", "" + fighter.fighterEventHolds.blockAir.id);
                }
                if (fighter.fighterEventHolds.hitstunLightHighStanding != null) {
                    eventHolds.setAttribute("hitstunLightHighStanding", "" + fighter.fighterEventHolds.hitstunLightHighStanding.id);
                }
                if (fighter.fighterEventHolds.hitstunLightMidStanding != null) {
                    eventHolds.setAttribute("hitstunLightMidStanding", "" + fighter.fighterEventHolds.hitstunLightMidStanding.id);
                }
                if (fighter.fighterEventHolds.hitstunLightLowStanding != null) {
                    eventHolds.setAttribute("hitstunLightLowStanding", "" + fighter.fighterEventHolds.hitstunLightLowStanding.id);
                }
                if (fighter.fighterEventHolds.hitstunLightMidCrouching != null) {
                    eventHolds.setAttribute("hitstunLightMidCrouching", "" + fighter.fighterEventHolds.hitstunLightMidCrouching.id);
                }
                if (fighter.fighterEventHolds.hitstunLightLowCrouching != null) {
                    eventHolds.setAttribute("hitstunLightLowCrouching", "" + fighter.fighterEventHolds.hitstunLightLowCrouching.id);
                }
                if (fighter.fighterEventHolds.hitstunLightAir != null) {
                    eventHolds.setAttribute("hitstunLightAir", "" + fighter.fighterEventHolds.hitstunLightAir.id);
                }
                if (fighter.fighterEventHolds.attackLightNeutralGround != null) {
                    eventHolds.setAttribute("attackLightNeutralGround", "" + fighter.fighterEventHolds.attackLightNeutralGround.id);
                }
                if (fighter.fighterEventHolds.attackLightDownGround != null) {
                    eventHolds.setAttribute("attackLightDownGround", "" + fighter.fighterEventHolds.attackLightDownGround.id);
                }
                if (fighter.fighterEventHolds.attackLightUpGround != null) {
                    eventHolds.setAttribute("attackLightUpGround", "" + fighter.fighterEventHolds.attackLightUpGround.id);
                }
                if (fighter.fighterEventHolds.attackLightForwardGround != null) {
                    eventHolds.setAttribute("attackLightForwardGround", "" + fighter.fighterEventHolds.attackLightForwardGround.id);
                }
                if (fighter.fighterEventHolds.attackLightQCFGround != null) {
                    eventHolds.setAttribute("attackLightQCFGround", "" + fighter.fighterEventHolds.attackLightQCFGround.id);
                }
                if (fighter.fighterEventHolds.attackLightNeutralAir != null) {
                    eventHolds.setAttribute("attackLightNeutralAir", "" + fighter.fighterEventHolds.attackLightNeutralAir.id);
                }
                if (fighter.fighterEventHolds.attackLightDownAir != null) {
                    eventHolds.setAttribute("attackLightDownAir", "" + fighter.fighterEventHolds.attackLightDownAir.id);
                }
                if (fighter.fighterEventHolds.attackLightUpAir != null) {
                    eventHolds.setAttribute("attackLightUpAir", "" + fighter.fighterEventHolds.attackLightUpAir.id);
                }
                if (fighter.fighterEventHolds.attackLightForwardAir != null) {
                    eventHolds.setAttribute("attackLightForwardAir", "" + fighter.fighterEventHolds.attackLightForwardAir.id);
                }
                if (fighter.fighterEventHolds.attackLightBackwardAir != null) {
                    eventHolds.setAttribute("attackLightBackwardAir", "" + fighter.fighterEventHolds.attackLightBackwardAir.id);
                }
                if (fighter.fighterEventHolds.attackLightQCFAir != null) {
                    eventHolds.setAttribute("attackLightQCFAir", "" + fighter.fighterEventHolds.attackLightQCFAir.id);
                }
                if (fighter.fighterEventHolds.attackHeavyNeutralGround != null) {
                    eventHolds.setAttribute("attackHeavyNeutralGround", "" + fighter.fighterEventHolds.attackHeavyNeutralGround.id);
                }
                if (fighter.fighterEventHolds.attackHeavyDownGround != null) {
                    eventHolds.setAttribute("attackHeavyDownGround", "" + fighter.fighterEventHolds.attackHeavyDownGround.id);
                }
                if (fighter.fighterEventHolds.attackHeavyUpGround != null) {
                    eventHolds.setAttribute("attackHeavyUpGround", "" + fighter.fighterEventHolds.attackHeavyUpGround.id);
                }
                if (fighter.fighterEventHolds.attackHeavyForwardGround != null) {
                    eventHolds.setAttribute("attackHeavyForwardGround", "" + fighter.fighterEventHolds.attackHeavyForwardGround.id);
                }
                if (fighter.fighterEventHolds.attackHeavyQCFGround != null) {
                    eventHolds.setAttribute("attackHeavyQCFGround", "" + fighter.fighterEventHolds.attackHeavyQCFGround.id);
                }
                if (fighter.fighterEventHolds.attackHeavyNeutralAir != null) {
                    eventHolds.setAttribute("attackHeavyNeutralAir", "" + fighter.fighterEventHolds.attackHeavyNeutralAir.id);
                }
                if (fighter.fighterEventHolds.attackHeavyDownAir != null) {
                    eventHolds.setAttribute("attackHeavyDownAir", "" + fighter.fighterEventHolds.attackHeavyDownAir.id);
                }
                if (fighter.fighterEventHolds.attackHeavyUpAir != null) {
                    eventHolds.setAttribute("attackHeavyUpAir", "" + fighter.fighterEventHolds.attackHeavyUpAir.id);
                }
                if (fighter.fighterEventHolds.attackHeavyForwardAir != null) {
                    eventHolds.setAttribute("attackHeavyForwardAir", "" + fighter.fighterEventHolds.attackHeavyForwardAir.id);
                }
                if (fighter.fighterEventHolds.attackHeavyBackwardAir != null) {
                    eventHolds.setAttribute("attackHeavyBackwardAir", "" + fighter.fighterEventHolds.attackHeavyBackwardAir.id);
                }
                if (fighter.fighterEventHolds.attackHeavyQCFAir != null) {
                    eventHolds.setAttribute("attackHeavyQCFAir", "" + fighter.fighterEventHolds.attackHeavyQCFAir.id);
                }
                if (fighter.fighterEventHolds.knockout != null) {
                    eventHolds.setAttribute("knockout", "" + fighter.fighterEventHolds.knockout.id);
                }
            }
            object.appendChild(eventHolds);
            Element holds = doc.createElement("Holds");
            for (HSObjectHold h : holdList) {
                Element hold = doc.createElement("Hold");
                hold.setAttribute("name", h.name);
                hold.setAttribute("duration", "" + h.duration);
                hold.setAttribute("id", "" + h.id);
                hold.setAttribute("repositionX", "" + h.reposition.x);
                hold.setAttribute("repositionY", "" + h.reposition.y);
                hold.setAttribute("velocityX", "" + h.velocity.x);
                hold.setAttribute("velocityY", "" + h.velocity.y);
                hold.setAttribute("overwriteVelocity", "" + h.overwriteVelocity);
                if (h.nextHold != null) {
                    hold.setAttribute("nextHoldId", "" + h.nextHold.id);
                }
                if (h.IsTerrainObjectHold()) {
                    Element box;
                    TerrainObjectHold th = (TerrainObjectHold)h;
                    hold.setAttribute("blockability", "" + (Object)((Object)th.blockability));
                    hold.setAttribute("ownHitstop", "" + th.ownHitstop);
                    hold.setAttribute("ownHitstopOverride", "" + th.ownHitstopOverride);
                    hold.setAttribute("victimHitstop", "" + th.victimHitstop);
                    hold.setAttribute("victimHitstopOverride", "" + th.victimHitstopOverride);
                    hold.setAttribute("blockstun", "" + th.blockstun);
                    hold.setAttribute("changeAttackBoxAttributes", "" + th.changeAttackBoxAttributes);
                    hold.setAttribute("damage", "" + th.damage);
                    hold.setAttribute("forceX", "" + th.force.x);
                    hold.setAttribute("forceY", "" + th.force.y);
                    hold.setAttribute("hitstun", "" + th.hitstun);
                    hold.setAttribute("horizontalDirectionBasedBlock", "" + th.horizontalDirectionBasedBlock);
                    hold.setAttribute("reversedHorizontalBlock", "" + th.reversedHorizontalBlock);
                    hold.setAttribute("trips", "" + th.trips);
                    hold.setAttribute("resetHits", "" + th.resetHits);
                    hold.setAttribute("changeHurtBoxAttributes", "" + th.changeHurtBoxAttributes);
                    hold.setAttribute("invulnerability", "" + (Object)((Object)th.invulnerability));
                    hold.setAttribute("hitLevel", "" + (Object)((Object)th.hitLevel));
                    hold.setAttribute("superArmorHits", "" + th.superArmorHits);
                    hold.setAttribute("superArmorDamage", "" + th.superArmorDamage);
                    hold.setAttribute("superArmorDamageScaling", "" + th.superArmorDamageScaling);
                    if (!th.attackBoxes.isEmpty()) {
                        Element attackBoxes = doc.createElement("AttackBoxes");
                        for (HSBox b : th.attackBoxes) {
                            box = doc.createElement("Box");
                            box.setAttribute("offsetX", "" + b.offset.x);
                            box.setAttribute("offsetY", "" + b.offset.y);
                            box.setAttribute("width", "" + b.width);
                            box.setAttribute("height", "" + b.height);
                            box.setAttribute("depth", "" + b.depth);
                            attackBoxes.appendChild(box);
                        }
                        hold.appendChild(attackBoxes);
                    }
                    if (!th.hurtBoxes.isEmpty()) {
                        Element hurtBoxes = doc.createElement("HurtBoxes");
                        for (HSBox b : th.hurtBoxes) {
                            box = doc.createElement("Box");
                            box.setAttribute("offsetX", "" + b.offset.x);
                            box.setAttribute("offsetY", "" + b.offset.y);
                            box.setAttribute("width", "" + b.width);
                            box.setAttribute("height", "" + b.height);
                            box.setAttribute("depth", "" + b.depth);
                            hurtBoxes.appendChild(box);
                        }
                        hold.appendChild(hurtBoxes);
                    }
                    if (!th.hitAudioList.isEmpty()) {
                        Element hitAudioList = doc.createElement("HitAudioList");
                        for (HSAudio a : th.hitAudioList) {
                            Element hitAudio = doc.createElement("HitAudio");
                            hitAudio.setAttribute("delay", "" + a.delay);
                            hitAudio.setAttribute("hitAudioFilePath", this.createPathRelativeTo(a.filePath, this.exeDirectory));
                            hitAudio.setAttribute("exclusive", "" + a.exclusive);
                            hitAudio.setAttribute("percentage", "" + a.percentage);
                            hitAudio.setAttribute("usePercentage", "" + a.usePercentage);
                            hitAudioList.appendChild(hitAudio);
                        }
                        hold.appendChild(hitAudioList);
                    }
                    if (!th.blockedAudioList.isEmpty()) {
                        Element blockedAudioList = doc.createElement("BlockedAudioList");
                        for (HSAudio a : th.blockedAudioList) {
                            Element blockedAudio = doc.createElement("BlockedAudio");
                            blockedAudio.setAttribute("delay", "" + a.delay);
                            blockedAudio.setAttribute("blockedAudioFilePath", this.createPathRelativeTo(a.filePath, this.exeDirectory));
                            blockedAudio.setAttribute("exclusive", "" + a.exclusive);
                            blockedAudio.setAttribute("percentage", "" + a.percentage);
                            blockedAudio.setAttribute("usePercentage", "" + a.usePercentage);
                            blockedAudioList.appendChild(blockedAudio);
                        }
                        hold.appendChild(blockedAudioList);
                    }
                }
                if (h.IsPhysicsObjectHold()) {
                    PhysicsObjectHold ph = (PhysicsObjectHold)h;
                    hold.setAttribute("changePhysicsAttributes", "" + ph.changePhysics);
                    hold.setAttribute("ignoreGravity", "" + ph.ignoreGravity);
                }
                if (h.IsFighterHold()) {
                    FighterHold fh = (FighterHold)h;
                    hold.setAttribute("changeFighterAttributes", "" + fh.changeFighterAttributes);
                    hold.setAttribute("disableAirControl", "" + fh.disableAirControl);
                    hold.setAttribute("endAirDash", "" + fh.endAirDash);
                    hold.setAttribute("changeCancels", "" + fh.changeCancels);
                    hold.setAttribute("dashCancel", "" + (Object)((Object)fh.cancels.dash));
                    hold.setAttribute("jumpCancel", "" + (Object)((Object)fh.cancels.jump));
                    hold.setAttribute("lightNeutralCancel", "" + (Object)((Object)fh.cancels.lightNeutral));
                    hold.setAttribute("lightForwardCancel", "" + (Object)((Object)fh.cancels.lightForward));
                    hold.setAttribute("lightUpCancel", "" + (Object)((Object)fh.cancels.lightUp));
                    hold.setAttribute("lightDownCancel", "" + (Object)((Object)fh.cancels.lightDown));
                    hold.setAttribute("lightBackwardCancel", "" + (Object)((Object)fh.cancels.lightBackward));
                    hold.setAttribute("lightQCFCancel", "" + (Object)((Object)fh.cancels.lightQCF));
                    hold.setAttribute("heavyNeutralCancel", "" + (Object)((Object)fh.cancels.heavyNeutral));
                    hold.setAttribute("heavyForwardCancel", "" + (Object)((Object)fh.cancels.heavyForward));
                    hold.setAttribute("heavyUpCancel", "" + (Object)((Object)fh.cancels.heavyUp));
                    hold.setAttribute("heavyDownCancel", "" + (Object)((Object)fh.cancels.heavyDown));
                    hold.setAttribute("heavyBackwardCancel", "" + (Object)((Object)fh.cancels.heavyBackward));
                    hold.setAttribute("heavyQCFCancel", "" + (Object)((Object)fh.cancels.heavyQCF));
                }
                if (!h.textures.isEmpty()) {
                    Element textures = doc.createElement("Textures");
                    for (HSTexture t : h.textures) {
                        Element texture = doc.createElement("Texture");
                        texture.setAttribute("depth", "" + t.depth);
                        texture.setAttribute("offsetX", "" + t.offset.x);
                        texture.setAttribute("offsetY", "" + t.offset.y);
                        texture.setAttribute("textureFilePath", this.createPathRelativeTo(t.filePath, this.exeDirectory));
                        textures.appendChild(texture);
                    }
                    hold.appendChild(textures);
                }
                if (!h.audioList.isEmpty()) {
                    Element audioList = doc.createElement("AudioList");
                    for (HSAudio a : h.audioList) {
                        Element audio = doc.createElement("Audio");
                        audio.setAttribute("delay", "" + a.delay);
                        audio.setAttribute("audioFilePath", this.createPathRelativeTo(a.filePath, this.exeDirectory));
                        audio.setAttribute("exclusive", "" + a.exclusive);
                        audio.setAttribute("percentage", "" + a.percentage);
                        audio.setAttribute("usePercentage", "" + a.usePercentage);
                        audioList.appendChild(audio);
                    }
                    hold.appendChild(audioList);
                }
                if (!h.spawnObjects.isEmpty()) {
                    Element spawnObjects = doc.createElement("SpawnObjects");
                    for (HSSpawnObject s : h.spawnObjects) {
                        Element spawnObject = doc.createElement("SpawnObject");
                        spawnObject.setAttribute("definitionFilePath", this.createPathRelativeTo(s.defFilePath, this.exeDirectory));
                        spawnObject.setAttribute("delay", "" + s.delay);
                        spawnObject.setAttribute("number", "" + s.number);
                        spawnObject.setAttribute("parentOffsetX", "" + s.parentOffset.x);
                        spawnObject.setAttribute("parentOffsetY", "" + s.parentOffset.y);
                        spawnObject.setAttribute("velocityX", "" + s.vel.x);
                        spawnObject.setAttribute("velocityY", "" + s.vel.y);
                        spawnObject.setAttribute("followParent", "" + s.followParent);
                        spawnObject.setAttribute("collideParent", "" + s.collideParent);
                        spawnObject.setAttribute("useParentPalette", "" + s.useParentPalette);
                        spawnObjects.appendChild(spawnObject);
                    }
                    hold.appendChild(spawnObjects);
                }
                holds.appendChild(hold);
            }
            object.appendChild(holds);
            root.appendChild(object);
            doc.appendChild(root);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(String.valueOf(this.workingDirectory) + "/" + this.currentlyLoadedObject.name + ".xml"));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Parser Configuration Exception", 0);
        }
        catch (TransformerConfigurationException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Transformer Configuration Exception", 0);
        }
        catch (TransformerException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Transformer Exception", 0);
        }
    }

    private void saveAs() {
        if (this.currentlyLoadedObject == null) {
            JOptionPane.showMessageDialog(this, "No Object loaded", "Whoops", 0);
            return;
        }
        fileChooser.setFileSelectionMode(1);
        int returnVal = fileChooser.showSaveDialog(this);
        fileChooser.setFileSelectionMode(0);
        if (returnVal != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        this.workingDirectory = file.getAbsolutePath();
        this.save();
    }

    private void save() {
        File wd;
        if (this.currentlyLoadedObject == null || this.workingDirectory.isEmpty()) {
            this.saveAs();
        }
        if (!(wd = new File(this.workingDirectory)).exists()) {
            return;
        }
        this.setTitle(String.valueOf(BaseWindowTitle) + this.currentlyLoadedObject.name);
        this.createDefinitionFile();
    }

    private void importAnimation() {
        if (this.currentlyLoadedObject == null) {
            JOptionPane.showMessageDialog(this, "No Object loaded", "Whoops", 0);
            return;
        }
        fileChooser.setMultiSelectionEnabled(true);
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File[] files = fileChooser.getSelectedFiles();
        if (this.currentlyLoadedObject.IsFighter()) {
            FighterHold lastHold = null;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FighterHold hold = new FighterHold();
                hold.id = this.currentlyLoadedObject.getHighestHoldId() + 1;
                hold.textures.add(new HSTexture(f.getAbsolutePath()));
                hold.name = f.getName().split("\\.")[0];
                this.holdListPane.addHoldToHoldList(hold);
                if (lastHold != null) {
                    lastHold.nextHold = hold;
                    lastHold.nextHoldId = hold.id;
                }
                this.currentlyLoadedObject.holds.add(hold);
                lastHold = hold;
                ++n2;
            }
        } else if (this.currentlyLoadedObject.IsPhysicsObject()) {
            FighterHold lastHold = null;
            File[] fileArray = files;
            int n = files.length;
            int n3 = 0;
            while (n3 < n) {
                File f = fileArray[n3];
                FighterHold hold = new FighterHold();
                hold.id = this.currentlyLoadedObject.getHighestHoldId() + 1;
                hold.textures.add(new HSTexture(f.getAbsolutePath()));
                hold.name = f.getName().split("\\.")[0];
                this.holdListPane.addHoldToHoldList(hold);
                if (lastHold != null) {
                    lastHold.nextHold = hold;
                    lastHold.nextHoldId = hold.id;
                }
                this.currentlyLoadedObject.holds.add(hold);
                lastHold = hold;
                ++n3;
            }
        } else if (this.currentlyLoadedObject.IsTerrainObject()) {
            FighterHold lastHold = null;
            File[] fileArray = files;
            int n = files.length;
            int n4 = 0;
            while (n4 < n) {
                File f = fileArray[n4];
                FighterHold hold = new FighterHold();
                hold.id = this.currentlyLoadedObject.getHighestHoldId() + 1;
                hold.textures.add(new HSTexture(f.getAbsolutePath()));
                hold.name = f.getName().split("\\.")[0];
                this.holdListPane.addHoldToHoldList(hold);
                if (lastHold != null) {
                    lastHold.nextHold = hold;
                    lastHold.nextHoldId = hold.id;
                }
                this.currentlyLoadedObject.holds.add(hold);
                lastHold = hold;
                ++n4;
            }
        } else {
            FighterHold lastHold = null;
            File[] fileArray = files;
            int n = files.length;
            int n5 = 0;
            while (n5 < n) {
                File f = fileArray[n5];
                FighterHold hold = new FighterHold();
                hold.id = this.currentlyLoadedObject.getHighestHoldId() + 1;
                hold.textures.add(new HSTexture(f.getAbsolutePath()));
                hold.name = f.getName().split("\\.")[0];
                this.holdListPane.addHoldToHoldList(hold);
                if (lastHold != null) {
                    lastHold.nextHold = hold;
                    lastHold.nextHoldId = hold.id;
                }
                this.currentlyLoadedObject.holds.add(hold);
                lastHold = hold;
                ++n5;
            }
        }
        fileChooser.setMultiSelectionEnabled(false);
    }

    private void undo() {
        this.textureHitboxPane.undo();
    }

    private void redo() {
        this.textureHitboxPane.redo();
    }

    private void cut() {
        this.textureHitboxPane.cut();
    }

    private void copy() {
        this.textureHitboxPane.copy();
    }

    private void paste() {
        this.textureHitboxPane.paste();
    }

    private void delete() {
        this.textureHitboxPane.textureHitboxPane.removeSelectedItems();
    }

    private void selectAll() {
        this.textureHitboxPane.textureHitboxPane.selectAll();
    }

    private void helpContent() {
    }

    private void about() {
        JOptionPane.showMessageDialog(this, "This is the object editor created for the Homestrife Fighting Game!\nOriginally created by Darlos9D and maintained by WhiteVoidia.", "About", 1);
    }

    private void changeLog() {
        JOptionPane.showMessageDialog(this, this.changeLogText, "Change Log", 1);
    }

    private void createObjectAttributesWindow() {
        if (this.currentlyLoadedObject == null) {
            JOptionPane.showMessageDialog(this, "No Object loaded", "Whoops", 0);
            return;
        }
        ObjectAttributesWindow window = new ObjectAttributesWindow(this, this.currentlyLoadedObject);
        window.setVisible(true);
    }

    private void createEventHoldsWindow() {
        if (this.currentlyLoadedObject == null) {
            JOptionPane.showMessageDialog(this, "No Object loaded", "Whoops", 0);
            return;
        }
        EventHoldsWindow window = new EventHoldsWindow(this, this.currentlyLoadedObject);
        window.setVisible(true);
    }

    private void createPalettesWindow() {
        if (this.currentlyLoadedObject == null) {
            JOptionPane.showMessageDialog(this, "No Object loaded", "Whoops", 0);
            return;
        }
        PalettesWindow window = new PalettesWindow(this, this.currentlyLoadedObject);
        window.setVisible(true);
    }

    public void updatePalettesMenu() {
        this.updatePalettesMenu(false);
    }

    public void updatePalettesMenu(boolean warn) {
        JMenuItem menuItem;
        this.palettesMenu.removeAll();
        if (this.currentlyLoadedObject == null || this.currentlyLoadedObject.palettes.size() == 0) {
            this.palettesMenu.add(new JMenuItem("NONE"));
        } else {
            this.curPal = 0;
            while (this.curPal < this.currentlyLoadedObject.palettes.size()) {
                boolean alreadyUsedId = false;
                for (HSPalette hsp : this.currentlyLoadedObject.palettes) {
                    if (hsp.id != this.curPal) continue;
                    if (alreadyUsedId) {
                        if (!warn) continue;
                        JOptionPane.showMessageDialog(this, "Duplicate palette IDs detected on: " + hsp.name, "Palette Loading", 0);
                        continue;
                    }
                    alreadyUsedId = true;
                    menuItem = new JMenuItem(new AbstractAction(hsp.name){
                        private static final long serialVersionUID = 1L;
                        int palNum;
                        {
                            this.palNum = EditorWindow.this.curPal;
                        }

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            EditorWindow.this.currentlyLoadedObject.curPalette = this.palNum;
                            EditorWindow.this.textureHitboxPane.reloadTextures();
                        }
                    });
                    this.palettesMenu.add(menuItem);
                }
                ++this.curPal;
            }
        }
        this.palettesMenu.add(new JSeparator());
        menuItem = new JMenuItem("Edit Palettes");
        menuItem.setActionCommand("palettes");
        menuItem.addActionListener(this);
        this.palettesMenu.add(menuItem);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println(e.getActionCommand());
        switch (e.getActionCommand()) {
            case "newGraphic": {
                this.newGraphic();
                break;
            }
            case "newTerrain": {
                this.newTerrain();
                break;
            }
            case "newPhysicsObject": {
                this.newPhysicsObject();
                break;
            }
            case "newFighter": {
                this.newFighter();
                break;
            }
            case "generate": {
                this.generate();
                break;
            }
            case "open": {
                this.open();
                break;
            }
            case "save": {
                this.save();
                break;
            }
            case "saveAs": {
                this.saveAs();
                break;
            }
            case "importAnimation": {
                this.importAnimation();
                break;
            }
            case "exeLocation": {
                this.setExeLocation();
                break;
            }
            case "undo": {
                this.undo();
                break;
            }
            case "redo": {
                this.redo();
                break;
            }
            case "cut": {
                this.cut();
                break;
            }
            case "copy": {
                this.copy();
                break;
            }
            case "paste": {
                this.paste();
                break;
            }
            case "delete": {
                this.delete();
                break;
            }
            case "selectAll": {
                this.selectAll();
                break;
            }
            case "objectAttributes": {
                this.createObjectAttributesWindow();
                break;
            }
            case "eventHolds": {
                this.createEventHoldsWindow();
                break;
            }
            case "palettes": {
                this.createPalettesWindow();
                break;
            }
            case "helpContent": {
                this.helpContent();
                break;
            }
            case "about": {
                this.about();
                break;
            }
            case "changeLog": {
                this.changeLog();
            }
        }
    }

    private static void removeWhitespaceNodes(Document doc) {
        NodeList nl;
        XPath xp = XPathFactory.newInstance().newXPath();
        try {
            nl = (NodeList)xp.evaluate("//text()[normalize-space(.)='']", doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return;
        }
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            node.getParentNode().removeChild(node);
            ++i;
        }
    }

    private class KeyDispatcher
    implements KeyEventDispatcher {
        private KeyDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getID() == 401) {
                if (e.getKeyCode() == 88 && (e.getModifiers() & 2) != 0) {
                    if (EditorWindow.this.holdListPane.tree.isFocusOwner()) {
                        EditorWindow.this.cut();
                    }
                } else if (e.getKeyCode() == 67 && (e.getModifiers() & 2) != 0) {
                    if (EditorWindow.this.holdListPane.tree.isFocusOwner()) {
                        EditorWindow.this.copy();
                    }
                } else if (e.getKeyCode() == 86 && (e.getModifiers() & 2) != 0 && EditorWindow.this.holdListPane.tree.isFocusOwner()) {
                    EditorWindow.this.paste();
                }
            }
            return false;
        }
    }
}

