/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows;

import homestrifeeditor.objects.FighterObject;
import homestrifeeditor.objects.HSObject;
import homestrifeeditor.objects.PhysicsObject;
import homestrifeeditor.objects.TerrainObject;
import homestrifeeditor.objects.holds.FighterHold;
import homestrifeeditor.objects.holds.HSObjectHold;
import homestrifeeditor.objects.holds.TerrainObjectHold;
import homestrifeeditor.windows.EditorWindow;
import homestrifeeditor.windows.renderers.HoldComboBoxRenderer;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class EventHoldsWindow
extends JFrame
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private static int windowWidth = 920;
    private static int windowHeightGeneral = 160;
    private static int windowHeightTerrain = 210;
    private static int windowHeightPhysics = 210;
    private static int windowHeightFighter = 500;
    private static int windowBorderBuffer = 10;
    private static int gridWidth = 700;
    private static int gridRowHeight = 45;
    private static int gridColumns = 4;
    private static int gridHorizontalGap = 10;
    private static int gridVerticalGap = 5;
    private EditorWindow parent;
    private HSObject hsObject;
    private JComboBox lifetimeDeath;
    private JComboBox healthDeath;
    private JComboBox standing;
    private JComboBox turn;
    private JComboBox walk;
    private JComboBox walking;
    private JComboBox walkingTurn;
    private JComboBox run;
    private JComboBox running;
    private JComboBox runningTurn;
    private JComboBox runningStop;
    private JComboBox crouch;
    private JComboBox crouching;
    private JComboBox crouchingTurn;
    private JComboBox stand;
    private JComboBox jumpNeutralStart;
    private JComboBox jumpNeutralStartAir;
    private JComboBox jumpNeutralRising;
    private JComboBox jumpNeutralFall;
    private JComboBox jumpNeutralFalling;
    private JComboBox jumpNeutralLand;
    private JComboBox jumpNeutralLandHard;
    private JComboBox jumpForwardStart;
    private JComboBox jumpForwardRising;
    private JComboBox jumpForwardFall;
    private JComboBox jumpForwardFalling;
    private JComboBox jumpForwardLand;
    private JComboBox jumpForwardLandHard;
    private JComboBox jumpBackwardStart;
    private JComboBox jumpBackwardRising;
    private JComboBox jumpBackwardFall;
    private JComboBox jumpBackwardFalling;
    private JComboBox jumpBackwardLand;
    private JComboBox jumpBackwardLandHard;
    private JComboBox airDashForward;
    private JComboBox airDashBackward;
    private JComboBox blockHigh;
    private JComboBox blockLow;
    private JComboBox blockAir;
    private JComboBox ledgeGrab;
    private JComboBox ledgeClimb;
    private JComboBox hitstunHighStandingStart;
    private JComboBox hitstunLightHighStanding;
    private JComboBox hitstunHighStandingEnd;
    private JComboBox hitstunLightMidStanding;
    private JComboBox hitstunLowStandingStart;
    private JComboBox hitstunLightLowStanding;
    private JComboBox hitstunLowStandingEnd;
    private JComboBox hitstunCrouchingStart;
    private JComboBox hitstunLightMidCrouching;
    private JComboBox hitstunCrouchingEnd;
    private JComboBox hitstunLightLowCrouching;
    private JComboBox hitstunLightAir;
    private JComboBox tripForward;
    private JComboBox tripBackward;
    private JComboBox proneFaceUp;
    private JComboBox proneFaceUpStand;
    private JComboBox proneFaceDown;
    private JComboBox proneFaceDownStand;
    private JComboBox crumpleStart;
    private JComboBox crumple;
    private JComboBox airbornFaceUpRising;
    private JComboBox airbornFaceUpFall;
    private JComboBox airbornFaceUpFalling;
    private JComboBox airbornFaceUpRise;
    private JComboBox airbornFaceDownRising;
    private JComboBox airbornFaceDownFall;
    private JComboBox airbornFaceDownFalling;
    private JComboBox airbornFaceDownRise;
    private JComboBox airbornFaceSideMovingForward;
    private JComboBox airbornFaceSideMoveBackward;
    private JComboBox airbornFaceSideMovingBackward;
    private JComboBox airbornFaceSideMoveForward;
    private JComboBox attackLightNeutralGround;
    private JComboBox attackLightDownGround;
    private JComboBox attackLightUpGround;
    private JComboBox attackLightForwardGround;
    private JComboBox attackLightQCFGround;
    private JComboBox attackLightNeutralAir;
    private JComboBox attackLightDownAir;
    private JComboBox attackLightUpAir;
    private JComboBox attackLightForwardAir;
    private JComboBox attackLightBackwardAir;
    private JComboBox attackLightQCFAir;
    private JComboBox attackHeavyNeutralGround;
    private JComboBox attackHeavyDownGround;
    private JComboBox attackHeavyUpGround;
    private JComboBox attackHeavyForwardGround;
    private JComboBox attackHeavyQCFGround;
    private JComboBox attackHeavyNeutralAir;
    private JComboBox attackHeavyDownAir;
    private JComboBox attackHeavyUpAir;
    private JComboBox attackHeavyForwardAir;
    private JComboBox attackHeavyBackwardAir;
    private JComboBox attackHeavyQCFAir;
    private JComboBox knockout;
    private JButton applyButton;

    public EventHoldsWindow(EditorWindow theParent, HSObject theHSObject) {
        this.parent = theParent;
        this.hsObject = theHSObject;
        this.setTitle("Event Holds - " + this.hsObject.name);
        this.setSize(windowWidth, windowHeightGeneral);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.createWindowContents();
    }

    private JComboBox createHoldComboBox(HoldComboBoxRenderer renderer, HSObjectHold[] allHoldsPlusNull, HSObjectHold hold) {
        JComboBox<HSObjectHold> holdCombo = new JComboBox<HSObjectHold>(allHoldsPlusNull);
        holdCombo.setRenderer(renderer);
        if (hold == null) {
            holdCombo.setSelectedIndex(0);
        } else {
            holdCombo.setSelectedItem(hold);
        }
        holdCombo.setActionCommand("fieldChanged");
        holdCombo.addItemListener(this);
        return holdCombo;
    }

    private void createWindowContents() {
        TerrainObject tObject;
        HoldComboBoxRenderer holdComboRenderer = new HoldComboBoxRenderer();
        ArrayList<HSObjectHold> allHolds = this.parent.getAllHolds();
        HSObjectHold[] allHoldsPlusNull = new HSObjectHold[allHolds.size() + 1];
        HSObjectHold nullHold = new HSObjectHold();
        nullHold.name = "NONE";
        allHoldsPlusNull[0] = nullHold;
        int i = 0;
        while (i < allHolds.size()) {
            allHoldsPlusNull[i + 1] = allHolds.get(i);
            ++i;
        }
        JLabel lifetimeDeathLabel = new JLabel("Lifetime Death");
        this.lifetimeDeath = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, this.hsObject.hsObjectEventHolds.lifetimeDeath);
        JPanel graphicInterface = new JPanel(new GridLayout(1, gridColumns, gridHorizontalGap, gridVerticalGap));
        graphicInterface.setSize(gridWidth, gridRowHeight);
        graphicInterface.setBorder(new TitledBorder("General Events"));
        graphicInterface.add(lifetimeDeathLabel);
        graphicInterface.add(this.lifetimeDeath);
        graphicInterface.add(new JLabel(""));
        graphicInterface.add(new JLabel(""));
        JPanel eventHoldPane = new JPanel();
        eventHoldPane.setLayout(new BoxLayout(eventHoldPane, 1));
        eventHoldPane.setBorder(new EmptyBorder(windowBorderBuffer, windowBorderBuffer, windowBorderBuffer, windowBorderBuffer));
        eventHoldPane.add(graphicInterface);
        if (this.hsObject.IsTerrainObject()) {
            this.setSize(windowWidth, windowHeightTerrain);
            tObject = (TerrainObject)this.hsObject;
            JLabel healthDeathLabel = new JLabel("Health Death");
            this.healthDeath = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, tObject.terrainEventHolds.healthDeath);
            JPanel terrainInterface = new JPanel(new GridLayout(1, gridColumns, gridHorizontalGap, gridVerticalGap));
            terrainInterface.setSize(gridWidth, gridRowHeight);
            terrainInterface.setBorder(new TitledBorder("Destruction Events"));
            terrainInterface.add(healthDeathLabel);
            terrainInterface.add(this.healthDeath);
            terrainInterface.add(new JLabel(""));
            terrainInterface.add(new JLabel(""));
            eventHoldPane.add(terrainInterface);
        }
        if (this.hsObject.IsPhysicsObject()) {
            this.setSize(windowWidth, windowHeightPhysics);
            tObject = (PhysicsObject)this.hsObject;
        }
        if (this.hsObject.IsFighter()) {
            this.setSize(windowWidth, windowHeightFighter);
            FighterObject fighter = (FighterObject)this.hsObject;
            JLabel standingLabel = new JLabel("Standing");
            this.standing = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.standing);
            JLabel turnLabel = new JLabel("Turn");
            this.turn = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.turn);
            JLabel walkLabel = new JLabel("Walk");
            this.walk = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.walk);
            JLabel walkingLabel = new JLabel("Walking");
            this.walking = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.walking);
            JLabel walkingTurnLabel = new JLabel("Walking Turn");
            this.walkingTurn = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.walkingTurn);
            JLabel runLabel = new JLabel("Run");
            this.run = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.run);
            JLabel runningLabel = new JLabel("Running");
            this.running = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.running);
            JLabel runningTurnLabel = new JLabel("Running Turn");
            this.runningTurn = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.runningTurn);
            JLabel runningStopLabel = new JLabel("Running Stop");
            this.runningStop = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.runningStop);
            JLabel crouchLabel = new JLabel("Crouch");
            this.crouch = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.crouch);
            JLabel crouchingLabel = new JLabel("Crouching");
            this.crouching = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.crouching);
            JLabel crouchingTurnLabel = new JLabel("Crouching Turn");
            this.crouchingTurn = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.crouchingTurn);
            JLabel standLabel = new JLabel("Stand");
            this.stand = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.stand);
            JLabel jumpNeutralStartLabel = new JLabel("Neutral Start");
            this.jumpNeutralStart = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.jumpNeutralStart);
            JLabel jumpNeutralStartAirLabel = new JLabel("Neutral Start Air");
            this.jumpNeutralStartAir = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.jumpNeutralStartAir);
            JLabel jumpNeutralRisingLabel = new JLabel("Neutral Rising");
            this.jumpNeutralRising = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.jumpNeutralRising);
            JLabel jumpNeutralFallLabel = new JLabel("Neutral Fall");
            this.jumpNeutralFall = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.jumpNeutralFall);
            JLabel jumpNeutralFallingLabel = new JLabel("Neutral Falling");
            this.jumpNeutralFalling = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.jumpNeutralFalling);
            JLabel jumpNeutralLandLabel = new JLabel("Neutral Land");
            this.jumpNeutralLand = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.jumpNeutralLand);
            JLabel jumpBackwardRisingLabel = new JLabel("Backward Rising");
            this.jumpBackwardRising = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.jumpBackwardRising);
            JLabel jumpBackwardFallLabel = new JLabel("Backward Fall");
            this.jumpBackwardFall = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.jumpBackwardFall);
            JLabel airDashForwardLabel = new JLabel("Forward");
            this.airDashForward = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.airDashForward);
            JLabel airDashBackwardLabel = new JLabel("Backward");
            this.airDashBackward = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.airDashBackward);
            JLabel blockHighLabel = new JLabel("High");
            this.blockHigh = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.blockHigh);
            JLabel blockLowLabel = new JLabel("Low");
            this.blockLow = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.blockLow);
            JLabel blockAirLabel = new JLabel("Air");
            this.blockAir = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.blockAir);
            JLabel hitstunLightHighStandingLabel = new JLabel("Light High Standing");
            this.hitstunLightHighStanding = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.hitstunLightHighStanding);
            JLabel hitstunLightMidStandingLabel = new JLabel("Light Mid Standing");
            this.hitstunLightMidStanding = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.hitstunLightMidStanding);
            JLabel hitstunLightLowStandingLabel = new JLabel("Light Low Standing");
            this.hitstunLightLowStanding = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.hitstunLightLowStanding);
            JLabel hitstunLightMidCrouchingLabel = new JLabel("Light Mid Crouching");
            this.hitstunLightMidCrouching = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.hitstunLightMidCrouching);
            JLabel hitstunLightLowCrouchingLabel = new JLabel("Light Low Crouching");
            this.hitstunLightLowCrouching = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.hitstunLightLowCrouching);
            JLabel hitstunLightAirLabel = new JLabel("Light Air");
            this.hitstunLightAir = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.hitstunLightAir);
            JLabel attackLightNeutralGroundLabel = new JLabel("Light Neutral");
            this.attackLightNeutralGround = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackLightNeutralGround);
            JLabel attackLightDownGroundLabel = new JLabel("Light Down");
            this.attackLightDownGround = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackLightDownGround);
            JLabel attackLightUpGroundLabel = new JLabel("Light Up");
            this.attackLightUpGround = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackLightUpGround);
            JLabel attackLightForwardGroundLabel = new JLabel("Light Forward");
            this.attackLightForwardGround = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackLightForwardGround);
            JLabel attackLightQCFGroundLabel = new JLabel("Light QCF");
            this.attackLightQCFGround = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackLightQCFGround);
            JLabel attackLightNeutralAirLabel = new JLabel("Light Neutral");
            this.attackLightNeutralAir = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackLightNeutralAir);
            JLabel attackLightDownAirLabel = new JLabel("Light Down");
            this.attackLightDownAir = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackLightDownAir);
            JLabel attackLightUpAirLabel = new JLabel("Light Up");
            this.attackLightUpAir = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackLightUpAir);
            JLabel attackLightForwardAirLabel = new JLabel("Light Forward");
            this.attackLightForwardAir = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackLightForwardAir);
            JLabel attackLightBackwardAirLabel = new JLabel("Light Backward");
            this.attackLightBackwardAir = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackLightBackwardAir);
            JLabel attackLightQCFAirLabel = new JLabel("Light QCF");
            this.attackLightQCFAir = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackLightQCFAir);
            JLabel attackHeavyNeutralGroundLabel = new JLabel("Heavy Neutral");
            this.attackHeavyNeutralGround = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackHeavyNeutralGround);
            JLabel attackHeavyDownGroundLabel = new JLabel("Heavy Down");
            this.attackHeavyDownGround = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackHeavyDownGround);
            JLabel attackHeavyUpGroundLabel = new JLabel("Heavy Up");
            this.attackHeavyUpGround = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackHeavyUpGround);
            JLabel attackHeavyForwardGroundLabel = new JLabel("Heavy Forward");
            this.attackHeavyForwardGround = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackHeavyForwardGround);
            JLabel attackHeavyQCFGroundLabel = new JLabel("Heavy QCF");
            this.attackHeavyQCFGround = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackHeavyQCFGround);
            JLabel attackHeavyNeutralAirLabel = new JLabel("Heavy Neutral");
            this.attackHeavyNeutralAir = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackHeavyNeutralAir);
            JLabel attackHeavyDownAirLabel = new JLabel("Heavy Down");
            this.attackHeavyDownAir = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackHeavyDownAir);
            JLabel attackHeavyUpAirLabel = new JLabel("Heavy Up");
            this.attackHeavyUpAir = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackHeavyUpAir);
            JLabel attackHeavyForwardAirLabel = new JLabel("Heavy Forward");
            this.attackHeavyForwardAir = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackHeavyForwardAir);
            JLabel attackHeavyBackwardAirLabel = new JLabel("Heavy Backward");
            this.attackHeavyBackwardAir = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackHeavyBackwardAir);
            JLabel attackHeavyQCFAirLabel = new JLabel("Heavy QCF");
            this.attackHeavyQCFAir = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.attackHeavyQCFAir);
            JLabel knockoutLabel = new JLabel("Knockout");
            this.knockout = this.createHoldComboBox(holdComboRenderer, allHoldsPlusNull, fighter.fighterEventHolds.knockout);
            JPanel groundMoveInterface = new JPanel(new GridLayout(7, gridColumns, gridHorizontalGap, gridVerticalGap));
            groundMoveInterface.setSize(gridWidth, gridRowHeight * 7);
            groundMoveInterface.setBorder(new TitledBorder("Ground Movement Events"));
            groundMoveInterface.add(standingLabel);
            groundMoveInterface.add(this.standing);
            groundMoveInterface.add(turnLabel);
            groundMoveInterface.add(this.turn);
            groundMoveInterface.add(walkLabel);
            groundMoveInterface.add(this.walk);
            groundMoveInterface.add(walkingLabel);
            groundMoveInterface.add(this.walking);
            groundMoveInterface.add(walkingTurnLabel);
            groundMoveInterface.add(this.walkingTurn);
            groundMoveInterface.add(runLabel);
            groundMoveInterface.add(this.run);
            groundMoveInterface.add(runningLabel);
            groundMoveInterface.add(this.running);
            groundMoveInterface.add(runningTurnLabel);
            groundMoveInterface.add(this.runningTurn);
            groundMoveInterface.add(runningStopLabel);
            groundMoveInterface.add(this.runningStop);
            groundMoveInterface.add(crouchLabel);
            groundMoveInterface.add(this.crouch);
            groundMoveInterface.add(crouchingLabel);
            groundMoveInterface.add(this.crouching);
            groundMoveInterface.add(crouchingTurnLabel);
            groundMoveInterface.add(this.crouchingTurn);
            groundMoveInterface.add(standLabel);
            groundMoveInterface.add(this.stand);
            groundMoveInterface.add(new JLabel(""));
            groundMoveInterface.add(new JLabel(""));
            eventHoldPane.add(groundMoveInterface);
            JPanel jumpInterface = new JPanel(new GridLayout(4, gridColumns, gridHorizontalGap, gridVerticalGap));
            jumpInterface.setSize(gridWidth, gridRowHeight * 4);
            jumpInterface.setBorder(new TitledBorder("Jump Events"));
            jumpInterface.add(jumpNeutralStartLabel);
            jumpInterface.add(this.jumpNeutralStart);
            jumpInterface.add(jumpNeutralStartAirLabel);
            jumpInterface.add(this.jumpNeutralStartAir);
            jumpInterface.add(jumpNeutralRisingLabel);
            jumpInterface.add(this.jumpNeutralRising);
            jumpInterface.add(jumpNeutralFallLabel);
            jumpInterface.add(this.jumpNeutralFall);
            jumpInterface.add(jumpNeutralFallingLabel);
            jumpInterface.add(this.jumpNeutralFalling);
            jumpInterface.add(jumpNeutralLandLabel);
            jumpInterface.add(this.jumpNeutralLand);
            jumpInterface.add(jumpBackwardRisingLabel);
            jumpInterface.add(this.jumpBackwardRising);
            jumpInterface.add(jumpBackwardFallLabel);
            jumpInterface.add(this.jumpBackwardFall);
            eventHoldPane.add(jumpInterface);
            JPanel airDashInterface = new JPanel(new GridLayout(1, gridColumns, gridHorizontalGap, gridVerticalGap));
            airDashInterface.setSize(gridWidth, gridRowHeight * 1);
            airDashInterface.setBorder(new TitledBorder("Air Dash Events"));
            airDashInterface.add(airDashForwardLabel);
            airDashInterface.add(this.airDashForward);
            airDashInterface.add(airDashBackwardLabel);
            airDashInterface.add(this.airDashBackward);
            eventHoldPane.add(airDashInterface);
            JPanel blockInterface = new JPanel(new GridLayout(2, gridColumns, gridHorizontalGap, gridVerticalGap));
            blockInterface.setSize(gridWidth, gridRowHeight * 2);
            blockInterface.setBorder(new TitledBorder("Block Events"));
            blockInterface.add(blockHighLabel);
            blockInterface.add(this.blockHigh);
            blockInterface.add(blockLowLabel);
            blockInterface.add(this.blockLow);
            blockInterface.add(blockAirLabel);
            blockInterface.add(this.blockAir);
            blockInterface.add(new JLabel(""));
            blockInterface.add(new JLabel(""));
            eventHoldPane.add(blockInterface);
            JPanel hitstunInterface = new JPanel(new GridLayout(3, gridColumns, gridHorizontalGap, gridVerticalGap));
            hitstunInterface.setSize(gridWidth, gridRowHeight * 3);
            hitstunInterface.setBorder(new TitledBorder("Hitstun Events"));
            hitstunInterface.add(hitstunLightHighStandingLabel);
            hitstunInterface.add(this.hitstunLightHighStanding);
            hitstunInterface.add(hitstunLightMidStandingLabel);
            hitstunInterface.add(this.hitstunLightMidStanding);
            hitstunInterface.add(hitstunLightLowStandingLabel);
            hitstunInterface.add(this.hitstunLightLowStanding);
            hitstunInterface.add(hitstunLightMidCrouchingLabel);
            hitstunInterface.add(this.hitstunLightMidCrouching);
            hitstunInterface.add(hitstunLightLowCrouchingLabel);
            hitstunInterface.add(this.hitstunLightLowCrouching);
            hitstunInterface.add(hitstunLightAirLabel);
            hitstunInterface.add(this.hitstunLightAir);
            eventHoldPane.add(hitstunInterface);
            JPanel groundNormalInterface = new JPanel(new GridLayout(5, gridColumns, gridHorizontalGap, gridVerticalGap));
            groundNormalInterface.setSize(gridWidth, gridRowHeight * 5);
            groundNormalInterface.setBorder(new TitledBorder("Ground Normal Attack Events"));
            groundNormalInterface.add(attackLightNeutralGroundLabel);
            groundNormalInterface.add(this.attackLightNeutralGround);
            groundNormalInterface.add(attackLightDownGroundLabel);
            groundNormalInterface.add(this.attackLightDownGround);
            groundNormalInterface.add(attackLightUpGroundLabel);
            groundNormalInterface.add(this.attackLightUpGround);
            groundNormalInterface.add(attackLightForwardGroundLabel);
            groundNormalInterface.add(this.attackLightForwardGround);
            groundNormalInterface.add(attackLightQCFGroundLabel);
            groundNormalInterface.add(this.attackLightQCFGround);
            groundNormalInterface.add(attackHeavyNeutralGroundLabel);
            groundNormalInterface.add(this.attackHeavyNeutralGround);
            groundNormalInterface.add(attackHeavyDownGroundLabel);
            groundNormalInterface.add(this.attackHeavyDownGround);
            groundNormalInterface.add(attackHeavyUpGroundLabel);
            groundNormalInterface.add(this.attackHeavyUpGround);
            groundNormalInterface.add(attackHeavyForwardGroundLabel);
            groundNormalInterface.add(this.attackHeavyForwardGround);
            groundNormalInterface.add(attackHeavyQCFGroundLabel);
            groundNormalInterface.add(this.attackHeavyQCFGround);
            eventHoldPane.add(groundNormalInterface);
            JPanel airNormalInterface = new JPanel(new GridLayout(6, gridColumns, gridHorizontalGap, gridVerticalGap));
            airNormalInterface.setSize(gridWidth, gridRowHeight * 6);
            airNormalInterface.setBorder(new TitledBorder("Air Normal Attack Events"));
            airNormalInterface.add(attackLightNeutralAirLabel);
            airNormalInterface.add(this.attackLightNeutralAir);
            airNormalInterface.add(attackLightDownAirLabel);
            airNormalInterface.add(this.attackLightDownAir);
            airNormalInterface.add(attackLightUpAirLabel);
            airNormalInterface.add(this.attackLightUpAir);
            airNormalInterface.add(attackLightForwardAirLabel);
            airNormalInterface.add(this.attackLightForwardAir);
            airNormalInterface.add(attackLightBackwardAirLabel);
            airNormalInterface.add(this.attackLightBackwardAir);
            airNormalInterface.add(attackLightQCFAirLabel);
            airNormalInterface.add(this.attackLightQCFAir);
            airNormalInterface.add(attackHeavyNeutralAirLabel);
            airNormalInterface.add(this.attackHeavyNeutralAir);
            airNormalInterface.add(attackHeavyDownAirLabel);
            airNormalInterface.add(this.attackHeavyDownAir);
            airNormalInterface.add(attackHeavyUpAirLabel);
            airNormalInterface.add(this.attackHeavyUpAir);
            airNormalInterface.add(attackHeavyForwardAirLabel);
            airNormalInterface.add(this.attackHeavyForwardAir);
            airNormalInterface.add(attackHeavyBackwardAirLabel);
            airNormalInterface.add(this.attackHeavyBackwardAir);
            airNormalInterface.add(attackHeavyQCFAirLabel);
            airNormalInterface.add(this.attackHeavyQCFAir);
            eventHoldPane.add(airNormalInterface);
            JPanel otherInterface = new JPanel(new GridLayout(1, gridColumns, gridHorizontalGap, gridVerticalGap));
            otherInterface.setSize(gridWidth, gridRowHeight * 1);
            otherInterface.setBorder(new TitledBorder("Other Events"));
            otherInterface.add(knockoutLabel);
            otherInterface.add(this.knockout);
            otherInterface.add(new JLabel(""));
            otherInterface.add(new JLabel(""));
            eventHoldPane.add(otherInterface);
        }
        JScrollPane eventHoldScrollPane = new JScrollPane(eventHoldPane);
        eventHoldScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("okButton");
        okButton.addActionListener(this);
        JButton closeButton = new JButton("Close");
        closeButton.setActionCommand("closeButton");
        closeButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.setActionCommand("applyButton");
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        JPanel buttonPane = new JPanel(new FlowLayout(4));
        buttonPane.add(okButton);
        buttonPane.add(closeButton);
        buttonPane.add(this.applyButton);
        JPanel interfacePane = new JPanel();
        interfacePane.setLayout(new BoxLayout(interfacePane, 1));
        interfacePane.setBorder(new EmptyBorder(windowBorderBuffer, windowBorderBuffer, windowBorderBuffer, windowBorderBuffer));
        interfacePane.add(eventHoldScrollPane);
        interfacePane.add(buttonPane);
        this.add(interfacePane);
    }

    public void applyChanges() {
        HSObjectHold hSObjectHold = this.hsObject.hsObjectEventHolds.lifetimeDeath = this.lifetimeDeath.getSelectedIndex() == 0 ? null : (HSObjectHold)this.lifetimeDeath.getSelectedItem();
        if (this.hsObject.IsTerrainObject()) {
            ((TerrainObject)this.hsObject).terrainEventHolds.healthDeath = this.healthDeath.getSelectedIndex() == 0 ? null : (TerrainObjectHold)this.healthDeath.getSelectedItem();
        }
        this.hsObject.IsPhysicsObject();
        if (this.hsObject.IsFighter()) {
            ((FighterObject)this.hsObject).fighterEventHolds.standing = this.standing.getSelectedIndex() == 0 ? null : (FighterHold)this.standing.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.turn = this.turn.getSelectedIndex() == 0 ? null : (FighterHold)this.turn.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.walk = this.walk.getSelectedIndex() == 0 ? null : (FighterHold)this.walk.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.walking = this.walking.getSelectedIndex() == 0 ? null : (FighterHold)this.walking.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.walkingTurn = this.walkingTurn.getSelectedIndex() == 0 ? null : (FighterHold)this.walkingTurn.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.run = this.run.getSelectedIndex() == 0 ? null : (FighterHold)this.run.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.running = this.running.getSelectedIndex() == 0 ? null : (FighterHold)this.running.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.runningTurn = this.runningTurn.getSelectedIndex() == 0 ? null : (FighterHold)this.runningTurn.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.runningStop = this.runningStop.getSelectedIndex() == 0 ? null : (FighterHold)this.runningStop.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.crouch = this.crouch.getSelectedIndex() == 0 ? null : (FighterHold)this.crouch.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.crouching = this.crouching.getSelectedIndex() == 0 ? null : (FighterHold)this.crouching.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.crouchingTurn = this.crouchingTurn.getSelectedIndex() == 0 ? null : (FighterHold)this.crouchingTurn.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.stand = this.stand.getSelectedIndex() == 0 ? null : (FighterHold)this.stand.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.jumpNeutralStart = this.jumpNeutralStart.getSelectedIndex() == 0 ? null : (FighterHold)this.jumpNeutralStart.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.jumpNeutralStartAir = this.jumpNeutralStartAir.getSelectedIndex() == 0 ? null : (FighterHold)this.jumpNeutralStartAir.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.jumpNeutralRising = this.jumpNeutralRising.getSelectedIndex() == 0 ? null : (FighterHold)this.jumpNeutralRising.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.jumpNeutralFall = this.jumpNeutralFall.getSelectedIndex() == 0 ? null : (FighterHold)this.jumpNeutralFall.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.jumpNeutralFalling = this.jumpNeutralFalling.getSelectedIndex() == 0 ? null : (FighterHold)this.jumpNeutralFalling.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.jumpNeutralLand = this.jumpNeutralLand.getSelectedIndex() == 0 ? null : (FighterHold)this.jumpNeutralLand.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.jumpBackwardRising = this.jumpBackwardRising.getSelectedIndex() == 0 ? null : (FighterHold)this.jumpBackwardRising.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.jumpBackwardFall = this.jumpBackwardFall.getSelectedIndex() == 0 ? null : (FighterHold)this.jumpBackwardFall.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.airDashForward = this.airDashForward.getSelectedIndex() == 0 ? null : (FighterHold)this.airDashForward.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.airDashBackward = this.airDashBackward.getSelectedIndex() == 0 ? null : (FighterHold)this.airDashBackward.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.blockHigh = this.blockHigh.getSelectedIndex() == 0 ? null : (FighterHold)this.blockHigh.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.blockLow = this.blockLow.getSelectedIndex() == 0 ? null : (FighterHold)this.blockLow.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.blockAir = this.blockAir.getSelectedIndex() == 0 ? null : (FighterHold)this.blockAir.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.hitstunLightHighStanding = this.hitstunLightHighStanding.getSelectedIndex() == 0 ? null : (FighterHold)this.hitstunLightHighStanding.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.hitstunLightMidStanding = this.hitstunLightMidStanding.getSelectedIndex() == 0 ? null : (FighterHold)this.hitstunLightMidStanding.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.hitstunLightLowStanding = this.hitstunLightLowStanding.getSelectedIndex() == 0 ? null : (FighterHold)this.hitstunLightLowStanding.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.hitstunLightMidCrouching = this.hitstunLightMidCrouching.getSelectedIndex() == 0 ? null : (FighterHold)this.hitstunLightMidCrouching.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.hitstunLightLowCrouching = this.hitstunLightLowCrouching.getSelectedIndex() == 0 ? null : (FighterHold)this.hitstunLightLowCrouching.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.hitstunLightAir = this.hitstunLightAir.getSelectedIndex() == 0 ? null : (FighterHold)this.hitstunLightAir.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackLightNeutralGround = this.attackLightNeutralGround.getSelectedIndex() == 0 ? null : (FighterHold)this.attackLightNeutralGround.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackLightDownGround = this.attackLightDownGround.getSelectedIndex() == 0 ? null : (FighterHold)this.attackLightDownGround.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackLightUpGround = this.attackLightUpGround.getSelectedIndex() == 0 ? null : (FighterHold)this.attackLightUpGround.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackLightForwardGround = this.attackLightForwardGround.getSelectedIndex() == 0 ? null : (FighterHold)this.attackLightForwardGround.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackLightQCFGround = this.attackLightQCFGround.getSelectedIndex() == 0 ? null : (FighterHold)this.attackLightQCFGround.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackLightNeutralAir = this.attackLightNeutralAir.getSelectedIndex() == 0 ? null : (FighterHold)this.attackLightNeutralAir.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackLightDownAir = this.attackLightDownAir.getSelectedIndex() == 0 ? null : (FighterHold)this.attackLightDownAir.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackLightUpAir = this.attackLightUpAir.getSelectedIndex() == 0 ? null : (FighterHold)this.attackLightUpAir.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackLightForwardAir = this.attackLightForwardAir.getSelectedIndex() == 0 ? null : (FighterHold)this.attackLightForwardAir.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackLightBackwardAir = this.attackLightBackwardAir.getSelectedIndex() == 0 ? null : (FighterHold)this.attackLightBackwardAir.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackLightQCFAir = this.attackLightQCFAir.getSelectedIndex() == 0 ? null : (FighterHold)this.attackLightQCFAir.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackHeavyNeutralGround = this.attackHeavyNeutralGround.getSelectedIndex() == 0 ? null : (FighterHold)this.attackHeavyNeutralGround.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackHeavyDownGround = this.attackHeavyDownGround.getSelectedIndex() == 0 ? null : (FighterHold)this.attackHeavyDownGround.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackHeavyUpGround = this.attackHeavyUpGround.getSelectedIndex() == 0 ? null : (FighterHold)this.attackHeavyUpGround.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackHeavyForwardGround = this.attackHeavyForwardGround.getSelectedIndex() == 0 ? null : (FighterHold)this.attackHeavyForwardGround.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackHeavyQCFGround = this.attackHeavyQCFGround.getSelectedIndex() == 0 ? null : (FighterHold)this.attackHeavyQCFGround.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackHeavyNeutralAir = this.attackHeavyNeutralAir.getSelectedIndex() == 0 ? null : (FighterHold)this.attackHeavyNeutralAir.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackHeavyDownAir = this.attackHeavyDownAir.getSelectedIndex() == 0 ? null : (FighterHold)this.attackHeavyDownAir.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackHeavyUpAir = this.attackHeavyUpAir.getSelectedIndex() == 0 ? null : (FighterHold)this.attackHeavyUpAir.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackHeavyForwardAir = this.attackHeavyForwardAir.getSelectedIndex() == 0 ? null : (FighterHold)this.attackHeavyForwardAir.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackHeavyBackwardAir = this.attackHeavyBackwardAir.getSelectedIndex() == 0 ? null : (FighterHold)this.attackHeavyBackwardAir.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.attackHeavyQCFAir = this.attackHeavyQCFAir.getSelectedIndex() == 0 ? null : (FighterHold)this.attackHeavyQCFAir.getSelectedItem();
            ((FighterObject)this.hsObject).fighterEventHolds.knockout = this.knockout.getSelectedIndex() == 0 ? null : (FighterHold)this.knockout.getSelectedItem();
        }
        this.parent.repaint();
        this.applyButton.setEnabled(false);
    }

    private void closeWindow() {
        this.dispose();
    }

    private void okButtonPressed() {
        this.applyChanges();
        this.closeWindow();
    }

    private void closeButtonPressed() {
        this.closeWindow();
    }

    private void applyButtonPressed() {
        this.applyChanges();
    }

    public void fieldChanged() {
        this.applyButton.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "okButton": {
                this.okButtonPressed();
                break;
            }
            case "closeButton": {
                this.closeButtonPressed();
                break;
            }
            case "applyButton": {
                this.applyButtonPressed();
                break;
            }
            case "fieldChanged": {
                this.fieldChanged();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fieldChanged();
    }
}

