/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows;

import homestrifeeditor.objects.holds.properties.HSBoxLabel;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HitboxAttributesWindow
extends JFrame
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private static int windowWidth = 300;
    private static int windowHeight = 140;
    private static int windowBorderBuffer = 10;
    private static int gridWidth = 650;
    private static int gridRowHeight = 45;
    private static int gridColumns = 4;
    private static int gridHorizontalGap = 10;
    private static int gridVerticalGap = 5;
    private HSBoxLabel hitboxLabel;
    private JSpinner offsetXSpinner;
    private JSpinner offsetYSpinner;
    private JSpinner widthSpinner;
    private JSpinner heightSpinner;

    public HitboxAttributesWindow(HSBoxLabel theHitboxLabel) {
        this.hitboxLabel = theHitboxLabel;
        this.setTitle("Hitbox Attributes");
        this.setSize(windowWidth, windowHeight);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.createWindowContents();
    }

    private void createWindowContents() {
        JLabel offsetXLabel = new JLabel("Offset X");
        this.offsetXSpinner = new JSpinner(new SpinnerNumberModel(0, -99999, 99999, 1));
        this.offsetXSpinner.setValue((int)this.hitboxLabel.box.offset.x);
        this.offsetXSpinner.addChangeListener(this);
        JLabel offsetYLabel = new JLabel("Offset Y");
        this.offsetYSpinner = new JSpinner(new SpinnerNumberModel(0, -99999, 99999, 1));
        this.offsetYSpinner.setValue((int)this.hitboxLabel.box.offset.y);
        this.offsetYSpinner.addChangeListener(this);
        JLabel widthLabel = new JLabel("Width");
        this.widthSpinner = new JSpinner(new SpinnerNumberModel(0, -99999, 99999, 1));
        this.widthSpinner.setValue((int)this.hitboxLabel.box.width);
        this.widthSpinner.addChangeListener(this);
        JLabel heightLabel = new JLabel("Height");
        this.heightSpinner = new JSpinner(new SpinnerNumberModel(0, -99999, 99999, 1));
        this.heightSpinner.setValue((int)this.hitboxLabel.box.height);
        this.heightSpinner.addChangeListener(this);
        JPanel valueInterface = new JPanel(new GridLayout(2, gridColumns, gridHorizontalGap, gridVerticalGap));
        valueInterface.setSize(gridWidth, gridRowHeight * 2);
        valueInterface.add(offsetXLabel);
        valueInterface.add(this.offsetXSpinner);
        valueInterface.add(widthLabel);
        valueInterface.add(this.widthSpinner);
        valueInterface.add(offsetYLabel);
        valueInterface.add(this.offsetYSpinner);
        valueInterface.add(heightLabel);
        valueInterface.add(this.heightSpinner);
        JButton closeButton = new JButton("Close");
        closeButton.setActionCommand("closeButton");
        closeButton.addActionListener(this);
        JPanel buttonPane = new JPanel(new FlowLayout(4));
        buttonPane.add(closeButton);
        JPanel hitboxAttributesPane = new JPanel();
        hitboxAttributesPane.setLayout(new BoxLayout(hitboxAttributesPane, 1));
        hitboxAttributesPane.setBorder(new EmptyBorder(windowBorderBuffer, windowBorderBuffer, windowBorderBuffer, windowBorderBuffer));
        hitboxAttributesPane.add(valueInterface);
        hitboxAttributesPane.add(buttonPane);
        this.add(hitboxAttributesPane);
    }

    private void closeWindow() {
        this.dispose();
    }

    private void fieldChanged() {
        this.hitboxLabel.box.offset.x = ((Integer)this.offsetXSpinner.getValue()).intValue();
        this.hitboxLabel.box.offset.y = ((Integer)this.offsetYSpinner.getValue()).intValue();
        this.hitboxLabel.box.width = ((Integer)this.widthSpinner.getValue()).intValue();
        this.hitboxLabel.box.height = ((Integer)this.heightSpinner.getValue()).intValue();
        Point pos = this.hitboxLabel.parent.parent.getSwingOffset(this.hitboxLabel.box.offset.x, this.hitboxLabel.box.offset.y);
        this.hitboxLabel.setBounds(pos.x, pos.y, (int)this.hitboxLabel.box.width, (int)this.hitboxLabel.box.height);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "closeButton": {
                this.closeWindow();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fieldChanged();
    }
}

