/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows;

import homestrifeeditor.objects.FighterObject;
import homestrifeeditor.objects.HSObject;
import homestrifeeditor.objects.PhysicsObject;
import homestrifeeditor.objects.TerrainObject;
import homestrifeeditor.windows.EditorWindow;
import homestrifeeditor.windows.SoundsWindow;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ObjectAttributesWindow
extends JFrame
implements ActionListener,
ChangeListener,
DocumentListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private static int windowWidth = 720;
    private static int windowHeightGeneral = 155;
    private static int windowHeightTerrain = 230;
    private static int windowHeightPhysics = 300;
    private static int windowHeightFighter = 470;
    private static int windowBorderBuffer = 10;
    private static int gridWidth = 700;
    private static int gridRowHeight = 45;
    private static int gridColumns = 4;
    private static int gridHorizontalGap = 10;
    private static int gridVerticalGap = 5;
    private EditorWindow parent;
    private HSObject hsObject;
    private JTextField nameField;
    private static String nameTooltip = "<html>The name of the object.</html>";
    private JSpinner lifetimeSpinner;
    private JSpinner healthSpinner;
    private JSpinner bounceSpinner;
    private JSpinner frictionSpinner;
    private JCheckBox takesTerrainDamageCheck;
    private JCheckBox fragileCheck;
    private static String fragileTooltip = "<html>Whether or not this object is destroyed upon ANY impact.</html>";
    private JSpinner massSpinner;
    private JCheckBox fallsCheck;
    private JSpinner maxFallSpeedSpinner;
    private JSpinner walkSpeedSpinner;
    private JSpinner runSpeedSpinner;
    private JSpinner jumpSpeedSpinner;
    private JSpinner forwardAirDashSpeedSpinner;
    private JSpinner backwardAirDashSpeedSpinner;
    private JSpinner forwardAirDashDurationSpinner;
    private JSpinner backwardAirDashDurationSpinner;
    private JSpinner stepHeightSpinner;
    private JSpinner airActionsSpinner;
    private JSpinner airControlAccelSpinner;
    private JSpinner maxAirControlSpeedSpinner;
    private JButton applyButton;

    public ObjectAttributesWindow(EditorWindow theParent, HSObject theHSObject) {
        this.parent = theParent;
        this.hsObject = theHSObject;
        this.setTitle("Object Attributes - " + this.hsObject.name);
        this.setSize(windowWidth, windowHeightGeneral);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.createWindowContents();
    }

    private void createWindowContents() {
        Float stepSize;
        Float max;
        Float min;
        Float value;
        JLabel nameLabel = new JLabel("Name");
        nameLabel.setToolTipText(nameTooltip);
        this.nameField = new JTextField(this.hsObject.name);
        this.nameField.setToolTipText(nameTooltip);
        this.nameField.getDocument().addDocumentListener(this);
        JLabel lifetimeLabel = new JLabel("Life Time");
        this.lifetimeSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99999, 1));
        this.lifetimeSpinner.setValue(this.hsObject.lifetime);
        this.lifetimeSpinner.addChangeListener(this);
        JPanel graphicInterface = new JPanel(new GridLayout(1, gridColumns, gridHorizontalGap, gridVerticalGap));
        graphicInterface.setSize(gridWidth, gridRowHeight);
        graphicInterface.setBorder(new TitledBorder("General Attributes"));
        graphicInterface.add(nameLabel);
        graphicInterface.add(this.nameField);
        graphicInterface.add(lifetimeLabel);
        graphicInterface.add(this.lifetimeSpinner);
        JPanel objectAttributesPane = new JPanel();
        objectAttributesPane.setLayout(new BoxLayout(objectAttributesPane, 1));
        objectAttributesPane.setBorder(new EmptyBorder(windowBorderBuffer, windowBorderBuffer, windowBorderBuffer, windowBorderBuffer));
        objectAttributesPane.add(graphicInterface);
        if (this.hsObject.IsTerrainObject()) {
            this.setSize(windowWidth, windowHeightTerrain);
            TerrainObject tObject = (TerrainObject)this.hsObject;
            value = new Float(0.0);
            min = new Float(0.0f);
            max = new Float(1.0f);
            stepSize = new Float(0.1);
            JLabel healthLabel = new JLabel("Health");
            this.healthSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99999, 1));
            this.healthSpinner.setValue(tObject.health);
            this.healthSpinner.addChangeListener(this);
            JLabel bounceLabel = new JLabel("Bounce");
            this.bounceSpinner = new JSpinner(new SpinnerNumberModel(value, min, max, stepSize));
            this.bounceSpinner.setValue(Float.valueOf(tObject.bounce));
            this.bounceSpinner.addChangeListener(this);
            JLabel frictionLabel = new JLabel("Friction");
            this.frictionSpinner = new JSpinner(new SpinnerNumberModel(value, min, max, stepSize));
            this.frictionSpinner.setValue(Float.valueOf(tObject.friction));
            this.frictionSpinner.addChangeListener(this);
            JLabel takesTerrainDamageLabel = new JLabel("Takes Impact Damage");
            this.takesTerrainDamageCheck = new JCheckBox("", tObject.takesTerrainDamage);
            this.takesTerrainDamageCheck.setActionCommand("fieldChanged");
            this.takesTerrainDamageCheck.addActionListener(this);
            JLabel fragileLabel = new JLabel("Fragile");
            this.fragileCheck = new JCheckBox("", tObject.fragile);
            this.fragileCheck.setActionCommand("fieldChanged");
            this.fragileCheck.setToolTipText(fragileTooltip);
            this.fragileCheck.addActionListener(this);
            JButton getHitSounds = new JButton("Sounds on Hit...");
            getHitSounds.setActionCommand("onHit");
            getHitSounds.addActionListener(this);
            JPanel terrainInterface = new JPanel(new GridLayout(0, gridColumns, gridHorizontalGap, gridVerticalGap));
            terrainInterface.setSize(gridWidth, gridRowHeight * 3);
            terrainInterface.setBorder(new TitledBorder("Health & Impact Attributes"));
            terrainInterface.add(healthLabel);
            terrainInterface.add(this.healthSpinner);
            terrainInterface.add(bounceLabel);
            terrainInterface.add(this.bounceSpinner);
            terrainInterface.add(takesTerrainDamageLabel);
            terrainInterface.add(this.takesTerrainDamageCheck);
            terrainInterface.add(frictionLabel);
            terrainInterface.add(this.frictionSpinner);
            terrainInterface.add(fragileLabel);
            terrainInterface.add(this.fragileCheck);
            terrainInterface.add(new JLabel(""));
            terrainInterface.add(getHitSounds);
            objectAttributesPane.add(terrainInterface);
        }
        if (this.hsObject.IsPhysicsObject()) {
            this.setSize(windowWidth, windowHeightPhysics);
            PhysicsObject pObject = (PhysicsObject)this.hsObject;
            value = new Float(0.0);
            min = new Float(0.0f);
            max = new Float(99999.0f);
            stepSize = new Float(1.0f);
            JLabel massLabel = new JLabel("Mass");
            this.massSpinner = new JSpinner(new SpinnerNumberModel(value, min, max, stepSize));
            this.massSpinner.setValue(Float.valueOf(pObject.mass));
            this.massSpinner.addChangeListener(this);
            JLabel fallsLabel = new JLabel("Falls");
            this.fallsCheck = new JCheckBox("", pObject.falls);
            this.fallsCheck.setActionCommand("fieldChanged");
            this.fallsCheck.addActionListener(this);
            JLabel maxFallSpeedLabel = new JLabel("Max Fall Speed");
            this.maxFallSpeedSpinner = new JSpinner(new SpinnerNumberModel(value, min, max, stepSize));
            this.maxFallSpeedSpinner.setValue(Float.valueOf(pObject.maxFallSpeed));
            this.maxFallSpeedSpinner.addChangeListener(this);
            JPanel physicsInterface = new JPanel(new GridLayout(2, gridColumns, gridHorizontalGap, gridVerticalGap));
            physicsInterface.setSize(gridWidth, gridRowHeight * 3);
            physicsInterface.setBorder(new TitledBorder("Physics Attributes"));
            physicsInterface.add(massLabel);
            physicsInterface.add(this.massSpinner);
            physicsInterface.add(maxFallSpeedLabel);
            physicsInterface.add(this.maxFallSpeedSpinner);
            physicsInterface.add(fallsLabel);
            physicsInterface.add(this.fallsCheck);
            physicsInterface.add(new JLabel(""));
            physicsInterface.add(new JLabel(""));
            objectAttributesPane.add(physicsInterface);
        }
        if (this.hsObject.IsFighter()) {
            this.setSize(windowWidth, windowHeightFighter);
            FighterObject fighter = (FighterObject)this.hsObject;
            value = new Float(0.0);
            min = new Float(0.0f);
            max = new Float(99999.0f);
            stepSize = new Float(1.0f);
            JLabel walkSpeedLabel = new JLabel("Walk Speed");
            this.walkSpeedSpinner = new JSpinner(new SpinnerNumberModel(value, min, max, stepSize));
            this.walkSpeedSpinner.setValue(Float.valueOf(fighter.walkSpeed));
            this.walkSpeedSpinner.addChangeListener(this);
            JLabel runSpeedLabel = new JLabel("Run Speed");
            this.runSpeedSpinner = new JSpinner(new SpinnerNumberModel(value, min, max, stepSize));
            this.runSpeedSpinner.setValue(Float.valueOf(fighter.runSpeed));
            this.runSpeedSpinner.addChangeListener(this);
            JLabel jumpSpeedLabel = new JLabel("Jump Speed");
            this.jumpSpeedSpinner = new JSpinner(new SpinnerNumberModel(value, min, max, stepSize));
            this.jumpSpeedSpinner.setValue(Float.valueOf(fighter.jumpSpeed));
            this.jumpSpeedSpinner.addChangeListener(this);
            JLabel forwardAirDashSpeedLabel = new JLabel("Forward Air Dash Speed");
            this.forwardAirDashSpeedSpinner = new JSpinner(new SpinnerNumberModel(value, min, max, stepSize));
            this.forwardAirDashSpeedSpinner.setValue(Float.valueOf(fighter.forwardAirDashSpeed));
            this.forwardAirDashSpeedSpinner.addChangeListener(this);
            JLabel backwardAirDashSpeedLabel = new JLabel("Backward Air Dash Speed");
            this.backwardAirDashSpeedSpinner = new JSpinner(new SpinnerNumberModel(value, min, max, stepSize));
            this.backwardAirDashSpeedSpinner.setValue(Float.valueOf(fighter.backwardAirDashSpeed));
            this.backwardAirDashSpeedSpinner.addChangeListener(this);
            JLabel forwardAirDashDurationLabel = new JLabel("Forward Air Dash Duration");
            this.forwardAirDashDurationSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99999, 1));
            this.forwardAirDashDurationSpinner.setValue(fighter.forwardAirDashDuration);
            this.forwardAirDashDurationSpinner.addChangeListener(this);
            JLabel backwardAirDashDurationLabel = new JLabel("Backward Air Dash Duration");
            this.backwardAirDashDurationSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99999, 1));
            this.backwardAirDashDurationSpinner.setValue(fighter.backwardAirDashDuration);
            this.backwardAirDashDurationSpinner.addChangeListener(this);
            JLabel stepHeightLabel = new JLabel("Step Height");
            this.stepHeightSpinner = new JSpinner(new SpinnerNumberModel(value, min, max, stepSize));
            this.stepHeightSpinner.setValue(Float.valueOf(fighter.stepHeight));
            this.stepHeightSpinner.addChangeListener(this);
            JLabel airActionsLabel = new JLabel("# of Air Actions");
            this.airActionsSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99999, 1));
            this.airActionsSpinner.setValue(fighter.airActions);
            this.airActionsSpinner.addChangeListener(this);
            JLabel airControlAccelLabel = new JLabel("Air Control Accel");
            this.airControlAccelSpinner = new JSpinner(new SpinnerNumberModel(value, min, max, stepSize));
            this.airControlAccelSpinner.setValue(Float.valueOf(fighter.airControlAccel));
            this.airControlAccelSpinner.addChangeListener(this);
            JLabel maxAirControlSpeedLabel = new JLabel("Max Air Control Speed");
            this.maxAirControlSpeedSpinner = new JSpinner(new SpinnerNumberModel(value, min, max, stepSize));
            this.maxAirControlSpeedSpinner.setValue(Float.valueOf(fighter.maxAirControlSpeed));
            this.maxAirControlSpeedSpinner.addChangeListener(this);
            JPanel fighterInterface = new JPanel(new GridLayout(6, gridColumns, gridHorizontalGap, gridVerticalGap));
            fighterInterface.setSize(gridWidth, gridRowHeight * 3);
            fighterInterface.setBorder(new TitledBorder("Fighter Attributes"));
            fighterInterface.add(walkSpeedLabel);
            fighterInterface.add(this.walkSpeedSpinner);
            fighterInterface.add(runSpeedLabel);
            fighterInterface.add(this.runSpeedSpinner);
            fighterInterface.add(jumpSpeedLabel);
            fighterInterface.add(this.jumpSpeedSpinner);
            fighterInterface.add(airActionsLabel);
            fighterInterface.add(this.airActionsSpinner);
            fighterInterface.add(airControlAccelLabel);
            fighterInterface.add(this.airControlAccelSpinner);
            fighterInterface.add(maxAirControlSpeedLabel);
            fighterInterface.add(this.maxAirControlSpeedSpinner);
            fighterInterface.add(forwardAirDashSpeedLabel);
            fighterInterface.add(this.forwardAirDashSpeedSpinner);
            fighterInterface.add(backwardAirDashSpeedLabel);
            fighterInterface.add(this.backwardAirDashSpeedSpinner);
            fighterInterface.add(forwardAirDashDurationLabel);
            fighterInterface.add(this.forwardAirDashDurationSpinner);
            fighterInterface.add(backwardAirDashDurationLabel);
            fighterInterface.add(this.backwardAirDashDurationSpinner);
            fighterInterface.add(stepHeightLabel);
            fighterInterface.add(this.stepHeightSpinner);
            fighterInterface.add(new JLabel(""));
            fighterInterface.add(new JLabel(""));
            objectAttributesPane.add(fighterInterface);
        }
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("okButton");
        okButton.addActionListener(this);
        JButton closeButton = new JButton("Close");
        closeButton.setActionCommand("closeButton");
        closeButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.setActionCommand("applyButton");
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        JPanel buttonPane = new JPanel(new FlowLayout(4));
        buttonPane.add(okButton);
        buttonPane.add(closeButton);
        buttonPane.add(this.applyButton);
        objectAttributesPane.add(buttonPane);
        this.add(objectAttributesPane);
    }

    public void applyChanges() {
        this.hsObject.name = this.nameField.getText();
        this.hsObject.lifetime = (Integer)this.lifetimeSpinner.getValue();
        if (this.hsObject.IsTerrainObject()) {
            ((TerrainObject)this.hsObject).health = (Integer)this.healthSpinner.getValue();
            ((TerrainObject)this.hsObject).bounce = ((Float)this.bounceSpinner.getValue()).floatValue();
            ((TerrainObject)this.hsObject).friction = ((Float)this.frictionSpinner.getValue()).floatValue();
            ((TerrainObject)this.hsObject).takesTerrainDamage = this.takesTerrainDamageCheck.isSelected();
            ((TerrainObject)this.hsObject).fragile = this.fragileCheck.isSelected();
        }
        if (this.hsObject.IsPhysicsObject()) {
            ((PhysicsObject)this.hsObject).mass = ((Float)this.massSpinner.getValue()).floatValue();
            ((PhysicsObject)this.hsObject).falls = this.fallsCheck.isSelected();
            ((PhysicsObject)this.hsObject).maxFallSpeed = ((Float)this.maxFallSpeedSpinner.getValue()).floatValue();
        }
        if (this.hsObject.IsFighter()) {
            ((FighterObject)this.hsObject).walkSpeed = ((Float)this.walkSpeedSpinner.getValue()).floatValue();
            ((FighterObject)this.hsObject).runSpeed = ((Float)this.runSpeedSpinner.getValue()).floatValue();
            ((FighterObject)this.hsObject).jumpSpeed = ((Float)this.jumpSpeedSpinner.getValue()).floatValue();
            ((FighterObject)this.hsObject).forwardAirDashSpeed = ((Float)this.forwardAirDashSpeedSpinner.getValue()).floatValue();
            ((FighterObject)this.hsObject).backwardAirDashSpeed = ((Float)this.backwardAirDashSpeedSpinner.getValue()).floatValue();
            ((FighterObject)this.hsObject).forwardAirDashDuration = (Integer)this.forwardAirDashDurationSpinner.getValue();
            ((FighterObject)this.hsObject).backwardAirDashDuration = (Integer)this.backwardAirDashDurationSpinner.getValue();
            ((FighterObject)this.hsObject).stepHeight = ((Float)this.stepHeightSpinner.getValue()).floatValue();
            ((FighterObject)this.hsObject).airActions = (Integer)this.airActionsSpinner.getValue();
            ((FighterObject)this.hsObject).airControlAccel = ((Float)this.airControlAccelSpinner.getValue()).floatValue();
            ((FighterObject)this.hsObject).maxAirControlSpeed = ((Float)this.maxAirControlSpeedSpinner.getValue()).floatValue();
        }
        this.parent.repaint();
        this.parent.setTitle("Homestrife Editor - " + this.hsObject.name);
        this.setTitle("Object Attributes - " + this.hsObject.name);
        this.applyButton.setEnabled(false);
    }

    private void closeWindow() {
        this.dispose();
    }

    private void okButtonPressed() {
        this.applyChanges();
        this.closeWindow();
    }

    private void closeButtonPressed() {
        this.closeWindow();
    }

    private void applyButtonPressed() {
        this.applyChanges();
    }

    public void fieldChanged() {
        this.applyButton.setEnabled(true);
    }

    public void onHitSounds() {
        SoundsWindow window = new SoundsWindow(this, this.hsObject, "onHit");
        window.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "okButton": {
                this.okButtonPressed();
                break;
            }
            case "closeButton": {
                this.closeButtonPressed();
                break;
            }
            case "applyButton": {
                this.applyButtonPressed();
                break;
            }
            case "fieldChanged": {
                this.fieldChanged();
                break;
            }
            case "onHit": {
                this.onHitSounds();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fieldChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fieldChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fieldChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fieldChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fieldChanged();
    }
}

