/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows;

import homestrifeeditor.objects.HSObject;
import homestrifeeditor.objects.TerrainObject;
import homestrifeeditor.objects.holds.HSObjectHold;
import homestrifeeditor.objects.holds.TerrainObjectHold;
import homestrifeeditor.objects.holds.properties.HSAudio;
import homestrifeeditor.windows.EditorWindow;
import homestrifeeditor.windows.renderers.SoundListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SoundsWindow
extends JFrame
implements ActionListener,
ListSelectionListener,
MouseListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private static int windowWidth = 400;
    private static int windowHeight = 200;
    private JFrame parent;
    private Object object;
    private String mode;
    private boolean loading;
    public DefaultListModel<HSAudio> soundListModel;
    public JList<HSAudio> soundList;
    private JToolBar soundListToolBar;
    private JLabel soundFile;
    private JButton changeSoundButton;
    private static String changeSoundTooltip = "<html>Load a sound from the hard drive.</html>";
    private JSpinner delaySpinner;
    private static String delayTooltip = "<html>Which frame of this hold the sound triggers on.</html>";
    private JCheckBox exclusiveCheckBox;
    private static String exclusiveToolTip = "<html>If set, this sound cancels out all other exclusive sounds previously produced by this object</html>";
    private JSpinner percentageSpinner;
    private static String percentageToolTip = "<html>When enabled, the % chance that this sound will play</html>";
    private JCheckBox percentageCheckBox;

    public SoundsWindow(JFrame theParent, Object theObject, String theMode) {
        this.parent = theParent;
        this.object = theObject;
        this.mode = theMode;
        this.loading = false;
        if (this.mode.compareTo("hold") == 0) {
            this.setTitle("Hold Sounds - " + ((HSObjectHold)this.object).name);
        } else if (this.mode.compareTo("hit") == 0) {
            this.setTitle("Hit Sounds - " + ((HSObjectHold)this.object).name);
        } else if (this.mode.compareTo("blocked") == 0) {
            this.setTitle("Blocked Sounds - " + ((HSObjectHold)this.object).name);
        } else if (this.mode.compareTo("onHit") == 0) {
            this.setTitle("On Hit Sounds - " + ((HSObject)this.object).name);
        }
        this.setSize(windowWidth, windowHeight);
        this.setLocationRelativeTo(null);
        this.createWindowContents();
    }

    private void createWindowContents() {
        JLabel soundListLabel = new JLabel("Sound List");
        this.soundListModel = new DefaultListModel();
        this.soundList = new JList<HSAudio>(this.soundListModel);
        this.soundList.setName("soundList");
        this.soundList.setCellRenderer(new SoundListCellRenderer());
        this.soundList.addListSelectionListener(this);
        this.soundList.addMouseListener(this);
        if (this.mode.compareTo("hold") == 0) {
            for (HSAudio a : ((HSObjectHold)this.object).audioList) {
                this.soundListModel.addElement(a);
            }
        } else if (this.mode.compareTo("hit") == 0) {
            for (HSAudio a : ((TerrainObjectHold)this.object).hitAudioList) {
                this.soundListModel.addElement(a);
            }
        } else if (this.mode.compareTo("blocked") == 0) {
            for (HSAudio a : ((TerrainObjectHold)this.object).blockedAudioList) {
                this.soundListModel.addElement(a);
            }
        } else if (this.mode.compareTo("onHit") == 0) {
            for (HSAudio a : ((TerrainObject)this.object).onHitSounds) {
                this.soundListModel.addElement(a);
            }
        }
        JScrollPane holdListScrollPane = new JScrollPane(this.soundList);
        JButton addSoundButton = new JButton("+");
        addSoundButton.setActionCommand("addSound");
        addSoundButton.setToolTipText("Add New Sound");
        addSoundButton.addActionListener(this);
        JButton removeSoundsButton = new JButton("-");
        removeSoundsButton.setActionCommand("removeSounds");
        removeSoundsButton.setToolTipText("Remove Selected Sound(s)");
        removeSoundsButton.addActionListener(this);
        this.soundListToolBar = new JToolBar();
        this.soundListToolBar.setFloatable(false);
        this.soundListToolBar.add(addSoundButton);
        this.soundListToolBar.add(removeSoundsButton);
        JPanel soundListPane = new JPanel();
        soundListPane.setLayout(new BorderLayout());
        soundListPane.add((Component)soundListLabel, "First");
        soundListPane.add((Component)holdListScrollPane, "Center");
        soundListPane.add((Component)this.soundListToolBar, "Last");
        JLabel soundFileLabel = new JLabel("File:");
        this.soundFile = new JLabel("N/A");
        this.changeSoundButton = new JButton("Change Sound...");
        this.changeSoundButton.setToolTipText(changeSoundTooltip);
        this.changeSoundButton.setActionCommand("changeSound");
        this.changeSoundButton.setEnabled(false);
        this.changeSoundButton.addActionListener(this);
        JLabel delayLabel = new JLabel("Delay");
        delayLabel.setToolTipText(delayTooltip);
        this.delaySpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99999, 1));
        this.delaySpinner.setToolTipText(delayTooltip);
        this.delaySpinner.setValue(0);
        this.delaySpinner.addChangeListener(this);
        this.delaySpinner.setEnabled(false);
        this.exclusiveCheckBox = new JCheckBox("Exclusive");
        this.exclusiveCheckBox.setToolTipText(exclusiveToolTip);
        this.exclusiveCheckBox.setEnabled(false);
        this.exclusiveCheckBox.setActionCommand("changeExclusive");
        this.exclusiveCheckBox.addActionListener(this);
        this.percentageSpinner = new JSpinner(new SpinnerNumberModel(100, 0, 100, 1));
        this.percentageSpinner.setToolTipText(percentageToolTip);
        this.percentageSpinner.addChangeListener(this);
        this.percentageSpinner.setEnabled(false);
        this.percentageCheckBox = new JCheckBox("Play Chance");
        this.percentageCheckBox.setToolTipText(percentageToolTip);
        this.percentageCheckBox.setEnabled(false);
        this.percentageCheckBox.setActionCommand("changeUsePercentage");
        this.percentageCheckBox.addActionListener(this);
        JPanel soundDataPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        soundDataPane.add((Component)soundFileLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        soundDataPane.add((Component)this.soundFile, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.ipady = 20;
        gbc.fill = 2;
        soundDataPane.add((Component)this.changeSoundButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.ipady = 0;
        gbc.fill = 2;
        soundDataPane.add((Component)delayLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 2;
        soundDataPane.add((Component)this.delaySpinner, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        soundDataPane.add((Component)this.exclusiveCheckBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        soundDataPane.add((Component)this.percentageCheckBox, gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.anchor = 20;
        soundDataPane.add((Component)this.percentageSpinner, gbc);
        JSplitPane sPane = new JSplitPane(1, soundListPane, soundDataPane);
        sPane.setDividerLocation(100);
        this.setContentPane(sPane);
    }

    private void addSoundToSoundList() {
        int returnVal = EditorWindow.fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File file = EditorWindow.fileChooser.getSelectedFile();
        int index = this.soundList.getSelectedIndex();
        this.soundList.clearSelection();
        HSAudio newAudio = new HSAudio(file.getPath());
        if (this.mode.compareTo("hold") == 0) {
            ((HSObjectHold)this.object).audioList.add(newAudio);
        } else if (this.mode.compareTo("hit") == 0) {
            ((TerrainObjectHold)this.object).hitAudioList.add(newAudio);
        } else if (this.mode.compareTo("blocked") == 0) {
            ((TerrainObjectHold)this.object).blockedAudioList.add(newAudio);
        } else if (this.mode.compareTo("onHit") == 0) {
            ((TerrainObject)this.object).onHitSounds.add(newAudio);
        }
        if (index >= 0) {
            this.soundListModel.add(index, newAudio);
            this.soundList.setSelectedIndex(index);
        } else {
            this.soundListModel.addElement(newAudio);
            this.soundList.setSelectedIndex(this.soundListModel.getSize() - 1);
        }
    }

    public HSAudio removeSoundFromSoundList(int index) {
        HSAudio audio = this.soundListModel.remove(index);
        if (this.mode.compareTo("hold") == 0) {
            ((HSObjectHold)this.object).audioList.remove(audio);
        } else if (this.mode.compareTo("hit") == 0) {
            ((TerrainObjectHold)this.object).hitAudioList.remove(audio);
        } else if (this.mode.compareTo("blocked") == 0) {
            ((TerrainObjectHold)this.object).blockedAudioList.remove(audio);
        } else if (this.mode.compareTo("onHit") == 0) {
            ((TerrainObject)this.object).onHitSounds.remove(audio);
        }
        return audio;
    }

    public ArrayList<HSAudio> removeSoundsFromSoundList(int[] indices) {
        ArrayList<HSAudio> removedSounds = new ArrayList<HSAudio>();
        Arrays.sort(indices, 0, indices.length - 1);
        int i = indices.length - 1;
        while (i >= 0) {
            removedSounds.add(0, this.removeSoundFromSoundList(indices[i]));
            --i;
        }
        return removedSounds;
    }

    public ArrayList<HSAudio> removeSelectedSoundsFromSoundList() {
        int n = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the selected sound(s)?", "Delete Sound(s)", 0);
        if (n == 0) {
            this.unloadSoundData();
            return this.removeSoundsFromSoundList(this.soundList.getSelectedIndices());
        }
        return null;
    }

    private void unloadSoundData() {
        this.loading = true;
        this.soundFile.setText("N/A");
        this.changeSoundButton.setEnabled(false);
        this.delaySpinner.setValue(0);
        this.delaySpinner.setEnabled(false);
        this.exclusiveCheckBox.setEnabled(false);
        this.percentageSpinner.setEnabled(false);
        this.percentageCheckBox.setEnabled(false);
        this.loading = false;
    }

    private void loadSoundData(HSAudio sound) {
        this.loading = true;
        File file = new File(sound.filePath);
        this.soundFile.setText(file.getName());
        this.soundFile.setToolTipText(file.getPath());
        this.changeSoundButton.setEnabled(true);
        this.delaySpinner.setValue(sound.delay);
        this.delaySpinner.setEnabled(true);
        this.exclusiveCheckBox.setSelected(sound.exclusive);
        this.exclusiveCheckBox.setEnabled(true);
        this.percentageSpinner.setValue(sound.percentage);
        if (sound.usePercentage) {
            this.percentageSpinner.setEnabled(true);
        } else {
            this.percentageSpinner.setEnabled(false);
        }
        this.percentageCheckBox.setSelected(sound.usePercentage);
        this.percentageCheckBox.setEnabled(true);
        this.loading = false;
    }

    private void changeSound() {
        int returnVal = EditorWindow.fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File file = EditorWindow.fileChooser.getSelectedFile();
        int index = this.soundList.getSelectedIndex();
        HSAudio sound = this.soundListModel.get(index);
        if (sound != null) {
            sound.filePath = file.getPath();
            this.soundFile.setText(file.getName());
            this.soundFile.setToolTipText(file.getPath());
        }
        this.soundList.repaint();
    }

    private void delayChanged() {
        if (this.loading) {
            return;
        }
        int index = this.soundList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        HSAudio sound = this.soundListModel.get(index);
        if (sound != null) {
            sound.delay = (Integer)this.delaySpinner.getValue();
        }
    }

    private void changeExclusive() {
        if (this.loading) {
            return;
        }
        int index = this.soundList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        HSAudio sound = this.soundListModel.get(index);
        if (sound != null) {
            sound.exclusive = this.exclusiveCheckBox.isSelected();
        }
    }

    private void percentageChanged() {
        if (this.loading) {
            return;
        }
        int index = this.soundList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        HSAudio sound = this.soundListModel.get(index);
        if (sound != null) {
            sound.percentage = (Integer)this.percentageSpinner.getValue();
        }
    }

    private void changeUsePercentage() {
        if (this.loading) {
            return;
        }
        int index = this.soundList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        HSAudio sound = this.soundListModel.get(index);
        if (sound != null) {
            sound.usePercentage = this.percentageCheckBox.isSelected();
        }
        this.percentageSpinner.setEnabled(this.percentageCheckBox.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "addSound": {
                this.addSoundToSoundList();
                break;
            }
            case "removeSounds": {
                this.removeSelectedSoundsFromSoundList();
                break;
            }
            case "changeSound": {
                this.changeSound();
                break;
            }
            case "changeExclusive": {
                this.changeExclusive();
                break;
            }
            case "changeUsePercentage": {
                this.changeUsePercentage();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.unloadSoundData();
            if (this.soundList.getSelectedIndex() >= 0) {
                this.loadSoundData(this.soundList.getSelectedValue());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().getClass().getName().contains("JSpinner")) {
            this.delayChanged();
            this.percentageChanged();
        }
    }
}

