/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows;

import homestrifeeditor.objects.holds.HSObjectHold;
import homestrifeeditor.objects.holds.properties.HSSpawnObject;
import homestrifeeditor.windows.EditorWindow;
import homestrifeeditor.windows.HoldAttributesWindow;
import homestrifeeditor.windows.renderers.SpawnListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SpawnObjectsWindow
extends JFrame
implements ActionListener,
ListSelectionListener,
MouseListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private static int windowWidth = 400;
    private static int windowHeight = 300;
    private HoldAttributesWindow parent;
    private Object object;
    private boolean loading;
    public DefaultListModel<HSSpawnObject> spawnListModel;
    public JList<HSSpawnObject> spawnList;
    private JToolBar spawnListToolBar;
    private JLabel objectFile;
    private JButton changeObjectButton;
    private static String changeObjectTooltip = "<html>Load a sound from the hard drive.</html>";
    private JSpinner delaySpinner;
    private static String delayTooltip = "<html>Which frame of this hold the sound triggers on.</html>";
    private JSpinner numberSpinner;
    private static String numberTooltip = "<html>How many of the object should be spawned.</html>";
    private JCheckBox followParentCheck;
    private static String followParentTooltip = "<html>Whether or not this object should follow the parent's motion.</html>";
    private JCheckBox collideParentCheck;
    private static String collideParentTooltip = "<html>Whether or not this object should collide with its parent.</html>";
    private JSpinner offsetXSpinner;
    private static String offsetXTooltip = "<html>Horizontal spawn location in relation to the parent.</html>";
    private JSpinner offsetYSpinner;
    private static String offsetYTooltip = "<html>Vertical spawn location in relation to the parent.</html>";
    private JSpinner velXSpinner;
    private static String velXTooltip = "<html>Initial horizontal velocity.</html>";
    private JSpinner velYSpinner;
    private static String velYTooltip = "<html>Initial vertical velocity.</html>";
    private JCheckBox useParentPaletteCheck;
    private static String useParentPaletteTooltip = "<html>Change your colors along with your parent's palette</html>";

    public SpawnObjectsWindow(HoldAttributesWindow theParent, Object theObject) {
        this.parent = theParent;
        this.object = theObject;
        this.loading = false;
        this.setTitle("Spawn Objects - " + ((HSObjectHold)this.object).name);
        this.setSize(windowWidth, windowHeight);
        this.setLocationRelativeTo(null);
        this.createWindowContents();
    }

    private void createWindowContents() {
        JLabel spawnListLabel = new JLabel("Object List");
        this.spawnListModel = new DefaultListModel();
        this.spawnList = new JList<HSSpawnObject>(this.spawnListModel);
        this.spawnList.setName("spawnList");
        this.spawnList.setCellRenderer(new SpawnListCellRenderer());
        this.spawnList.addListSelectionListener(this);
        this.spawnList.addMouseListener(this);
        for (HSSpawnObject a : ((HSObjectHold)this.object).spawnObjects) {
            this.spawnListModel.addElement(a);
        }
        JScrollPane spawnListScrollPane = new JScrollPane(this.spawnList);
        JButton addObjectButton = new JButton("+");
        addObjectButton.setActionCommand("addObject");
        addObjectButton.setToolTipText("Add New Object");
        addObjectButton.addActionListener(this);
        JButton removeObjectsButton = new JButton("-");
        removeObjectsButton.setActionCommand("removeObjects");
        removeObjectsButton.setToolTipText("Remove Selected Object(s)");
        removeObjectsButton.addActionListener(this);
        this.spawnListToolBar = new JToolBar();
        this.spawnListToolBar.setFloatable(false);
        this.spawnListToolBar.add(addObjectButton);
        this.spawnListToolBar.add(removeObjectsButton);
        JPanel spawnListPane = new JPanel();
        spawnListPane.setLayout(new BorderLayout());
        spawnListPane.add((Component)spawnListLabel, "First");
        spawnListPane.add((Component)spawnListScrollPane, "Center");
        spawnListPane.add((Component)this.spawnListToolBar, "Last");
        JLabel objectFileLabel = new JLabel("File:");
        this.objectFile = new JLabel("N/A");
        this.changeObjectButton = new JButton("Change Object...");
        this.changeObjectButton.setToolTipText(changeObjectTooltip);
        this.changeObjectButton.setActionCommand("changeObject");
        this.changeObjectButton.setEnabled(false);
        this.changeObjectButton.addActionListener(this);
        JLabel delayLabel = new JLabel("Delay");
        delayLabel.setToolTipText(delayTooltip);
        this.delaySpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99999, 1));
        this.delaySpinner.setToolTipText(delayTooltip);
        this.delaySpinner.setValue(0);
        this.delaySpinner.addChangeListener(this);
        this.delaySpinner.setEnabled(false);
        JLabel numberLabel = new JLabel("Number");
        numberLabel.setToolTipText(numberTooltip);
        this.numberSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99999, 1));
        this.numberSpinner.setToolTipText(numberTooltip);
        this.numberSpinner.setValue(1);
        this.numberSpinner.addChangeListener(this);
        this.numberSpinner.setEnabled(false);
        JLabel offsetXLabel = new JLabel("Offset X");
        offsetXLabel.setToolTipText(offsetXTooltip);
        this.offsetXSpinner = new JSpinner(new SpinnerNumberModel(0.0, -99999.0, 99999.0, 1.0));
        this.offsetXSpinner.setToolTipText(offsetXTooltip);
        this.offsetXSpinner.setValue(0);
        this.offsetXSpinner.addChangeListener(this);
        this.offsetXSpinner.setEnabled(false);
        JLabel offsetYLabel = new JLabel("Offset Y");
        offsetYLabel.setToolTipText(offsetYTooltip);
        this.offsetYSpinner = new JSpinner(new SpinnerNumberModel(0.0, -99999.0, 99999.0, 1.0));
        this.offsetYSpinner.setToolTipText(offsetYTooltip);
        this.offsetYSpinner.setValue(0);
        this.offsetYSpinner.addChangeListener(this);
        this.offsetYSpinner.setEnabled(false);
        JLabel velXLabel = new JLabel("Velocity X");
        velXLabel.setToolTipText(velXTooltip);
        this.velXSpinner = new JSpinner(new SpinnerNumberModel(0.0, -99999.0, 99999.0, 1.0));
        this.velXSpinner.setToolTipText(velXTooltip);
        this.velXSpinner.setValue(0);
        this.velXSpinner.addChangeListener(this);
        this.velXSpinner.setEnabled(false);
        JLabel velYLabel = new JLabel("Velocity Y");
        velYLabel.setToolTipText(velYTooltip);
        this.velYSpinner = new JSpinner(new SpinnerNumberModel(0.0, -99999.0, 99999.0, 1.0));
        this.velYSpinner.setToolTipText(velYTooltip);
        this.velYSpinner.setValue(0);
        this.velYSpinner.addChangeListener(this);
        this.velYSpinner.setEnabled(false);
        this.followParentCheck = new JCheckBox("Follow Parent");
        this.followParentCheck.setToolTipText(followParentTooltip);
        this.followParentCheck.setEnabled(false);
        this.followParentCheck.setActionCommand("changeFollowParent");
        this.followParentCheck.addActionListener(this);
        this.collideParentCheck = new JCheckBox("Collide Parent");
        this.collideParentCheck.setToolTipText(collideParentTooltip);
        this.collideParentCheck.setEnabled(false);
        this.collideParentCheck.setActionCommand("changeCollideParent");
        this.collideParentCheck.addActionListener(this);
        this.useParentPaletteCheck = new JCheckBox("Use Parent Palette");
        this.useParentPaletteCheck.setToolTipText(useParentPaletteTooltip);
        this.useParentPaletteCheck.setEnabled(false);
        this.useParentPaletteCheck.setActionCommand("useParentPalette");
        this.useParentPaletteCheck.addActionListener(this);
        JPanel spawnDataPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        spawnDataPane.add((Component)objectFileLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        spawnDataPane.add((Component)this.objectFile, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.ipady = 20;
        gbc.fill = 2;
        spawnDataPane.add((Component)this.changeObjectButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.ipady = 0;
        gbc.fill = 2;
        spawnDataPane.add((Component)delayLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 2;
        spawnDataPane.add((Component)this.delaySpinner, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.ipady = 0;
        gbc.fill = 2;
        spawnDataPane.add((Component)numberLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.fill = 2;
        spawnDataPane.add((Component)this.numberSpinner, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.ipady = 0;
        gbc.fill = 2;
        spawnDataPane.add((Component)offsetXLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.fill = 2;
        spawnDataPane.add((Component)this.offsetXSpinner, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.ipady = 0;
        gbc.fill = 2;
        spawnDataPane.add((Component)offsetYLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.fill = 2;
        spawnDataPane.add((Component)this.offsetYSpinner, gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.ipady = 0;
        gbc.fill = 2;
        spawnDataPane.add((Component)velXLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.fill = 2;
        spawnDataPane.add((Component)this.velXSpinner, gbc);
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.ipady = 0;
        gbc.fill = 2;
        spawnDataPane.add((Component)velYLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.fill = 2;
        spawnDataPane.add((Component)this.velYSpinner, gbc);
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.fill = 2;
        spawnDataPane.add((Component)this.followParentCheck, gbc);
        gbc.gridx = 1;
        gbc.gridy = 8;
        gbc.gridwidth = 1;
        gbc.ipady = 0;
        gbc.fill = 2;
        spawnDataPane.add((Component)this.collideParentCheck, gbc);
        gbc.gridx = 1;
        gbc.gridy = 9;
        gbc.gridwidth = 1;
        gbc.ipady = 0;
        gbc.fill = 2;
        spawnDataPane.add((Component)this.useParentPaletteCheck, gbc);
        JSplitPane sPane = new JSplitPane(1, spawnListPane, spawnDataPane);
        sPane.setDividerLocation(100);
        this.setContentPane(sPane);
    }

    private void addObjectToSpawnList() {
        int returnVal = EditorWindow.fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File file = EditorWindow.fileChooser.getSelectedFile();
        int index = this.spawnList.getSelectedIndex();
        this.spawnList.clearSelection();
        HSSpawnObject newObject = new HSSpawnObject(file.getPath());
        ((HSObjectHold)this.object).spawnObjects.add(newObject);
        if (index >= 0) {
            this.spawnListModel.add(index, newObject);
            this.spawnList.setSelectedIndex(index);
        } else {
            this.spawnListModel.addElement(newObject);
            this.spawnList.setSelectedIndex(this.spawnListModel.getSize() - 1);
        }
    }

    public HSSpawnObject removeObjectFromSpawnList(int index) {
        HSSpawnObject spawnObject = this.spawnListModel.remove(index);
        ((HSObjectHold)this.object).spawnObjects.remove(spawnObject);
        return spawnObject;
    }

    public ArrayList<HSSpawnObject> removeObjectsFromSpawnList(int[] indices) {
        ArrayList<HSSpawnObject> removedObjects = new ArrayList<HSSpawnObject>();
        Arrays.sort(indices, 0, indices.length - 1);
        int i = indices.length - 1;
        while (i >= 0) {
            removedObjects.add(0, this.removeObjectFromSpawnList(indices[i]));
            --i;
        }
        return removedObjects;
    }

    public ArrayList<HSSpawnObject> removeSelectedObjectsFromSpawnList() {
        int n = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the selected object(s)?", "Delete Object(s)", 0);
        if (n == 0) {
            this.unloadObjectData();
            return this.removeObjectsFromSpawnList(this.spawnList.getSelectedIndices());
        }
        return null;
    }

    private void unloadObjectData() {
        this.loading = true;
        this.objectFile.setText("N/A");
        this.changeObjectButton.setEnabled(false);
        this.delaySpinner.setValue(0);
        this.delaySpinner.setEnabled(false);
        this.numberSpinner.setValue(0);
        this.numberSpinner.setEnabled(false);
        this.offsetXSpinner.setValue(0);
        this.offsetXSpinner.setEnabled(false);
        this.offsetYSpinner.setValue(0);
        this.offsetYSpinner.setEnabled(false);
        this.velXSpinner.setValue(0);
        this.velXSpinner.setEnabled(false);
        this.velYSpinner.setValue(0);
        this.velYSpinner.setEnabled(false);
        this.followParentCheck.setEnabled(false);
        this.collideParentCheck.setEnabled(false);
        this.useParentPaletteCheck.setEnabled(false);
        this.loading = false;
    }

    private void loadObjectData(HSSpawnObject spawnObject) {
        this.loading = true;
        File file = new File(spawnObject.defFilePath);
        this.objectFile.setText(file.getName());
        this.objectFile.setToolTipText(file.getPath());
        this.changeObjectButton.setEnabled(true);
        this.delaySpinner.setValue(spawnObject.delay);
        this.delaySpinner.setEnabled(true);
        this.numberSpinner.setValue(spawnObject.number);
        this.numberSpinner.setEnabled(true);
        this.offsetXSpinner.setValue(Float.valueOf(spawnObject.parentOffset.x));
        this.offsetXSpinner.setEnabled(true);
        this.offsetYSpinner.setValue(Float.valueOf(spawnObject.parentOffset.y));
        this.offsetYSpinner.setEnabled(true);
        this.velXSpinner.setValue(Float.valueOf(spawnObject.vel.x));
        this.velXSpinner.setEnabled(true);
        this.velYSpinner.setValue(Float.valueOf(spawnObject.vel.y));
        this.velYSpinner.setEnabled(true);
        this.followParentCheck.setSelected(spawnObject.followParent);
        this.followParentCheck.setEnabled(true);
        this.collideParentCheck.setSelected(spawnObject.collideParent);
        this.collideParentCheck.setEnabled(true);
        this.useParentPaletteCheck.setSelected(spawnObject.useParentPalette);
        this.useParentPaletteCheck.setEnabled(true);
        this.loading = false;
    }

    private void changeObject() {
        int returnVal = EditorWindow.fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File file = EditorWindow.fileChooser.getSelectedFile();
        int index = this.spawnList.getSelectedIndex();
        HSSpawnObject spawnObject = this.spawnListModel.get(index);
        if (spawnObject != null) {
            spawnObject.defFilePath = file.getPath();
            this.objectFile.setText(file.getName());
            this.objectFile.setToolTipText(file.getPath());
        }
        this.spawnList.repaint();
    }

    private void valueChanged() {
        if (this.loading) {
            return;
        }
        int index = this.spawnList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        HSSpawnObject spawnObject = this.spawnListModel.get(index);
        if (spawnObject != null) {
            spawnObject.delay = ((SpinnerNumberModel)this.delaySpinner.getModel()).getNumber().intValue();
            spawnObject.number = ((SpinnerNumberModel)this.numberSpinner.getModel()).getNumber().intValue();
            spawnObject.parentOffset.x = ((SpinnerNumberModel)this.offsetXSpinner.getModel()).getNumber().floatValue();
            spawnObject.parentOffset.y = ((SpinnerNumberModel)this.offsetYSpinner.getModel()).getNumber().floatValue();
            spawnObject.vel.x = ((SpinnerNumberModel)this.velXSpinner.getModel()).getNumber().floatValue();
            spawnObject.vel.y = ((SpinnerNumberModel)this.velYSpinner.getModel()).getNumber().floatValue();
            spawnObject.followParent = this.followParentCheck.isSelected();
            spawnObject.collideParent = this.collideParentCheck.isSelected();
            spawnObject.useParentPalette = this.useParentPaletteCheck.isSelected();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "addObject": {
                this.addObjectToSpawnList();
                break;
            }
            case "removeObjects": {
                this.removeSelectedObjectsFromSpawnList();
                break;
            }
            case "changeObject": {
                this.changeObject();
                break;
            }
            case "followParentChanged": {
                this.valueChanged();
                break;
            }
            case "collideParentChanged": {
                this.valueChanged();
                break;
            }
            case "useParentPalette": {
                this.valueChanged();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.unloadObjectData();
            if (this.spawnList.getSelectedIndex() >= 0) {
                this.loadObjectData(this.spawnList.getSelectedValue());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().getClass().getName().contains("JSpinner")) {
            this.valueChanged();
        }
        this.parent.fieldChanged();
    }
}

