/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows;

import homestrifeeditor.objects.holds.properties.HSTextureLabel;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TextureAttributesWindow
extends JFrame
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private static int windowWidth = 150;
    private static int windowHeight = 140;
    private static int windowBorderBuffer = 10;
    private static int gridWidth = 650;
    private static int gridRowHeight = 45;
    private static int gridColumns = 2;
    private static int gridHorizontalGap = 10;
    private static int gridVerticalGap = 5;
    private HSTextureLabel textureLabel;
    private JSpinner offsetXSpinner;
    private JSpinner offsetYSpinner;

    public TextureAttributesWindow(HSTextureLabel theTextureLabel) {
        this.textureLabel = theTextureLabel;
        this.setTitle("Hitbox Attributes");
        this.setSize(windowWidth, windowHeight);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.createWindowContents();
    }

    private void createWindowContents() {
        JLabel offsetXLabel = new JLabel("Offset X");
        this.offsetXSpinner = new JSpinner(new SpinnerNumberModel(0, -99999, 99999, 1));
        this.offsetXSpinner.setValue((int)this.textureLabel.texture.offset.x);
        this.offsetXSpinner.addChangeListener(this);
        JLabel offsetYLabel = new JLabel("Offset Y");
        this.offsetYSpinner = new JSpinner(new SpinnerNumberModel(0, -99999, 99999, 1));
        this.offsetYSpinner.setValue((int)this.textureLabel.texture.offset.y);
        this.offsetYSpinner.addChangeListener(this);
        JPanel valueInterface = new JPanel(new GridLayout(2, gridColumns, gridHorizontalGap, gridVerticalGap));
        valueInterface.setSize(gridWidth, gridRowHeight * 2);
        valueInterface.add(offsetXLabel);
        valueInterface.add(this.offsetXSpinner);
        valueInterface.add(offsetYLabel);
        valueInterface.add(this.offsetYSpinner);
        JButton closeButton = new JButton("Close");
        closeButton.setActionCommand("closeButton");
        closeButton.addActionListener(this);
        JPanel buttonPane = new JPanel(new FlowLayout(4));
        buttonPane.add(closeButton);
        JPanel hitboxAttributesPane = new JPanel();
        hitboxAttributesPane.setLayout(new BoxLayout(hitboxAttributesPane, 1));
        hitboxAttributesPane.setBorder(new EmptyBorder(windowBorderBuffer, windowBorderBuffer, windowBorderBuffer, windowBorderBuffer));
        hitboxAttributesPane.add(valueInterface);
        hitboxAttributesPane.add(buttonPane);
        this.add(hitboxAttributesPane);
    }

    private void closeWindow() {
        this.dispose();
    }

    private void fieldChanged() {
        this.textureLabel.texture.offset.x = ((Integer)this.offsetXSpinner.getValue()).intValue();
        this.textureLabel.texture.offset.y = ((Integer)this.offsetYSpinner.getValue()).intValue();
        Point pos = this.textureLabel.parent.parent.getSwingOffset(this.textureLabel.texture.offset.x, this.textureLabel.texture.offset.y);
        this.textureLabel.setBounds(pos.x, pos.y, this.textureLabel.getWidth(), this.textureLabel.getHeight());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "closeButton": {
                this.closeWindow();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fieldChanged();
    }
}

