/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows.panes;

import homestrifeeditor.objects.HSObject;
import homestrifeeditor.objects.holds.FighterHold;
import homestrifeeditor.objects.holds.HSObjectHold;
import homestrifeeditor.objects.holds.PhysicsObjectHold;
import homestrifeeditor.objects.holds.TerrainObjectHold;
import homestrifeeditor.objects.holds.properties.HSBox;
import homestrifeeditor.objects.holds.properties.HSTexture;
import homestrifeeditor.windows.EditorWindow;
import homestrifeeditor.windows.HoldAttributesWindow;
import homestrifeeditor.windows.MassShiftWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class HoldListPane
extends JPanel
implements ActionListener,
TreeSelectionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    public EditorWindow parent;
    public JTree tree;
    public DefaultMutableTreeNode root;
    private JToolBar holdListToolBar;

    public HoldListPane(EditorWindow theParent) {
        this.parent = theParent;
        this.createPaneContents();
    }

    private void createPaneContents() {
        JLabel holdListLabel = new JLabel("Hold List");
        this.root = new DefaultMutableTreeNode("Holds (S - Spawn Object | A - Audio)");
        this.tree = new JTree(this.root);
        this.tree.setName("holdTree");
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setEditable(true);
        this.tree.addTreeSelectionListener(this);
        this.tree.addMouseListener(this);
        JScrollPane holdListScrollPane = new JScrollPane(this.tree);
        JButton addHoldButton = new JButton("+");
        addHoldButton.setActionCommand("addHold");
        addHoldButton.setToolTipText("Create New Hold");
        addHoldButton.addActionListener(this);
        JButton removeHoldsButton = new JButton("-");
        removeHoldsButton.setActionCommand("removeHolds");
        removeHoldsButton.setToolTipText("Delete Selected Hold(s)");
        removeHoldsButton.addActionListener(this);
        JButton moveHoldUpButton = new JButton("/\\");
        moveHoldUpButton.setActionCommand("moveHoldUp");
        moveHoldUpButton.setToolTipText("Move Selected Hold Up");
        moveHoldUpButton.addActionListener(this);
        JButton moveHoldDownButton = new JButton("\\/");
        moveHoldDownButton.setActionCommand("moveHoldDown");
        moveHoldDownButton.setToolTipText("Move Selected Hold Down");
        moveHoldDownButton.addActionListener(this);
        JButton editHoldButton = new JButton("Edit");
        editHoldButton.setActionCommand("editHold");
        editHoldButton.setToolTipText("Edit Hold Attributes");
        editHoldButton.addActionListener(this);
        JButton massShiftHoldButton = new JButton("Mass Shift");
        massShiftHoldButton.setActionCommand("massShift");
        massShiftHoldButton.setToolTipText("Mass Shift Attributes");
        massShiftHoldButton.addActionListener(this);
        this.holdListToolBar = new JToolBar();
        this.holdListToolBar.setFloatable(false);
        this.holdListToolBar.add(addHoldButton);
        this.holdListToolBar.add(removeHoldsButton);
        this.holdListToolBar.add(editHoldButton);
        this.holdListToolBar.add(massShiftHoldButton);
        this.setToolBarEnabled(false);
        this.setLayout(new BorderLayout());
        this.add((Component)holdListLabel, "First");
        this.add((Component)holdListScrollPane, "Center");
        this.add((Component)this.holdListToolBar, "Last");
    }

    public void setToolBarEnabled(boolean enable) {
        Component[] componentArray = this.holdListToolBar.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setEnabled(enable);
            ++n2;
        }
    }

    public TreeNode[] addHoldToTree(HSObjectHold hold) {
        if (hold == null) {
            return null;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(hold);
        try {
            boolean found = false;
            int i = 0;
            while (i < this.root.getChildCount()) {
                Object obj = model.getChild(this.root, i);
                Object userObject = ((DefaultMutableTreeNode)obj).getUserObject();
                if (userObject instanceof String && ((String)userObject).compareTo(hold.getNameOnly()) == 0) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)model.getChild(this.root, i);
                    int j = 1;
                    while (j < child.getChildCount()) {
                        DefaultMutableTreeNode child2 = (DefaultMutableTreeNode)child.getChildAt(j);
                        if (!(child2.getUserObject() instanceof HSObjectHold)) break;
                        HSObjectHold checkAgainst = (HSObjectHold)child2.getUserObject();
                        if (hold.getNumFromName() < checkAgainst.getNumFromName()) {
                            model.insertNodeInto(node, child, j);
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        model.insertNodeInto(node, child, child.getChildCount());
                        found = true;
                    }
                }
                ++i;
            }
            if (!found) {
                DefaultMutableTreeNode ndmtn = new DefaultMutableTreeNode(hold.getNameOnly().length() > 0 ? hold.getNameOnly() : hold.name);
                ndmtn.add(node);
                this.root.add(ndmtn);
            }
        }
        catch (Exception e) {
            this.root.add(node);
        }
        this.reload();
        return node.getPath();
    }

    public void addHoldToHoldList(HSObjectHold hold, int index) {
        this.addHoldToHoldList(hold);
    }

    public void addHoldToHoldList(HSObjectHold hold) {
        this.addHoldToTree(hold);
    }

    public void addHoldToHoldList() {
        HSObjectHold newHold = this.parent.currentlyLoadedObject.IsFighter() ? new FighterHold() : (this.parent.currentlyLoadedObject.IsPhysicsObject() ? new PhysicsObjectHold() : (this.parent.currentlyLoadedObject.IsTerrainObject() ? new TerrainObjectHold() : new HSObjectHold()));
        this.addHoldToHoldList(newHold);
    }

    public void addHoldsToHoldList(ArrayList<HSObjectHold> holds) {
        for (HSObjectHold hold : holds) {
            this.addHoldToHoldList(hold);
        }
    }

    public HSObjectHold removeHoldFromHoldList(TreePath path) {
        HSObjectHold hold = null;
        try {
            hold = (HSObjectHold)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        }
        catch (Exception exc) {
            return null;
        }
        ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent((DefaultMutableTreeNode)path.getLastPathComponent());
        if (((DefaultTreeModel)this.tree.getModel()).getChildCount((DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 2)) == 0) {
            ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent((DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 2));
        }
        this.reload();
        return hold;
    }

    public ArrayList<HSObjectHold> removeHoldsFromHoldList(TreePath[] paths) {
        ArrayList<HSObjectHold> removedHolds = new ArrayList<HSObjectHold>();
        int i = paths.length - 1;
        while (i >= 0) {
            removedHolds.add(0, this.removeHoldFromHoldList(paths[i]));
            --i;
        }
        return removedHolds;
    }

    public ArrayList<HSObjectHold> removeSelectedHoldsFromHoldList() {
        int n = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the selected hold(s)?", "Delete Hold(s)", 0);
        if (this.tree.getSelectionRows().length == 0) {
            return null;
        }
        return n == 0 ? this.removeHoldsFromHoldList(this.tree.getSelectionPaths()) : null;
    }

    public void removeAllHoldsFromList() {
        this.setToolBarEnabled(false);
        this.root.removeAllChildren();
        this.reload();
    }

    public HSObjectHold getCurrentlySelectedHold() {
        return (HSObjectHold)((DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()).getUserObject();
    }

    public ArrayList<HSObjectHold> getAllChildren(DefaultMutableTreeNode node, ArrayList<HSObjectHold> holds) {
        if (holds == null) {
            holds = new ArrayList();
        }
        if (node.getChildCount() == 0) {
            holds.add((HSObjectHold)node.getUserObject());
        } else {
            int i = 0;
            while (i < this.tree.getModel().getChildCount(node)) {
                DefaultMutableTreeNode e = (DefaultMutableTreeNode)this.tree.getModel().getChild(node, i);
                holds = this.getAllChildren(e, holds);
                ++i;
            }
        }
        return holds;
    }

    public ArrayList<HSObjectHold> getAllHolds() {
        return this.getAllChildren(this.root, null);
    }

    public void loadObjectHolds(HSObject currentlyLoadedObject) {
        this.removeAllHoldsFromList();
        if (currentlyLoadedObject == null) {
            return;
        }
        this.setToolBarEnabled(true);
        this.addHoldsToHoldList(currentlyLoadedObject.holds);
    }

    public void applyHoldChanges(HSObjectHold hold, TreePath path) {
    }

    public void createHoldAttributesWindow(HSObjectHold hold, TreePath path) {
        HoldAttributesWindow window = new HoldAttributesWindow(this, hold, path);
        window.setVisible(true);
    }

    public void editHoldButtonPressed() {
        this.createHoldAttributesWindow(this.getCurrentlySelectedHold(), this.tree.getSelectionPath());
    }

    public void massShiftButtonPressed() {
        MassShiftWindow window = new MassShiftWindow(this);
        window.setVisible(true);
    }

    public void massShift(int shiftX, int shiftY) {
        TreePath[] paths;
        TreePath[] treePathArray = paths = this.tree.getSelectionPaths();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            HSObjectHold hold = null;
            try {
                hold = (HSObjectHold)((DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1)).getUserObject();
                for (HSTexture tex : hold.textures) {
                    tex.offset.x += (float)shiftX;
                    tex.offset.y += (float)shiftY;
                }
                if (hold.IsTerrainObjectHold()) {
                    for (HSBox box : ((TerrainObjectHold)hold).attackBoxes) {
                        box.offset.x += (float)shiftX;
                        box.offset.y += (float)shiftY;
                    }
                    for (HSBox box : ((TerrainObjectHold)hold).hurtBoxes) {
                        box.offset.x += (float)shiftX;
                        box.offset.y += (float)shiftY;
                    }
                }
                this.parent.textureHitboxPane.loadHoldData((HSObjectHold)((DefaultMutableTreeNode)this.tree.getSelectionPath().getPathComponent(path.getPathCount() - 1)).getUserObject());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    public void reload() {
        ((DefaultTreeModel)this.tree.getModel()).reload();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "addHold": {
                this.addHoldToHoldList();
                break;
            }
            case "removeHolds": {
                this.removeSelectedHoldsFromHoldList();
                break;
            }
            case "editHold": {
                this.editHoldButtonPressed();
                break;
            }
            case "massShift": {
                this.massShiftButtonPressed();
            }
        }
        if (this.parent.currentlyLoadedObject != null) {
            this.parent.setTitle(String.valueOf(EditorWindow.BaseWindowTitle) + this.parent.currentlyLoadedObject.name + "*");
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null || node.getUserObject() instanceof String) {
            if (this.parent.currentlyLoadedObject != null) {
                this.parent.textureHitboxPane.unloadHoldData();
            }
        } else {
            this.parent.textureHitboxPane.loadHoldData((HSObjectHold)node.getUserObject());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        switch (e.getComponent().getName()) {
            case "holdTree": {
                TreePath path = this.tree.getPathForLocation(e.getPoint().x, e.getPoint().y);
                HSObjectHold hold = null;
                try {
                    hold = (HSObjectHold)((DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1)).getUserObject();
                }
                catch (Exception exc) {
                    break;
                }
                if (hold == null) break;
                this.tree.makeVisible(path);
                this.editHoldButtonPressed();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

