/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows.panes;

import homestrifeeditor.objects.FighterObject;
import homestrifeeditor.objects.TerrainObject;
import homestrifeeditor.objects.holds.TerrainObjectHold;
import homestrifeeditor.objects.holds.properties.HSBox;
import homestrifeeditor.objects.holds.properties.HSBoxLabel;
import homestrifeeditor.objects.holds.properties.HSSpawnObject;
import homestrifeeditor.objects.holds.properties.HSSpawnObjectLabel;
import homestrifeeditor.objects.holds.properties.HSTexture;
import homestrifeeditor.objects.holds.properties.HSTextureLabel;
import homestrifeeditor.windows.EditorWindow;
import homestrifeeditor.windows.panes.TextureHitboxPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;

public class TextureHitboxLayeredPane
extends JLayeredPane
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private static int defaultHitBoxSize = 200;
    public TextureHitboxPane parent;
    public ArrayList<JLabel> selectedItems;
    public boolean showTextures;
    public boolean showTerrainBox;
    public boolean showAttackBoxes;
    public boolean showHurtBoxes;

    public TextureHitboxLayeredPane(TextureHitboxPane theParent) {
        this.parent = theParent;
        this.selectedItems = new ArrayList();
        this.showTextures = true;
        this.showTerrainBox = true;
        this.showAttackBoxes = true;
        this.showHurtBoxes = true;
        this.addMouseListener(this);
    }

    public void unselect(JLabel label) {
        if (label.getName().compareTo("texture") == 0) {
            label.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        } else if (label.getName().compareTo("terrain") == 0) {
            ((HSBoxLabel)label).setAsTerrainBox();
        } else if (label.getName().compareTo("attack") == 0) {
            ((HSBoxLabel)label).setAsAttackBox();
        } else if (label.getName().compareTo("hurt") == 0) {
            ((HSBoxLabel)label).setAsHurtBox();
        }
        this.selectedItems.remove(label);
        this.parent.updateLockButton();
        this.repaint();
    }

    public void unselectAll() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.getName().compareTo("texture") == 0) {
                ((JLabel)c).setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            } else if (c.getName().compareTo("terrain") == 0) {
                ((HSBoxLabel)c).setAsTerrainBox();
            } else if (c.getName().compareTo("attack") == 0) {
                ((HSBoxLabel)c).setAsAttackBox();
            } else if (c.getName().compareTo("hurt") == 0) {
                ((HSBoxLabel)c).setAsHurtBox();
            }
            ++n2;
        }
        this.selectedItems.clear();
        this.parent.updateLockButton();
        this.repaint();
    }

    public void setSelected(JLabel selectedLabel, boolean multiSelect) {
        if (!selectedLabel.isVisible()) {
            return;
        }
        if (!multiSelect) {
            this.unselectAll();
        }
        this.selectedItems.add(selectedLabel);
        selectedLabel.setBorder(BorderFactory.createDashedBorder(Color.BLACK));
        this.parent.updateLockButton();
        this.repaint();
    }

    public void selectAll() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.getName().compareTo("texture") == 0 || c.getName().compareTo("terrain") == 0 || c.getName().compareTo("attack") == 0 || c.getName().compareTo("hurt") == 0) {
                this.setSelected((JLabel)c, true);
            }
            ++n2;
        }
    }

    public void clearTerrainBox() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.getName().compareTo("terrain") == 0) {
                this.remove(c);
            }
            ++n2;
        }
        this.repaint();
    }

    public void setTerrainBox() {
        this.clearTerrainBox();
        if (this.parent.parent.currentlyLoadedObject != null && !this.parent.parent.currentlyLoadedObject.IsTerrainObject()) {
            return;
        }
        for (HSBox tBos : ((TerrainObject)this.parent.parent.currentlyLoadedObject).terrainBoxes) {
            HSBoxLabel terrainBoxLabel = new HSBoxLabel(this, tBos);
            terrainBoxLabel.setAsTerrainBox();
            terrainBoxLabel.setVisible(this.showTerrainBox);
            this.add(terrainBoxLabel);
        }
        this.repaint();
    }

    public void setUprightTerrainBox() {
        this.clearTerrainBox();
        if (this.parent.parent.currentlyLoadedObject != null && !this.parent.parent.currentlyLoadedObject.IsFighter()) {
            this.setTerrainBox();
        }
        HSBoxLabel terrainBoxLabel = new HSBoxLabel(this, ((FighterObject)this.parent.parent.currentlyLoadedObject).uprightTerrainBoxes.get(0));
        terrainBoxLabel.setAsTerrainBox();
        terrainBoxLabel.setVisible(this.showTerrainBox);
        this.add(terrainBoxLabel);
        this.repaint();
    }

    public void setCrouchingTerrainBox() {
        this.clearTerrainBox();
        if (this.parent.parent.currentlyLoadedObject != null && !this.parent.parent.currentlyLoadedObject.IsFighter()) {
            this.setTerrainBox();
        }
        HSBoxLabel terrainBoxLabel = new HSBoxLabel(this, ((FighterObject)this.parent.parent.currentlyLoadedObject).crouchingTerrainBoxes.get(0));
        terrainBoxLabel.setAsTerrainBox();
        terrainBoxLabel.setVisible(this.showTerrainBox);
        this.add(terrainBoxLabel);
        this.repaint();
    }

    public void setProneTerrainBox() {
        this.clearTerrainBox();
        if (this.parent.parent.currentlyLoadedObject != null && !this.parent.parent.currentlyLoadedObject.IsFighter()) {
            this.setTerrainBox();
        }
        HSBoxLabel terrainBoxLabel = new HSBoxLabel(this, ((FighterObject)this.parent.parent.currentlyLoadedObject).proneTerrainBoxes.get(0));
        terrainBoxLabel.setAsTerrainBox();
        terrainBoxLabel.setVisible(this.showTerrainBox);
        this.add(terrainBoxLabel);
        this.repaint();
    }

    public void setCompactTerrainBox() {
        this.clearTerrainBox();
        if (this.parent.parent.currentlyLoadedObject != null && !this.parent.parent.currentlyLoadedObject.IsFighter()) {
            this.setTerrainBox();
        }
        HSBoxLabel terrainBoxLabel = new HSBoxLabel(this, ((FighterObject)this.parent.parent.currentlyLoadedObject).compactTerrainBoxes.get(0));
        terrainBoxLabel.setAsTerrainBox();
        terrainBoxLabel.setVisible(this.showTerrainBox);
        this.add(terrainBoxLabel);
        this.repaint();
    }

    public void moveAllTextureDepthsDown() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.getName().compareTo("texture") == 0) {
                --((HSTextureLabel)c).texture.depth;
                this.setLayer(c, ((HSTextureLabel)c).texture.depth);
            }
            ++n2;
        }
    }

    public void addTexture(HSTexture tex) {
        this.addTexture(tex, true);
    }

    public void addTexture(HSTexture tex, boolean addToHold) {
        HSTextureLabel texLabel = new HSTextureLabel(this, tex);
        if (texLabel.getIcon() == null) {
            return;
        }
        texLabel.setVisible(this.showTextures);
        this.add((Component)texLabel, new Integer(tex.depth));
        if (addToHold) {
            this.parent.hold.textures.add(tex);
        }
        this.setSelected(texLabel, false);
    }

    public void addTexture(String path) {
        HSTexture newTex = new HSTexture(path);
        this.moveAllTextureDepthsDown();
        newTex.depth = 0;
        newTex.offset.x = 0.0f;
        newTex.offset.y = 0.0f;
        this.addTexture(newTex);
    }

    public void addTexture() {
        int returnVal = EditorWindow.fileChooser.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        File file = EditorWindow.fileChooser.getSelectedFile();
        this.addTexture(file.getPath());
    }

    public void addTerrainBox(HSBox box) {
        this.addTerrainBox(box, true);
    }

    public void addTerrainBox(HSBox box, boolean addToHold) {
        HSBoxLabel boxLabel = new HSBoxLabel(this, box);
        boxLabel.setAsTerrainBox();
        boxLabel.setVisible(this.showTerrainBox);
        this.add((Component)boxLabel, new Integer(box.depth));
        if (addToHold) {
            ((TerrainObject)this.parent.parent.currentlyLoadedObject).terrainBoxes.add(box);
        }
        this.setSelected(boxLabel, false);
    }

    public void addAttackBox(HSBox box) {
        this.addAttackBox(box, true);
    }

    public void addAttackBox(HSBox box, boolean addToHold) {
        HSBoxLabel boxLabel = new HSBoxLabel(this, box);
        boxLabel.setAsAttackBox();
        boxLabel.setVisible(this.showAttackBoxes);
        this.add((Component)boxLabel, new Integer(box.depth));
        if (addToHold) {
            ((TerrainObjectHold)this.parent.hold).attackBoxes.add(box);
        }
        this.setSelected(boxLabel, false);
    }

    public void addTerrainBox() {
        if (!this.parent.hold.IsTerrainObjectHold() || this.parent.hold.IsFighterHold() || this.parent.hold.IsPhysicsObjectHold()) {
            return;
        }
        HSBox newBox = new HSBox();
        newBox.depth = this.highestLayer() + 1;
        newBox.width = defaultHitBoxSize;
        newBox.height = defaultHitBoxSize;
        newBox.offset.x = 0.0f;
        newBox.offset.y = 0.0f;
        this.addTerrainBox(newBox);
    }

    public void addAttackBox() {
        if (!this.parent.hold.IsTerrainObjectHold()) {
            return;
        }
        HSBox newBox = new HSBox();
        newBox.depth = this.highestLayer() + 1;
        newBox.width = defaultHitBoxSize;
        newBox.height = defaultHitBoxSize;
        newBox.offset.x = 0.0f;
        newBox.offset.y = 0.0f;
        this.addAttackBox(newBox);
    }

    public void addHurtBox(HSBox box) {
        this.addHurtBox(box, true);
    }

    public void addHurtBox(HSBox box, boolean addToHold) {
        HSBoxLabel boxLabel = new HSBoxLabel(this, box);
        boxLabel.setAsHurtBox();
        boxLabel.setVisible(this.showHurtBoxes);
        this.add((Component)boxLabel, new Integer(box.depth));
        if (addToHold) {
            ((TerrainObjectHold)this.parent.hold).hurtBoxes.add(box);
        }
        this.setSelected(boxLabel, false);
    }

    public void addHurtBox() {
        if (!this.parent.hold.IsTerrainObjectHold()) {
            return;
        }
        HSBox newBox = new HSBox();
        newBox.depth = this.highestLayer() + 1;
        newBox.width = defaultHitBoxSize;
        newBox.height = defaultHitBoxSize;
        newBox.offset.x = 0.0f;
        newBox.offset.y = 0.0f;
        this.addHurtBox(newBox);
    }

    public void addSpawnObject(HSSpawnObject spawn) {
        HSSpawnObjectLabel spawnLabel = new HSSpawnObjectLabel(this, spawn);
        this.add(spawnLabel);
    }

    public void removeSelectedItems() {
        ArrayList<JLabel> removedItems = new ArrayList<JLabel>();
        for (JLabel selectedItem : this.selectedItems) {
            if (selectedItem.getName().compareTo("texture") == 0) {
                this.parent.hold.textures.remove(((HSTextureLabel)selectedItem).texture);
            } else if (selectedItem.getName().compareTo("attack") == 0) {
                ((TerrainObjectHold)this.parent.hold).attackBoxes.remove(((HSBoxLabel)selectedItem).box);
            } else if (selectedItem.getName().compareTo("hurt") == 0) {
                ((TerrainObjectHold)this.parent.hold).hurtBoxes.remove(((HSBoxLabel)selectedItem).box);
            } else {
                return;
            }
            this.remove(selectedItem);
            removedItems.add(selectedItem);
        }
        this.selectedItems.removeAll(removedItems);
        this.repaint();
    }

    public void editSelectedItem() {
        if (this.selectedItems.isEmpty()) {
            return;
        }
        if (this.selectedItems.get(0).getName().compareTo("texture") == 0) {
            ((HSTextureLabel)this.selectedItems.get(0)).createTextureAttributesWindow();
        } else if (this.selectedItems.get(0).getName().compareTo("attack") == 0 || this.selectedItems.get(0).getName().compareTo("hurt") == 0) {
            ((HSBoxLabel)this.selectedItems.get(0)).createHitboxAttributesWindow();
        }
    }

    public void showHideTextures() {
        this.showTextures = !this.showTextures;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.getName().compareTo("texture") == 0) {
                c.setVisible(this.showTextures);
                this.unselect((JLabel)c);
            }
            ++n2;
        }
        this.repaint();
    }

    public void showHideTerrainBox() {
        this.showTerrainBox = !this.showTerrainBox;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.getName().compareTo("terrain") == 0) {
                c.setVisible(this.showTerrainBox);
                this.unselect((JLabel)c);
            }
            ++n2;
        }
        this.repaint();
    }

    public void showHideAttackBoxes() {
        this.showAttackBoxes = !this.showAttackBoxes;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.getName().compareTo("attack") == 0) {
                c.setVisible(this.showAttackBoxes);
                this.unselect((JLabel)c);
            }
            ++n2;
        }
        this.repaint();
    }

    public void showHideHurtBoxes() {
        this.showHurtBoxes = !this.showHurtBoxes;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.getName().compareTo("hurt") == 0) {
                c.setVisible(this.showHurtBoxes);
                this.unselect((JLabel)c);
            }
            ++n2;
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
        g.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() != 2 && e.getClickCount() == 1) {
            this.unselectAll();
        }
        if (this.parent.parent.currentlyLoadedObject != null) {
            this.parent.parent.setTitle(String.valueOf(EditorWindow.BaseWindowTitle) + this.parent.parent.currentlyLoadedObject.name + "*");
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    public void undo() {
    }

    public void redo() {
    }

    public void cut() {
        this.copy();
        this.removeSelectedItems();
    }

    public void copy() {
        this.parent.clipboard = new ArrayList();
        for (JLabel c : this.selectedItems) {
            if (c.getName().compareTo("texture") == 0) {
                this.parent.clipboard.add(new HSTextureLabel((HSTextureLabel)c));
                continue;
            }
            if (c.getName().compareTo("terrain") == 0) continue;
            if (c.getName().compareTo("attack") == 0) {
                this.parent.clipboard.add(new HSBoxLabel((HSBoxLabel)c));
                continue;
            }
            if (c.getName().compareTo("hurt") != 0) continue;
            this.parent.clipboard.add(new HSBoxLabel((HSBoxLabel)c));
        }
    }

    public void paste() {
        for (Component component : this.parent.clipboard) {
            if (component.getName().compareTo("texture") == 0) {
                this.addTexture(new HSTexture(((HSTextureLabel)component).texture));
                continue;
            }
            if (component.getName().compareTo("terrain") == 0) continue;
            if (component.getName().compareTo("attack") == 0) {
                this.addAttackBox(new HSBox(((HSBoxLabel)component).box));
                continue;
            }
            if (component.getName().compareTo("hurt") != 0) continue;
            this.addHurtBox(new HSBox(((HSBoxLabel)component).box));
        }
    }
}

