/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows.panes;

import homestrifeeditor.objects.holds.HSObjectHold;
import homestrifeeditor.objects.holds.TerrainObjectHold;
import homestrifeeditor.objects.holds.properties.HSBox;
import homestrifeeditor.objects.holds.properties.HSBoxLabel;
import homestrifeeditor.objects.holds.properties.HSSpawnObject;
import homestrifeeditor.objects.holds.properties.HSTexture;
import homestrifeeditor.objects.holds.properties.HSTextureLabel;
import homestrifeeditor.objects.holds.properties.HSVect2D;
import homestrifeeditor.windows.EditorWindow;
import homestrifeeditor.windows.panes.TextureHitboxLayeredPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class TextureHitboxPane
extends JPanel
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    public static int textureHitboxPaneWidth = 15360;
    public static int textureHitboxPaneHeight = 8640;
    public EditorWindow parent;
    public HSObjectHold hold;
    public TextureHitboxLayeredPane textureHitboxPane;
    public JScrollPane textureHitboxScrollPane;
    private JToolBar textureHitboxToolBar;
    private JLabel terrainBoxLabel;
    private JComboBox<?> terrainBoxCombo;
    private JButton addTerrainBoxButton;
    private JButton addAttackBoxButton;
    private JButton addHurtBoxButton;
    public JButton removeButton;
    private JButton showHideTexturesButton;
    private JButton showHideTerrainBoxButton;
    private JButton showHideAttackBoxesButton;
    private JButton showHideHurtBoxesButton;
    private JButton lockBoxButton;
    public ArrayList<JLabel> clipboard;

    public TextureHitboxPane(EditorWindow theParent) {
        this.parent = theParent;
        this.hold = null;
        this.clipboard = new ArrayList();
        this.createPaneContents();
    }

    private void createPaneContents() {
        JLabel textureHitboxLabel = new JLabel("Textures and Hitboxes");
        this.textureHitboxPane = new TextureHitboxLayeredPane(this);
        this.textureHitboxPane.setOpaque(true);
        this.textureHitboxPane.setBackground(Color.magenta);
        this.textureHitboxPane.setPreferredSize(new Dimension(textureHitboxPaneWidth, textureHitboxPaneHeight));
        this.textureHitboxScrollPane = new JScrollPane(this.textureHitboxPane, 22, 32);
        this.textureHitboxScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.terrainBoxLabel = new JLabel("Ter Box: ");
        String[] terrainBoxOptions = new String[]{"Upright", "Crouching", "Prone", "Compact"};
        this.terrainBoxCombo = new JComboBox<String>(terrainBoxOptions);
        this.terrainBoxCombo.addItemListener(this);
        this.terrainBoxCombo.setName("terrainBoxCombo");
        JPanel terrainBoxPanel = new JPanel();
        terrainBoxPanel.setLayout(new BoxLayout(terrainBoxPanel, 0));
        terrainBoxPanel.add(this.terrainBoxLabel);
        terrainBoxPanel.add(this.terrainBoxCombo);
        JButton addTextureButton = new JButton("+Tex");
        addTextureButton.setActionCommand("addTexture");
        addTextureButton.setToolTipText("Create New Texture");
        addTextureButton.addActionListener(this);
        this.addTerrainBoxButton = new JButton("+Trn");
        this.addTerrainBoxButton.setActionCommand("addTerrainBox");
        this.addTerrainBoxButton.setToolTipText("Create New Terrain Box (Terrain Objects Only)");
        this.addTerrainBoxButton.addActionListener(this);
        this.addAttackBoxButton = new JButton("+Atk");
        this.addAttackBoxButton.setActionCommand("addAttackBox");
        this.addAttackBoxButton.setToolTipText("Create New Attack Hitbox");
        this.addAttackBoxButton.addActionListener(this);
        this.addHurtBoxButton = new JButton("+Hrt");
        this.addHurtBoxButton.setActionCommand("addHurtBox");
        this.addHurtBoxButton.setToolTipText("Create New Hurt Hitbox");
        this.addHurtBoxButton.addActionListener(this);
        this.removeButton = new JButton("-");
        this.removeButton.setActionCommand("remove");
        this.removeButton.setToolTipText("Delete Selected Texture(s) or Hitbox(es)");
        this.removeButton.addActionListener(this);
        JButton editButton = new JButton("Edit");
        editButton.setActionCommand("edit");
        editButton.setToolTipText("Edit Texture or Hitbox Attributes");
        editButton.addActionListener(this);
        this.showHideTexturesButton = new JButton("HideTex");
        this.showHideTexturesButton.setActionCommand("showHideTex");
        this.showHideTexturesButton.setToolTipText("Show/Hide Textures");
        this.showHideTexturesButton.addActionListener(this);
        this.showHideTerrainBoxButton = new JButton("HideTer");
        this.showHideTerrainBoxButton.setActionCommand("showHideTer");
        this.showHideTerrainBoxButton.setToolTipText("Show/Hide Terrain Box");
        this.showHideTerrainBoxButton.addActionListener(this);
        this.showHideAttackBoxesButton = new JButton("HideAtk");
        this.showHideAttackBoxesButton.setActionCommand("showHideAtk");
        this.showHideAttackBoxesButton.setToolTipText("Show/Hide Attack Boxes");
        this.showHideAttackBoxesButton.addActionListener(this);
        this.showHideHurtBoxesButton = new JButton("HideHrt");
        this.showHideHurtBoxesButton.setActionCommand("showHideHrt");
        this.showHideHurtBoxesButton.setToolTipText("Show/Hide Hurt Boxes");
        this.showHideHurtBoxesButton.addActionListener(this);
        this.lockBoxButton = new JButton("Lock");
        this.lockBoxButton.setActionCommand("lock");
        this.lockBoxButton.setToolTipText("Lock/Unlock selected boxes");
        this.lockBoxButton.addActionListener(this);
        this.textureHitboxToolBar = new JToolBar();
        this.textureHitboxToolBar.setFloatable(false);
        this.textureHitboxToolBar.add(addTextureButton);
        this.textureHitboxToolBar.add(this.addTerrainBoxButton);
        this.textureHitboxToolBar.add(this.addAttackBoxButton);
        this.textureHitboxToolBar.add(this.addHurtBoxButton);
        this.textureHitboxToolBar.add(this.removeButton);
        this.textureHitboxToolBar.add(editButton);
        this.textureHitboxToolBar.add(this.showHideTexturesButton);
        this.textureHitboxToolBar.add(this.showHideTerrainBoxButton);
        this.textureHitboxToolBar.add(this.showHideAttackBoxesButton);
        this.textureHitboxToolBar.add(this.showHideHurtBoxesButton);
        this.textureHitboxToolBar.add(this.lockBoxButton);
        JPanel textureHitboxToolPane = new JPanel(new BorderLayout());
        textureHitboxToolPane.add((Component)terrainBoxPanel, "Before");
        textureHitboxToolPane.add((Component)this.textureHitboxToolBar, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)textureHitboxLabel, "First");
        this.add((Component)this.textureHitboxScrollPane, "Center");
        this.add((Component)textureHitboxToolPane, "Last");
        this.setAllEnabled(false);
    }

    public HSVect2D getHSOffset(int x, int y) {
        HSVect2D point = new HSVect2D();
        point.x = x - textureHitboxPaneWidth / 2;
        point.y = y - textureHitboxPaneHeight / 2;
        return point;
    }

    public Point getSwingOffset(float x, float y) {
        Point point = new Point(textureHitboxPaneWidth / 2 + (int)x, textureHitboxPaneHeight / 2 + (int)y);
        return point;
    }

    public void setAllEnabled(boolean enable) {
        Component c;
        Component[] componentArray = this.textureHitboxScrollPane.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = componentArray[n2];
            c.setEnabled(enable);
            ++n2;
        }
        this.textureHitboxScrollPane.setEnabled(enable);
        componentArray = this.textureHitboxToolBar.getComponents();
        n = componentArray.length;
        n2 = 0;
        while (n2 < n) {
            c = componentArray[n2];
            c.setEnabled(enable);
            if (!(this.parent.currentlyLoadedObject == null || this.parent.currentlyLoadedObject.IsTerrainObject() || c != this.addAttackBoxButton && c != this.addHurtBoxButton && c != this.showHideTerrainBoxButton && c != this.showHideAttackBoxesButton && c != this.showHideHurtBoxesButton)) {
                c.setEnabled(false);
            }
            if (this.parent.currentlyLoadedObject != null && (!this.parent.currentlyLoadedObject.IsTerrainObject() || this.parent.currentlyLoadedObject.IsFighter() || this.parent.currentlyLoadedObject.IsPhysicsObject()) && c == this.addTerrainBoxButton) {
                c.setEnabled(false);
            }
            ++n2;
        }
        this.textureHitboxToolBar.setEnabled(enable);
        this.terrainBoxLabel.setEnabled(enable);
        this.terrainBoxCombo.setEnabled(enable);
        if (this.parent.currentlyLoadedObject != null && !this.parent.currentlyLoadedObject.IsFighter()) {
            this.terrainBoxLabel.setEnabled(false);
            this.terrainBoxCombo.setEnabled(false);
        }
    }

    public void resetScrollBars() {
        this.textureHitboxScrollPane.revalidate();
        float horMin = this.textureHitboxScrollPane.getHorizontalScrollBar().getMinimum();
        float horMax = this.textureHitboxScrollPane.getHorizontalScrollBar().getMaximum();
        float horMid = (horMax - horMin) / 2.0f - (float)(this.textureHitboxScrollPane.getWidth() / 2);
        float verMin = this.textureHitboxScrollPane.getVerticalScrollBar().getMinimum();
        float verMax = this.textureHitboxScrollPane.getVerticalScrollBar().getMaximum();
        float verMid = (verMax - verMin) / 2.0f - (float)this.textureHitboxScrollPane.getHeight();
        this.textureHitboxScrollPane.getHorizontalScrollBar().setValue((int)horMid);
        this.textureHitboxScrollPane.getVerticalScrollBar().setValue((int)verMid);
    }

    public void loadHoldData(HSObjectHold theHold) {
        this.unloadHoldData();
        this.hold = theHold;
        for (HSTexture tex : this.hold.textures) {
            this.textureHitboxPane.addTexture(tex, false);
        }
        if (this.hold.IsTerrainObjectHold()) {
            TerrainObjectHold toHold = (TerrainObjectHold)this.hold;
            for (HSBox box : toHold.attackBoxes) {
                this.textureHitboxPane.addAttackBox(box, false);
            }
            for (HSBox box : toHold.hurtBoxes) {
                this.textureHitboxPane.addHurtBox(box, false);
            }
        }
        for (HSSpawnObject spawn : this.hold.spawnObjects) {
            this.textureHitboxPane.addSpawnObject(spawn);
        }
        this.setAllEnabled(true);
        this.updateLockButton();
    }

    public void unloadHoldData() {
        this.hold = null;
        this.textureHitboxPane.removeAll();
        this.textureHitboxPane.repaint();
        this.setCorrectTerrainBox();
        this.setAllEnabled(false);
    }

    public void reloadTextures() {
        Component[] componentArray = this.textureHitboxPane.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.getName().compareTo("texture") == 0) {
                ((HSTextureLabel)c).loadIcon();
            }
            ++n2;
        }
    }

    private void showHideTexturesButtonClicked() {
        this.textureHitboxPane.showHideTextures();
        this.showHideTexturesButton.setText(this.textureHitboxPane.showTextures ? "HideTex" : "ShowTex");
    }

    private void showHideTerrainBoxButtonClicked() {
        this.textureHitboxPane.showHideTerrainBox();
        this.showHideTerrainBoxButton.setText(this.textureHitboxPane.showTerrainBox ? "HideTer" : "ShowTer");
    }

    private void showHideAttackBoxesButtonClicked() {
        this.textureHitboxPane.showHideAttackBoxes();
        this.showHideAttackBoxesButton.setText(this.textureHitboxPane.showAttackBoxes ? "HideAtk" : "ShowAtk");
    }

    private void showHideHurtBoxesButtonclicked() {
        this.textureHitboxPane.showHideHurtBoxes();
        this.showHideHurtBoxesButton.setText(this.textureHitboxPane.showHurtBoxes ? "HideHrt" : "ShowHrt");
    }

    public void updateLockButton() {
        boolean allSame = true;
        String newLabel = "";
        Boolean lastLocked = null;
        for (JLabel jl : this.textureHitboxPane.selectedItems) {
            if (jl.getName().compareTo("terrain") != 0 && jl.getName().compareTo("attack") != 0 && jl.getName().compareTo("hurt") != 0 && jl.getName().compareTo("texture") != 0) continue;
            if (jl.getName().compareTo("texture") == 0) {
                lastLocked = ((HSTextureLabel)jl).locked;
                break;
            }
            lastLocked = ((HSBoxLabel)jl).locked;
            break;
        }
        if (lastLocked == null) {
            this.lockBoxButton.setEnabled(false);
            return;
        }
        this.lockBoxButton.setEnabled(true);
        for (JLabel jl : this.textureHitboxPane.selectedItems) {
            boolean isLocked;
            if (jl.getName().compareTo("terrain") != 0 && jl.getName().compareTo("attack") != 0 && jl.getName().compareTo("hurt") != 0 && jl.getName().compareTo("texture") != 0) continue;
            if (jl.getName().compareTo("texture") == 0) {
                isLocked = ((HSTextureLabel)jl).locked;
                if (isLocked != lastLocked) {
                    allSame = false;
                }
                lastLocked = isLocked;
                continue;
            }
            isLocked = ((HSBoxLabel)jl).locked;
            if (isLocked != lastLocked) {
                allSame = false;
            }
            lastLocked = isLocked;
        }
        if (!allSame) {
            newLabel = "(Un)Lock";
        } else if (lastLocked.booleanValue()) {
            newLabel = "Unlock";
        } else if (!lastLocked.booleanValue()) {
            newLabel = "Lock";
        }
        this.lockBoxButton.setText(newLabel);
    }

    private void lockedButtonClicked() {
        boolean allSame = true;
        String newLabel = "";
        boolean lastLocked = false;
        boolean noBoxes = true;
        for (JLabel jl : this.textureHitboxPane.selectedItems) {
            if (jl.getName().compareTo("terrain") != 0 && jl.getName().compareTo("attack") != 0 && jl.getName().compareTo("hurt") != 0 && jl.getName().compareTo("texture") != 0) continue;
            if (jl.getName().compareTo("texture") == 0) {
                lastLocked = ((HSTextureLabel)jl).locked;
                noBoxes = false;
                break;
            }
            lastLocked = ((HSBoxLabel)jl).locked;
            noBoxes = false;
            break;
        }
        if (noBoxes) {
            return;
        }
        for (JLabel jl : this.textureHitboxPane.selectedItems) {
            boolean isLocked;
            if (jl.getName().compareTo("terrain") != 0 && jl.getName().compareTo("attack") != 0 && jl.getName().compareTo("hurt") != 0 && jl.getName().compareTo("texture") != 0) continue;
            if (jl.getName().compareTo("texture") == 0) {
                isLocked = ((HSTextureLabel)jl).locked;
                if (isLocked != lastLocked) {
                    allSame = false;
                }
                ((HSTextureLabel)jl).locked = !isLocked;
                lastLocked = isLocked;
                continue;
            }
            isLocked = ((HSBoxLabel)jl).locked;
            if (isLocked != lastLocked) {
                allSame = false;
            }
            ((HSBoxLabel)jl).locked = !isLocked;
            lastLocked = isLocked;
            ((HSBoxLabel)jl).updateColor();
            this.repaint();
        }
        boolean bl = lastLocked = !lastLocked;
        if (!allSame) {
            newLabel = "(Un)Lock";
        } else if (lastLocked) {
            newLabel = "Unlock";
        } else if (!lastLocked) {
            newLabel = "Lock";
        }
        this.lockBoxButton.setText(newLabel);
    }

    public void setCorrectTerrainBox() {
        if (this.parent.currentlyLoadedObject.IsFighter()) {
            int index = this.terrainBoxCombo.getSelectedIndex();
            switch (index) {
                case 0: {
                    this.textureHitboxPane.setUprightTerrainBox();
                    break;
                }
                case 1: {
                    this.textureHitboxPane.setCrouchingTerrainBox();
                    break;
                }
                case 2: {
                    this.textureHitboxPane.setProneTerrainBox();
                    break;
                }
                case 3: {
                    this.textureHitboxPane.setCompactTerrainBox();
                }
            }
        } else if (this.parent.currentlyLoadedObject.IsTerrainObject()) {
            this.textureHitboxPane.setTerrainBox();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "addTexture": {
                this.textureHitboxPane.addTexture();
                break;
            }
            case "addTerrainBox": {
                this.textureHitboxPane.addTerrainBox();
                break;
            }
            case "addAttackBox": {
                this.textureHitboxPane.addAttackBox();
                break;
            }
            case "addHurtBox": {
                this.textureHitboxPane.addHurtBox();
                break;
            }
            case "remove": {
                this.textureHitboxPane.removeSelectedItems();
                break;
            }
            case "edit": {
                this.textureHitboxPane.editSelectedItem();
                break;
            }
            case "showHideTex": {
                this.showHideTexturesButtonClicked();
                break;
            }
            case "showHideTer": {
                this.showHideTerrainBoxButtonClicked();
                break;
            }
            case "showHideAtk": {
                this.showHideAttackBoxesButtonClicked();
                break;
            }
            case "showHideHrt": {
                this.showHideHurtBoxesButtonclicked();
                break;
            }
            case "lock": {
                this.lockedButtonClicked();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (((Component)e.getSource()).getName().compareTo("terrainBoxCombo") == 0) {
            this.setCorrectTerrainBox();
        }
    }

    public void undo() {
        this.textureHitboxPane.undo();
    }

    public void redo() {
        this.textureHitboxPane.redo();
    }

    public void cut() {
        this.textureHitboxPane.cut();
    }

    public void copy() {
        this.textureHitboxPane.copy();
    }

    public void paste() {
        this.textureHitboxPane.paste();
    }
}

