/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor;

import homestrifeeditor.HSVect2D;
import homestrifeeditor.windows.EditorWindow;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HSObject {
    public String name = "HSObject";
    public String texturePath = "";
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;
    public String defPath = "";
    public HSVect2D pos = new HSVect2D();
    public double depth = 0.0;

    public HSObject() {
    }

    public HSObject(HSObject o) {
        this.name = new String(o.name);
        this.texturePath = new String(o.texturePath);
        this.defPath = new String(o.defPath);
        this.pos = new HSVect2D(o.pos);
        this.depth = o.depth;
    }

    public String toString() {
        return "HSObject at position (" + this.pos.x + ", " + this.pos.y + ") at depth=" + this.depth + " with texture at " + this.texturePath;
    }

    public static HSObject ObjectFromDefinition(File def, EditorWindow window) {
        Document doc;
        float offsetY;
        float offsetX;
        String texPath;
        HSObject hsobject;
        block7: {
            hsobject = new HSObject();
            hsobject.defPath = def.getPath();
            texPath = "";
            offsetX = 0.0f;
            offsetY = 0.0f;
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(def);
            doc.getDocumentElement().normalize();
            if (doc.getDocumentElement().getNodeName().compareTo("HSObjects") == 0) break block7;
            JOptionPane.showMessageDialog(null, "Root node of Object is not 'HSObjects'", "Error", 0);
            return null;
        }
        try {
            NodeList textureList = doc.getElementsByTagName("Texture");
            int i = 0;
            while (i < textureList.getLength()) {
                NamedNodeMap textureAttr;
                Node n = textureList.item(i);
                if (n.getNodeType() == 1 && (textureAttr = n.getAttributes()).getNamedItem("textureFilePath") != null) {
                    texPath = window.createAbsolutePathFrom(textureAttr.getNamedItem("textureFilePath").getNodeValue(), window.exeDirectory);
                    offsetX = Float.parseFloat(textureAttr.getNamedItem("offsetX").getNodeValue());
                    offsetY = Float.parseFloat(textureAttr.getNamedItem("offsetY").getNodeValue());
                    break;
                }
                ++i;
            }
            hsobject.texturePath = texPath;
            hsobject.offsetX = offsetX;
            hsobject.offsetY = offsetY;
            hsobject.name = def.getName();
            hsobject.pos = new HSVect2D(0.0f, 0.0f);
        }
        catch (ParserConfigurationException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Parser Configuration Exception", 0);
        }
        catch (SAXException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "SAX Exception", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "IO Exception", 0);
        }
        return hsobject;
    }

    public static HSObject ObjectFromDefinition(String dir, String defPath, NamedNodeMap attributes, EditorWindow window) {
        Document doc;
        File file;
        float offsetY;
        float offsetX;
        String texPath;
        HSObject hsobject;
        block10: {
            hsobject = null;
            texPath = "";
            defPath = defPath.replace("\\", "/");
            offsetX = 0.0f;
            offsetY = 0.0f;
            file = new File(String.valueOf(dir) + "/" + defPath);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(file);
            doc.getDocumentElement().normalize();
            if (doc.getDocumentElement().getNodeName().compareTo("HSObjects") == 0) break block10;
            JOptionPane.showMessageDialog(window, "Root node of Object is not 'HSObjects'", "Error", 0);
            return null;
        }
        try {
            NodeList textureList = doc.getElementsByTagName("Texture");
            int i = 0;
            while (i < textureList.getLength()) {
                NamedNodeMap textureAttr;
                Node n = textureList.item(i);
                if (n.getNodeType() == 1 && (textureAttr = n.getAttributes()).getNamedItem("textureFilePath") != null) {
                    texPath = window.createAbsolutePathFrom(textureAttr.getNamedItem("textureFilePath").getNodeValue(), dir);
                    offsetX = Float.parseFloat(textureAttr.getNamedItem("offsetX").getNodeValue());
                    offsetY = Float.parseFloat(textureAttr.getNamedItem("offsetY").getNodeValue());
                    break;
                }
                ++i;
            }
            hsobject = new HSObject();
            hsobject.texturePath = texPath;
            hsobject.defPath = window.createAbsolutePathFrom(defPath, dir);
            hsobject.name = file.getName();
            hsobject.offsetX = offsetX;
            hsobject.offsetY = offsetY;
            if (attributes.getNamedItem("posX") != null) {
                hsobject.pos.x = Float.parseFloat(attributes.getNamedItem("posX").getNodeValue()) + offsetX;
            }
            if (attributes.getNamedItem("posY") != null) {
                hsobject.pos.y = Float.parseFloat(attributes.getNamedItem("posY").getNodeValue()) + offsetY;
            }
            if (attributes.getNamedItem("depth") != null) {
                hsobject.depth = Double.parseDouble(attributes.getNamedItem("depth").getNodeValue());
            }
            System.out.println(hsobject);
        }
        catch (ParserConfigurationException e) {
            JOptionPane.showMessageDialog(window, e.getMessage(), "Parser Configuration Exception", 0);
        }
        catch (SAXException e) {
            JOptionPane.showMessageDialog(window, e.getMessage(), "SAX Exception", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(window, e.getMessage(), "IO Exception", 0);
        }
        return hsobject;
    }
}

