/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class TGAReader {
    private static byte ATTRIBUTE_BITS = (byte)15;
    private static byte RIGHT_ALIGN = (byte)16;
    private static byte TOP_ALIGN = (byte)32;
    private static byte RL_PACKET = (byte)-128;
    private static byte REP_COUNT_BITS = (byte)127;

    public static int indexArrayToIndex(byte[] indexArray, boolean bigEndian) {
        if (bigEndian) {
            return indexArray[indexArray.length - 1] & 0xFF;
        }
        return indexArray[0] & 0xFF;
    }

    public static short byteArrayToShort(byte[] paRawBytes, boolean pbBigEndian) {
        byte iHigh;
        byte iLow;
        int iRetVal = -1;
        if (paRawBytes.length != 2) {
            return -1;
        }
        if (pbBigEndian) {
            iLow = paRawBytes[1];
            iHigh = paRawBytes[0];
        } else {
            iLow = paRawBytes[0];
            iHigh = paRawBytes[1];
        }
        iRetVal = iHigh << 8 | 0xFF & iLow;
        return (short)iRetVal;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageIcon loadTGA(String texFilePath, String palFilePath) {
        block24: {
            bigEndian = false;
            imageWidthBytes = new byte[2];
            imageWidth = 0;
            imageHeightBytes = new byte[2];
            imageHeight = 0;
            image = null;
            palData = new byte[1];
            opaque = true;
            colorMapLengthBytes = new byte[2];
            colorBytesPerPixel = 3;
            GLbytesPerPixel = 4;
            topAlign = true;
            rightAlign = true;
            try {
                file = new FileInputStream(texFilePath);
                imageIDLength = (byte)file.read();
                colorMapType = (byte)file.read();
                imageType = (byte)file.read();
                if (imageType != 9 && imageType != 10) {
                    file.close();
                    return null;
                }
                useInternalPalette = imageType == 9 && palFilePath.isEmpty() != false;
                file.skip(2L);
                file.read(colorMapLengthBytes);
                colorMapLength = TGAReader.byteArrayToShort(colorMapLengthBytes, bigEndian);
                colorMapEntrySize = file.read();
                if (colorMapEntrySize == 15) {
                    colorMapEntrySize = 16;
                }
                bytesPerColorMapEntry = (byte)(colorMapEntrySize / 8);
                file.skip(4L);
                file.read(imageWidthBytes);
                imageWidth = TGAReader.byteArrayToShort(imageWidthBytes, bigEndian);
                file.read(imageHeightBytes);
                imageHeight = TGAReader.byteArrayToShort(imageHeightBytes, bigEndian);
                pixelDepth = (byte)file.read();
                bytesPerPixel = (byte)(pixelDepth / 8);
                if (imageType == 9 && pixelDepth != 8 || imageType == 10 && pixelDepth != 24) {
                    file.close();
                    return null;
                }
                imageDescriptor = (byte)file.read();
                if ((imageDescriptor & TGAReader.ATTRIBUTE_BITS) > 0) {
                    file.close();
                    return null;
                }
                if ((imageDescriptor & TGAReader.TOP_ALIGN) == 0) {
                    topAlign = false;
                }
                if ((imageDescriptor & TGAReader.RIGHT_ALIGN) == 0) {
                    rightAlign = false;
                }
                file.skip(imageIDLength);
                maxPixels = imageWidth * imageHeight;
                curPixels = 0;
                image = new BufferedImage(imageWidth, imageHeight, 2);
                color = new byte[colorBytesPerPixel];
                colorObj = null;
                indexBytes = new byte[bytesPerPixel];
                if (imageType == 9 && !useInternalPalette) {
                    file.skip(colorMapLength * bytesPerColorMapEntry);
                    palFile = new FileInputStream(palFilePath);
                    palData = new byte[palFile.available()];
                    palFile.read(palData);
                    palFile.close();
                } else if (useInternalPalette && colorMapType != 0) {
                    palData = new byte[colorMapLength * bytesPerColorMapEntry];
                    file.read(palData);
                } else if (imageType == 9) {
                    file.close();
                    return null;
                }
lbl78:
                // 5 sources

                while (true) {
                    block25: {
                        if (curPixels >= maxPixels) {
                            file.close();
                            return new ImageIcon(image);
                        }
                        repCount = file.read();
                        if ((repCount & TGAReader.RL_PACKET) != 0) break block25;
                        repCount = (byte)(repCount & TGAReader.REP_COUNT_BITS);
                        i = 0;
                        if (true) ** GOTO lbl137
                    }
                    repCount = (byte)(repCount & TGAReader.REP_COUNT_BITS);
                    if (imageType == 9) {
                        file.read(indexBytes);
                        index = (short)TGAReader.indexArrayToIndex(indexBytes, bigEndian);
                        alpha = index == 0 ? 0 : 255;
                        colorObj = new Color(palData[index * colorBytesPerPixel + 2] & 255, palData[index * colorBytesPerPixel + 1] & 255, palData[index * colorBytesPerPixel + 0] & 255, alpha);
                    } else if (imageType == 10) {
                        file.read(color);
                        file.skip(bytesPerPixel - colorBytesPerPixel);
                        alpha = color[0] == 255 && color[1] == 0 && color[2] == 255 ? 0 : 255;
                        colorObj = new Color(color[2] & 255, color[1] & 255, color[0] & 255, alpha);
                    }
                    i = 0;
                    while (i <= repCount) {
                        curRow = maxPixels / imageWidth - curPixels / imageWidth - 1;
                        curPixelThisRow = (curPixels + i) % imageWidth;
                        image.setRGB(curPixelThisRow, curRow, colorObj.getRGB());
                        ++i;
                    }
                    break block24;
                    break;
                }
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog(null, "\"" + texFilePath + "\": " + e.getMessage(), "File Not Found Exception", 0);
                return null;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "IO Exception", 0);
            }
            return new ImageIcon(image);
            do {
                if (imageType == 9) {
                    file.read(indexBytes);
                    index = (short)TGAReader.indexArrayToIndex(indexBytes, bigEndian);
                    alpha = index == 0 ? 0 : 255;
                    colorObj = new Color(palData[index * colorBytesPerPixel + 2] & 255, palData[index * colorBytesPerPixel + 1] & 255, palData[index * colorBytesPerPixel + 0] & 255, alpha);
                    curRow = maxPixels / imageWidth - curPixels / imageWidth - 1;
                    curPixelThisRow = curPixels % imageWidth;
                    image.setRGB(curPixelThisRow, curRow, colorObj.getRGB());
                } else if (imageType == 10) {
                    file.read(color);
                    alpha = color[0] == 255 && color[1] == 0 && color[2] == 255 ? 0 : 255;
                    colorObj = new Color(color[2] & 255, color[1] & 255, color[0] & 255, alpha);
                    curRow = maxPixels / imageWidth - curPixels / imageWidth - 1;
                    curPixelThisRow = curPixels % imageWidth;
                    image.setRGB(curPixelThisRow, curRow, colorObj.getRGB());
                }
                ++i;
lbl137:
                // 2 sources

            } while (i <= repCount);
        }
        curPixels += repCount + 1;
        ** while (true)
    }
}

