/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows;

import homestrifeeditor.HSObject;
import homestrifeeditor.HSStage;
import homestrifeeditor.HSTextureLabel;
import homestrifeeditor.windows.StagePropertiesWindow;
import homestrifeeditor.windows.panes.ObjectListPane;
import homestrifeeditor.windows.panes.TextureObjectPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EditorWindow
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int XML_FORMAT_VERSION = 0;
    public static String BaseWindowTitle = "Homestrife Stage Editor - ";
    public static int windowWidth = 1000;
    public static int windowHeight = 600;
    public static float scale = 0.1f;
    public String workingDirectory = "";
    public String exeDirectory = "";
    public String fileChooserDirectory = "";
    public File curFile = null;
    public ObjectListPane objectListPane;
    public TextureObjectPane textureObjectPane;
    public HSStage currentlyLoadedStage;
    public static JFileChooser fileChooser;
    private String changeLogText = "<html><h2>Noteworthy Changes:</h2>6 May, 2014:<ul><li>Save using forward slashes only</li></ul>1 May, 2014:<ul><li>Added border around level boundry</li><li>Can edit stage width and height in Stage Properties window</li></ul>30 April, 2014:<ul><li>Added change log! :D</li></ul></html>";

    public EditorWindow() {
        this.setTitle(String.valueOf(BaseWindowTitle) + "No Stage Loaded");
        this.setSize(windowWidth, windowHeight);
        this.setMinimumSize(new Dimension(windowWidth, windowHeight));
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.createMenuBar();
        this.createWindowContents();
        this.loadSettings();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EditorWindow.this.saveSettings();
                super.windowClosing(e);
            }
        });
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyDispatcher());
    }

    private void createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem newStageItem = new JMenuItem("New");
        newStageItem.setActionCommand("new");
        newStageItem.addActionListener(this);
        JMenuItem openItem = new JMenuItem("Open...");
        openItem.setActionCommand("open");
        openItem.addActionListener(this);
        JMenuItem saveItem = new JMenuItem("Save");
        saveItem.setActionCommand("save");
        saveItem.addActionListener(this);
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        JMenuItem saveAsItem = new JMenuItem("Save As...");
        saveAsItem.setActionCommand("saveAs");
        saveAsItem.addActionListener(this);
        JMenuItem importAnimationItem = new JMenuItem("Import Animation");
        importAnimationItem.setActionCommand("importAnimation");
        importAnimationItem.addActionListener(this);
        JMenuItem setExeLocationItem = new JMenuItem("Set Game Location");
        setExeLocationItem.setActionCommand("exeLocation");
        setExeLocationItem.addActionListener(this);
        fileMenu.add(newStageItem);
        fileMenu.add(openItem);
        fileMenu.add(saveItem);
        fileMenu.add(saveAsItem);
        fileMenu.add(new JSeparator());
        fileMenu.add(setExeLocationItem);
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        JMenuItem undoItem = new JMenuItem("Undo");
        undoItem.setActionCommand("undo");
        undoItem.addActionListener(this);
        undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        JMenuItem redoItem = new JMenuItem("Redo");
        redoItem.setActionCommand("redo");
        redoItem.addActionListener(this);
        JMenuItem cutItem = new JMenuItem("Cut");
        cutItem.setActionCommand("cut");
        cutItem.addActionListener(this);
        cutItem.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        JMenuItem copyItem = new JMenuItem("Copy");
        copyItem.setActionCommand("copy");
        copyItem.addActionListener(this);
        copyItem.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        JMenuItem pasteItem = new JMenuItem("Paste");
        pasteItem.setActionCommand("paste");
        pasteItem.addActionListener(this);
        pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        JMenuItem deleteItem = new JMenuItem("Delete");
        deleteItem.setActionCommand("delete");
        deleteItem.addActionListener(this);
        deleteItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        JMenuItem selectAllItem = new JMenuItem("Select All");
        selectAllItem.setActionCommand("selectAll");
        selectAllItem.addActionListener(this);
        selectAllItem.setAccelerator(KeyStroke.getKeyStroke(65, 512));
        editMenu.add(undoItem);
        editMenu.add(redoItem);
        editMenu.add(new JSeparator());
        editMenu.add(cutItem);
        editMenu.add(copyItem);
        editMenu.add(pasteItem);
        editMenu.add(deleteItem);
        editMenu.add(selectAllItem);
        menuBar.add(editMenu);
        JMenu stageMenu = new JMenu("Stage");
        JMenuItem stagePropertiesItem = new JMenuItem("Properties");
        stagePropertiesItem.setActionCommand("stageProperties");
        stagePropertiesItem.addActionListener(this);
        stageMenu.add(stagePropertiesItem);
        menuBar.add(stageMenu);
        JMenu scaleMenu = new JMenu("Scale");
        JMenuItem tenPercentItem = new JMenuItem("10%");
        tenPercentItem.setActionCommand("10% Scale");
        tenPercentItem.addActionListener(this);
        JMenuItem twentyFivePercentItem = new JMenuItem("25%");
        twentyFivePercentItem.setActionCommand("25% Scale");
        twentyFivePercentItem.addActionListener(this);
        JMenuItem fiftyPercentItem = new JMenuItem("50%");
        fiftyPercentItem.setActionCommand("50% Scale");
        fiftyPercentItem.addActionListener(this);
        JMenuItem hundredPercentItem = new JMenuItem("100%");
        hundredPercentItem.setActionCommand("100% Scale");
        hundredPercentItem.addActionListener(this);
        scaleMenu.add(tenPercentItem);
        scaleMenu.add(twentyFivePercentItem);
        scaleMenu.add(fiftyPercentItem);
        scaleMenu.add(hundredPercentItem);
        menuBar.add(scaleMenu);
        JMenu helpMenu = new JMenu("Help");
        JMenuItem helpContentItem = new JMenuItem("Help Content");
        helpMenu.add(helpContentItem);
        JMenuItem aboutItem = new JMenuItem("About");
        helpMenu.add(aboutItem);
        JMenuItem changeLogItem = new JMenuItem("Change Log");
        changeLogItem.setActionCommand("changeLog");
        changeLogItem.addActionListener(this);
        helpMenu.add(changeLogItem);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
    }

    private void createWindowContents() {
        JSplitPane sp = new JSplitPane(1, this.createObjectListPane(), this.createObjectDataPane());
        sp.setResizeWeight(0.05);
        this.setContentPane(sp);
    }

    private void loadSettings() {
        File file = new File("settings.xml");
        fileChooser = new JFileChooser(".");
        this.exeDirectory = "";
        this.fileChooserDirectory = ".";
        System.out.println("Loading Settings...");
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            doc.getDocumentElement().normalize();
            Element root = doc.getDocumentElement();
            if (root.getNodeName().compareTo("Settings") != 0) {
                JOptionPane.showMessageDialog(this, "Settings file has invalid root, expected <Settings>", "Error loading settings", 0);
                return;
            }
            NodeList nodes = root.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                System.out.println(String.valueOf(node.getNodeName()) + ": " + node.getTextContent());
                switch (node.getNodeName()) {
                    case "FileChooserDir": {
                        if (node.getTextContent() != null) {
                            this.fileChooserDirectory = node.getTextContent();
                        }
                        fileChooser = new JFileChooser(this.fileChooserDirectory);
                        break;
                    }
                    case "ExeDir": {
                        if (node.getTextContent() == null) break;
                        this.exeDirectory = node.getTextContent();
                        break;
                    }
                    case "Scale": {
                        if (node.getTextContent() == null) break;
                        scale = Float.parseFloat(node.getTextContent());
                    }
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            JOptionPane.showMessageDialog(this, String.valueOf(e.getMessage()) + " | Using default settings", "Parser Configuration Exception", 0);
            return;
        }
        catch (SAXException e) {
            JOptionPane.showMessageDialog(this, String.valueOf(e.getMessage()) + " | Using default settings", "SAX Exception", 0);
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("Finished Loading Settings\n");
        if (this.exeDirectory.isEmpty() && JOptionPane.showConfirmDialog(this, "Set game .exe directory now?", ".exe Directory Not Set", 0) == 0) {
            this.setExeLocation();
        }
    }

    private void saveSettings() {
        System.out.println("\nSaving Settings...");
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.newDocument();
            Element root = doc.createElement("Settings");
            Element chooserDirSetting = doc.createElement("FileChooserDir");
            chooserDirSetting.setTextContent(fileChooser.getCurrentDirectory().getPath());
            System.out.println("FileChooserDir: " + fileChooser.getCurrentDirectory().getPath());
            Element exeDirSetting = doc.createElement("ExeDir");
            exeDirSetting.setTextContent(this.exeDirectory);
            System.out.println("ExeDir: " + this.exeDirectory);
            Element scaleSetting = doc.createElement("Scale");
            scaleSetting.setTextContent("" + scale);
            System.out.println("Scale: " + scale);
            root.appendChild(chooserDirSetting);
            root.appendChild(exeDirSetting);
            root.appendChild(scaleSetting);
            doc.appendChild(root);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File("settings.xml"));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Parser Configuration Exception", 0);
        }
        catch (TransformerConfigurationException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Transformer Configuration Exception", 0);
        }
        catch (TransformerException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Transformer Exception", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Exception", 0);
        }
    }

    private void setExeLocation() {
        File lastFile = fileChooser.getCurrentDirectory();
        fileChooser = new JFileChooser(this.exeDirectory);
        fileChooser.setFileSelectionMode(1);
        int returnVal = fileChooser.showDialog(this, "Choose .exe Location");
        if (returnVal == 0) {
            this.exeDirectory = fileChooser.getSelectedFile().getAbsolutePath();
            System.out.println("Set .exe Directory: " + this.exeDirectory);
        }
        fileChooser = new JFileChooser(lastFile);
    }

    public void setCurrentlyLoadedStage(HSStage newStage) {
        this.currentlyLoadedStage = newStage;
        this.setTitle(String.valueOf(BaseWindowTitle) + "Stage Loaded");
        this.textureObjectPane.setStage(this.currentlyLoadedStage);
        this.objectListPane.loadStageObjects(this.currentlyLoadedStage);
    }

    private JComponent createObjectListPane() {
        this.objectListPane = new ObjectListPane(this);
        return this.objectListPane;
    }

    private JComponent createObjectDataPane() {
        this.textureObjectPane = new TextureObjectPane(this);
        return this.textureObjectPane;
    }

    public void newObject() {
        this.textureObjectPane.setStage(this.currentlyLoadedStage);
        this.textureObjectPane.resetScrollBars();
    }

    private void changeLog() {
        JOptionPane.showMessageDialog(this, this.changeLogText, "Change Log", 1);
    }

    public String createAbsolutePath(String relPath) {
        return this.createAbsolutePathFrom(relPath, this.workingDirectory);
    }

    public String createAbsolutePathFrom(String relPath, String fromPath) {
        relPath = relPath.replace('\\', '/');
        if (!fromPath.endsWith("/")) {
            fromPath = String.valueOf(fromPath) + "/";
        }
        File a = new File(fromPath);
        File b = new File(a, relPath);
        String absolute = "";
        try {
            absolute = b.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return absolute.replace("\\", "/");
    }

    public String createRelativePath(String absPath) {
        return this.createPathRelativeTo(absPath, this.workingDirectory);
    }

    public String createPathRelativeTo(String absPath, String relativeTo) {
        int end;
        String[] absPathPieces;
        absPath = absPath.replace('\\', '/');
        String[] relativeToPieces = (relativeTo = relativeTo.replace('\\', '/')).split("/");
        if (!relativeToPieces[0].equals((absPathPieces = absPath.split("/"))[0])) {
            return "";
        }
        int divergeancePoint = end = relativeToPieces.length > absPathPieces.length ? absPathPieces.length : relativeToPieces.length;
        int i = 0;
        while (i < end) {
            if (!relativeToPieces[i].equals(absPathPieces[i])) {
                divergeancePoint = i;
                break;
            }
            ++i;
        }
        String relativePath = "";
        int i2 = 0;
        while (i2 < end - divergeancePoint) {
            relativePath = String.valueOf(relativePath) + "../";
            ++i2;
        }
        i2 = divergeancePoint;
        while (i2 < absPathPieces.length) {
            if (i2 > divergeancePoint) {
                relativePath = String.valueOf(relativePath) + "/";
            }
            relativePath = String.valueOf(relativePath) + absPathPieces[i2];
            ++i2;
        }
        return relativePath.replace("\\", "/");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println("Action Preformed: " + e.getActionCommand());
        switch (e.getActionCommand()) {
            case "new": {
                this.newStage();
                break;
            }
            case "open": {
                this.open();
                break;
            }
            case "save": {
                this.save();
                break;
            }
            case "saveAs": {
                this.saveAs();
                break;
            }
            case "delete": {
                this.delete();
                break;
            }
            case "exeLocation": {
                this.setExeLocation();
                break;
            }
            case "stageProperties": {
                this.stageProperties();
                break;
            }
            case "10% Scale": {
                this.adjustScale(0.1f);
                break;
            }
            case "25% Scale": {
                this.adjustScale(0.25f);
                break;
            }
            case "50% Scale": {
                this.adjustScale(0.5f);
                break;
            }
            case "100% Scale": {
                this.adjustScale(1.0f);
                break;
            }
            case "changeLog": {
                this.changeLog();
            }
        }
    }

    private void stageProperties() {
        if (this.currentlyLoadedStage == null) {
            JOptionPane.showMessageDialog(this, "No Stage loaded", "Whoops", 0);
        }
        StagePropertiesWindow window = new StagePropertiesWindow(this, this.currentlyLoadedStage);
        window.setVisible(true);
    }

    private void adjustScale(float d) {
        scale = d;
        Component[] componentArray = this.textureObjectPane.textureObjectLayeredPane.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof HSTextureLabel) {
                ((HSTextureLabel)comp).loadIcon();
            }
            ++n2;
        }
    }

    private void newStage() {
        this.currentlyLoadedStage = new HSStage();
        this.workingDirectory = "";
        this.setCurrentlyLoadedStage(this.currentlyLoadedStage);
    }

    private void saveAs() {
        if (this.currentlyLoadedStage == null) {
            JOptionPane.showMessageDialog(this, "No Stage loaded", "Whoops", 0);
            return;
        }
        fileChooser.setFileSelectionMode(0);
        int returnVal = fileChooser.showSaveDialog(this);
        if (returnVal != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        this.workingDirectory = file.getParent();
        this.curFile = file;
        this.save();
    }

    private void save() {
        if (this.currentlyLoadedStage == null || this.workingDirectory == "") {
            this.saveAs();
        }
        this.createDefinitionFile();
    }

    private void createDefinitionFile() {
        if (this.currentlyLoadedStage == null) {
            return;
        }
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.newDocument();
            Element root = doc.createElement("HSStage");
            root.setAttribute("version", "0");
            root.setAttribute("gravity", "" + this.currentlyLoadedStage.gravity);
            root.setAttribute("width", "" + this.currentlyLoadedStage.width);
            root.setAttribute("height", "" + this.currentlyLoadedStage.height);
            Element objects = doc.createElement("Objects");
            for (HSObject obj : this.currentlyLoadedStage.objects) {
                Element object = doc.createElement("Object");
                object.setAttribute("defFilePath", this.createPathRelativeTo(obj.defPath, this.exeDirectory));
                object.setAttribute("posX", "" + (obj.pos.x - obj.offsetX));
                object.setAttribute("posY", "" + (obj.pos.y - obj.offsetY));
                object.setAttribute("depth", "" + obj.depth);
                objects.appendChild(object);
            }
            root.appendChild(objects);
            doc.appendChild(root);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(this.curFile.getAbsolutePath());
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Parser Configuration Exception", 0);
        }
        catch (TransformerConfigurationException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Transformer Configuration Exception", 0);
        }
        catch (TransformerException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Transformer Exception", 0);
        }
    }

    /*
     * Exception decompiling
     */
    private void open() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[0, 5] lbl73 : CaseStatement: default:\u000a, @NONE, blocks:[0, 5] lbl73 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void delete() {
        this.textureObjectPane.textureObjectLayeredPane.removeSelected();
    }

    private static void removeWhitespaceNodes(Document doc) {
        NodeList nl;
        XPath xp = XPathFactory.newInstance().newXPath();
        try {
            nl = (NodeList)xp.evaluate("//text()[normalize-space(.)='']", doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return;
        }
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            node.getParentNode().removeChild(node);
            ++i;
        }
    }

    public static ImageIcon resize(ImageIcon icon) {
        int width = (int)((float)icon.getIconWidth() * scale);
        int height = (int)((float)icon.getIconHeight() * scale);
        BufferedImage bi = new BufferedImage(width, height, 3);
        Graphics2D g2d = bi.createGraphics();
        g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g2d.drawImage(icon.getImage(), 0, 0, width, height, null);
        g2d.dispose();
        return new ImageIcon(bi);
    }

    private class KeyDispatcher
    implements KeyEventDispatcher {
        private KeyDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (!(e.getID() != 401 || e.getKeyCode() == 88 && (e.getModifiers() & 2) != 0 || e.getKeyCode() == 67 && (e.getModifiers() & 2) != 0 || e.getKeyCode() != 86)) {
                e.getModifiers();
            }
            return false;
        }
    }
}

