/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows;

import homestrifeeditor.windows.panes.ObjectListPane;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MassShiftWindow
extends JFrame
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private static int windowWidth = 150;
    private static int windowHeight = 140;
    private static int windowBorderBuffer = 10;
    private static int gridWidth = 650;
    private static int gridRowHeight = 45;
    private static int gridColumns = 2;
    private static int gridHorizontalGap = 10;
    private static int gridVerticalGap = 5;
    private ObjectListPane parent;
    private JSpinner offsetXSpinner;
    private JSpinner offsetYSpinner;
    private int prevOffsetX;
    private int prevOffsetY;

    public MassShiftWindow(ObjectListPane theParent) {
        this.parent = theParent;
        this.prevOffsetX = 0;
        this.prevOffsetY = 0;
        this.setTitle("Multi-Object Shift");
        this.setSize(windowWidth, windowHeight);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.createWindowContents();
    }

    private void createWindowContents() {
        JLabel offsetXLabel = new JLabel("Offset X");
        this.offsetXSpinner = new JSpinner(new SpinnerNumberModel(0, -99999, 99999, 1));
        this.offsetXSpinner.setValue(0);
        this.offsetXSpinner.addChangeListener(this);
        JLabel offsetYLabel = new JLabel("Offset Y");
        this.offsetYSpinner = new JSpinner(new SpinnerNumberModel(0, -99999, 99999, 1));
        this.offsetYSpinner.setValue(0);
        this.offsetYSpinner.addChangeListener(this);
        JPanel valueInterface = new JPanel(new GridLayout(2, gridColumns, gridHorizontalGap, gridVerticalGap));
        valueInterface.setSize(gridWidth, gridRowHeight * 2);
        valueInterface.add(offsetXLabel);
        valueInterface.add(this.offsetXSpinner);
        valueInterface.add(offsetYLabel);
        valueInterface.add(this.offsetYSpinner);
        JButton closeButton = new JButton("Close");
        closeButton.setActionCommand("closeButton");
        closeButton.addActionListener(this);
        JPanel buttonPane = new JPanel(new FlowLayout(4));
        buttonPane.add(closeButton);
        JPanel massShiftPane = new JPanel();
        massShiftPane.setLayout(new BoxLayout(massShiftPane, 1));
        massShiftPane.setBorder(new EmptyBorder(windowBorderBuffer, windowBorderBuffer, windowBorderBuffer, windowBorderBuffer));
        massShiftPane.add(valueInterface);
        massShiftPane.add(buttonPane);
        this.add(massShiftPane);
    }

    private void closeWindow() {
        this.dispose();
    }

    private void fieldChanged() {
        int xDiff = (Integer)this.offsetXSpinner.getValue() - this.prevOffsetX;
        int yDiff = (Integer)this.offsetYSpinner.getValue() - this.prevOffsetY;
        this.parent.massShift(xDiff, yDiff);
        this.prevOffsetX += xDiff;
        this.prevOffsetY += yDiff;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "closeButton": {
                this.closeWindow();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fieldChanged();
    }
}

