/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows;

import homestrifeeditor.HSObject;
import homestrifeeditor.HSTextureLabel;
import homestrifeeditor.windows.panes.ObjectListPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ObjectAttributesWindow
extends JDialog
implements ActionListener,
ChangeListener,
DocumentListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private static int windowWidth = 400;
    private static int windowHeightGeneral = 200;
    public ObjectListPane parent;
    private HSObject object;
    private JLabel parallaxDepthLabel;
    private JSpinner parallaxDepthSpinner;
    private static String parallaxDepthTooltip = "<html>The higher the number, the farther away from the camera it is</html>";
    private JLabel xLabel;
    private JLabel yLabel;
    private JSpinner xSpinner;
    private JSpinner ySpinner;
    private static String positionTooltip = "<html>Set the position of the object precisely</html>";

    public ObjectAttributesWindow(ObjectListPane theParent, HSObject theObject) {
        this.parent = theParent;
        this.object = theObject;
        this.setTitle("Object Attributes - " + this.object.name);
        this.setSize(windowWidth, windowHeightGeneral);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.createWindowContents();
    }

    private void createWindowContents() {
        JPanel dataPane = new JPanel(new GridLayout(0, 2, 10, 10));
        this.xLabel = new JLabel("X Position");
        this.xLabel.setToolTipText(positionTooltip);
        dataPane.add(this.xLabel);
        this.xSpinner = new JSpinner(new SpinnerNumberModel(0.0, -10000.0, 10000.0, 1.0));
        this.xSpinner.setToolTipText(positionTooltip);
        this.xSpinner.addChangeListener(this);
        this.xSpinner.setValue(this.object.pos.x);
        this.xSpinner.setEnabled(true);
        dataPane.add(this.xSpinner);
        this.yLabel = new JLabel("Y Position");
        this.yLabel.setToolTipText(positionTooltip);
        dataPane.add(this.yLabel);
        this.ySpinner = new JSpinner(new SpinnerNumberModel(0.0, -10000.0, 10000.0, 1.0));
        this.ySpinner.setToolTipText(positionTooltip);
        this.ySpinner.addChangeListener(this);
        this.ySpinner.setValue(this.object.pos.y);
        this.ySpinner.setEnabled(true);
        dataPane.add(this.ySpinner);
        this.parallaxDepthLabel = new JLabel("Parallax Depth");
        this.parallaxDepthLabel.setToolTipText(parallaxDepthTooltip);
        dataPane.add(this.parallaxDepthLabel);
        this.parallaxDepthSpinner = new JSpinner(new SpinnerNumberModel(0.0, -1000.0, 1000.0, 1.0));
        this.parallaxDepthSpinner.setToolTipText(parallaxDepthTooltip);
        this.parallaxDepthSpinner.addChangeListener(this);
        this.parallaxDepthSpinner.setValue(this.object.depth);
        this.parallaxDepthSpinner.setEnabled(true);
        dataPane.add(this.parallaxDepthSpinner);
        this.setContentPane(dataPane);
    }

    public void fieldChanged() {
        if (this.parallaxDepthSpinner != null) {
            this.object.depth = (Double)this.parallaxDepthSpinner.getValue();
        }
        if (this.xSpinner != null) {
            this.object.pos.x = ((Double)this.xSpinner.getValue()).floatValue();
        }
        if (this.ySpinner != null) {
            this.object.pos.y = ((Double)this.ySpinner.getValue()).floatValue();
        }
        Component[] componentArray = this.parent.parent.textureObjectPane.textureObjectLayeredPane.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            HSTextureLabel texLabel = (HSTextureLabel)c;
            if (texLabel.parentObject == this.object) {
                this.parent.parent.textureObjectPane.textureObjectLayeredPane.remove(texLabel);
                texLabel.texture.depth = -this.object.depth;
                this.parent.parent.textureObjectPane.textureObjectLayeredPane.add((Component)texLabel, this.object.depth);
                this.parent.parent.textureObjectPane.textureObjectLayeredPane.repaint();
                texLabel.updatePos();
                break;
            }
            ++n2;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "fieldChanged": {
                this.fieldChanged();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fieldChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fieldChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fieldChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fieldChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fieldChanged();
    }
}

