/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows;

import homestrifeeditor.HSStage;
import homestrifeeditor.windows.EditorWindow;
import java.awt.GridLayout;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StagePropertiesWindow
extends JFrame
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private static int windowWidth = 200;
    private static int windowHeight = 100;
    private static int windowBorderBuffer = 10;
    private static int gridWidth = 650;
    private static int gridRowHeight = 45;
    private static int gridColumns = 2;
    private static int gridHorizontalGap = 10;
    private static int gridVerticalGap = 5;
    private EditorWindow parent;
    private HSStage stage;
    private JSpinner widthSpinner;
    private JSpinner heightSpinner;

    public StagePropertiesWindow(EditorWindow editorWindow, HSStage currentlyLoadedStage) {
        this.parent = editorWindow;
        this.stage = currentlyLoadedStage;
        this.setTitle("Stage Properties");
        this.setSize(windowWidth, windowHeight);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.createWindowContents();
    }

    private void createWindowContents() {
        JLabel widthLabel = new JLabel("Width");
        this.widthSpinner = new JSpinner(new SpinnerNumberModel(0, -99999, 99999, 1));
        this.widthSpinner.setValue(this.stage.width);
        this.widthSpinner.addChangeListener(this);
        JLabel heightLabel = new JLabel("Height");
        this.heightSpinner = new JSpinner(new SpinnerNumberModel(0, -99999, 99999, 1));
        this.heightSpinner.setValue(this.stage.height);
        this.heightSpinner.addChangeListener(this);
        JPanel valueInterface = new JPanel(new GridLayout(2, gridColumns, gridHorizontalGap, gridVerticalGap));
        valueInterface.setSize(gridWidth, gridRowHeight * 2);
        valueInterface.add(widthLabel);
        valueInterface.add(this.widthSpinner);
        valueInterface.add(heightLabel);
        valueInterface.add(this.heightSpinner);
        JPanel propertiesPane = new JPanel();
        propertiesPane.setLayout(new BoxLayout(propertiesPane, 1));
        propertiesPane.setBorder(new EmptyBorder(windowBorderBuffer, windowBorderBuffer, windowBorderBuffer, windowBorderBuffer));
        propertiesPane.add(valueInterface);
        this.add(propertiesPane);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.widthSpinner != null) {
            this.stage.width = (Integer)this.widthSpinner.getValue();
        }
        if (this.heightSpinner != null) {
            this.stage.height = (Integer)this.heightSpinner.getValue();
        }
        this.parent.textureObjectPane.textureObjectLayeredPane.repaint();
    }
}

