/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows.panes;

import homestrifeeditor.HSObject;
import homestrifeeditor.HSStage;
import homestrifeeditor.HSTexture;
import homestrifeeditor.HSTextureLabel;
import homestrifeeditor.windows.EditorWindow;
import homestrifeeditor.windows.panes.TextureObjectPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;

public class TextureObjectLayeredPane
extends JLayeredPane
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    public TextureObjectPane parent;
    public ArrayList<JLabel> selectedItems;

    public TextureObjectLayeredPane(TextureObjectPane theParent) {
        this.parent = theParent;
        this.selectedItems = new ArrayList();
    }

    public void addObject(HSObject obj) {
        HSTextureLabel texLabel = new HSTextureLabel(obj, this, new HSTexture(obj.texturePath, -obj.depth, obj.pos));
        if (texLabel.getIcon() == null) {
            return;
        }
        texLabel.setVisible(true);
        this.add((Component)texLabel, new Double(-obj.depth));
    }

    public void removeSelected() {
        for (JLabel sel : this.selectedItems) {
            this.remove(sel);
            this.parent.parent.currentlyLoadedStage.objects.remove(((HSTextureLabel)sel).parentObject);
            this.parent.parent.objectListPane.removeObjectFromList(((HSTextureLabel)sel).parentObject);
            this.parent.parent.objectListPane.repaint();
        }
        this.selectedItems.clear();
        this.repaint();
    }

    public void setStage(HSStage stage) {
        this.removeAll();
        for (HSObject obj : stage.objects) {
            this.addObject(obj);
        }
        this.repaint();
    }

    public void unselect(JLabel label) {
        if (label.getName().compareTo("texture") == 0) {
            label.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        this.selectedItems.remove(label);
        this.repaint();
    }

    public void unselectAll() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.getName().compareTo("texture") == 0) {
                ((JLabel)c).setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
            ++n2;
        }
        this.selectedItems.clear();
        this.repaint();
    }

    public void setSelected(JLabel selectedLabel, boolean multiSelect) {
        if (!selectedLabel.isVisible()) {
            return;
        }
        if (!multiSelect) {
            this.unselectAll();
        }
        this.selectedItems.add(selectedLabel);
        selectedLabel.setBorder(BorderFactory.createDashedBorder(Color.BLACK));
        this.repaint();
    }

    public void setSelectedFromListPane() {
        int[] curSelected = this.parent.parent.objectListPane.objectList.getSelectedIndices();
        this.unselectAll();
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof HSTextureLabel) {
                int i = 0;
                while (i < curSelected.length) {
                    if (((HSTextureLabel)c).parentObject.equals(this.parent.parent.objectListPane.objectListModel.get(curSelected[i]))) {
                        this.setSelected((HSTextureLabel)c, i != 0);
                    }
                    ++i;
                }
            }
            ++n2;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
        g.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
        if (this.parent.parent.currentlyLoadedStage != null) {
            g.setColor(Color.RED);
            g.drawRect((int)((float)(this.getWidth() / 2) + (float)(-this.parent.parent.currentlyLoadedStage.width / 2) * EditorWindow.scale), (int)((float)(this.getHeight() / 2) + (float)(-this.parent.parent.currentlyLoadedStage.height / 2) * EditorWindow.scale), (int)((float)this.parent.parent.currentlyLoadedStage.width * EditorWindow.scale), (int)((float)this.parent.parent.currentlyLoadedStage.height * EditorWindow.scale));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

