/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows.panes;

import homestrifeeditor.HSStage;
import homestrifeeditor.HSVect2D;
import homestrifeeditor.windows.EditorWindow;
import homestrifeeditor.windows.panes.TextureObjectLayeredPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class TextureObjectPane
extends JPanel
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    public static int textureObjectPaneWidth = 15360;
    public static int textureObjectPaneHeight = 8640;
    public EditorWindow parent;
    public HSStage stage;
    public TextureObjectLayeredPane textureObjectLayeredPane;
    public JScrollPane textureObjectScrollPane;
    public JToolBar textureObjectToolBar;
    public ArrayList<JLabel> clipboard;

    public TextureObjectPane(EditorWindow theParent) {
        this.parent = theParent;
        this.stage = null;
        this.clipboard = new ArrayList();
        this.createPaneContents();
        this.resetScrollBars();
    }

    public HSVect2D getHSOffset(int x, int y) {
        HSVect2D point = new HSVect2D();
        point.x = x - textureObjectPaneWidth / 2;
        point.y = y - textureObjectPaneHeight / 2;
        return point;
    }

    public Point getSwingOffset(float x, float y) {
        Point point = new Point(textureObjectPaneWidth / 2 + (int)x, textureObjectPaneHeight / 2 + (int)y);
        return point;
    }

    public void resetScrollBars() {
        this.textureObjectScrollPane.revalidate();
        float horMin = this.textureObjectScrollPane.getHorizontalScrollBar().getMinimum();
        float horMax = this.textureObjectScrollPane.getHorizontalScrollBar().getMaximum();
        float horMid = (horMax - horMin) / 2.5f;
        float verMin = this.textureObjectScrollPane.getVerticalScrollBar().getMinimum();
        float verMax = this.textureObjectScrollPane.getVerticalScrollBar().getMaximum();
        float verMid = (verMax - verMin) / 2.5f;
        this.textureObjectScrollPane.getHorizontalScrollBar().setValue((int)horMid);
        this.textureObjectScrollPane.getVerticalScrollBar().setValue((int)verMid);
    }

    private void createPaneContents() {
        this.textureObjectLayeredPane = new TextureObjectLayeredPane(this);
        this.textureObjectLayeredPane.setOpaque(true);
        this.textureObjectLayeredPane.setBackground(Color.magenta);
        this.textureObjectLayeredPane.setPreferredSize(new Dimension(textureObjectPaneWidth, textureObjectPaneHeight));
        this.textureObjectScrollPane = new JScrollPane(this.textureObjectLayeredPane, 22, 32);
        this.textureObjectScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.setLayout(new BorderLayout());
        this.add(this.textureObjectScrollPane);
    }

    public void setStage(HSStage stage) {
        this.textureObjectLayeredPane.setStage(stage);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

