/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.objects.holds.properties;

import homestrifeeditor.objects.holds.properties.HSSpawnObject;
import homestrifeeditor.windows.panes.TextureHitboxLayeredPane;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;

public class HSSpawnObjectLabel
extends JLabel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    public TextureHitboxLayeredPane parent;
    public HSSpawnObject spawnObject;
    private int mouseStartX;
    private int mouseStartY;
    private int mouseMoveThreshold;
    private boolean moveBox;
    public boolean locked;
    public int width = 100;
    public int height = 50;

    public HSSpawnObjectLabel(TextureHitboxLayeredPane theParent, HSSpawnObject theSpawnObject) {
        this.setName("texture");
        this.parent = theParent;
        this.spawnObject = theSpawnObject;
        this.mouseStartX = 0;
        this.mouseStartY = 0;
        this.mouseMoveThreshold = 5;
        this.moveBox = false;
        this.locked = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        Point pos = this.parent.parent.getSwingOffset(this.spawnObject.parentOffset.x, this.spawnObject.parentOffset.y);
        this.setBounds(pos.x - this.width / 2, pos.y - this.height / 2, this.width, this.height);
    }

    public HSSpawnObjectLabel(HSSpawnObjectLabel l) {
        this(l.parent, l.spawnObject);
        this.setBounds(l.getBounds());
        this.spawnObject = new HSSpawnObject(this.spawnObject.defFilePath);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
        g2.setColor(Color.GREEN);
        g2.fill(new Rectangle(0, 0, this.width, this.height));
        g2.setColor(Color.BLACK);
        g2.drawLine(0, this.height / 2, this.width, this.height / 2);
        g2.drawLine(this.width / 2, 0, this.width / 2, this.height);
        g2.drawChars(this.spawnObject.toString().toCharArray(), 0, this.spawnObject.toString().toCharArray().length, 0, this.height / 3);
        super.paint(g2);
        g2.dispose();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.locked) {
            return;
        }
        Component c = e.getComponent();
        if (c == null) {
            return;
        }
        int xDiff = e.getX() - this.mouseStartX;
        int yDiff = e.getY() - this.mouseStartY;
        if (Math.abs(xDiff) >= this.mouseMoveThreshold || Math.abs(yDiff) >= this.mouseMoveThreshold) {
            this.moveBox = true;
        }
        if (!this.moveBox) {
            return;
        }
        this.spawnObject.parentOffset.x += (float)xDiff;
        this.spawnObject.parentOffset.y += (float)yDiff;
        Point pos = this.parent.parent.getSwingOffset(this.spawnObject.parentOffset.x, this.spawnObject.parentOffset.y);
        this.setBounds(pos.x - this.width / 2, pos.y - this.height / 2, this.width, this.height);
        this.parent.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() != 2) {
            e.getClickCount();
        }
        this.mouseStartX = e.getX();
        this.mouseStartY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.moveBox = false;
    }
}

