/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows;

import homestrifeeditor.objects.holds.FighterHold;
import homestrifeeditor.objects.holds.HSObjectHold;
import homestrifeeditor.objects.holds.PhysicsObjectHold;
import homestrifeeditor.objects.holds.TerrainObjectHold;
import homestrifeeditor.objects.holds.properties.Blockability;
import homestrifeeditor.objects.holds.properties.Cancel;
import homestrifeeditor.objects.holds.properties.HitLevel;
import homestrifeeditor.objects.holds.properties.Invulnerability;
import homestrifeeditor.windows.SoundsWindow;
import homestrifeeditor.windows.SpawnObjectsWindow;
import homestrifeeditor.windows.panes.HoldListPane;
import homestrifeeditor.windows.renderers.HoldComboBoxRenderer;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreePath;

public class HoldAttributesWindow
extends JFrame
implements ActionListener,
ChangeListener,
DocumentListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private static int windowWidth = 1200;
    private static int windowHeight = 500;
    private static int windowBorderBuffer = 10;
    private static int gridWidth = 500;
    private static int gridRowHeight = 45;
    private static int gridColumns = 4;
    private static int gridHorizontalGap = 10;
    private static int gridVerticalGap = 5;
    public HoldListPane parent;
    private HSObjectHold hold;
    private JTextField nameField;
    private static String nameTooltip = "<html>The name to be displayed in the hold list.</html>";
    private JSpinner durationSpinner;
    private static String durationTooltip = "<html>How many frames this hold lasts. The game runs at 60 frames per second.</html>";
    private JComboBox<?> nextHoldCombo;
    private static String nextHoldTooltip = "<html>Which hold this object should switch to once this hold's duration expires.<br>If this is set to NONE, the engine will determine the next hold some other way.</html>";
    private JButton holdSoundsButton;
    private static String holdSoundsTooltip = "<html>Add/Edit sounds that occur in this hold</html>";
    private JButton spawnObjectsButton;
    private static String spawnObjectsTooltip = "<html>Add/Edit objects that are spawned in this hold</html>";
    private JSpinner repositionXSpinner;
    private static String repositionTooltip = "<html>I'm not sure what this means Darlos just told me to put it in, I assume it has something to do with repositioning??</html>";
    private JSpinner repositionYSpinner;
    private JSpinner velocityXSpinner;
    private static String velocityTooltip = "<html>Probably something pertaining to velocity? I dunno I didn't make the engine</html>";
    private JSpinner velocityYSpinner;
    private JCheckBox overwriteVelocityCheck;
    private static String overwriteVelocityTooltip = "<html>Whether or not you should overwrite the velocity (duh?)</html>";
    private JCheckBox changeAttackBoxAttributesCheck;
    private static String changeAttackBoxAttributesTooltip = "<html>If this is unchecked, this hold will inherit the attack<br/>attributes of any hold that has this hold as its<br/>next hold.</html>";
    private JSpinner damageSpinner;
    private static String damageTooltip = "<html>How much damage is done to another object with hurt boxes,<br>should one of this objects attack boxes collide with one of them.</html>";
    private JSpinner hitstunSpinner;
    private static String hitstunTooltip = "<html>How many frames another fighter is rendered out-of-control<br>when struck by one of this object's attack boxes.</html>";
    private JSpinner blockstunSpinner;
    private static String blockstunTooltip = "<html>How many frames another fighter is rendered out-of-control<br>when struck by one of this object's attack boxes while blocking.</html>";
    private JSpinner forceXSpinner;
    private static String forceXTooltip = "<html>When another physics object is struck by one of this object's<br>attack boxes, its X velocity is set to this value.</html>";
    private JSpinner forceYSpinner;
    private static String forceYTooltip = "<html>When another physics object is struck by one of this object's<br>attack boxes, its Y velocity is set to this value.</html>";
    private JCheckBox tripsCheck;
    private static String tripsTooltip = "<html>If checked, another fighter will fall prone if struck by one of<br>this object's attack boxes.</html>";
    private JCheckBox resetHitsCheck;
    private static String resetHitsTooltip = "<html>If checked, further attack boxes in this animation will strike<br>objects that have already been struck.</html>";
    private JComboBox<?> blockabilityCombo;
    private static String blockabilityTooltip = "<html>Unblockable: This object's attack boxes cannot be blocked.<br>High: This object's attack boxes must be blocked while standing or jumping.<br>Low: This object's attack boxes must be blocked while crouching or jumping.<br>Mid: This object's attack boxes can be blocked while crouching, standing, or jumping.</html>";
    private JComboBox<?> hitLevelCombo;
    private static String hitLevelTooltip = "<html>Ask Darlos</html>";
    private JCheckBox directionBlockCheck;
    private static String directionBlockTooltip = "<html>If checked, another figher must be facing in the opposite<br>direction that this object is facing in order to block this<br>object's attack boxes.<br>Normally, whether this object's attack boxes must be blocked while<br>facing left or right is determined by which side of the defending<br>fighter this object is on, regardless of which way this object is facing.</html>";
    private JCheckBox reverseBlockCheck;
    private static String reverseBlockTooltip = "<html>If checked, another fighter must face the direction opposite<br>of what they would normally need to in order to block this object's attack boxes.</html>";
    private JButton hitSoundsButton;
    private static String hitSoundsTooltip = "<html>Add/Edit sounds that occur upon an attack box collision</html>";
    private JButton blockedSoundsButton;
    private static String blockedSoundsTooltip = "<html>Add/Edit sounds that occur upon an attack being blocked</html>";
    private JSpinner ownHitstopSpinner;
    private static String ownHitstopTooltip = "<html>How many frames this object is frozen when it strikes<br>something else. This is usually the same amount as victim hitstop.</html>";
    private JSpinner victimHitstopSpinner;
    private static String victimHitstopTooltip = "<html>How many frames another object is frozen when struck<br>by this object. This is usually the same amount as own hitstop.</html>";
    private JCheckBox ownHitstopOverride;
    private static String ownHitstopOverrideTooltip = "<html>If checked, the own hitstop value overrides a universal hitstop value.</html>";
    private JCheckBox victimHitstopOverride;
    private static String victimHitstopOverrideTooltip = "<html>If checked, the victim hitstop value overrides a universal hitstop value.</html>";
    private JCheckBox changeHurtBoxAttributesCheck;
    private static String changeHurtBoxAttributesTooltip = "<html>If this is unchecked, this hold will inherit the hurt<br/>attributes of any hold that has this hold as its<br/>next hold.</html>";
    private JComboBox<?> invulnerabilityCombo;
    private static String invulnerabilityTooltip = "<html>I dunno ask Darlos</html>";
    private JSpinner superArmorHitsSpinner;
    private static String superArmorHitsTooltip = "<html>I dunno ask Darlos</html>";
    private JSpinner superArmorDamageSpinner;
    private static String superArmorDamageTooltip = "<html>I dunno ask Darlos</html>";
    private JSpinner superArmorDamageScalingSpinner;
    private static String superArmorDamageScalingTooltip = "<html>I dunno ask Darlos</html>";
    private JCheckBox changePhysicsCheck;
    private static String changePhysicsTooltip = "<html>If this is unchecked, this hold will not modify the object's physics attributes</html>";
    private JCheckBox ignoreGravityCheck;
    private JCheckBox changeFighterAttributesCheck;
    private static String changeFighterAttributesTooltip = "<html>If this is checked, the fighter attributes will change on this hold</html>";
    private JCheckBox disableAirControlCheck;
    private static String disableAirControlTooltip = "<html>If this is checked, this will disable the player's ability to affect horizontal motion while jumping, either until the end of the current animation or until the next time a hold that changes this attribute</html>";
    private JCheckBox endAirDashCheck;
    private static String endAirDashTooltip = "<html>If this is checked, the air-dashing state will be terminated immediately upon reaching this hold</html>";
    private JCheckBox changeCancelsCheck;
    private static String changeCancelsTooltip = "<html>If this is unchecked, this hold will inhereit the cancels<br>of any hold that has this hold as its next hold.</html>";
    private JComboBox<Cancel> dashCancelCombo;
    private static String cancelTooltip = "<html>Any Time: This action can be cancelled into at any time.<br>After Hit or Block: This action can be cancelled into after striking a hurt box.<br>After Hit: This action can ben cancelled into after striking a hurt box without being blocked.<br>After Block: This action can be cancelled into after striking a hurt box and beinb blocked.<br>Never: This action can never be cancelled into.</html>";
    private JComboBox<Cancel> jumpCancelCombo;
    private JComboBox<Cancel> lightNeutralCancelCombo;
    private JComboBox<Cancel> lightForwardCancelCombo;
    private JComboBox<Cancel> lightUpCancelCombo;
    private JComboBox<Cancel> lightDownCancelCombo;
    private JComboBox<Cancel> lightBackwardCancelCombo;
    private JComboBox<Cancel> lightQCFCancelCombo;
    private JComboBox<Cancel> heavyNeutralCancelCombo;
    private JComboBox<Cancel> heavyForwardCancelCombo;
    private JComboBox<Cancel> heavyUpCancelCombo;
    private JComboBox<Cancel> heavyDownCancelCombo;
    private JComboBox<Cancel> heavyBackwardCancelCombo;
    private JComboBox<Cancel> heavyQCFCancelCombo;
    private JPanel terrainInterface;
    private JPanel hitstopInterface;
    private JPanel hurtBoxInterface;
    private JPanel physicsInterface;
    private JPanel fighterAttributesInterface;
    private JPanel fighterInterface;
    private JButton applyButton;
    public TreePath holdPath;

    public HoldAttributesWindow(HoldListPane theParent, HSObjectHold theHold, TreePath path) {
        this.parent = theParent;
        this.hold = theHold;
        this.holdPath = path;
        this.setTitle("Hold Attributes - " + this.hold.name);
        this.setSize(windowWidth, windowHeight);
        this.setLocationRelativeTo(this.parent);
        this.createWindowContents();
    }

    private void createWindowContents() {
        JLabel nameLabel = new JLabel("Name");
        nameLabel.setToolTipText(nameTooltip);
        this.nameField = new JTextField(this.hold.name);
        this.nameField.setToolTipText(nameTooltip);
        this.nameField.getDocument().addDocumentListener(this);
        JLabel nextHoldLabel = new JLabel("Next Hold");
        nextHoldLabel.setToolTipText(nextHoldTooltip);
        HoldComboBoxRenderer holdComboRenderer = new HoldComboBoxRenderer();
        ArrayList<HSObjectHold> allHolds = this.parent.getAllHolds();
        HSObjectHold[] allHoldsPlusNull = new HSObjectHold[allHolds.size() + 1];
        HSObjectHold nullHold = new HSObjectHold();
        nullHold.name = "NONE";
        allHoldsPlusNull[0] = nullHold;
        int i = 0;
        while (i < allHolds.size()) {
            allHoldsPlusNull[i + 1] = allHolds.get(i);
            ++i;
        }
        this.nextHoldCombo = new JComboBox<HSObjectHold>(allHoldsPlusNull);
        this.nextHoldCombo.setRenderer(holdComboRenderer);
        if (this.hold.nextHold == null) {
            this.nextHoldCombo.setSelectedIndex(0);
        } else {
            this.nextHoldCombo.setSelectedItem(this.hold.nextHold);
        }
        this.nextHoldCombo.setToolTipText(nextHoldTooltip);
        this.nextHoldCombo.setActionCommand("fieldChanged");
        this.nextHoldCombo.addItemListener(this);
        JLabel durationLabel = new JLabel("Duration");
        durationLabel.setToolTipText(durationTooltip);
        this.durationSpinner = new JSpinner(new SpinnerNumberModel(4, 0, 99999, 1));
        this.durationSpinner.setToolTipText(durationTooltip);
        this.durationSpinner.setValue(this.hold.duration);
        this.durationSpinner.addChangeListener(this);
        this.holdSoundsButton = new JButton("Hold Sounds...");
        this.holdSoundsButton.setToolTipText(holdSoundsTooltip);
        this.holdSoundsButton.setActionCommand("holdSoundsButton");
        this.holdSoundsButton.addActionListener(this);
        this.spawnObjectsButton = new JButton("Spawn Objects...");
        this.spawnObjectsButton.setToolTipText(spawnObjectsTooltip);
        this.spawnObjectsButton.setActionCommand("spawnObjectsButton");
        this.spawnObjectsButton.addActionListener(this);
        JLabel repositionLabel = new JLabel("Reposition X/Y");
        repositionLabel.setToolTipText(repositionTooltip);
        this.repositionXSpinner = new JSpinner(new SpinnerNumberModel(0.0, -99999.0, 99999.0, 1.0));
        this.repositionXSpinner.setToolTipText(repositionTooltip);
        this.repositionXSpinner.setValue(Float.valueOf(this.hold.reposition.x));
        this.repositionXSpinner.addChangeListener(this);
        this.repositionYSpinner = new JSpinner(new SpinnerNumberModel(0.0, -99999.0, 99999.0, 1.0));
        this.repositionYSpinner.setToolTipText(repositionTooltip);
        this.repositionYSpinner.setValue(Float.valueOf(this.hold.reposition.y));
        this.repositionYSpinner.addChangeListener(this);
        JLabel velocityLabel = new JLabel("Velocity X/Y");
        velocityLabel.setToolTipText(velocityTooltip);
        this.overwriteVelocityCheck = new JCheckBox("Overwrite Velocity", this.hold.overwriteVelocity);
        this.overwriteVelocityCheck.setToolTipText(overwriteVelocityTooltip);
        this.overwriteVelocityCheck.setActionCommand("overwriteVelocityChanged");
        this.overwriteVelocityCheck.addActionListener(this);
        this.velocityXSpinner = new JSpinner(new SpinnerNumberModel(0, -99999, 99999, 1));
        this.velocityXSpinner.setToolTipText(velocityTooltip);
        this.velocityXSpinner.setValue(Float.valueOf(this.hold.velocity.x));
        this.velocityXSpinner.setEnabled(this.overwriteVelocityCheck.isSelected());
        this.velocityXSpinner.addChangeListener(this);
        this.velocityYSpinner = new JSpinner(new SpinnerNumberModel(0, -99999, 99999, 1));
        this.velocityYSpinner.setToolTipText(velocityTooltip);
        this.velocityYSpinner.setValue(Float.valueOf(this.hold.velocity.y));
        this.velocityYSpinner.setEnabled(this.overwriteVelocityCheck.isSelected());
        this.velocityYSpinner.addChangeListener(this);
        JPanel graphicInterface = new JPanel(new GridLayout(5, gridColumns, gridHorizontalGap, gridVerticalGap));
        graphicInterface.setBorder(new TitledBorder("General Attributes"));
        graphicInterface.add(nameLabel);
        graphicInterface.add(this.nameField);
        graphicInterface.add(durationLabel);
        graphicInterface.add(this.durationSpinner);
        graphicInterface.add(nextHoldLabel);
        graphicInterface.add(this.nextHoldCombo);
        graphicInterface.add(this.holdSoundsButton);
        graphicInterface.add(this.spawnObjectsButton);
        graphicInterface.add(repositionLabel);
        graphicInterface.add(this.repositionXSpinner);
        graphicInterface.add(this.repositionYSpinner);
        graphicInterface.add(new JLabel(""));
        graphicInterface.add(velocityLabel);
        graphicInterface.add(this.velocityXSpinner);
        graphicInterface.add(this.velocityYSpinner);
        graphicInterface.add(this.overwriteVelocityCheck);
        JPanel holdAttributesPane = new JPanel();
        holdAttributesPane.setLayout(new BoxLayout(holdAttributesPane, 1));
        holdAttributesPane.setBorder(new EmptyBorder(windowBorderBuffer, windowBorderBuffer, windowBorderBuffer, windowBorderBuffer));
        holdAttributesPane.add(graphicInterface);
        if (this.hold.IsTerrainObjectHold()) {
            TerrainObjectHold toHold = (TerrainObjectHold)this.hold;
            this.changeAttackBoxAttributesCheck = new JCheckBox("Change attack box attributes this hold", toHold.changeAttackBoxAttributes);
            this.changeAttackBoxAttributesCheck.setToolTipText(changeAttackBoxAttributesTooltip);
            this.changeAttackBoxAttributesCheck.setActionCommand("changeAttackBoxAttributesChanged");
            this.changeAttackBoxAttributesCheck.addActionListener(this);
            JPanel changeAttackBoxAttributesInterface = new JPanel(new GridLayout(1, gridColumns, gridHorizontalGap, gridVerticalGap));
            changeAttackBoxAttributesInterface.add(this.changeAttackBoxAttributesCheck);
            holdAttributesPane.add(changeAttackBoxAttributesInterface);
            JLabel blockabilityLabel = new JLabel("Blockability");
            blockabilityLabel.setToolTipText(blockabilityTooltip);
            this.blockabilityCombo = new JComboBox<Blockability>(Blockability.values());
            this.blockabilityCombo.setToolTipText(blockabilityTooltip);
            this.blockabilityCombo.setSelectedItem((Object)toHold.blockability);
            this.blockabilityCombo.setActionCommand("fieldChanged");
            this.blockabilityCombo.addItemListener(this);
            JLabel hitLevelLabel = new JLabel("Hit Level");
            hitLevelLabel.setToolTipText(hitLevelTooltip);
            this.hitLevelCombo = new JComboBox<HitLevel>(HitLevel.values());
            this.hitLevelCombo.setToolTipText(hitLevelTooltip);
            this.hitLevelCombo.setSelectedItem((Object)toHold.hitLevel);
            this.hitLevelCombo.setActionCommand("fieldChanged");
            this.hitLevelCombo.addItemListener(this);
            this.directionBlockCheck = new JCheckBox("Direction Block", toHold.horizontalDirectionBasedBlock);
            this.directionBlockCheck.setToolTipText(directionBlockTooltip);
            this.directionBlockCheck.setActionCommand("fieldChanged");
            this.directionBlockCheck.addActionListener(this);
            this.reverseBlockCheck = new JCheckBox("Reverse Block", toHold.reversedHorizontalBlock);
            this.reverseBlockCheck.setToolTipText(reverseBlockTooltip);
            this.reverseBlockCheck.setActionCommand("fieldChanged");
            this.reverseBlockCheck.addActionListener(this);
            JLabel damageLabel = new JLabel("Damage");
            damageLabel.setToolTipText(damageTooltip);
            this.damageSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99999, 1));
            this.damageSpinner.setToolTipText(damageTooltip);
            this.damageSpinner.setValue(toHold.damage);
            this.damageSpinner.addChangeListener(this);
            this.ownHitstopSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99999, 1));
            this.ownHitstopSpinner.setToolTipText(ownHitstopTooltip);
            this.ownHitstopSpinner.setValue(toHold.ownHitstop);
            this.ownHitstopSpinner.addChangeListener(this);
            this.ownHitstopOverride = new JCheckBox("Own Hit Stop", toHold.ownHitstopOverride);
            this.ownHitstopOverride.setToolTipText(ownHitstopOverrideTooltip);
            this.ownHitstopOverride.setActionCommand("ownHitstopOverrideChanged");
            this.ownHitstopOverride.addActionListener(this);
            this.victimHitstopSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99999, 1));
            this.victimHitstopSpinner.setToolTipText(victimHitstopTooltip);
            this.victimHitstopSpinner.setValue(toHold.victimHitstop);
            this.victimHitstopSpinner.addChangeListener(this);
            this.victimHitstopOverride = new JCheckBox("Victim Hit Stop", toHold.victimHitstopOverride);
            this.victimHitstopOverride.setToolTipText(victimHitstopOverrideTooltip);
            this.victimHitstopOverride.setActionCommand("victimHitstopOverrideChanged");
            this.victimHitstopOverride.addActionListener(this);
            JLabel hitstunLabel = new JLabel("Hit Stun");
            hitstunLabel.setToolTipText(hitstunTooltip);
            this.hitstunSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99999, 1));
            this.hitstunSpinner.setToolTipText(hitstunTooltip);
            this.hitstunSpinner.setValue(toHold.hitstun);
            this.hitstunSpinner.addChangeListener(this);
            JLabel blockstunLabel = new JLabel("Block Stun");
            blockstunLabel.setToolTipText(blockstunTooltip);
            this.blockstunSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99999, 1));
            this.blockstunSpinner.setToolTipText(blockstunTooltip);
            this.blockstunSpinner.setValue(toHold.blockstun);
            this.blockstunSpinner.addChangeListener(this);
            Float value = new Float(0.0);
            Float min = new Float(-99999.0);
            Float max = new Float(99999.0);
            Float stepSize = new Float(1.0f);
            JLabel forceXLabel = new JLabel("Horizontal Force");
            forceXLabel.setToolTipText(forceXTooltip);
            this.forceXSpinner = new JSpinner(new SpinnerNumberModel(value, min, max, stepSize));
            this.forceXSpinner.setToolTipText(forceXTooltip);
            this.forceXSpinner.setValue(Float.valueOf(toHold.force.x));
            this.forceXSpinner.addChangeListener(this);
            JLabel forceYLabel = new JLabel("Vertical Force");
            forceYLabel.setToolTipText(forceYTooltip);
            this.forceYSpinner = new JSpinner(new SpinnerNumberModel(value, min, max, stepSize));
            this.forceYSpinner.setToolTipText(forceYTooltip);
            this.forceYSpinner.setValue(Float.valueOf(toHold.force.y));
            this.forceYSpinner.addChangeListener(this);
            this.tripsCheck = new JCheckBox("Trips", toHold.trips);
            this.tripsCheck.setToolTipText(tripsTooltip);
            this.tripsCheck.setActionCommand("fieldChanged");
            this.tripsCheck.addActionListener(this);
            this.resetHitsCheck = new JCheckBox("Reset Hits", toHold.resetHits);
            this.resetHitsCheck.setToolTipText(resetHitsTooltip);
            this.resetHitsCheck.setActionCommand("fieldChanged");
            this.resetHitsCheck.addActionListener(this);
            this.hitSoundsButton = new JButton("Hit Sounds...");
            this.hitSoundsButton.setToolTipText(hitSoundsTooltip);
            this.hitSoundsButton.setActionCommand("hitSoundsButton");
            this.hitSoundsButton.addActionListener(this);
            this.blockedSoundsButton = new JButton("Blocked Sounds...");
            this.blockedSoundsButton.setToolTipText(blockedSoundsTooltip);
            this.blockedSoundsButton.setActionCommand("blockedSoundsButton");
            this.blockedSoundsButton.addActionListener(this);
            this.hitstopInterface = new JPanel(new GridLayout(2, 2, gridHorizontalGap, gridVerticalGap));
            this.hitstopInterface.setBorder(new TitledBorder("Hitstops"));
            this.hitstopInterface.add(this.ownHitstopOverride);
            this.hitstopInterface.add(this.ownHitstopSpinner);
            this.hitstopInterface.add(this.victimHitstopOverride);
            this.hitstopInterface.add(this.victimHitstopSpinner);
            this.terrainInterface = new JPanel(new GridLayout(5, gridColumns, gridHorizontalGap, gridVerticalGap));
            this.terrainInterface.setBorder(new TitledBorder("Attack Box Attributes"));
            this.terrainInterface.add(damageLabel);
            this.terrainInterface.add(this.damageSpinner);
            this.terrainInterface.add(hitstunLabel);
            this.terrainInterface.add(this.hitstunSpinner);
            this.terrainInterface.add(blockabilityLabel);
            this.terrainInterface.add(this.blockabilityCombo);
            this.terrainInterface.add(hitLevelLabel);
            this.terrainInterface.add(this.hitLevelCombo);
            this.terrainInterface.add(blockstunLabel);
            this.terrainInterface.add(this.blockstunSpinner);
            this.terrainInterface.add(forceXLabel);
            this.terrainInterface.add(this.forceXSpinner);
            this.terrainInterface.add(forceYLabel);
            this.terrainInterface.add(this.forceYSpinner);
            this.terrainInterface.add(this.tripsCheck);
            this.terrainInterface.add(this.resetHitsCheck);
            this.terrainInterface.add(this.directionBlockCheck);
            this.terrainInterface.add(this.reverseBlockCheck);
            this.terrainInterface.add(this.hitSoundsButton);
            this.terrainInterface.add(this.blockedSoundsButton);
            this.setTerrainInterfaceEnabled();
            holdAttributesPane.add(this.terrainInterface);
            holdAttributesPane.add(this.hitstopInterface);
            this.victimHitstopSpinner.setEnabled(toHold.victimHitstopOverride);
            this.ownHitstopSpinner.setEnabled(toHold.ownHitstopOverride);
            this.hurtBoxInterface = new JPanel(new GridLayout(2, gridColumns, gridHorizontalGap, gridVerticalGap));
            this.hurtBoxInterface.setBorder(new TitledBorder("Hurt Box Attributes"));
            this.changeHurtBoxAttributesCheck = new JCheckBox("Change hurt box attributes this hold", toHold.changeHurtBoxAttributes);
            this.changeHurtBoxAttributesCheck.setToolTipText(changeHurtBoxAttributesTooltip);
            this.changeHurtBoxAttributesCheck.setActionCommand("changeHurtBoxAttributesChanged");
            this.changeHurtBoxAttributesCheck.addActionListener(this);
            JPanel changeHurtBoxAttributesInterface = new JPanel(new GridLayout(1, gridColumns, gridHorizontalGap, gridVerticalGap));
            changeHurtBoxAttributesInterface.add(this.changeHurtBoxAttributesCheck);
            holdAttributesPane.add(changeHurtBoxAttributesInterface);
            JLabel invulnerabilityComboLabel = new JLabel("Invulnerability");
            invulnerabilityComboLabel.setToolTipText(invulnerabilityTooltip);
            this.invulnerabilityCombo = new JComboBox<Invulnerability>(Invulnerability.values());
            this.invulnerabilityCombo.setToolTipText(invulnerabilityTooltip);
            this.invulnerabilityCombo.setSelectedItem((Object)toHold.invulnerability);
            this.invulnerabilityCombo.setActionCommand("fieldChanged");
            this.invulnerabilityCombo.addItemListener(this);
            JLabel superArmorHitsLabel = new JLabel("Super Armor Hits");
            superArmorHitsLabel.setToolTipText(superArmorHitsTooltip);
            this.superArmorHitsSpinner = new JSpinner(new SpinnerNumberModel(toHold.superArmorHits, 0, 99999, 1));
            this.superArmorHitsSpinner.setToolTipText(superArmorHitsTooltip);
            this.superArmorHitsSpinner.addChangeListener(this);
            JLabel superArmorDamageLabel = new JLabel("Super Armor Damage");
            superArmorDamageLabel.setToolTipText(superArmorDamageTooltip);
            this.superArmorDamageSpinner = new JSpinner(new SpinnerNumberModel(toHold.superArmorDamage, 0, 99999, 1));
            this.superArmorDamageSpinner.setToolTipText(superArmorDamageTooltip);
            this.superArmorDamageSpinner.addChangeListener(this);
            JLabel superArmorDamageScalingLabel = new JLabel("Super Armor Damage Scaling");
            superArmorDamageScalingLabel.setToolTipText(superArmorDamageScalingTooltip);
            this.superArmorDamageScalingSpinner = new JSpinner(new SpinnerNumberModel(toHold.superArmorDamageScaling, 0.0, 1.0, 0.1));
            this.superArmorDamageScalingSpinner.setToolTipText(superArmorDamageScalingTooltip);
            this.superArmorDamageScalingSpinner.addChangeListener(this);
            this.hurtBoxInterface.add(invulnerabilityComboLabel);
            this.hurtBoxInterface.add(this.invulnerabilityCombo);
            this.hurtBoxInterface.add(superArmorHitsLabel);
            this.hurtBoxInterface.add(this.superArmorHitsSpinner);
            this.hurtBoxInterface.add(superArmorDamageLabel);
            this.hurtBoxInterface.add(this.superArmorDamageSpinner);
            this.hurtBoxInterface.add(superArmorDamageScalingLabel);
            this.hurtBoxInterface.add(this.superArmorDamageScalingSpinner);
            holdAttributesPane.add(this.hurtBoxInterface);
            this.setHurtBoxInterfaceEnabled();
        }
        if (this.hold.IsPhysicsObjectHold()) {
            PhysicsObjectHold pHold = (PhysicsObjectHold)this.hold;
            this.changePhysicsCheck = new JCheckBox("Change Physics Attributes This Hold", pHold.changePhysics);
            this.changePhysicsCheck.setToolTipText(changePhysicsTooltip);
            this.changePhysicsCheck.setActionCommand("changePhysicsChanged");
            this.changePhysicsCheck.addActionListener(this);
            JPanel changePhysicsInterface = new JPanel(new GridLayout(1, gridColumns, gridHorizontalGap, gridVerticalGap));
            changePhysicsInterface.add(this.changePhysicsCheck);
            holdAttributesPane.add(changePhysicsInterface);
            this.ignoreGravityCheck = new JCheckBox("Ignore Gravity", pHold.ignoreGravity);
            this.ignoreGravityCheck.setActionCommand("ignoreGravityChanged");
            this.ignoreGravityCheck.addActionListener(this);
            this.physicsInterface = new JPanel(new GridLayout(1, gridColumns, gridHorizontalGap, gridVerticalGap));
            this.physicsInterface.setBorder(new TitledBorder("Physics Attributes"));
            this.physicsInterface.add(this.ignoreGravityCheck);
            this.setPhysicsInterfaceEnabled();
            holdAttributesPane.add(this.physicsInterface);
        }
        if (this.hold.IsFighterHold()) {
            FighterHold fHold = (FighterHold)this.hold;
            this.changeFighterAttributesCheck = new JCheckBox("Change fighter attributes this hold", fHold.changeFighterAttributes);
            this.changeFighterAttributesCheck.setToolTipText(changeFighterAttributesTooltip);
            this.changeFighterAttributesCheck.setActionCommand("changeFighterAttributesChanged");
            this.changeFighterAttributesCheck.addActionListener(this);
            JPanel changeFighterAttributesInterface = new JPanel(new GridLayout(1, gridColumns, gridHorizontalGap, gridVerticalGap));
            changeFighterAttributesInterface.add(this.changeFighterAttributesCheck);
            holdAttributesPane.add(changeFighterAttributesInterface);
            this.disableAirControlCheck = new JCheckBox("Disable Air Control", fHold.disableAirControl);
            this.disableAirControlCheck.setToolTipText(disableAirControlTooltip);
            this.disableAirControlCheck.setActionCommand("disableAirControlChanged");
            this.disableAirControlCheck.addActionListener(this);
            this.endAirDashCheck = new JCheckBox("End Air Dash", fHold.endAirDash);
            this.endAirDashCheck.setToolTipText(endAirDashTooltip);
            this.endAirDashCheck.setActionCommand("endAirDashChanged");
            this.endAirDashCheck.addActionListener(this);
            this.fighterAttributesInterface = new JPanel(new GridLayout(1, gridColumns, gridHorizontalGap, gridVerticalGap));
            this.fighterAttributesInterface.setSize(gridWidth, gridRowHeight * 7);
            this.fighterAttributesInterface.setBorder(new TitledBorder("Fighter Attributes"));
            this.fighterAttributesInterface.add(this.disableAirControlCheck);
            this.fighterAttributesInterface.add(this.endAirDashCheck);
            this.setFighterAttributesInterfaceEnabled();
            holdAttributesPane.add(this.fighterAttributesInterface);
            this.changeCancelsCheck = new JCheckBox("Change cancels this hold", fHold.changeCancels);
            this.changeCancelsCheck.setToolTipText(changeCancelsTooltip);
            this.changeCancelsCheck.setActionCommand("changeCancelsChanged");
            this.changeCancelsCheck.addActionListener(this);
            JPanel changeCancelsInterface = new JPanel(new GridLayout(1, gridColumns, gridHorizontalGap, gridVerticalGap));
            changeCancelsInterface.setSize(gridWidth, gridRowHeight);
            changeCancelsInterface.add(this.changeCancelsCheck);
            holdAttributesPane.add(changeCancelsInterface);
            JLabel dashCancelLabel = new JLabel("Dash");
            dashCancelLabel.setToolTipText(cancelTooltip);
            this.dashCancelCombo = new JComboBox<Cancel>(Cancel.values());
            this.dashCancelCombo.setToolTipText(cancelTooltip);
            this.dashCancelCombo.setSelectedItem((Object)fHold.cancels.dash);
            this.dashCancelCombo.setActionCommand("fieldChanged");
            this.dashCancelCombo.addItemListener(this);
            JLabel jumpCancelLabel = new JLabel("Jump");
            jumpCancelLabel.setToolTipText(cancelTooltip);
            this.jumpCancelCombo = new JComboBox<Cancel>(Cancel.values());
            this.jumpCancelCombo.setToolTipText(cancelTooltip);
            this.jumpCancelCombo.setSelectedItem((Object)fHold.cancels.jump);
            this.jumpCancelCombo.setActionCommand("fieldChanged");
            this.jumpCancelCombo.addItemListener(this);
            JLabel lightNeutralCancelLabel = new JLabel("Light Neutral");
            lightNeutralCancelLabel.setToolTipText(cancelTooltip);
            this.lightNeutralCancelCombo = new JComboBox<Cancel>(Cancel.values());
            this.lightNeutralCancelCombo.setToolTipText(cancelTooltip);
            this.lightNeutralCancelCombo.setSelectedItem((Object)fHold.cancels.lightNeutral);
            this.lightNeutralCancelCombo.setActionCommand("fieldChanged");
            this.lightNeutralCancelCombo.addItemListener(this);
            JLabel lightForwardCancelLabel = new JLabel("Light Forward");
            lightForwardCancelLabel.setToolTipText(cancelTooltip);
            this.lightForwardCancelCombo = new JComboBox<Cancel>(Cancel.values());
            this.lightForwardCancelCombo.setToolTipText(cancelTooltip);
            this.lightForwardCancelCombo.setSelectedItem((Object)fHold.cancels.lightForward);
            this.lightForwardCancelCombo.setActionCommand("fieldChanged");
            this.lightForwardCancelCombo.addItemListener(this);
            JLabel lightUpCancelLabel = new JLabel("Light Up");
            lightUpCancelLabel.setToolTipText(cancelTooltip);
            this.lightUpCancelCombo = new JComboBox<Cancel>(Cancel.values());
            this.lightUpCancelCombo.setToolTipText(cancelTooltip);
            this.lightUpCancelCombo.setSelectedItem((Object)fHold.cancels.lightUp);
            this.lightUpCancelCombo.setActionCommand("fieldChanged");
            this.lightUpCancelCombo.addItemListener(this);
            JLabel lightDownCancelLabel = new JLabel("Light Down");
            lightDownCancelLabel.setToolTipText(cancelTooltip);
            this.lightDownCancelCombo = new JComboBox<Cancel>(Cancel.values());
            this.lightDownCancelCombo.setToolTipText(cancelTooltip);
            this.lightDownCancelCombo.setSelectedItem((Object)fHold.cancels.lightDown);
            this.lightDownCancelCombo.setActionCommand("fieldChanged");
            this.lightDownCancelCombo.addItemListener(this);
            JLabel lightBackwardCancelLabel = new JLabel("Light Backward");
            lightBackwardCancelLabel.setToolTipText(cancelTooltip);
            this.lightBackwardCancelCombo = new JComboBox<Cancel>(Cancel.values());
            this.lightBackwardCancelCombo.setToolTipText(cancelTooltip);
            this.lightBackwardCancelCombo.setSelectedItem((Object)fHold.cancels.lightBackward);
            this.lightBackwardCancelCombo.setActionCommand("fieldChanged");
            this.lightBackwardCancelCombo.addItemListener(this);
            JLabel lightQCFCancelLabel = new JLabel("Light QCF");
            lightQCFCancelLabel.setToolTipText(cancelTooltip);
            this.lightQCFCancelCombo = new JComboBox<Cancel>(Cancel.values());
            this.lightQCFCancelCombo.setToolTipText(cancelTooltip);
            this.lightQCFCancelCombo.setSelectedItem((Object)fHold.cancels.lightQCF);
            this.lightQCFCancelCombo.setActionCommand("fieldChanged");
            this.lightQCFCancelCombo.addItemListener(this);
            JLabel heavyNeutralCancelLabel = new JLabel("Heavy Neutral");
            heavyNeutralCancelLabel.setToolTipText(cancelTooltip);
            this.heavyNeutralCancelCombo = new JComboBox<Cancel>(Cancel.values());
            this.heavyNeutralCancelCombo.setToolTipText(cancelTooltip);
            this.heavyNeutralCancelCombo.setSelectedItem((Object)fHold.cancels.heavyNeutral);
            this.heavyNeutralCancelCombo.setActionCommand("fieldChanged");
            this.heavyNeutralCancelCombo.addItemListener(this);
            JLabel heavyForwardCancelLabel = new JLabel("Heavy Forward");
            heavyForwardCancelLabel.setToolTipText(cancelTooltip);
            this.heavyForwardCancelCombo = new JComboBox<Cancel>(Cancel.values());
            this.heavyForwardCancelCombo.setToolTipText(cancelTooltip);
            this.heavyForwardCancelCombo.setSelectedItem((Object)fHold.cancels.heavyForward);
            this.heavyForwardCancelCombo.setActionCommand("fieldChanged");
            this.heavyForwardCancelCombo.addItemListener(this);
            JLabel heavyUpCancelLabel = new JLabel("Heavy Up");
            heavyUpCancelLabel.setToolTipText(cancelTooltip);
            this.heavyUpCancelCombo = new JComboBox<Cancel>(Cancel.values());
            this.heavyUpCancelCombo.setToolTipText(cancelTooltip);
            this.heavyUpCancelCombo.setSelectedItem((Object)fHold.cancels.heavyUp);
            this.heavyUpCancelCombo.setActionCommand("fieldChanged");
            this.heavyUpCancelCombo.addItemListener(this);
            JLabel heavyDownCancelLabel = new JLabel("Heavy Down");
            heavyDownCancelLabel.setToolTipText(cancelTooltip);
            this.heavyDownCancelCombo = new JComboBox<Cancel>(Cancel.values());
            this.heavyDownCancelCombo.setToolTipText(cancelTooltip);
            this.heavyDownCancelCombo.setSelectedItem((Object)fHold.cancels.heavyDown);
            this.heavyDownCancelCombo.setActionCommand("fieldChanged");
            this.heavyDownCancelCombo.addItemListener(this);
            JLabel heavyBackwardCancelLabel = new JLabel("Heavy Backward");
            heavyBackwardCancelLabel.setToolTipText(cancelTooltip);
            this.heavyBackwardCancelCombo = new JComboBox<Cancel>(Cancel.values());
            this.heavyBackwardCancelCombo.setToolTipText(cancelTooltip);
            this.heavyBackwardCancelCombo.setSelectedItem((Object)fHold.cancels.heavyBackward);
            this.heavyBackwardCancelCombo.setActionCommand("fieldChanged");
            this.heavyBackwardCancelCombo.addItemListener(this);
            JLabel heavyQCFCancelLabel = new JLabel("Heavy QCF");
            heavyQCFCancelLabel.setToolTipText(cancelTooltip);
            this.heavyQCFCancelCombo = new JComboBox<Cancel>(Cancel.values());
            this.heavyQCFCancelCombo.setToolTipText(cancelTooltip);
            this.heavyQCFCancelCombo.setSelectedItem((Object)fHold.cancels.heavyQCF);
            this.heavyQCFCancelCombo.setActionCommand("fieldChanged");
            this.heavyQCFCancelCombo.addItemListener(this);
            this.fighterInterface = new JPanel(new GridLayout(7, gridColumns, gridHorizontalGap, gridVerticalGap));
            this.fighterInterface.setSize(gridWidth, gridRowHeight * 7);
            this.fighterInterface.setBorder(new TitledBorder("Cancels"));
            this.fighterInterface.add(dashCancelLabel);
            this.fighterInterface.add(this.dashCancelCombo);
            this.fighterInterface.add(jumpCancelLabel);
            this.fighterInterface.add(this.jumpCancelCombo);
            this.fighterInterface.add(lightNeutralCancelLabel);
            this.fighterInterface.add(this.lightNeutralCancelCombo);
            this.fighterInterface.add(lightForwardCancelLabel);
            this.fighterInterface.add(this.lightForwardCancelCombo);
            this.fighterInterface.add(lightUpCancelLabel);
            this.fighterInterface.add(this.lightUpCancelCombo);
            this.fighterInterface.add(lightDownCancelLabel);
            this.fighterInterface.add(this.lightDownCancelCombo);
            this.fighterInterface.add(lightBackwardCancelLabel);
            this.fighterInterface.add(this.lightBackwardCancelCombo);
            this.fighterInterface.add(lightQCFCancelLabel);
            this.fighterInterface.add(this.lightQCFCancelCombo);
            this.fighterInterface.add(heavyNeutralCancelLabel);
            this.fighterInterface.add(this.heavyNeutralCancelCombo);
            this.fighterInterface.add(heavyForwardCancelLabel);
            this.fighterInterface.add(this.heavyForwardCancelCombo);
            this.fighterInterface.add(heavyUpCancelLabel);
            this.fighterInterface.add(this.heavyUpCancelCombo);
            this.fighterInterface.add(heavyDownCancelLabel);
            this.fighterInterface.add(this.heavyDownCancelCombo);
            this.fighterInterface.add(heavyBackwardCancelLabel);
            this.fighterInterface.add(this.heavyBackwardCancelCombo);
            this.fighterInterface.add(heavyQCFCancelLabel);
            this.fighterInterface.add(this.heavyQCFCancelCombo);
            this.setFighterInterfaceEnabled();
            holdAttributesPane.add(this.fighterInterface);
        }
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("okButton");
        okButton.addActionListener(this);
        JButton closeButton = new JButton("Close");
        closeButton.setActionCommand("closeButton");
        closeButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.setActionCommand("applyButton");
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        JScrollPane holdAttributesScrollPane = new JScrollPane(holdAttributesPane);
        holdAttributesScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        JPanel buttonPane = new JPanel(new FlowLayout(4));
        buttonPane.add(okButton);
        buttonPane.add(closeButton);
        buttonPane.add(this.applyButton);
        JPanel interfacePane = new JPanel();
        interfacePane.setLayout(new BoxLayout(interfacePane, 1));
        interfacePane.setBorder(new EmptyBorder(windowBorderBuffer, windowBorderBuffer, windowBorderBuffer, windowBorderBuffer));
        interfacePane.add(holdAttributesScrollPane);
        interfacePane.add(buttonPane);
        this.add(interfacePane);
    }

    private void setTerrainInterfaceEnabled() {
        if (this.hold.IsTerrainObjectHold()) {
            TerrainObjectHold toHold = (TerrainObjectHold)this.hold;
            this.terrainInterface.setEnabled(this.changeAttackBoxAttributesCheck.isSelected());
            Component[] components = this.terrainInterface.getComponents();
            int i = 0;
            while (i < components.length) {
                components[i].setEnabled(this.changeAttackBoxAttributesCheck.isSelected());
                ++i;
            }
        }
    }

    private void setHurtBoxInterfaceEnabled() {
        if (this.hold.IsTerrainObjectHold()) {
            TerrainObjectHold toHold = (TerrainObjectHold)this.hold;
            this.hurtBoxInterface.setEnabled(this.changeHurtBoxAttributesCheck.isSelected());
            Component[] components = this.hurtBoxInterface.getComponents();
            int i = 0;
            while (i < components.length) {
                components[i].setEnabled(this.changeHurtBoxAttributesCheck.isSelected());
                ++i;
            }
        }
    }

    private void setPhysicsInterfaceEnabled() {
        if (this.hold.IsPhysicsObjectHold()) {
            PhysicsObjectHold toHold = (PhysicsObjectHold)this.hold;
            this.physicsInterface.setEnabled(this.changePhysicsCheck.isSelected());
            Component[] components = this.physicsInterface.getComponents();
            int i = 0;
            while (i < components.length) {
                components[i].setEnabled(this.changePhysicsCheck.isSelected());
                ++i;
            }
        }
    }

    private void setFighterAttributesInterfaceEnabled() {
        if (this.hold.IsFighterHold()) {
            FighterHold fHold = (FighterHold)this.hold;
            this.fighterAttributesInterface.setEnabled(this.changeFighterAttributesCheck.isSelected());
            Component[] components = this.fighterAttributesInterface.getComponents();
            int i = 0;
            while (i < components.length) {
                components[i].setEnabled(this.changeFighterAttributesCheck.isSelected());
                ++i;
            }
        }
    }

    private void setFighterInterfaceEnabled() {
        if (this.hold.IsFighterHold()) {
            FighterHold fHold = (FighterHold)this.hold;
            this.fighterInterface.setEnabled(this.changeCancelsCheck.isSelected());
            Component[] components = this.fighterInterface.getComponents();
            int i = 0;
            while (i < components.length) {
                components[i].setEnabled(this.changeCancelsCheck.isSelected());
                ++i;
            }
        }
    }

    public void applyChanges() {
        this.hold.name = this.nameField.getText();
        this.hold.duration = (Integer)this.durationSpinner.getValue();
        this.hold.reposition.x = ((Number)this.repositionXSpinner.getValue()).floatValue();
        this.hold.reposition.y = ((Number)this.repositionYSpinner.getValue()).floatValue();
        this.hold.velocity.x = ((Number)this.velocityXSpinner.getValue()).floatValue();
        this.hold.velocity.y = ((Number)this.velocityYSpinner.getValue()).floatValue();
        this.hold.overwriteVelocity = this.overwriteVelocityCheck.isSelected();
        this.hold.nextHold = this.nextHoldCombo.getSelectedIndex() == 0 ? null : (HSObjectHold)this.nextHoldCombo.getSelectedItem();
        if (this.hold.IsTerrainObjectHold()) {
            ((TerrainObjectHold)this.hold).changeAttackBoxAttributes = this.changeAttackBoxAttributesCheck.isSelected();
            ((TerrainObjectHold)this.hold).damage = (Integer)this.damageSpinner.getValue();
            ((TerrainObjectHold)this.hold).ownHitstop = (Integer)this.ownHitstopSpinner.getValue();
            ((TerrainObjectHold)this.hold).ownHitstopOverride = this.ownHitstopOverride.isSelected();
            ((TerrainObjectHold)this.hold).victimHitstop = (Integer)this.victimHitstopSpinner.getValue();
            ((TerrainObjectHold)this.hold).victimHitstopOverride = this.victimHitstopOverride.isSelected();
            ((TerrainObjectHold)this.hold).hitstun = (Integer)this.hitstunSpinner.getValue();
            ((TerrainObjectHold)this.hold).blockstun = (Integer)this.blockstunSpinner.getValue();
            ((TerrainObjectHold)this.hold).force.x = ((Float)this.forceXSpinner.getValue()).floatValue();
            ((TerrainObjectHold)this.hold).force.y = ((Float)this.forceYSpinner.getValue()).floatValue();
            ((TerrainObjectHold)this.hold).trips = this.tripsCheck.isSelected();
            ((TerrainObjectHold)this.hold).resetHits = this.resetHitsCheck.isSelected();
            ((TerrainObjectHold)this.hold).blockability = (Blockability)((Object)this.blockabilityCombo.getSelectedItem());
            ((TerrainObjectHold)this.hold).hitLevel = (HitLevel)((Object)this.hitLevelCombo.getSelectedItem());
            ((TerrainObjectHold)this.hold).horizontalDirectionBasedBlock = this.directionBlockCheck.isSelected();
            ((TerrainObjectHold)this.hold).reversedHorizontalBlock = this.reverseBlockCheck.isSelected();
            ((TerrainObjectHold)this.hold).changeHurtBoxAttributes = this.changeHurtBoxAttributesCheck.isSelected();
            ((TerrainObjectHold)this.hold).superArmorHits = (Integer)this.superArmorHitsSpinner.getValue();
            ((TerrainObjectHold)this.hold).superArmorDamage = (Integer)this.superArmorDamageSpinner.getValue();
            ((TerrainObjectHold)this.hold).superArmorDamageScaling = new Float((Double)this.superArmorDamageScalingSpinner.getValue()).floatValue();
            ((TerrainObjectHold)this.hold).invulnerability = (Invulnerability)((Object)this.invulnerabilityCombo.getSelectedItem());
        }
        if (this.hold.IsPhysicsObjectHold()) {
            ((PhysicsObjectHold)this.hold).changePhysics = this.changePhysicsCheck.isSelected();
            ((PhysicsObjectHold)this.hold).ignoreGravity = this.ignoreGravityCheck.isSelected();
        }
        if (this.hold.IsFighterHold()) {
            ((FighterHold)this.hold).changeFighterAttributes = this.changeFighterAttributesCheck.isSelected();
            ((FighterHold)this.hold).disableAirControl = this.disableAirControlCheck.isSelected();
            ((FighterHold)this.hold).endAirDash = this.endAirDashCheck.isSelected();
            ((FighterHold)this.hold).changeCancels = this.changeCancelsCheck.isSelected();
            ((FighterHold)this.hold).cancels.dash = (Cancel)((Object)this.dashCancelCombo.getSelectedItem());
            ((FighterHold)this.hold).cancels.jump = (Cancel)((Object)this.jumpCancelCombo.getSelectedItem());
            ((FighterHold)this.hold).cancels.lightNeutral = (Cancel)((Object)this.lightNeutralCancelCombo.getSelectedItem());
            ((FighterHold)this.hold).cancels.lightForward = (Cancel)((Object)this.lightForwardCancelCombo.getSelectedItem());
            ((FighterHold)this.hold).cancels.lightUp = (Cancel)((Object)this.lightUpCancelCombo.getSelectedItem());
            ((FighterHold)this.hold).cancels.lightDown = (Cancel)((Object)this.lightDownCancelCombo.getSelectedItem());
            ((FighterHold)this.hold).cancels.lightBackward = (Cancel)((Object)this.lightBackwardCancelCombo.getSelectedItem());
            ((FighterHold)this.hold).cancels.lightQCF = (Cancel)((Object)this.lightQCFCancelCombo.getSelectedItem());
            ((FighterHold)this.hold).cancels.heavyNeutral = (Cancel)((Object)this.heavyNeutralCancelCombo.getSelectedItem());
            ((FighterHold)this.hold).cancels.heavyForward = (Cancel)((Object)this.heavyForwardCancelCombo.getSelectedItem());
            ((FighterHold)this.hold).cancels.heavyUp = (Cancel)((Object)this.heavyUpCancelCombo.getSelectedItem());
            ((FighterHold)this.hold).cancels.heavyDown = (Cancel)((Object)this.heavyDownCancelCombo.getSelectedItem());
            ((FighterHold)this.hold).cancels.heavyBackward = (Cancel)((Object)this.heavyBackwardCancelCombo.getSelectedItem());
            ((FighterHold)this.hold).cancels.heavyQCF = (Cancel)((Object)this.heavyQCFCancelCombo.getSelectedItem());
        }
        this.parent.repaint();
        this.setTitle("Hold Attributes - " + this.hold.name);
        this.applyButton.setEnabled(false);
        this.parent.removeHoldFromHoldList(this.holdPath);
        this.holdPath = new TreePath(this.parent.addHoldToTree(this.hold));
        this.parent.tree.makeVisible(this.holdPath);
        this.parent.tree.setSelectionPath(this.holdPath);
    }

    private void closeWindow() {
        this.dispose();
    }

    private void holdSoundsButtonPressed() {
        SoundsWindow window = new SoundsWindow(this, this.hold, "hold");
        window.setVisible(true);
    }

    private void spawnObjectsButtonPressed() {
        SpawnObjectsWindow window = new SpawnObjectsWindow(this, this.hold);
        window.setVisible(true);
    }

    private void okButtonPressed() {
        this.applyChanges();
        this.closeWindow();
    }

    private void closeButtonPressed() {
        this.closeWindow();
    }

    private void applyButtonPressed() {
        this.applyChanges();
    }

    public void fieldChanged() {
        this.applyButton.setEnabled(true);
    }

    private void changeAttackBoxAttributesChanged() {
        this.setTerrainInterfaceEnabled();
        this.fieldChanged();
    }

    private void changeHurtBoxAttributesChanged() {
        this.setHurtBoxInterfaceEnabled();
        this.fieldChanged();
    }

    private void changePhysicsChanged() {
        this.setPhysicsInterfaceEnabled();
        this.fieldChanged();
    }

    private void changeCancelsChanged() {
        this.setFighterInterfaceEnabled();
        this.fieldChanged();
    }

    private void changeFighterAttributesChanged() {
        this.setFighterAttributesInterfaceEnabled();
        this.fieldChanged();
    }

    private void hitSoundsButtonPressed() {
        SoundsWindow window = new SoundsWindow(this, this.hold, "hit");
        window.setVisible(true);
    }

    private void blockedSoundsButtonPressed() {
        SoundsWindow window = new SoundsWindow(this, this.hold, "blocked");
        window.setVisible(true);
    }

    private void overwriteVelocityChanged() {
        this.velocityXSpinner.setEnabled(this.overwriteVelocityCheck.isSelected());
        this.velocityYSpinner.setEnabled(this.overwriteVelocityCheck.isSelected());
    }

    private void ownHitstopOverrideChanged() {
        this.ownHitstopSpinner.setEnabled(this.ownHitstopOverride.isSelected());
    }

    private void victimHitstopOverrideChanged() {
        this.victimHitstopSpinner.setEnabled(this.victimHitstopOverride.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "holdSoundsButton": {
                this.holdSoundsButtonPressed();
                break;
            }
            case "spawnObjectsButton": {
                this.spawnObjectsButtonPressed();
                break;
            }
            case "okButton": {
                this.okButtonPressed();
                break;
            }
            case "closeButton": {
                this.closeButtonPressed();
                break;
            }
            case "applyButton": {
                this.applyButtonPressed();
                break;
            }
            case "fieldChanged": {
                this.fieldChanged();
                break;
            }
            case "overwriteVelocityChanged": {
                this.overwriteVelocityChanged();
                break;
            }
            case "changeAttackBoxAttributesChanged": {
                this.changeAttackBoxAttributesChanged();
                break;
            }
            case "changeHurtBoxAttributesChanged": {
                this.changeHurtBoxAttributesChanged();
                break;
            }
            case "changePhysicsChanged": {
                this.changePhysicsChanged();
            }
            case "changeCancelsChanged": {
                this.changeCancelsChanged();
                break;
            }
            case "changeFighterAttributesChanged": {
                this.changeFighterAttributesChanged();
                break;
            }
            case "hitSoundsButton": {
                this.hitSoundsButtonPressed();
                break;
            }
            case "blockedSoundsButton": {
                this.blockedSoundsButtonPressed();
                break;
            }
            case "ownHitstopOverrideChanged": {
                this.ownHitstopOverrideChanged();
                break;
            }
            case "victimHitstopOverrideChanged": {
                this.victimHitstopOverrideChanged();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fieldChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fieldChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fieldChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fieldChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fieldChanged();
    }
}

