/*
 * Decompiled with CFR 0.152.
 */
package homestrifeeditor.windows;

import homestrifeeditor.objects.HSObject;
import homestrifeeditor.objects.holds.properties.HSPalette;
import homestrifeeditor.windows.EditorWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PalettesWindow
extends JFrame
implements KeyListener,
ActionListener,
ListSelectionListener,
MouseListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private static int windowWidth = 400;
    private static int windowHeight = 200;
    private Object object;
    private JFrame parent;
    private boolean loading;
    public DefaultListModel<HSPalette> paletteListModel;
    public JList<HSPalette> paletteList;
    private JToolBar paletteListToolBar;
    private JLabel paletteFile;
    private JButton changePaletteButton;
    private static String changePaletteTooltip = "<html>Load a palette from the hard drive.</html>";
    private JTextField paletteNameTextBox;
    private static String paletteNameTooltip = "<html>The name of the palette</html>";
    private JSpinner idSpinner;

    public PalettesWindow(JFrame theParent, Object obj) {
        this.object = obj;
        this.parent = theParent;
        this.loading = false;
        this.setTitle("Palettes");
        this.setSize(windowWidth, windowHeight);
        this.setLocationRelativeTo(null);
        this.createWindowContents();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ((EditorWindow)PalettesWindow.this.parent).updatePalettesMenu(true);
            }
        });
    }

    private void createWindowContents() {
        JLabel paletteListLabel = new JLabel("Palette List");
        this.paletteListModel = new DefaultListModel();
        this.paletteList = new JList<HSPalette>(this.paletteListModel);
        this.paletteList.setName("paletteList");
        this.paletteList.addListSelectionListener(this);
        this.paletteList.addMouseListener(this);
        JScrollPane holdListScrollPane = new JScrollPane(this.paletteList);
        JButton addPaletteButton = new JButton("+");
        addPaletteButton.setActionCommand("addPalette");
        addPaletteButton.setToolTipText("Add New Palette");
        addPaletteButton.addActionListener(this);
        JButton removePaletteButton = new JButton("-");
        removePaletteButton.setActionCommand("removePalette");
        removePaletteButton.setToolTipText("Remove Selected Palette(s)");
        removePaletteButton.addActionListener(this);
        this.paletteListToolBar = new JToolBar();
        this.paletteListToolBar.setFloatable(false);
        this.paletteListToolBar.add(addPaletteButton);
        this.paletteListToolBar.add(removePaletteButton);
        JPanel paletteListPane = new JPanel();
        paletteListPane.setLayout(new BorderLayout());
        paletteListPane.add((Component)paletteListLabel, "First");
        paletteListPane.add((Component)holdListScrollPane, "Center");
        paletteListPane.add((Component)this.paletteListToolBar, "Last");
        JLabel paletteFileLabel = new JLabel("File:");
        this.paletteFile = new JLabel("N/A");
        this.changePaletteButton = new JButton("Change Palette...");
        this.changePaletteButton.setToolTipText(changePaletteTooltip);
        this.changePaletteButton.setActionCommand("changePalette");
        this.changePaletteButton.setEnabled(false);
        this.changePaletteButton.addActionListener(this);
        this.paletteNameTextBox = new JTextField("");
        this.paletteNameTextBox.setEnabled(false);
        this.paletteNameTextBox.setActionCommand("changeName");
        this.paletteNameTextBox.addActionListener(this);
        this.paletteNameTextBox.addKeyListener(this);
        JLabel nameLabel = new JLabel("Name");
        nameLabel.setToolTipText(paletteNameTooltip);
        JLabel idLabel = new JLabel("ID");
        this.idSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        this.idSpinner.addChangeListener(this);
        this.idSpinner.setEnabled(false);
        JPanel paletteDataPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        paletteDataPane.add((Component)paletteFileLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        paletteDataPane.add((Component)this.paletteFile, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.ipady = 20;
        gbc.fill = 2;
        paletteDataPane.add((Component)this.changePaletteButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.ipady = 0;
        gbc.fill = 2;
        paletteDataPane.add((Component)nameLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.ipady = 0;
        gbc.fill = 2;
        paletteDataPane.add((Component)this.paletteNameTextBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.ipady = 0;
        gbc.fill = 2;
        paletteDataPane.add((Component)idLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.ipady = 0;
        gbc.fill = 2;
        paletteDataPane.add((Component)this.idSpinner, gbc);
        JSplitPane sPane = new JSplitPane(1, paletteListPane, paletteDataPane);
        sPane.setDividerLocation(100);
        this.setContentPane(sPane);
        for (HSPalette p : ((HSObject)this.object).palettes) {
            this.paletteListModel.addElement(p);
        }
    }

    private void addPaletteToPaletteList() {
        int returnVal = EditorWindow.fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File file = EditorWindow.fileChooser.getSelectedFile();
        int index = this.paletteList.getSelectedIndex();
        this.paletteList.clearSelection();
        HSPalette newPalette = new HSPalette("New Palette", file.getPath(), this.paletteList.getSelectedIndex());
        ((HSObject)this.object).palettes.add(newPalette);
        if (index >= 0) {
            this.paletteListModel.add(index, newPalette);
            this.paletteList.setSelectedIndex(index);
        } else {
            this.paletteListModel.addElement(newPalette);
            this.paletteList.setSelectedIndex(this.paletteListModel.getSize() - 1);
        }
        ((EditorWindow)this.parent).updatePalettesMenu();
    }

    public HSPalette removePaletteFromPaletteList(int index) {
        HSPalette pal = this.paletteListModel.remove(index);
        ((HSObject)this.object).palettes.remove(pal);
        ((EditorWindow)this.parent).updatePalettesMenu();
        return pal;
    }

    public ArrayList<HSPalette> removePalettesFromPaletteList(int[] indices) {
        ArrayList<HSPalette> removedPalettes = new ArrayList<HSPalette>();
        Arrays.sort(indices, 0, indices.length - 1);
        int i = indices.length - 1;
        while (i >= 0) {
            removedPalettes.add(0, this.removePaletteFromPaletteList(indices[i]));
            --i;
        }
        ((EditorWindow)this.parent).updatePalettesMenu();
        return removedPalettes;
    }

    public ArrayList<HSPalette> removeSelectedPaletteFromPaletteList() {
        int n = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the selected palette(s)?", "Delete Palette(s)", 0);
        if (n == 0) {
            this.unloadPaletteData();
            return this.removePalettesFromPaletteList(this.paletteList.getSelectedIndices());
        }
        return null;
    }

    private void unloadPaletteData() {
        this.loading = true;
        this.paletteFile.setText("N/A");
        this.changePaletteButton.setEnabled(false);
        this.paletteNameTextBox.setText("");
        this.paletteNameTextBox.setEnabled(false);
        this.loading = false;
    }

    private void loadPaletteData(HSPalette pal) {
        this.loading = true;
        File file = new File(pal.path);
        this.paletteFile.setText(file.getName());
        this.paletteFile.setToolTipText(file.getPath());
        this.changePaletteButton.setEnabled(true);
        this.paletteNameTextBox.setText(pal.name);
        this.paletteNameTextBox.setEnabled(true);
        this.idSpinner.setValue(pal.id);
        this.idSpinner.setEnabled(true);
        this.loading = false;
    }

    private void changePalette() {
        int returnVal = EditorWindow.fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File file = EditorWindow.fileChooser.getSelectedFile();
        int index = this.paletteList.getSelectedIndex();
        HSPalette pal = this.paletteListModel.get(index);
        if (pal != null) {
            pal.path = file.getPath();
            this.paletteFile.setText(file.getName());
            this.paletteFile.setToolTipText(file.getPath());
        }
        this.paletteList.repaint();
        ((EditorWindow)this.parent).updatePalettesMenu();
    }

    private void changeName() {
        int index = this.paletteList.getSelectedIndex();
        HSPalette pal = this.paletteListModel.get(index);
        if (pal != null) {
            pal.name = this.paletteNameTextBox.getText();
        }
        this.paletteList.repaint();
        ((EditorWindow)this.parent).updatePalettesMenu();
    }

    private void updateId() {
        this.paletteListModel.get((int)this.paletteList.getSelectedIndex()).id = (Integer)this.idSpinner.getValue();
        this.paletteList.repaint();
        ((EditorWindow)this.parent).updatePalettesMenu();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "addPalette": {
                this.addPaletteToPaletteList();
                break;
            }
            case "removePalette": {
                this.removeSelectedPaletteFromPaletteList();
                break;
            }
            case "changePalette": {
                this.changePalette();
                break;
            }
            case "changeName": {
                this.changeName();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.unloadPaletteData();
            if (this.paletteList.getSelectedIndex() >= 0) {
                this.loadPaletteData(this.paletteList.getSelectedValue());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateId();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.changeName();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.changeName();
    }
}

