#include "hsobject.h"

list<string> GetStringParts(list<string> parts, string toSplit, string splitToken)
{
	if(toSplit.empty()) { return parts; }

	string part = toSplit.substr(0, toSplit.find_first_of(splitToken));
	parts.push_back(part);

	if(part.compare(toSplit) == 0) { return parts; }

	string remaining = toSplit.substr(toSplit.find_first_of(splitToken) + splitToken.length(), toSplit.length());
	parts = GetStringParts(parts, remaining, splitToken);

	return parts;
}

list<string> SplitString(string toSplit, string splitToken)
{
	list<string> parts;
	parts.clear();

	if(splitToken.empty())
	{
		parts.push_back(toSplit);
		return parts;
	}

	parts = GetStringParts(parts, toSplit, splitToken);

	return parts;
}

string CreateAbsolutePath(string baseDirectory, string relPath)
{
	list<string> baseDirectoryParts = SplitString(baseDirectory, "\\");
	list<string> relPathParts = SplitString(relPath, "\\");

	//get the number of double periods
	int doublePeriods = 0;
	list<string>::iterator stIt;
	for ( stIt=relPathParts.begin(); stIt != relPathParts.end(); stIt++)
	{
		if((*stIt).compare("..") == 0)
		{
			doublePeriods++;
		}
		else
		{
			break;
		}
	}

	//get base directory parts up to the double periods
	string absolutePath = "";
	int cur = 0;
	int max = baseDirectoryParts.size() - doublePeriods;
	for ( stIt=baseDirectoryParts.begin(); stIt != baseDirectoryParts.end(); stIt++)
	{
		if(cur > 0)
		{
			absolutePath += "\\";
		}
		absolutePath += (*stIt);
		cur++;
		if(cur >= max)
		{
			break;
		}
	}

	//get the relative path parts past the double periods
	cur = 0;
	max = relPathParts.size();
	for ( stIt=relPathParts.begin(); stIt != relPathParts.end(); stIt++)
	{
		if(cur >= doublePeriods)
		{
			absolutePath += "\\" + (*stIt);
		}
	}

	return absolutePath;
}

/////////
//HSBox//
/////////

int DefineBox(XMLElement * definition, HSBox * newBox)
{
	if(definition->QueryFloatAttribute("height", &(newBox->height)) != XML_NO_ERROR)
	{
		UpdateLog("No height defined on new hitbox.", true);
		return -1; //no height defined
	}
	if(definition->QueryFloatAttribute("width", &(newBox->width)) != XML_NO_ERROR)
	{
		UpdateLog("No width defined on new hitbox.", true);
		return -1; //no width defined
	}

	newBox->offset.x = 0;
	definition->QueryFloatAttribute("offsetX", &(newBox->offset.x));

	newBox->offset.y = 0;
	definition->QueryFloatAttribute("offsetY", &(newBox->offset.y));

	/*newBox->isTriangle = false;
	definition->QueryBoolAttribute("isTriangle", &(newBox->isTriangle));
					
	newBox->rightAlign = false;
	newBox->bottomAlign = false;
	if(newBox->isTriangle)
	{
		definition->QueryBoolAttribute("rightAlign", &(newBox->rightAlign));

		definition->QueryBoolAttribute("bottomAlign", &(newBox->bottomAlign));
	}*/

	return 0;
}

////////////////
//HSObjectHold//
////////////////

HSObjectHold::HSObjectHold()
{
	id = 0;
	nextHoldId = 0;
	textures.clear();
	audioList.clear();
	nextHold = NULL;
	nextListHold = NULL;

	duration = 0;
}

HSObjectHold::~HSObjectHold()
{

}

int HSObjectHold::Define(XMLElement * definition, string defFileDirectory, list<HSTexture*> * textureRegistry, list<HSAudio*> * audioRegistry, SDL_AudioSpec * obtainedAudioSpec)
{
	//get the hold's settings
	if(definition->QueryUnsignedAttribute("id", &(id)) != XML_NO_ERROR)
	{
		UpdateLog("No ID defined on new hold.", true);
		return -1; //no id defined
	}
	definition->QueryUnsignedAttribute("nextHoldId", &(nextHoldId)); //nextHold can be undefined
	definition->QueryUnsignedAttribute("duration", &(duration)); //duration can be undefined

	//loop through the hold's textures
	XMLElement * textures;
	if((textures = definition->FirstChildElement("Textures")) != NULL)
	{
		for(XMLElement * k = textures->FirstChildElement(); k != NULL; k = k->NextSiblingElement())
		{
			//check the element name
			if(strcmp(k->Value(), "Texture") == 0)
			{
				//add the texture to the hold
				if(int error = AddTexture(k, defFileDirectory, textureRegistry) != 0)
				{
					return error; //there was an error adding the texture
				}
			}
		}
	}

	//loop through the hold's audio
	XMLElement * audioList;
	if((audioList = definition->FirstChildElement("AudioList")) != NULL)
	{
		for(XMLElement * k = audioList->FirstChildElement(); k != NULL; k = k->NextSiblingElement())
		{
			//check the element name
			if(strcmp(k->Value(), "Audio") == 0)
			{
				//add the audio to the hold
				if(int error = AddAudio(k, defFileDirectory, audioRegistry, obtainedAudioSpec) != 0)
				{
					return error; //there was an error adding the audio
				}
			}
		}
	}

	return 0;
}

int HSObjectHold::AddTexture(XMLElement * texture, string defFileDirectory, list<HSTexture*> * textureRegistry)
{
	//get the file path
	string textureFilePath = CreateAbsolutePath(defFileDirectory, texture->Attribute("textureFilePath"));

	TextureInstance newTexInst;

	//see if the texture has already been loaded
	list<HSTexture*>::iterator trIt;
	bool texNotLoaded = true;
	for ( trIt=(*textureRegistry).begin(); trIt != (*textureRegistry).end(); trIt++)
	{
		if((*trIt)->textureFilePath.compare(textureFilePath) == 0)
		{
			//texture has been loaded
			newTexInst.hsTex = (*trIt);
			(*trIt)->usingCount++;
			texNotLoaded = false;
			break;
		}
	}

	if(texNotLoaded)
	{
		//texture hasn't been loaded before, so load it
		HSTexture * newTex = new HSTexture();
		newTex->usingCount = 1;
		newTex->textureFilePath = textureFilePath;

		if(int error = LoadTGAToTexture(newTex) != 0) //load the texture
		{
			return error;
		}

		newTexInst.hsTex = newTex;
		textureRegistry->push_back(newTex);
	}
	
	newTexInst.offset.x = 0;
	newTexInst.offset.y = 0;
	newTexInst.depth = 0;
	newTexInst.hScale = 1;
	newTexInst.vScale = 1;
	texture->QueryFloatAttribute("offsetX", &(newTexInst.offset.x));
	texture->QueryFloatAttribute("offsetY", &(newTexInst.offset.y));
	texture->QueryIntAttribute("depth", &(newTexInst.depth));
	textures.push_back(newTexInst);

	return 0;
}

int HSObjectHold::AddAudio(XMLElement * audio, string defFileDirectory, list<HSAudio*> * audioRegistry, SDL_AudioSpec * obtainedAudioSpec)
{
	//get the file path
	string audioFilePath = CreateAbsolutePath(defFileDirectory, audio->Attribute("audioFilePath"));

	AudioInstance newAudInst;

	//see if the audio has already been loaded
	list<HSAudio*>::iterator arIt;
	bool audNotLoaded = true;
	for ( arIt=(*audioRegistry).begin(); arIt != (*audioRegistry).end(); arIt++)
	{
		if((*arIt)->audioFilePath.compare(audioFilePath) == 0)
		{
			//audio has been loaded
			newAudInst.hsAud = (*arIt);
			(*arIt)->usingCount++;
			audNotLoaded = false;
			break;
		}
	}

	if(audNotLoaded)
	{
		//audio hasn't been loaded before, so load it
		HSAudio * newAud = new HSAudio();
		newAud->usingCount = 1;
		newAud->audioFilePath = audioFilePath;

		if(int error = LoadWAVToAudio(newAud, obtainedAudioSpec) != 0) //load the audio
		{
			return error;
		}

		newAudInst.hsAud = newAud;
		audioRegistry->push_back(newAud);
	}
	
	newAudInst.delay = 0;
	audio->QueryIntAttribute("delay", &(newAudInst.delay));
	audioList.push_back(newAudInst);

	return 0;
}

////////////
//HSObject//
////////////

HSObject::HSObject()
{
	id = 0;
	//player = -1;
	palettes.clear();
	palette = NULL;
	firstHold = NULL;
	lastHold = NULL;
	curHold = NULL;
	hFlip = false;
	lifetime = 0;
	time = 0;
	holdTime = 0;
	toDelete = false;
	pos.x = 0;
	pos.y = 0;
	prevPos.x = 0;
	prevPos.y = 0;
	vel.x = 0;
	vel.y = 0;
	prevVel.x = 0;
	prevVel.y = 0;
	hsObjectEventHolds.lifetimeDeath = NULL;
}

HSObject::~HSObject()
{
	HSObjectHold * curHold = firstHold;
	HSObjectHold * nextHold;

	while(curHold != NULL)
	{
		nextHold = curHold->nextListHold;
		delete curHold;
		curHold = nextHold;
	}
}

int HSObject::Define(XMLElement * definition, string defFileDirectory, list<HSTexture*> * textureRegistry, list<HSPalette*> * paletteRegistry, list<HSAudio*> * audioRegistry, SDL_AudioSpec * obtainedAudioSpec)
{
	//get the HSObject's settings
	//get the lifetime
	definition->QueryUnsignedAttribute("lifetime", &(lifetime)); //lifetime can be undefined

	//get the specified palette
	//string palFilePath = "";
	//if(palette > 0)
	//{
	//	if(palette == 1)		{ palFilePath = definition->Attribute("palette1FilePath"); }
	//	else if(palette == 2)	{ palFilePath = definition->Attribute("palette2FilePath"); }
	//	else if(palette == 3)	{ palFilePath = definition->Attribute("palette3FilePath"); }
	//	else if(palette == 4)	{ palFilePath = definition->Attribute("palette4FilePath"); }
	//	else if(palette == 5)	{ palFilePath = definition->Attribute("palette5FilePath"); }
	//	else if(palette == 6)	{ palFilePath = definition->Attribute("palette6FilePath"); }
	//	else if(palette == 7)	{ palFilePath = definition->Attribute("palette7FilePath"); }
	//	else if(palette == 8)	{ palFilePath = definition->Attribute("palette8FilePath"); }
	//	else if(palette == 9)	{ palFilePath = definition->Attribute("palette9FilePath"); }
	//	else if(palette == 10)	{ palFilePath = definition->Attribute("palette10FilePath"); }

	//	//the file path assumes a starting point of the location of the definition. So add that on.
	//	if(!defFileDirectory.empty())
	//	{
	//		palFilePath = defFileDirectory + "\\" + palFilePath;
	//		
	//		//see if the palette has already been loaded
	//		bool alreadyLoaded = false;
	//		list<HSPalette*>::iterator plIt;
	//		for ( plIt=(*paletteRegistry).begin(); plIt != (*paletteRegistry).end(); plIt++)
	//		{
	//			if((*plIt)->paletteFilePath.compare(palFilePath) == 0)
	//			{
	//				this->palette = (*plIt);
	//				this->palette->usingCount++;
	//				alreadyLoaded = true;
	//			}
	//		}

	//		if(!alreadyLoaded)
	//		{
	//			//make a new palette
	//			HSPalette * newPal = new HSPalette();
	//			newPal->usingCount = 1;
	//			newPal->paletteFilePath = palFilePath;

	//			if(int error = LoadHSPToPalette(newPal) != 0) //load the texture
	//			{
	//				return error;
	//			}

	//			this->palette = newPal;
	//			paletteRegistry->push_back(newPal);
	//		}
	//	}
	//}

	//get every available palette for this object
	string palletesDirectory = defFileDirectory + "\\palettes\\*";
	HANDLE hFind = INVALID_HANDLE_VALUE;
    WIN32_FIND_DATA ffd;
	hFind = FindFirstFile(palletesDirectory.data(), &ffd);

	if(INVALID_HANDLE_VALUE != hFind)
	{
		do
		{
			//skip this if it's a directory
			if(ffd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) { continue; }

			string filename = ffd.cFileName;

			//skip this if it's not a .hsp
			if(filename.find(".hsp", 0) == string::npos) { continue; }

			string palFilePath = defFileDirectory + "\\palettes\\" + filename;
			
			//see if the palette has already been loaded
			bool alreadyLoaded = false;
			list<HSPalette*>::iterator plIt;
			for ( plIt=(*paletteRegistry).begin(); plIt != (*paletteRegistry).end(); plIt++)
			{
				if((*plIt)->paletteFilePath.compare(palFilePath) == 0)
				{
					palettes.push_back((*plIt));
					alreadyLoaded = true;
					break;
				}
			}

			if(!alreadyLoaded)
			{
				//make a new palette
				HSPalette * newPal = new HSPalette();
				newPal->usingCount = 0;
				newPal->paletteFilePath = palFilePath;

				if(int error = LoadHSPToPalette(newPal) != 0) //load the texture
				{
					return error;
				}

				paletteRegistry->push_back(newPal);
				palettes.push_back(newPal);
			}
		}
		while(FindNextFile(hFind, &ffd) != 0);
	}

	//get a palette that isn't used
	list<HSPalette*>::iterator plIt;
	for ( plIt=palettes.begin(); plIt != palettes.end(); plIt++)
	{
		if((*plIt)->usingCount <= 0)
		{
			palette = (*plIt);
			(*plIt)->usingCount++;
			break;
		}
	}

	//if all palettes are used, just get the first one
	if(palette == NULL && !palettes.empty())
	{
		palette = palettes.front();
		palette->usingCount++;
	}

	//loop through the object's holds
	XMLElement * holds;
	if((holds = definition->FirstChildElement("Holds")) == NULL)
	{
		UpdateLog("No holds defined on new object.", true);
		return -1; //no holds!
	}
	for(XMLElement * j = holds->FirstChildElement(); j != NULL; j = j->NextSiblingElement())
	{
		//check the element name
		if(strcmp(j->Value(), "Hold") != 0)
		{
			continue; //there's a mal-formed element in the hold list
		}

		//create a new hold
		HSObjectHold * newHold = CreateNewHold();
		newHold->nextHold = NULL;
		newHold->nextListHold = NULL;

		//execute the hold's local definition code
		if(int error = newHold->Define(j, defFileDirectory, textureRegistry, audioRegistry, obtainedAudioSpec) != 0)
		{
			return error; //there was an error defining the hold
		}

		//save event hold pointers, if necessary
		XMLElement * eventHolds = definition->FirstChildElement("EventHolds");
		if((eventHolds = definition->FirstChildElement("EventHolds")) != NULL)
		{
			if(int error = SaveEventHolds(newHold, eventHolds) != 0)
			{
				return error; //there was an error defining the hold
			}
		}

		//add the new hold to the list of holds
		if(int error = AddHold(newHold) != 0)
		{
			return error; //there was an error adding the hold
		}
	}
	
	//link all the holds in this object
	if(int error = LinkHolds() != 0)
	{
		return error; //there was an error linking the holds
	}

	return 0;
}

HSObjectHold * HSObject::CreateNewHold()
{
	HSObjectHold * newHold = new HSObjectHold();

	return newHold;
}

int HSObject::SaveEventHolds(HSObjectHold * hold, XMLElement * eventHolds)
{
	//check the attribute names, and put the hold pointers into the proper event hold slots.
	unsigned int eventHoldId;
	eventHolds->QueryUnsignedAttribute("lifetimeDeath", &eventHoldId);
	if(hold->id == eventHoldId) { hsObjectEventHolds.lifetimeDeath = (HSObjectHold*)hold; }

	return 0;
}

int HSObject::AddHold(HSObjectHold * newHold)
{
	if(firstHold == NULL)
	{
		//just make the new hold the first hold
		firstHold = newHold;
		lastHold = newHold;
	}
	else
	{
		//put the new hold at the end of the list
		lastHold->nextListHold = newHold;
		lastHold = newHold;
	}

	return 0;
}

int HSObject::LinkHolds()
{
	for(HSObjectHold * i = firstHold; i != NULL; i = i->nextListHold)
	{
		if(i->nextHoldId > 0)
		{
			for(HSObjectHold * j = firstHold; j != NULL; j = j->nextListHold)
			{
				if(j->id == i->nextHoldId)
				{
					i->nextHold = j;
					break;
				}
			}
			if(i->nextHold == NULL)
			{
				UpdateLog("Next hold not found when linking holds.", true);
				return -1; //the nextHold wasn't found
			}
		}
	}

	return 0;
}

int HSObject::AdvanceHolds()
{
	//handle holds
	if(curHold->duration > 0)
	{
		holdTime++;
		if(holdTime >= curHold->duration)
		{
			ChangeHold(curHold->nextHold);
		}
	}

	return 0;
}

int HSObject::Event(InputStates * inputHistory, int frame)
{
	return 0;
}

int HSObject::Update()
{
	//save the current position
	prevPos.x = pos.x;
	prevPos.y = pos.y;

	//move according to velocity
	pos.x += vel.x;
	pos.y += vel.y;

	prevVel.x = vel.x;
	prevVel.y = vel.y;

	//handle lifetime
	if(lifetime > 0)
	{
		time++;
		if(time > lifetime)
		{
			toDelete = true;
		}
	}

	return 0;
}

bool HSObject::ChangeHold(HSObjectHold* hold)
{
	holdTime = 0;
	curHold = hold;
	if(curHold == NULL)
	{
		curHold = GetDefaultHold();
		return false;
	}

	return true;
}

HSObjectHold * HSObject::GetDefaultHold()
{
	return firstHold;
}

int HSObject::CollideTerrain(list<HSObject*> * gameObjects)
{
	return 0;
}

int HSObject::CollideAttack(list<HSObject*> * gameObjects)
{
	return 0;
}

void HSObject::ApplyAttackResults()
{
	return;
}

void HSObject::HandleHurtCollision(HSObject * attacker)
{
	return;
}

list<HSAudio*> HSObject::GetAudio()
{
	list<HSAudio*> audio;
	audio.clear();

	list<AudioInstance>::iterator audIt;
	for ( audIt=curHold->audioList.begin(); audIt != curHold->audioList.end(); audIt++)
	{
		if(holdTime == (*audIt).delay)
		{
			audio.push_back((*audIt).hsAud);
		}
	}

	return audio;
}

bool HSObject::IsTerrain()
{
	return false;
}

bool HSObject::IsTerrainObject()
{
	return false;
}

bool HSObject::IsPhysicsObject()
{
	return false;
}

bool HSObject::IsFighter()
{
	return false;
}