#ifndef __HSOBJECT_H_
#define __HSOBJECT_H_

//this only works for windows!
#include <direct.h>
#define GetCurrentWorkingDirectory _getcwd

#include <list>
#include "texture.h"
#include "audio.h"
#include "tinyxml2.h"
using namespace tinyxml2;
using std::list;

list<string> GetStringParts(list<string> parts, string toSplit, string splitToken);
list<string> SplitString(string toSplit, string splitToken);
string CreateAbsolutePath(string baseDirectory, string relPath);

struct TextureInstance
{
	HSTexture * hsTex;
	HSVect2D offset; //offset from the position of the object that owns this texture
	int depth; //how far in front or back it should be drawn
	float hScale; //horizontal scaling
	float vScale; //vertical scaling
};

struct AudioInstance
{
	HSAudio * hsAud;
	int delay; //number of frames to wait before actually playing it
};

struct InputState
{
	bool pressed;
	bool held;
	bool released;
};

struct InputStates
{
	//every bool array signifies if an input is pressed, held, or released in the current frame, in that order
	//keyboard input states
	InputState bKeyUp;
	InputState bKeyDown;
	InputState bKeyLeft;
	InputState bKeyRight;
	InputState bKeyJump;
	InputState bKeyBlock;
	InputState bKeyLight;
	InputState bKeyHeavy;
	InputState bKeyStart;
	InputState bKeySelect;

	//joystic button input states
	InputState bButtonUp;
	InputState bButtonDown;
	InputState bButtonLeft;
	InputState bButtonRight;
	InputState bButtonJump;
	InputState bButtonBlock;
	InputState bButtonLight;
	InputState bButtonHeavy;
	InputState bButtonStart;
	InputState bButtonSelect;

	//stick input states
	InputState bStickUp;
	InputState bStickDown;
	InputState bStickLeft;
	InputState bStickRight;
	InputState bStickHardUp;
	InputState bStickHardDown;
	InputState bStickHardLeft;
	InputState bStickHardRight;

	//hat input states
	InputState bHatUp;
	InputState bHatDown;
	InputState bHatLeft;
	InputState bHatRight;

	//previous input states
	InputStates * prevInputState;

	//frame in which this input state was created
	int frame;
};

struct HSBox //a rectangle hitbox
{
	HSBox * nextBox; //next box in this list of boxes
	float height;
	float width;
	HSVect2D offset; //offset from the position of the object that owns this box
	bool isTriangle; //whether or not this box is a triangle
	bool rightAlign; //whether or not the triangle's right angle is to the right
	bool bottomAlign; //wheather or not the traingle's right angle is at the top
};

int DefineBox(XMLElement * definition, HSBox * newBox);

class HSObjectHold //a single segment of an animation. can actually last for multiple frames
{
public:
	unsigned int id; //the id number of the hold
	unsigned int nextHoldId; //the id number of the intended nextHold
	list<TextureInstance> textures; //textures in this hold
	list<AudioInstance> audioList; //sounds in this hold 
	HSObjectHold * nextHold; //the hold to change to when this one's duration is reached
	HSObjectHold * nextListHold; //the next hold in the list of holds

	unsigned int duration; //how many frames this hold lasts (based on 60fps)

	HSObjectHold();
	~HSObjectHold();

	virtual int Define(XMLElement * definition, string defFileDirectory, list<HSTexture*> * textureRegistry, list<HSAudio*> * audioRegistry, SDL_AudioSpec * obtainedAudioSpec); //initialize this hold based on definition file info

protected:
	int AddTexture(XMLElement * texture, string defFileDirectory, list<HSTexture*> * textureRegistry); //add a texture to the list of textures
	int AddAudio(XMLElement * audio, string defFileDirectory, list<HSAudio*> * audioRegistry, SDL_AudioSpec * obtainedAudioSpec); //add a piece of audio to be played with the hold
};

struct HSObjectEventHolds
{
	HSObjectHold * lifetimeDeath;
};

class HSObject
{
public:
	unsigned int id; //the object's id. Every object should have a unique id

	//int player; //player currently in control of this object. -1 means no player controls this
	
	list<HSPalette*> palettes; //all of the object's palettes
	HSPalette * palette; //current palette
	HSObjectHold * firstHold; //the first of a list of all of the object's animation holds
	HSObjectHold * lastHold; //the last of the list
	HSObjectHold * curHold; //the object's current animation hold

	bool hFlip; //whether or not this object's textures should be flipped horizontally about the current position

	unsigned int lifetime; //how long the object exists. 0 means it exists forever
	unsigned int time; //how long the object has existed
	unsigned int holdTime; //how long since curHold has been changed
	bool toDelete; //whether or not the object needs to be removed from the game
	HSVect2D pos; //the object's current position
	HSVect2D prevPos; //the object's previous position
	HSVect2D vel; //the object's velocity
	HSVect2D prevVel; //the object's previous velocity

	//the holds this object moves to upon particular events
	HSObjectEventHolds hsObjectEventHolds;

	HSObject();
	~HSObject();

	virtual int Define(XMLElement * definition, string defFileDirectory, list<HSTexture*> * textureRegistry, list<HSPalette*> * paletteRegistry, list<HSAudio*> * audioRegistry, SDL_AudioSpec * obtainedAudioSpec); //initialize this object based on definition file info
	
	virtual int AdvanceHolds();
	virtual int Event(InputStates * inputHistory, int frame); //handle events
	virtual int Update(); //handle updates
	virtual int CollideTerrain(list<HSObject*> * gameObjects); //handle collisions between terrain boxes
	virtual int CollideAttack(list<HSObject*> * gameObjects); //handle collisions between attack and hurt boxes
	virtual void ApplyAttackResults(); //apply the results of the attack collision step
	virtual void HandleHurtCollision(HSObject * attacker); //react to another object's attack
	virtual list<HSAudio*> GetAudio(); //get any audio this object currently wishes to play
	
	virtual bool IsTerrain();
	virtual bool IsTerrainObject();
	virtual bool IsPhysicsObject();
	virtual bool IsFighter();

protected:
	virtual HSObjectHold * CreateNewHold();
	virtual int SaveEventHolds(HSObjectHold * hold, XMLElement * eventHolds);
	virtual int AddHold(HSObjectHold * newHold); //add a new hold to the list of holds
	int LinkHolds(); //sets the appropriate nextHold pointers for each hold based on its nextHoldId
	virtual bool ChangeHold(HSObjectHold * hold); //change to a new hold
	virtual HSObjectHold * GetDefaultHold(); //gets a default hold, based on current states
};

#endif