#ifndef __MAIN_H_
#define __MAIN_H_

#include <iostream>
#include <fstream>
#include "fighter.h"

#define TARGET_FPS 60
#define MAX_GAME_RESOLUTION_X 1920
#define MAX_GAME_RESOLUTION_Y 1080
#define MIN_GAME_RESOLUTION_X 640
#define MIN_GAME_RESOLUTION_Y 360
#define GAME_ASPECT_RATIO_X 16
#define GAME_ASPECT_RATIO_Y 9
#define MAX_INPUT_HISTORY 60
#define MAX_PLAYERS 4
#define STICK_THRESHOLD 18000 //how far a stick must be tilted before it actually registers as a direction being "pressed"
#define STICK_HARD_THRESHOLD 32000 //how far a stick must be tilted before it actually registers as a direction being pressed hard
#define ZOOM_STEP 0.05
#define ZOOM_BOUNDARY_X_THRESHOLD 800
#define ZOOM_BOUNDARY_Y_THRESHOLD 450

//stuff
#define KEY_MAP_GUI_POS_X 100
#define P1_P2_POS_Y 100
#define PRESS_BUTTON_FOR_POS_Y 300
#define BUTTON_POS_Y 500
#define KEY_MAP_GUI_AWAY_POS -10000

struct JoystickMapping
{
	Uint8 joystick;
	Uint8 button;
};

struct InputMappings
{
	//keyboard key mappings
	SDLKey keyUp;
	SDLKey keyDown;
	SDLKey keyLeft;
	SDLKey keyRight;
	SDLKey keyJump;
	SDLKey keyBlock;
	SDLKey keyLight;
	SDLKey keyHeavy;
	SDLKey keyStart;
	SDLKey keySelect;

	//joystick button mappings
	JoystickMapping buttonUp;
	JoystickMapping buttonDown;
	JoystickMapping buttonLeft;
	JoystickMapping buttonRight;
	JoystickMapping buttonJump;
	JoystickMapping buttonBlock;
	JoystickMapping buttonLight;
	JoystickMapping buttonHeavy;
	JoystickMapping buttonStart;
	JoystickMapping buttonSelect;
	
	//joystick stick and hat mapping
	Uint8 stick;
	Uint8 hat;
};

struct PreviousJoystickStates
{
	Uint8 hat;
	bool stickHeldUp;
	bool stickHeldDown;
	bool stickHeldLeft;
	bool stickHeldRight;
	bool stickHeldHardUp;
	bool stickHeldHardDown;
	bool stickHeldHardLeft;
	bool stickHeldHardRight;
};

enum CurrentSettingMapping
{
	SETTING_UP,
	SETTING_DOWN,
	SETTING_LEFT,
	SETTING_RIGHT,
	SETTING_JUMP,
	SETTING_LIGHT,
	SETTING_BLOCK
};

struct CurrentAudioEntry
{
	HSAudio* aud; //audio object
	Uint32 curPosition; //current position in the audio playthrough
};

list<CurrentAudioEntry*> currentAudio;

class Main
{
public:
	Main();
	int Execute();

protected:
	GLuint texCoordBufferID;
	unsigned int newObjectId;
	list<HSObject*> gameObjects;
	list<HSObject*> HUDObjects;
	list<HSTexture*> textureRegistry;
	list<HSPalette*> paletteRegistry;
	list<HSAudio*> audioRegistry;

	bool notDone;
	SDL_Surface* surf_display;
	int screenResolutionX;
	int screenResolutionY;
	int gameResolutionX;
	int gameResolutionY;
	bool fullScreen;

	SDL_AudioSpec * obtainedAudioSpec;

	list<SDL_Joystick*> sticks;

	bool zoomOutIncrease;
	bool zoomOutDecrease;
	float zoomOut;
	HSObject * focusObjectOne;
	HSObject * focusObjectTwo;

	unsigned int lastFrameTicks;
	unsigned int frame;

	int SetBestGameResolution();

	int Initialize();
	int LoadDefinition(string defFilePath, list<HSObject*> * gameObjects, HSObject ** returnValue = NULL);
	int AdvanceHolds();
	int Event(SDL_Event* events);
	int Update();
	int Collide();
	int Render();
	int RenderTexture(HSObject * obj, TextureInstance tex, int uTexLoc, int uIndLoc, int uIndTexLoc, int uPalLoc); 
	int PlayAudio();
	int Cleanup();

	//event/input crap
	HSObject * players[MAX_PLAYERS];
	InputMappings mappings[MAX_PLAYERS];
	InputStates * inputHistory[MAX_PLAYERS];
	InputStates * curInputs[MAX_PLAYERS];
	bool inputStateChange[MAX_PLAYERS];
	PreviousJoystickStates prevJoystickStates[MAX_PLAYERS];
	InputStates defaultInputs;

	int playerToSetUp;
	CurrentSettingMapping currentSettingMapping;
	HSObject * p1GUI;
	HSObject * p2GUI;
	HSObject * pressButtonForGUI;
	HSObject * upGUI;
	HSObject * downGUI;
	HSObject * leftGUI;
	HSObject * rightGUI;
	HSObject * jumpGUI;
	HSObject * lightAttackGUI;
	HSObject * blockGUI;

	void ClearControls(int player);
	void SetControls(int player);
	void NextControl(bool hatStickSet);
	void DoneSettingControls();

	void ChangePlayerPalette(int player);
	
	int HandleEvent(SDL_Event * Event);
	bool IsHeld(InputState * cur, InputState * prev);
	bool IsPressed(InputState * cur, InputState * prev);
	bool IsReleased(InputState * cur, InputState * prev);
    void InputFocus();
    void InputBlur();
    void KeyDown(SDLKey sym, SDLMod mod, Uint16 unicode);
    void KeyUp(SDLKey sym, SDLMod mod, Uint16 unicode);
    void MouseFocus();
    void MouseBlur();
    void MouseMove(int mX, int mY, int relX, int relY, bool Left,bool Right,bool Middle);
    void MouseWheel(bool Up, bool Down);
    void LButtonDown(int mX, int mY);
    void LButtonUp(int mX, int mY);
    void RButtonDown(int mX, int mY);
    void RButtonUp(int mX, int mY);
    void MButtonDown(int mX, int mY);
    void MButtonUp(int mX, int mY);
    void JoyAxis(Uint8 which, Uint8 axis, Sint16 value);
    void JoyButtonDown(Uint8 which, Uint8 button);
    void JoyButtonUp(Uint8 which, Uint8 button);
    void JoyHat(Uint8 which, Uint8 hat, Uint8 value);
    void JoyBall(Uint8 which, Uint8 ball, Sint16 xrel, Sint16 yrel);
    void Minimize();
    void Restore();
    void Resize(int w,int h);
    void Expose();
    void Exit();
	int ToggleFullScreen();
	int SetFullScreen(bool newFullScreen);
    void User(Uint8 type, int code, void* data1, void* data2);
};

#endif