#ifndef __FIGHTER_H_
#define __FIGHTER_H_

#include "physicsobject.h"
#include "HUD.h"

#define RUN_INPUT_FRAMES 10 //max number of frames between the two left/right taps that activate a ground run/dash
#define AIR_DASH_INPUT_FRAMES 10 //max number of frames between the two left/right taps that activate an air run/dash
#define MOVING_TURN_THRESHOLD 10 //number of frames after walk/run stop that turning will trigger the walking/running turn animation
#define HARD_PRESS_THRESHOLD 2 //number of frames the stick has to go from neutral to hard pressed to be equivalent to a double-tap

enum FighterState
{
	STANDING,
	WALKING,
	RUNNING,
	CROUCHING,
	JUMPING,
	AIR_DASHING,
	AIRBORN
};

enum FighterFacing
{
	LEFT = -1,
	RIGHT = 1
};

enum FighterJump
{
	NO_JUMP,
	STANDING_JUMP,
	WALKING_JUMP,
	RUNNING_JUMP,
	BACKWARD_JUMP
};

enum FighterAirDash
{
	NO_AIR_DASH,
	FORWARD_AIR_DASH,
	BACKWARD_AIR_DASH
};

enum FighterAirControl
{
	NO_AIR_CONTROL,
	CONTROL_LEFT,
	CONTROL_RIGHT
};

enum FighterAirVelocityCategory
{
	LOW_VELOCITY,
	HIGH_VELOCITY_FORWARD,
	HIGH_VELOCITY_BACKWARD
};

enum FighterLandingAction
{
	NO_LANDING_ACTION,
	MOVE,
	DASH,
	CROUCH,
	JUMP,
	NEUTRAL_LIGHT,
	UP_LIGHT,
	DOWN_LIGHT,
	FORWARD_LIGHT
};

class FighterHold : public PhysicsObjectHold
{
public:
	FighterHold();
	~FighterHold();
	
	virtual int Define(XMLElement * definition, string defFileDirectory, list<HSTexture*> * textureRegistry, list<HSAudio*> * audioRegistry, SDL_AudioSpec * obtainedAudioSpec); //initialize this hold based on definition file info

protected:

};

struct FighterEventHolds// : public TerrainEventHolds
{
	FighterHold * standing;
	FighterHold * turn;
	FighterHold * walk;
	FighterHold * walking;
	FighterHold * walkingTurn;
	FighterHold * run;
	FighterHold * running;
	FighterHold * runningTurn;
	FighterHold * runningStop;
	FighterHold * crouch;
	FighterHold * crouching;
	FighterHold * crouchingTurn;
	FighterHold * stand;
	
	FighterHold * jumpNeutralStart;
	FighterHold * jumpNeutralStartAir;
	FighterHold * jumpNeutralRising;
	FighterHold * jumpNeutralFall;
	FighterHold * jumpNeutralFalling;
	FighterHold * jumpNeutralLand;
	//FighterHold * jumpNeutralLandHard;
	/*FighterHold * jumpForwardStart;
	FighterHold * jumpForwardRising;
	FighterHold * jumpForwardFall;
	FighterHold * jumpForwardFalling;
	FighterHold * jumpForwardLand;
	FighterHold * jumpForwardLandHard;
	FighterHold * jumpBackwardStart;*/
	FighterHold * jumpBackwardRising;
	FighterHold * jumpBackwardFall;
	/*FighterHold * jumpBackwardFalling;
	FighterHold * jumpBackwardLand;
	FighterHold * jumpBackwardLandHard;*/

	FighterHold * airDashForward;
	FighterHold * airDashBackward;

	/*FighterHold * ledgeGrab;
	FighterHold * ledgeClimb;*/

	FighterHold * blockHigh;
	FighterHold * blockLow;
	FighterHold * blockAir;

	//FighterHold * hitstunHighStandingStart;
	FighterHold * hitstunLightHighStanding;
	//FighterHold * hitstunHighStandingEnd;
	FighterHold * hitstunLightMidStanding;
	//FighterHold * hitstunLowStandingStart;
	FighterHold * hitstunLightLowStanding;
	//FighterHold * hitstunLowStandingEnd;
	//FighterHold * hitstunCrouchingStart;
	FighterHold * hitstunLightMidCrouching;
	//FighterHold * hitstunCrouchingEnd;
	FighterHold * hitstunLightLowCrouching;
	FighterHold * hitstunLightAir;
	/*FighterHold * tripForward;
	FighterHold * tripBackward;
	FighterHold * proneFaceUp;
	FighterHold * proneFaceUpStand;
	FighterHold * proneFaceDown;
	FighterHold * proneFaceDownStand;
	FighterHold * crumpleStart;
	FighterHold * crumple;*/

	/*FighterHold * airbornFaceUpRising;
	FighterHold * airbornFaceUpFall;
	FighterHold * airbornFaceUpFalling;
	FighterHold * airbornFaceUpRise;
	FighterHold * airbornFaceDownRising;
	FighterHold * airbornFaceDownFall;
	FighterHold * airbornFaceDownFalling;
	FighterHold * airbornFaceDownRise;
	FighterHold * airbornFaceSideMovingForward;
	FighterHold * airbornFaceSideMoveBackward;
	FighterHold * airbornFaceSideMovingBackward;
	FighterHold * airbornFaceSideMoveForward;*/
    
    FighterHold * attackLightNeutralGround;
    FighterHold * attackLightDownGround;
    FighterHold * attackLightUpGround;
    FighterHold * attackLightForwardGround;
    FighterHold * attackLightNeutralAir;
    FighterHold * attackLightDownAir;
    FighterHold * attackLightUpAir;
    FighterHold * attackLightForwardAir;
    FighterHold * attackLightBackwardAir;
};

class Fighter : public PhysicsObject
{
public:
	//the previous terrain hitbox
	HSBox * firstPreviousTerrainBox;
	HSBox * lastPreviousTerrainBox;

	//whether or not the terrain hitbox was just changed
	bool terrainBoxesChanged;

	//special terrain boxes that represent a fighter in an upright state (standing, jumping, etc)
	HSBox * firstUprightTerrainBox;
	HSBox * lastUprightTerrainBox;

	//special terrain boxes that represent a fighter in a crouching state
	HSBox * firstCrouchingTerrainBox;
	HSBox * lastCrouchingTerrainBox;

	//special terrain boxes that represent a fighter in a prone state
	HSBox * firstProneTerrainBox;
	HSBox * lastProneTerrainBox;

	//special terrain boxes that represent a fighter in small compact centralized state
	HSBox * firstCompactTerrainBox;
	HSBox * lastCompactTerrainBox;

	//The fighter's current state
	FighterState state;
	FighterFacing facing;
	bool blocking;
	Blockability hitstunBlockability;
	FighterJump jump;
	FighterAirDash airDash;
	float currentSurfaceFriction;
	bool jumpStartup;
	int timeSinceWalkStop;
	int timeSinceRunStop;
	bool runStopping;
	bool turning;
	bool sliding;
	bool attacking;
	bool lightNeutralAttack;
	bool jumpCancellable;
	bool walkAfterTurning;
	bool runAfterTurning;
	FighterAirVelocityCategory airVelocityCategory;
	bool fastFall;
	FighterAirControl airControl;
	FighterLandingAction landingAction;
	bool turnUponLanding;

	int curHitstun;
	int curBlockstun;

	//the holds this object moves to upon particular events
	FighterEventHolds fighterEventHolds;

	//fighter statistics
	float walkSpeed;
	float runSpeed;
	float jumpSpeed;
	float forwardAirDashSpeed;
	float backwardAirDashSpeed;
	int forwardAirDashDuration;
	int backwardAirDashDuration;
	int curAirDashDuration;
	float stepHeight;
	int airActions;
	int curAirActions;
	float airControlAccel;
	float maxAirControlSpeed;

	//the fighter's HUD
	HUD * hud;

	Fighter();
	~Fighter();

	virtual int Define(XMLElement * definition, string defFileDirectory, list<HSTexture*> * textureRegistry, list<HSPalette*> * paletteRegistry, list<HSAudio*> * audioRegistry, SDL_AudioSpec * obtainedAudioSpec); //initialize this object based on definition file info
	
	virtual int AdvanceHolds();
	virtual int Event(InputStates * inputHistory, int frame); //handle events
	virtual int Update();
	virtual int CollideTerrain(list<HSObject*> * gameObjects);
	virtual void ApplyAttackResults();
	virtual void HandleHurtCollision(TerrainObject * attacker);
	
	virtual bool IsFighter();

	//command inputs
	void GroundAttackExecuted();
	void AirAttackExecuted();
	bool ForwardWasTapped(InputStates * inputHistory, int frame, int framesAgo);
	bool BackwardWasTapped(InputStates * inputHistory, int frame, int framesAgo);
	bool ForwardHeld(InputStates * inputHistory);
	bool BackwardHeld(InputStates * inputHistory);
	bool ForwardHardPressed(InputStates * inputHistory, int frame, int framesAgo);
	bool BackwardHardPressed(InputStates * inputHistory, int frame, int framesAgo);

protected:
	virtual FighterHold * CreateNewHold();
	virtual int SaveEventHolds(HSObjectHold * hold, XMLElement * eventHolds);
	int AddUprightTerrainBox(HSBox * newUprightTerrainBox, XMLElement * definition);
	int AddCrouchingTerrainBox(HSBox * newCrouchingTerrainBox, XMLElement * definition);
	int AddProneTerrainBox(HSBox * newProneTerrainBox, XMLElement * definition);
	int AddCompactTerrainBox(HSBox * newCompactTerrainBox, XMLElement * definition);
	void ChangeTerrainBoxes(HSBox * newFirstTerrainBox);
	virtual bool ChangeHold(HSObjectHold * hold);
	virtual HSObjectHold * GetDefaultHold();
	
	virtual void HandleChangeInTerrainBoxes(list<HSObject*> * gameObjects);
	virtual int HandleTerrainCollision(list<HSObject*> * gameObjects, TerrainCollisionResult * result, HSVect2D * ownPos = NULL, HSVect2D * ownPrevPos = NULL);
	virtual int StepCheck(list<HSObject*> * gameObjects);
	virtual int HandleJumpLanding();
};

#endif